//+------------------------------------------------------------------+
//|                                                info_criteria.mqh |
//|                                  Copyright 2025, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2025, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
//+------------------------------------------------------------------------------+
//|Schwarz information criterion (SIC), aka Bayesian information criterion (BIC).|
//+------------------------------------------------------------------------------+
double sic(double log_likelihood, int n, int k=1)
 {
  return log(n) * k -2 * log_likelihood;
 }
//+------------------------------------------------------------------+
//|Akaike information criterion.                                     |
//+------------------------------------------------------------------+
double aic(double log_likelihood, int n, int k = 1)
 {
  return (2 * n / (n - k - 1)) * k - 2 * log_likelihood;
 }
//+------------------------------------------------------------------+
//| Hannan-Quinn information criterion                               |
//+------------------------------------------------------------------+
double hqic(double log_likelihood, int n, int k = 1)
{
  return 2 * log(log(n)) * k - 2 * log_likelihood;
}

//+------------------------------------------------------------------+

