//+------------------------------------------------------------------+
//|                                                         ecdf.mqh |
//|                                  Copyright 2024, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2024, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#ifndef _NP_
  #include<np.mqh>
#endif 
//+------------------------------------------------------------------+
//| A basic step function.                                           |
//+------------------------------------------------------------------+
class CStepFunction
  {
protected:
   bool              m_rside;
   vector            m_x,m_y;
   long             m_indices[];
   ulong             m_n;
public:
                     CStepFunction(void)
     {
     }
                    ~CStepFunction(void)
     {
     }
   bool              fit(vector& inx, vector& iny, double ival=0.0, bool is_sorted = false,bool rside = false)
     {
      m_rside = rside;
      vector in_x = inx;
      vector in_y = iny;
      if(in_x.Size()!=in_y.Size() || !in_y.Size())
        {
         Print(__FUNCTION__," Invalid inputs ");
         return false;
        }

      if(!is_sorted)
         {
          if(!np::arange(m_indices,int(inx.Size()),long(0),long(1)) || !np::quickSortIndices(inx,true,m_indices,0,long(inx.Size()-1)))
            {
             Print(__FUNCTION__, " error at if statement ", __LINE__);
             return false;
            }
          in_x = np::select(inx,m_indices);
          in_y = np::select(iny,m_indices);
          
          ArrayFree(m_indices);
         } 
         
      m_x = vector::Zeros(in_x.Size()+1);
      m_y = vector::Zeros(in_y.Size()+1);
      m_x[0] = -DBL_MIN;
      m_y[0] = ival;
      
      if(!np::vectorCopy(m_x,in_x,1) || !np::vectorCopy(m_y,in_y,1))
        return false;
      
      m_n = m_x.Size();
      
      return true;
      
     }
   vector transform(vector & in_v)
    {
      vector tind;
      if(!np::searchsorted(m_x,in_v,m_rside,tind) || !np::vecAsArray(tind - 1.0,m_indices))
        {
         Print(__FUNCTION__, " error ");
         return vector::Zeros(0);
        }
        
       tind = np::select(m_y,m_indices);
       
      return tind;
    }
  };
//+------------------------------------------------------------------+
//| the Empirical CDF of an array as a step function.                |
//+------------------------------------------------------------------+
class CECDF
{
 private:
   CStepFunction m_stepf;
 public:
  CECDF(void)
   {
   }
  ~CECDF(void)
   {
   }
   bool fit(vector &in ,bool right_side = true)
    {
     vector sorted = in;
     np::sort(sorted);
     double nobs = (double)in.Size();
     vector y = np::linspace(1.0/nobs,1.0,in.Size());
     return m_stepf.fit(sorted,y,0,true,right_side);
    }
   vector ecdf(vector &in)
    {
      return m_stepf.transform(in);
    }
};
