//+------------------------------------------------------------------+
//|                                                        utils.mqh |
//|                                  Copyright 2025, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2025, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#include<info_criteria.mqh>
#include "base.mqh"
//+----------------------------------------------------------------------+
//| Fit copula to empirical data and generate goodness-of-fit statistics |
//+----------------------------------------------------------------------+
bool copula_info_criteria(vector &x, vector &y, CBivariateCopula* &copula_pointer, double &out_sic,double &out_aic, double &out_hqic)
  {

   if(CheckPointer(copula_pointer)==POINTER_INVALID)
     {
      Print(__FUNCTION__, " Invalid pointer ");
      return false;
     }

   double theta = copula_pointer.Fit(x,y);
   double logl = copula_pointer.Log_likelihood(x,y);

   out_sic = sic(logl,int(x.Size()));
   out_aic = aic(logl,int(x.Size()));
   out_hqic = hqic(logl,int(x.Size()));

   return true;
  }