//+------------------------------------------------------------------+
//|                                                       brentq.mqh |
//|                                  Copyright 2024, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2024, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
//+------------------------------------------------------------------+
//| brentq minimization                                              |
//+------------------------------------------------------------------+
class CBrentQ
  {
protected:
   int               funcalls,iterations;
   string            error_num;
public:
                     CBrentQ(void)
     {
     }
                    ~CBrentQ(void)
     {
     }
   virtual double    objective(double u,double v,double y)
     {
      return 0;
     }
   string            get_status(void) { return error_num;}
   int               get_num_func_calls(void) { return funcalls;}
   int               get_num_iters(void) { return iterations;}
   bool               converged(void)
     {
      return (StringFind(error_num,"CONVERGED")>-1);
     }
   double            minimize(double v,double y, double xa, double xb, double xtol, double rtol,int iter)
     {
      double xpre = xa, xcur = xb;
      double xblk = 0., fpre, fcur, fblk = 0.0, spre = 0.0, scur = 0.0, sbis;
      /* the tolerance is 2*delta */
      double delta;
      double stry, dpre, dblk;
      //int i;
      error_num = "INPROGRESS";
      funcalls = 0;
      iterations = 0;

      fpre = objective(xpre,v,y);
      fcur = objective(xcur,v,y);
      funcalls = 2;
      if(fpre == 0.0)
        {
         error_num = "CONVERGED";
         return xpre;
        }
      if(fcur == 0.0)
        {
         error_num = "CONVERGED";
         return xcur;
        }
      if((fpre<0.0 && fcur<0.0) || (fpre>=0.0 && fcur>=0.0))
        {
         error_num = "SIGNERR";
         return xcur;
        }

      for(int i = 0; i < iter; i++)
        {
         iterations++;
         if(fpre != 0.0 && fcur != 0.0 &&
            ((fpre<0.0 && fcur>=0.0) || (fpre>=0.0 && fcur<0.0)))
           {
            xblk = xpre;
            fblk = fpre;
            spre = scur = xcur - xpre;
           }
         if(fabs(fblk) < fabs(fcur))
           {
            xpre = xcur;
            xcur = xblk;
            xblk = xpre;

            fpre = fcur;
            fcur = fblk;
            fblk = fpre;
           }

         delta = (xtol + rtol*fabs(xcur))/2.0;
         sbis = (xblk - xcur)/2.0;
         if(fcur == 0.0 || fabs(sbis) < delta)
           {
            error_num = "CONVERGED";
            return xcur;
           }

         if(fabs(spre) > delta && fabs(fcur) < fabs(fpre))
           {
            if(xpre == xblk)
              {
               /* interpolate */
               stry = -fcur*(xcur - xpre)/(fcur - fpre);
              }
            else
              {
               /* extrapolate */
               dpre = (fpre - fcur)/(xpre - xcur);
               dblk = (fblk - fcur)/(xblk - xcur);
               stry = -fcur*(fblk*dblk - fpre*dpre)
                      /(dblk*dpre*(fblk - fpre));
              }
            if(2.0*fabs(stry) < MathMin(fabs(spre), 3.0*fabs(sbis) - delta))
              {
               /* good short step */
               spre = scur;
               scur = stry;
              }
            else
              {
               /* bisect */
               spre = sbis;
               scur = sbis;
              }
           }
         else
           {
            /* bisect */
            spre = sbis;
            scur = sbis;
           }

         xpre = xcur;
         fpre = fcur;
         if(fabs(scur) > delta)
           {
            xcur += scur;
           }
         else
           {
            xcur += (sbis > 0 ? delta : -delta);
           }

         fcur = objective(xcur,v,y);
         funcalls++;
        }
      error_num = "CONVERR";
      return xcur;
     }
  };
//+------------------------------------------------------------------+
