//+------------------------------------------------------------------+
//|                                             bivariate_copula.mqh |
//|                                  Copyright 2025, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2025, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#include"clayton.mqh"
#include"frank.mqh"
#include"gumbel.mqh"
#include"joe.mqh"
#include"n13.mqh"
#include"n14.mqh"
#include"gaussian.mqh"
#include"t.mqh"
#include"utils.mqh"
//+------------------------------------------------------------------+
//|Load a general copula model from file                             |
//|returns a pointer to base copula type                             |
//+------------------------------------------------------------------+
CBivariateCopula* bivariate_copula(const int file_handle)
  {
//---
   long ff = FileReadLong(file_handle);
//---
   CBivariateCopula* cop = NULL;
//---
   if(ff == -1)
     {
//---
      ENUM_COPULA_TYPE copula_type = ENUM_COPULA_TYPE(FileReadInteger(file_handle,INT_VALUE));
      int len = FileReadInteger(file_handle,INT_VALUE);
//---
      ResetLastError();
//---
      double eps=FileReadDouble(file_handle);
      double theta=FileReadDouble(file_handle);
      double tau=FileReadDouble(file_handle);
      double rho=FileReadDouble(file_handle);
      double nu=FileReadDouble(file_handle);
      double threshold=FileReadDouble(file_handle);
//---
      if(GetLastError())
        {
         Print(__FUNCTION__, " possible read error ", GetLastError());
         return cop;
        }
//---
      switch(copula_type)
        {
         case CLAYTON_COPULA:
            cop = new CClayton();
            break;
         case FRANK_COPULA:
            cop = new CFrank();
            break;
         case GAUSSIAN_COPULA:
            cop = new CGaussian();
            break;
         case GUMBEL_COPULA:
            cop = new CGumbel();
            break;
         case JOE_COPULA:
            cop = new CJoe();
            break;
         case N13_COPULA:
            cop = new CN13();
            break;
         case N14_COPULA:
            cop = new CN14();
            break;
         case STUDENT_COPULA:
            cop = new CStudent();
            break;
         default:
            Print(__FUNCTION__, " invalid copula ", EnumToString(copula_type));
            break;
        }
//---
      if(CheckPointer(cop)!=POINTER_INVALID)
        {
         cop.Set_nu(nu);
         cop.Set_theta(theta);
         cop.Set_eps(eps);
         cop.Set_tau(tau);
         cop.Set_rho(rho);
         cop.Set_threshold(threshold);
        }
//---
     }
//---
   return cop;
  }
//+------------------------------------------------------------------+
