//+------------------------------------------------------------------+
//|                                                        utils.mqh |
//|                                  Copyright 2025, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2025, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#include<info_criteria.mqh>
#include "base.mqh"
//---
const double GAMMA_SCAD[20] = {
                               0.001, 0.00143845, 0.00206914, 0.00297635, 0.00428133,
                               0.00615848, 0.00885867, 0.01274275, 0.01832981, 0.02636651,
                               0.0379269, 0.05455595, 0.078476, 0.11288379, 0.16237767,
                               0.23357215, 0.33598183, 0.48329302, 0.6951928, 1.
                              };
//+----------------------------------------------------------------------+
//| Fit copula to empirical data and generate goodness-of-fit statistics |
//+----------------------------------------------------------------------+
bool copula_info_criteria(vector &x, vector &y, CBivariateCopula* &copula_pointer, double &out_sic,double &out_aic, double &out_hqic)
  {

   if(CheckPointer(copula_pointer)==POINTER_INVALID)
     {
      Print(__FUNCTION__, " Invalid pointer ");
      return false;
     }

   double theta = copula_pointer.Fit(x,y);
   double logl = copula_pointer.Log_likelihood(x,y);

   out_sic = sic(logl,int(x.Size()));
   out_aic = aic(logl,int(x.Size()));
   out_hqic = hqic(logl,int(x.Size()));

   return true;
  }
//+------------------------------------------------------------------+
//|SCAD (smoothly clipped absolute deviation) penalty function.      |
//+------------------------------------------------------------------+
double scad_penalty(double x, double gamma, double a)
  {
   bool is_linear = (fabs(x)<=gamma);
   bool is_quadratic = (gamma<fabs(x)) & (fabs(x)<=a*gamma);
   bool is_constant = ((a*gamma)<fabs(x));

   double linear_part = gamma * fabs(x) * double(is_linear);
   double quadratic_part = (2.*a*gamma*fabs(x) - pow(x,2.)- pow(gamma,2.))/(2.*(a-1.))*double(is_quadratic);
   double constant_part = (pow(gamma,2.)*(a+1.))/2.*(double(is_constant));

//Print(__FUNCTION__, " linear part ", linear_part,"\n quadratic part ", quadratic_part, "\n constant part ", constant_part);

   return linear_part+quadratic_part+constant_part;
  }
//+------------------------------------------------------------------+
//|The derivative of SCAD penalty function w.r.t x.                  |
//+------------------------------------------------------------------+
double scad_derivative(double x, double gamma, double a)
  {
   double p1 = gamma*double(x<=gamma);
   double p2 = gamma *(a*gamma-x)*double((a*gamma-x)>0.)/((a - 1.)*gamma)*double(x>gamma);
   return p1+p2;
  }
//+------------------------------------------------------------------+
//|Adjust the weights of mixed copula components.                    |
//+------------------------------------------------------------------+
vector adjust_weights(vector& weights, double threshold)
  {
   vector rw = weights;
   vector fw = rw;
   for(ulong i = 0; i<fw.Size(); ++i)
      fw[i] = (rw[i]>threshold)?rw[i]*1.:rw[i]*0.;
   double scaler = fw.Sum();
   return fw/(scaler+1.e-12);
  }
//+------------------------------------------------------------------+
