//+------------------------------------------------------------------+
//|                                                  Parafrac V2.mq4 |
//|                        Copyright 2023, MetaQuotes Software Corp. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Wamek EA"
#property link      "https://www.mql5.com/en/users/wamek"
#property version   "1.00"
#property strict
#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1 DeepSkyBlue   // Color for uptrend histogram
#property indicator_color2 Tomato    // Color for downtrend histogram
#property indicator_width1 2
#property indicator_width2 2
#property indicator_style1 STYLE_SOLID
#property indicator_style2 STYLE_SOLID


#property indicator_level1     2.5
#property indicator_level2    -2.5
#property indicator_level3     5
#property indicator_level4    -5
#property indicator_level5     7
#property indicator_level6    -7


// Indicator buffers
double UpBuffer[];
double DownBuffer[];

//--Input parameter--
input double pstep =0.02;
input double pMax =0.2;
input int AtrPeriod =7;
int lookback=20;


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   IndicatorBuffers(2);

   // Set up buffer for uptrend histogram
   SetIndexStyle(0, DRAW_HISTOGRAM);
   SetIndexBuffer(0, UpBuffer);
   SetIndexLabel(0, "Uptrend");

   // Set up buffer for downtrend histogram
   SetIndexStyle(1, DRAW_HISTOGRAM);
   SetIndexBuffer(1, DownBuffer);
   SetIndexLabel(1, "Downtrend");
   
 // IndicatorSetString( INDICATOR_SHORTNAME, "Parafrac V2(" + DoubleToString(pstep, 2) + "," + DoubleToString(pMax, 2) + ")");

   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int counted_bars = IndicatorCounted();
   if(counted_bars < 0) return(-1);
      
  int limit=(counted_bars ==0)? Bars-(lookback+AtrPeriod):Bars - counted_bars--;


   // Loop through all bars that haven't been calculated yet
   for(int i = limit - 1; i >= 0; i--)
     {
      // Get the PSAR value for the current bar
      double sar = iSAR(NULL, 0, pstep, pMax, i);
      // Get the ATR value for the current bar
      double atr = iATR(NULL, 0, AtrPeriod, i);

      // Initialize buffers to EMPTY_VALUE so only the relevant one is plotted
      UpBuffer[i]   = EMPTY_VALUE;
      DownBuffer[i] = EMPTY_VALUE;

      // Avoid division by zero
      if(atr == 0) continue;

      // Determine trend and compute histogram value
      if(Close[i] > sar)  // Uptrend condition
        {
         double diff = (High[i] - sar) / atr;
         UpBuffer[i] = diff;
        }
      else if(Close[i] < sar) // Downtrend condition
        {
         double diff = ( Low[i]- sar) / atr;
         DownBuffer[i] = diff;
        }
      else // If Close equals SAR, no value is plotted
      {
         UpBuffer[i] = 0;
         DownBuffer[i] = 0;
      }

     }
   return(0);
  }
//+------------------------------------------------------------------+
