//+------------------------------------------------------------------+
//|                                                  Parafrac V2.mq5 |
//|                        Copyright 2023, MetaQuotes Software Corp. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Wamek EA"
#property link      "https://www.mql5.com/en/users/wamek"
#property version   "1.00"

#property indicator_separate_window
#property indicator_buffers 2
#property indicator_plots   2

#property indicator_type1   DRAW_HISTOGRAM
#property indicator_color1  DeepSkyBlue   // Color for uptrend histogram
#property indicator_width1  2
#property indicator_label1  "Uptrend"

#property indicator_type2   DRAW_HISTOGRAM
#property indicator_color2  Tomato        // Color for downtrend histogram
#property indicator_width2  2
#property indicator_label2  "Downtrend"

#property indicator_level1     2.5
#property indicator_level2    -2.5
#property indicator_level3     5.0
#property indicator_level4    -5.0
#property indicator_level5     7.0
#property indicator_level6    -7.0


// Input parameters
input double pstep = 0.02;
input double pMax = 0.2;
input int AtrPeriod = 7;
int lookback = 20;

// Indicator buffers
double UpBuffer[];
double DownBuffer[];

// Handles for technical indicators
int sarHandle;
int atrHandle;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
{
   // Set indicator buffers
   SetIndexBuffer(0, UpBuffer, INDICATOR_DATA);
   SetIndexBuffer(1, DownBuffer, INDICATOR_DATA);
   
   // Set empty values
   PlotIndexSetDouble(0, PLOT_EMPTY_VALUE, 0.0);
   PlotIndexSetDouble(1, PLOT_EMPTY_VALUE, 0.0);
   
   // Initialize buffers
   ArrayInitialize(UpBuffer, 0.0);
   ArrayInitialize(DownBuffer, 0.0);
   
   // Create indicator handles
   sarHandle = iSAR(_Symbol, _Period, pstep, pMax);
   if(sarHandle == INVALID_HANDLE)
   {
      Print("Error creating SAR handle");
      return(INIT_FAILED);
   }
   
   atrHandle = iATR(_Symbol, _Period, AtrPeriod);
   if(atrHandle == INVALID_HANDLE)
   {
      Print("Error creating ATR handle");
      return(INIT_FAILED);
   }
   
   // Set short name for indicator window
//   IndicatorSetString(INDICATOR_SHORTNAME, "Parafrac V2(" + DoubleToString(pstep, 2) + "," + DoubleToString(pMax, 2) + ")");
   
   return(INIT_SUCCEEDED);
}

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
{
   // Check for minimum bars
   if(rates_total < AtrPeriod + lookback)
      return(0);
      
   // Calculate starting index
   int pStart;
   if(prev_calculated == 0)
   {
      pStart = AtrPeriod + lookback;
      // Initialize the unused parts of buffers
      ArrayInitialize(UpBuffer, 0.0);
      ArrayInitialize(DownBuffer, 0.0);
   }
   else
   {
      pStart = prev_calculated - 1;
   }
   
   // Get SAR values
   double sarArray[];
   if(CopyBuffer(sarHandle, 0, 0, rates_total, sarArray) <= 0)
   {
      Print("Error copying SAR buffer: ", GetLastError());
      return(0);
   }
   
   // Get ATR values
   double atrArray[];
   if(CopyBuffer(atrHandle, 0, 0, rates_total, atrArray) <= 0)
   {
      Print("Error copying ATR buffer: ", GetLastError());
      return(0);
   }
   
   // Processing loop
   for(int i = pStart; i < rates_total; i++)
   {
      // Skip if data is not valid
      if(sarArray[i] == EMPTY_VALUE || atrArray[i] == EMPTY_VALUE || atrArray[i] == 0)
      {
         UpBuffer[i] = 0;
         DownBuffer[i] = 0;
         continue;
      }
      
      // Determine trend and compute histogram value
      if(close[i] > sarArray[i])  // Uptrend condition
      {
         double diff = (high[i] - sarArray[i]) / atrArray[i];
         UpBuffer[i] = diff;
         DownBuffer[i] = 0;
      }
      else if(close[i] < sarArray[i]) // Downtrend condition
      {
         double diff = (low[i]-sarArray[i]) / atrArray[i];
         DownBuffer[i] = diff; // Negative value for downtrend
         UpBuffer[i] = 0;
      }
      else // If Close equals SAR, no value is plotted
      {
         UpBuffer[i] = 0;
         DownBuffer[i] = 0;
      }
   }
   
   return(rates_total);
}
//+------------------------------------------------------------------+