//+------------------------------------------------------------------+
//|                                                     Wave Lin.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#property indicator_chart_window
#property indicator_buffers 1
#property indicator_plots   1

#property indicator_type1  DRAW_LINE
#property indicator_label1 "Wave Lin"
#property indicator_color1 clrBlue
#property indicator_width1 1
#property indicator_style1 STYLE_SOLID

enum type {Triangle,Saw,TriangleI,SawI};
input type Type=Triangle;
input ushort iPeriod=24,
             NumWave=0;

struct func {double c[];};
func array[];
int period,size;
double buffer[],weight[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,buffer,INDICATOR_DATA);
   ArraySetAsSeries(buffer,true);

   period=MathMax(3,iPeriod);
   int cnt=1,num=NumWave+1;
   size=1;
   int stop=(Type==Triangle || Type==TriangleI)?3:2;

   ArrayResize(array,size);
   ArrayResize(array[0].c,period);
   ArrayInitialize(array[0].c,1);

   for(int i=period;i>=stop;i--)
     {
      int n=period/i;
      if(n*i==period && cnt<num)
        {
         if(Type==Triangle)
           {
            ArrayResize(array,size+1);
            CreateTriangle(array[size].c,i);
            size++;
           }
         if(Type==Saw)
           {
            ArrayResize(array,size+1);
            CreateSaw(array[size].c,i);
            size++;
           }

         if(Type==TriangleI)
            for(int j=0;j<n;j++)
              {
               ArrayResize(array,size+1);
               CreateTriangleI(array[size].c,i,j);
               size++;
              }

         if(Type==SawI)
            for(int j=0;j<n;j++)
              {
               ArrayResize(array,size+1);
               CreateSawI(array[size].c,i,j);
               size++;
              }

         cnt++;
        }
     }

   ArrayResize(weight,size);
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---
   if(rates_total>prev_calculated)
     {
      ArraySetAsSeries(open,true);

      int bars=prev_calculated>0? rates_total-prev_calculated-1:rates_total-period-1;

      for(int b=bars;b>=0;b--)
        {
         for(int i=0;i<size;i++)
           {
            weight[i]=0;
            for(int j=0;j<period;j++)
               weight[i]=weight[i]+array[i].c[j]*open[b+j];
            weight[i]=weight[i]/period;
           }

         double res=0;
         for(int j=0;j<size;j++)
            res=res+weight[j]*array[j].c[0];
         buffer[b]=res;
        }
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CreateSawI(double &a[],int wave,int j)
  {
//---
   ArrayResize(a,period);
   ArrayInitialize(a,0);
   double sum=0;
   for(int i=0;i<wave;i++)
     {
      int n=j*wave+i;
      a[n]=wave-i;
      sum=sum+a[n];
     }

   for(int i=0;i<wave;i++)
     {
      int n=j*wave+i;
      a[n]=wave*a[n]/sum-1;
     }
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CreateTriangleI(double &a[],int wave,int j)
  {
//---
   ArrayResize(a,period);
   ArrayInitialize(a,0);
   double sum=0;
   for(int i=0;i<wave;i++)
     {
      int n=j*wave+i;
      a[n]=wave-MathAbs(2*i-wave+1);
      sum=sum+a[n];
     }

   for(int i=0;i<wave;i++)
     {
      int n=j*wave+i;
      a[n]=wave*a[n]/sum-1;
     }
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CreateSaw(double &a[],int wave)
  {
//---
   ArrayResize(a,period);
   double sum=0;
   for(int i=0;i<period;i++)
     {
      a[i]=wave-MathMod(i,wave);
      sum=sum+a[i];
     }

   for(int i=0;i<period;i++)
      a[i]=period*a[i]/sum-1;
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CreateTriangle(double &a[],int wave)
  {
//---
   ArrayResize(a,period);
   double sum=0;
   for(int i=0;i<period;i++)
     {
      a[i]=wave-MathAbs(2*MathMod(i,wave)-wave+1);
      sum=sum+a[i];
     }

   for(int i=0;i<period;i++)
      a[i]=period*a[i]/sum-1;
//---
  }
//+------------------------------------------------------------------+
