//+------------------------------------------------------------------+
//|                                                    EA Wave 2.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#resource "\\Indicators\\Wave.ex5"
#include <Trade\PositionInfo.mqh>
#include <Trade\Trade.mqh>
CPositionInfo pos;
CTrade trade;

enum type {Triangle,Saw,TriangleI,SawI};
input type Type1=Saw;
input ushort iPeriod1=620,
             NumWave1=310;

input type Type2=SawI;
input ushort iPeriod2=462,
             NumWave2=231;

int handle1,handle2;
double lot,ind1[2],ind2[2];
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//---
   lot=SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_MIN);

   handle1=iCustom(_Symbol,PERIOD_CURRENT,"::Indicators\\Wave.ex5",Type1,iPeriod1,NumWave1,0);
   handle2=iCustom(_Symbol,PERIOD_CURRENT,"::Indicators\\Wave.ex5",Type2,iPeriod2,NumWave2,0);
   if(handle1==INVALID_HANDLE || handle2==INVALID_HANDLE)
     {
      Print("Error code = ",GetLastError());
      return(INIT_FAILED);
     }

   CalcSignal();
   NewBar();
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---
//---
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---
   if(NewBar()==true)
     {
      int signal=CalcSignal();

      if(signal==0)
        {
         for(int i=PositionsTotal()-1;i>=0;i--)
            if(pos.SelectByIndex(i)==true && pos.PositionType()==POSITION_TYPE_SELL)
               trade.PositionClose(pos.Ticket(),10);

         trade.Buy(lot);
        }

      if(signal==1)
        {
         for(int i=PositionsTotal()-1;i>=0;i--)
            if(pos.SelectByIndex(i)==true && pos.PositionType()==POSITION_TYPE_BUY)
               trade.PositionClose(pos.Ticket(),10);

         trade.Sell(lot);
        }
     }
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
char CalcSignal()
  {
//---
   char signal=-1;

   if(CopyBuffer(handle1,0,0,2,ind1)>1 && CopyBuffer(handle2,0,0,2,ind2)>1)
     {
      for(int i=0;i<2;i++)
         ind1[i]=ind1[i]-ind2[i];

      if(ind1[0]>0 && ind1[1]<0)
         signal=0;

      if(ind1[0]<0 && ind1[1]>0)
         signal=1;
     }

   return(signal);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool NewBar()
  {
//---
   static long lastbar;
   long curbar=SeriesInfoInteger(_Symbol,PERIOD_CURRENT,SERIES_LASTBAR_DATE);
   if(lastbar<curbar)
     {
      lastbar=curbar;
      return(true);
     }
   return(false);
//---
  }
//+------------------------------------------------------------------+
