//+------------------------------------------------------------------+
//|                                        EA New Function Osc 2.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#resource "\\Indicators\\New Function Osc.ex5"

#include <Trade\PositionInfo.mqh>
#include <Trade\Trade.mqh>
CPositionInfo pos;
CTrade trade;

enum type {Rademacher,Walsh,RadSmooth,Hartley};

input type Type=Hartley;
input uchar N=12,
            P=72;

input ushort LvlBuy=260,
             LvlSell=820;

int handle;
double lot;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//---
   lot=SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_MIN);

   handle=iCustom(_Symbol,PERIOD_CURRENT,"::Indicators\\New Function Osc.ex5",Type,N,P);
   if(handle==INVALID_HANDLE)
     {
      Print("Error code = ",GetLastError());
      return(INIT_FAILED);
     }

   CalcSignal();
   NewBar();
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---
//---
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---
   if(NewBar()==true)
     {
      int signal=CalcSignal();

      if(signal==0)
        {
         trade.Buy(lot);
        }

      if(signal==1)
        {


         trade.Sell(lot);
        }

      if(signal==2)
         for(int i=PositionsTotal()-1;i>=0;i--)
            if(pos.SelectByIndex(i)==true && pos.PositionType()==POSITION_TYPE_BUY)
               trade.PositionClose(pos.Ticket(),10);

      if(signal==3)
         for(int i=PositionsTotal()-1;i>=0;i--)
            if(pos.SelectByIndex(i)==true && pos.PositionType()==POSITION_TYPE_SELL)
               trade.PositionClose(pos.Ticket(),10);
     }
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
char CalcSignal()
  {
//---
   static double lastprice;
   char signal=-1;
   double indicator[1];

   if(CopyBuffer(handle,0,0,1,indicator)>0)
     {
      if(-indicator[0]>LvlBuy*_Point)
         signal=0;

      if(indicator[0]>LvlSell*_Point)
         signal=1;

      if(indicator[0]>0 && lastprice<=0)
         signal=2;

      if(indicator[0]<0 && lastprice>=0)
         signal=3;

      lastprice=indicator[0];
     }

   return(signal);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool NewBar()
  {
//---
   static long lastbar;
   long curbar=SeriesInfoInteger(_Symbol,PERIOD_CURRENT,SERIES_LASTBAR_DATE);
   if(lastbar<curbar)
     {
      lastbar=curbar;
      return(true);
     }
   return(false);
//---
  }
//+------------------------------------------------------------------+
