//+------------------------------------------------------------------+
//|                                                       imodel.mqh |
//|                                  Copyright 2024, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2024, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
//+------------------------------------------------------------------+
//| IModel interface defining methods for manipulation of learning   |
//| algorithms                                                       |
//+------------------------------------------------------------------+
interface IModel
  {
   public:
//train a model
   bool train(matrix &predictors,matrix&targets);
//make a prediction with a trained model
   double forecast(vector &predictors);
  };
//+------------------------------------------------------------------+
//| IClassify interface defining methods for manipulation of         |
//|classification  algorithms                                        |
//+------------------------------------------------------------------+
interface IClassify:public IModel
  {
   public:
//get number of inputs for a model
   ulong getNumInputs(void);
//get number of class outputs for a model
   ulong getNumOutputs(void);
//make a prediction with a trained model
   vector classify(vector &predictors);
  };