//It's not recommended to change timeframe after attaching the EA to chart!
//The EA should be used at 5-digits symbols on the D1 timeframe!
//It's accepted to add the code to other trading systems able to work
//stabilized at the same timeframe as the other strategies.
#property copyright "Copyright  Evgeniy Trofimov, 2010"
#property link      "http://forum.mql4.com/ru/16793/"
#include <VirtualTrend.mqh>
#include <RealTrend.mqh>
//+------------------------------------------------------------------+
extern string file="virtual.csv"; // - File of virtual trading
extern int MinRating=50;    // - Minimal rating (in percentage terms) for opening a real position
extern string _tmp1_="---- Trading system 1 ----";
extern int    T1.Enabled = 1; // 1 - enbld.; 0 - dsbld. 
extern int    T1.Magic = 101; // Magic number
extern double T1.lot = 0.10;  // Value of fixed volume
extern int T1.Fast  = 10;     // Period of fast 
extern int T1.Slow  =100;     // Period of slow 
extern int T1.TS  = 7000;     // Trailing stop
extern int T1.PeriodRating=20; // - Period of averaging of rating

extern string _tmp2_="---- Trading system 2 ----";
extern int    T2.Enabled = 1; // 1 - enbld.; 0 - dsbld. 
extern int    T2.Magic = 102; // Magic number
extern double T2.lot = 0.10;  // Value of fixed volume
extern int T2.PeriodCCI=30;
extern int T2.LevelCCI=200;
extern int T2.SL=500;         // Stop Loss
extern int T2.PeriodRating=10; // - Period of averaging of rating

extern string _tmp3_="---- Trading system 3 ----";
extern int    T3.Enabled = 1; // 1 - enbld.; 0 - dsbld. 
extern int    T3.Magic = 103; // Magic number
extern double T3.lot = 0.10;  // Value of fixed volume
extern int    T3.Fast  = 30;  // Period of fast 
extern int    T3.Slow  =200;  // Period of slow 
extern int    T3.TS  = 5000;  // Trailing stop
extern int    T3.PeriodRating=2; // - Period of averaging of rating

extern string _tmp4_="---- Trading system 4 ----";
extern int    T4.Enabled = 1; // 1 - enbld.; 0 - dsbld. 
extern int    T4.Magic = 104; // Magic number
extern double T4.lot = 0.10;  // Value of fixed volume
extern double T4.SL = 5000;
extern double T4.TS = 5000;
extern double T4.LimitMACD = 0.002;
extern int    T4.PeriodRating=20; // - Period of averaging of rating

extern string _tmp5_="---- Trading system 5 ----";
extern int    T5.Enabled = 1; // 1 - enbld.; 0 - dsbld. 
extern int    T5.Magic = 105; // Magic number
extern double T5.lot = 0.10;  // Value of fixed volume
extern int T5.PeriodCCI=90;
extern int T5.LevelCCI=100;
extern int T5.TralingCCI=100;
extern int T5.SL=5000;
extern int T5.TS1=5000; //One-time trailing stop (move Stop Loss to a break-even level)
extern int T5.PeriodRating=10; // - Period of averaging of rating
//+------------------------------------------------------------------+
int init(){
}//init()
//+------------------------------------------------------------------+
void deinit() {
   FastTest=false;
   VirtualFileSave(file);
}//deinit()
//+------------------------------------------------------------------+
void start() {
   VirtualUpdate(file);
   Closings();
   Accompaniment();
   Openings();
}//start()
//+------------------------------------------------------------------+
void Closings(){
   //Procedure of closing a position by a signal
   int i, j;
   double PriceClose;
   int myFilter[];
   //----------------------------------- System 1
   if(!(IsTesting() && T1.Enabled!=1)){
      j=OrdersTotal();
      for(i=0; i<j; i++){
         if(OrderSelect(i,SELECT_BY_POS)){
            if(OrderMagicNumber()==T1.Magic){
               if(T1_SignalClose(OrderType())){
                  if(OrderType()==OP_BUY){
                     PriceClose=MarketInfo(Symbol(),MODE_BID);
                  }else if(OrderType()==OP_SELL){
                     PriceClose=MarketInfo(Symbol(),MODE_ASK);
                  }
                  if(!Block()) OrderClose(OrderTicket(), OrderLots(), PriceClose, Slippage);
               }
            }
         }
      }//Next i

      VirtualFileLoad(file);
      VirtualFilter(VIRT_TRADES, -1, -1, Symbol(), T1.Magic);
      ArrayResize(myFilter, Virt.Filter.Count);
      for(i=0; i<Virt.Filter.Count; i++){
         myFilter[i]=Virt.Filter[i];
      }//Next i
      for(i=0; i<ArraySize(myFilter); i++){
         if(T1_SignalClose(Virt.Type[myFilter[i]])){
            VirtualClose(Virt.Ticket[myFilter[i]], file);
         }
      }//Next i
   }
   //----------------------------------- System 2
   if(!(IsTesting() && T2.Enabled!=1)){
      j=OrdersTotal();
      for(i=0; i<j; i++){
         if(OrderSelect(i,SELECT_BY_POS)){
            if(OrderMagicNumber()==T2.Magic){
               if(T2_SignalClose(OrderType())){
                  if(OrderType()==OP_BUY){
                     PriceClose=MarketInfo(Symbol(),MODE_BID);
                  }else if(OrderType()==OP_SELL){
                     PriceClose=MarketInfo(Symbol(),MODE_ASK);
                  }
                  if(!Block()) OrderClose(OrderTicket(), OrderLots(), PriceClose, Slippage);
               }
            }
         }
      }//Next i
      VirtualFileLoad(file);
      VirtualFilter(VIRT_TRADES, -1, -1, Symbol(), T2.Magic);
      ArrayResize(myFilter, Virt.Filter.Count);
      for(i=0; i<Virt.Filter.Count; i++){
         myFilter[i]=Virt.Filter[i];
      }//Next i
      for(i=0; i<ArraySize(myFilter); i++){
         if(T2_SignalClose(Virt.Type[myFilter[i]])){
            VirtualClose(Virt.Ticket[myFilter[i]], file);
         }
      }//Next i
   }
   //----------------------------------- System 3
   if(!(IsTesting() && T3.Enabled!=1)){
      j=OrdersTotal();
      for(i=0; i<j; i++){
         if(OrderSelect(i,SELECT_BY_POS)){
            if(OrderMagicNumber()==T3.Magic){
               if(T3_SignalClose(OrderType())){
                  if(OrderType()==OP_BUY){
                     PriceClose=MarketInfo(Symbol(),MODE_BID);
                  }else if(OrderType()==OP_SELL){
                     PriceClose=MarketInfo(Symbol(),MODE_ASK);
                  }
                  if(!Block()) OrderClose(OrderTicket(), OrderLots(), PriceClose, Slippage);
               }
            }
         }
      }//Next i
      VirtualFileLoad(file);
      VirtualFilter(VIRT_TRADES, -1, -1, Symbol(), T3.Magic);
      ArrayResize(myFilter, Virt.Filter.Count);
      for(i=0; i<Virt.Filter.Count; i++){
         myFilter[i]=Virt.Filter[i];
      }//Next i
      for(i=0; i<ArraySize(myFilter); i++){
         if(T3_SignalClose(Virt.Type[myFilter[i]])){
            VirtualClose(Virt.Ticket[myFilter[i]], file);
         }
      }//Next i
   }
   //----------------------------------- System 4
   if(!(IsTesting() && T4.Enabled!=1)){
      j=OrdersTotal();
      for(i=0; i<j; i++){
         if(OrderSelect(i,SELECT_BY_POS)){
            if(OrderMagicNumber()==T4.Magic){
               if(T4_SignalClose(OrderType())){
                  if(OrderType()==OP_BUY){
                     PriceClose=MarketInfo(Symbol(),MODE_BID);
                  }else if(OrderType()==OP_SELL){
                     PriceClose=MarketInfo(Symbol(),MODE_ASK);
                  }
                  if(!Block()) OrderClose(OrderTicket(), OrderLots(), PriceClose, Slippage);
               }
            }
         }
      }//Next i
      VirtualFileLoad(file);
      VirtualFilter(VIRT_TRADES, -1, -1, Symbol(), T4.Magic);
      ArrayResize(myFilter, Virt.Filter.Count);
      for(i=0; i<Virt.Filter.Count; i++){
         myFilter[i]=Virt.Filter[i];
      }//Next i
      for(i=0; i<ArraySize(myFilter); i++){
         if(T4_SignalClose(Virt.Type[myFilter[i]])){
            VirtualClose(Virt.Ticket[myFilter[i]], file);
         }
      }//Next i
   }
   //----------------------------------- System 5
   if(!(IsTesting() && T5.Enabled!=1)){
      j=OrdersTotal();
      for(i=0; i<j; i++){
         if(OrderSelect(i,SELECT_BY_POS)){
            if(OrderMagicNumber()==T5.Magic){
               if(T5_SignalClose(OrderType())){
                  if(OrderType()==OP_BUY){
                     PriceClose=MarketInfo(Symbol(),MODE_BID);
                  }else if(OrderType()==OP_SELL){
                     PriceClose=MarketInfo(Symbol(),MODE_ASK);
                  }
                  if(!Block()) OrderClose(OrderTicket(), OrderLots(), PriceClose, Slippage);
               }
            }
         }
      }//Next i
      VirtualFileLoad(file);
      VirtualFilter(VIRT_TRADES, -1, -1, Symbol(), T5.Magic);
      ArrayResize(myFilter, Virt.Filter.Count);
      for(i=0; i<Virt.Filter.Count; i++){
         myFilter[i]=Virt.Filter[i];
      }//Next i
      for(i=0; i<ArraySize(myFilter); i++){
         if(T5_SignalClose(Virt.Type[myFilter[i]])){
            VirtualClose(Virt.Ticket[myFilter[i]], file);
         }
      }//Next i
   }
   
}//Closes()
//+------------------------------------------------------------------+
void Accompaniment(){
   //Procedure of trailing open positions
   int myFilter[];
   if(!IsTesting() || T1.Enabled==1){ //--- Trailing for the trading system 1 ---
      int j=OrdersTotal();
      for(int i=0; i<j; i++){
         if(OrderSelect(i,SELECT_BY_POS)){
            if(OrderMagicNumber()==T1.Magic){
               if(OrderType()==OP_BUY){
                  if((Bid-OrderOpenPrice())/Point>T1.TS){
                     if(OrderStopLoss()==0 || (Bid-OrderStopLoss())/Point>T1.TS){
                        Modify(OrderTicket(), Bid-T1.TS*Point);
                     }
                  }
               }else if(OrderType()==OP_SELL){
                  if((OrderOpenPrice()-Ask)/Point>T1.TS){
                     if(OrderStopLoss()==0 || (OrderStopLoss()-Ask)/Point>T1.TS){
                        Modify(OrderTicket(), Ask+T1.TS*Point);
                     }                  
                  }
               }
            }
         }
      }//Next i
      VirtualFileLoad(file);
      VirtualFilter(VIRT_TRADES, -1, -1, Symbol(), T1.Magic);
      ArrayResize(myFilter, Virt.Filter.Count);
      for(i=0; i<Virt.Filter.Count; i++){
         myFilter[i]=Virt.Filter[i];
      }//Next i
      for(i=0; i<ArraySize(myFilter); i++){
         if(Virt.Type[myFilter[i]]==OP_BUY){
            if((Bid-Virt.OpenPrice[myFilter[i]])/Point>T1.TS){
               if(Virt.StopLoss[myFilter[i]]==0 || (Bid-Virt.StopLoss[myFilter[i]])/Point>T1.TS){
                  VirtualModify(Virt.Ticket[myFilter[i]], 0, Bid-T1.TS*Point, 0, 0, file);
               }
            }
         }else if(Virt.Type[myFilter[i]]==OP_SELL){
            if((Virt.OpenPrice[myFilter[i]]-Ask)/Point>T1.TS){
               if(Virt.StopLoss[myFilter[i]]==0 || (Virt.StopLoss[myFilter[i]]-Ask)/Point>T1.TS){
                  VirtualModify(Virt.Ticket[myFilter[i]], 0, Ask+T1.TS*Point, 0, 0, file);
               }                  
            }
         }
      }//Next i
   }//--- End of trailing for the trading system 1 ---
   
   if(!IsTesting() || T3.Enabled==1){//--- Trailing for the trading system 3 ---
      j=OrdersTotal();
      for(i=0; i<j; i++){
         if(OrderSelect(i,SELECT_BY_POS)){
            if(OrderMagicNumber()==T3.Magic){
               if(OrderType()==OP_BUY){
                  if((Bid-OrderOpenPrice())/Point>T3.TS){
                     if(OrderStopLoss()==0 || (Bid-OrderStopLoss())/Point>T3.TS){
                        Modify(OrderTicket(), Bid-T3.TS*Point);
                     }
                  }
               }else if(OrderType()==OP_SELL){
                  if((OrderOpenPrice()-Ask)/Point>T3.TS){
                     if(OrderStopLoss()==0 || (OrderStopLoss()-Ask)/Point>T3.TS){
                        Modify(OrderTicket(), Ask+T3.TS*Point);
                     }                  
                  }
               }
            }
         }
      }//Next i
      VirtualFileLoad(file);
      VirtualFilter(VIRT_TRADES, -1, -1, Symbol(), T3.Magic);
      ArrayResize(myFilter, Virt.Filter.Count);
      for(i=0; i<Virt.Filter.Count; i++){
         myFilter[i]=Virt.Filter[i];
      }//Next i
      for(i=0; i<ArraySize(myFilter); i++){
         if(Virt.Type[myFilter[i]]==OP_BUY){
            if((Bid-Virt.OpenPrice[myFilter[i]])/Point>T3.TS){
               if(Virt.StopLoss[myFilter[i]]==0 || (Bid-Virt.StopLoss[myFilter[i]])/Point>T3.TS){
                  VirtualModify(Virt.Ticket[myFilter[i]], 0, Bid-T3.TS*Point, 0, 0, file);
               }
            }
         }else if(Virt.Type[myFilter[i]]==OP_SELL){
            if((Virt.OpenPrice[myFilter[i]]-Ask)/Point>T3.TS){
               if(Virt.StopLoss[myFilter[i]]==0 || (Virt.StopLoss[myFilter[i]]-Ask)/Point>T3.TS){
                  VirtualModify(Virt.Ticket[myFilter[i]], 0, Ask+T3.TS*Point, 0, 0, file);
               }                  
            }
         }
      }//Next i
   }//--- End of trailing for the trading system 3 ---
   
   if(!IsTesting() || T4.Enabled==1){//--- Trailing for the trading system 4 ---
      j=OrdersTotal();
      for(i=0; i<j; i++){
         if(OrderSelect(i,SELECT_BY_POS)){
            if(OrderMagicNumber()==T4.Magic){
               if(OrderType()==OP_BUY){
                  if((Bid-OrderOpenPrice())/Point>T4.TS){
                     if(OrderStopLoss()==0 || (Bid-OrderStopLoss())/Point>T4.TS){
                        Modify(OrderTicket(), Bid-T4.TS*Point);
                     }
                  }
               }else if(OrderType()==OP_SELL){
                  if((OrderOpenPrice()-Ask)/Point>T4.TS){
                     if(OrderStopLoss()==0 || (OrderStopLoss()-Ask)/Point>T4.TS){
                        Modify(OrderTicket(), Ask+T4.TS*Point);
                     }                  
                  }
               }
            }
         }
      }//Next i
      VirtualFileLoad(file);
      VirtualFilter(VIRT_TRADES, -1, -1, Symbol(), T4.Magic);
      ArrayResize(myFilter, Virt.Filter.Count);
      for(i=0; i<Virt.Filter.Count; i++){
         myFilter[i]=Virt.Filter[i];
      }//Next i
      for(i=0; i<ArraySize(myFilter); i++){
         if(Virt.Type[myFilter[i]]==OP_BUY){
            if((Bid-Virt.OpenPrice[myFilter[i]])/Point>T4.TS){
               if(Virt.StopLoss[myFilter[i]]==0 || (Bid-Virt.StopLoss[myFilter[i]])/Point>T4.TS){
                  VirtualModify(Virt.Ticket[myFilter[i]], 0, Bid-T4.TS*Point, 0, 0, file);
               }
            }
         }else if(Virt.Type[myFilter[i]]==OP_SELL){
            if((Virt.OpenPrice[myFilter[i]]-Ask)/Point>T4.TS){
               if(Virt.StopLoss[myFilter[i]]==0 || (Virt.StopLoss[myFilter[i]]-Ask)/Point>T4.TS){
                  VirtualModify(Virt.Ticket[myFilter[i]], 0, Ask+T4.TS*Point, 0, 0, file);
               }                  
            }
         }
      }//Next i
   }//--- End of trailing for the trading system 4 ---   
   if(!IsTesting() || T5.Enabled==1){//--- Trailing for the trading system 5 ---
      j=OrdersTotal();
      for(i=0; i<j; i++){
         if(OrderSelect(i,SELECT_BY_POS)){
            if(OrderMagicNumber()==T5.Magic){
               if(OrderType()==OP_BUY){
                  if(OrderStopLoss()==0 || OrderStopLoss()<OrderOpenPrice()){
                     if((Bid-OrderOpenPrice())/Point>T5.TS1){
                        Modify(OrderTicket(), Bid-T5.TS1*Point);
                     }
                  }
               }else if(OrderType()==OP_SELL){
                  if(OrderStopLoss()==0 || OrderStopLoss()>OrderOpenPrice()){
                     if((OrderOpenPrice()-Ask)/Point>T5.TS1){
                        Modify(OrderTicket(), Ask+T5.TS1*Point);
                     }                  
                  }
               }
            }
         }
      }//Next i
      VirtualFileLoad(file);
      VirtualFilter(VIRT_TRADES, -1, -1, Symbol(), T5.Magic);
      ArrayResize(myFilter, Virt.Filter.Count);
      for(i=0; i<Virt.Filter.Count; i++){
         myFilter[i]=Virt.Filter[i];
      }//Next i
      for(i=0; i<ArraySize(myFilter); i++){
         if(Virt.Type[myFilter[i]]==OP_BUY){
            if(Virt.StopLoss[myFilter[i]]==0 || Virt.StopLoss[myFilter[i]]<Virt.OpenPrice[myFilter[i]]){
               if((Bid-Virt.OpenPrice[myFilter[i]])/Point>T5.TS1){
                  VirtualModify(Virt.Ticket[myFilter[i]], 0, Bid-T5.TS1*Point, 0, 0, file);
               }
            }
         }else if(Virt.Type[myFilter[i]]==OP_SELL){
            if(Virt.StopLoss[myFilter[i]]==0 || Virt.StopLoss[myFilter[i]]>Virt.OpenPrice[myFilter[i]]){   
               if((Virt.OpenPrice[myFilter[i]]-Ask)/Point>T5.TS1){
                  VirtualModify(Virt.Ticket[myFilter[i]], 0, Ask+T5.TS1*Point, 0, 0, file);
               }                  
            }
         }
      }//Next i
   }//--- End of trailing for the trading system 5 ---   
   
}//Accompaniment()
//+------------------------------------------------------------------+
void Openings(){
   //Procedure of opening a position by a signal
   int S;
   double R, OpenPrice, StopLoss, TakeProfit;
   if(T1.Enabled==1) {   
      S=T1_SignalOpen();
      if(S>-1){
         R=VirtualRating(T1.Magic, Symbol(), T1.PeriodRating, 0, file);
         if(!VirtualExist(iTime(Symbol(), 0, 0), T1.Magic)){
            if(RatingON) Print("Rating 1 of system: ",R);
            if(S==OP_BUY) OpenPrice=MarketInfo(Symbol(),MODE_ASK);
                     else OpenPrice=MarketInfo(Symbol(),MODE_BID);
            VirtualSend(Symbol(), S, T1.lot, OpenPrice, Slippage, 0, 0, "R:"+DoubleToStr(R,1)+"%", T1.Magic, 0, file);
            if(R>MinRating){
               if(!OrderExist(iTime(Symbol(), 0, 0), T1.Magic)){
                  if(S==OP_BUY){
                     BUY_pips(T1.lot*R/100, 0, 0, T1.Magic, "System 1 (rating: "+DoubleToStr(R,1)+"%)");
                  }else if(S==OP_SELL){
                     SELL_pips(T1.lot*R/100, 0, 0, T1.Magic, "System 1 (rating: "+DoubleToStr(R,1)+"%)");
                  }
               }
            }
         }//if(!VirtualExist...
      }
   }
   if(T2.Enabled==1) {   
      S=T2_SignalOpen();
      if(S>-1){
         R=VirtualRating(T2.Magic, Symbol(), T2.PeriodRating, 0, file);
         if(!VirtualExist(iTime(Symbol(), 0, 0), T2.Magic)){
            if(RatingON) Print("Rating 2 of system: ",R);
            if(S==OP_BUY) {
               OpenPrice=MarketInfo(Symbol(),MODE_ASK);
               StopLoss=OpenPrice-T2.SL*Point;
            } else {
               OpenPrice=MarketInfo(Symbol(),MODE_BID);
               StopLoss=OpenPrice+T2.SL*Point;
            }
            VirtualSend(Symbol(), S, T2.lot, OpenPrice, Slippage, StopLoss, 0, "R:"+DoubleToStr(R,1)+"%", T2.Magic, 0, file);
            if(R>MinRating){
               if(!OrderExist(iTime(Symbol(), 0, 0), T2.Magic)){
                  if(S==OP_BUY){
                     BUY_pips(T2.lot*R/100, T2.SL, 0, T2.Magic, "System 2 (rating: "+DoubleToStr(R,1)+"%)");
                  }else if(S==OP_SELL){
                     SELL_pips(T2.lot*R/100, T2.SL, 0, T2.Magic, "System 2 (rating: "+DoubleToStr(R,1)+"%)");
                  }
               }
            }
         }//if(!VirtualExist...
      }
   }
   if(T3.Enabled==1) {
      S=T3_SignalOpen();
      if(S>-1){
         R=VirtualRating(T3.Magic, Symbol(), T3.PeriodRating, 0, file);
         if(!VirtualExist(iTime(Symbol(), 0, 0), T3.Magic)){
            if(RatingON) Print("Rating 3 of system: ",R);
            if(S==OP_BUY) OpenPrice=MarketInfo(Symbol(),MODE_ASK);
                     else OpenPrice=MarketInfo(Symbol(),MODE_BID);
            VirtualSend(Symbol(), S, T3.lot, OpenPrice, Slippage, 0, 0, "R:"+DoubleToStr(R,1)+"%", T3.Magic, 0, file);
            if(R>MinRating){
               if(!OrderExist(iTime(Symbol(), 0, 0), T3.Magic)){
                  if(S==OP_BUY){
                     BUY_pips(T3.lot*R/100, 0, 0, T3.Magic, "System 3 (rating: "+DoubleToStr(R,1)+"%)");
                  }else if(S==OP_SELL){
                     SELL_pips(T3.lot*R/100, 0, 0, T3.Magic, "System 3 (rating: "+DoubleToStr(R,1)+"%)");
                  }
               }
            }
         }//if(!VirtualExist...
      }
   }
   if(T4.Enabled==1) {      
      S=T4_SignalOpen();
      if(S>-1){
         VirtualFilter(VIRT_TRADES, -1, -1, Symbol(), T4.Magic);
         if(Virt.Filter.Count==0) {
            R=VirtualRating(T4.Magic, Symbol(), T4.PeriodRating, 0, file);
            if(!VirtualExist(iTime(Symbol(), 0, 0), T4.Magic)){
               if(RatingON) Print("Rating 4 of system: ",R);
               if(S==OP_BUY) {
                  OpenPrice=MarketInfo(Symbol(),MODE_ASK);
                  StopLoss=OpenPrice-T4.SL*Point;
               } else {
                  OpenPrice=MarketInfo(Symbol(),MODE_BID);
                  StopLoss=OpenPrice+T4.SL*Point;
               }
               VirtualSend(Symbol(), S, T4.lot, OpenPrice, Slippage, StopLoss, 0, "R:"+DoubleToStr(R,1)+"%", T4.Magic, 0, file);
               if(R>MinRating){
                  if(!OrderExist(iTime(Symbol(), 0, 0), T4.Magic)){
                     if(S==OP_BUY){
                        BUY_pips(T4.lot*R/100, T4.SL, 0, T4.Magic, "System 4 (rating: "+DoubleToStr(R,1)+"%)");
                     }else if(S==OP_SELL){
                        SELL_pips(T4.lot*R/100, T4.SL, 0, T4.Magic, "System 4 (rating: "+DoubleToStr(R,1)+"%)");
                     }
                  }
               }
            }//if(!VirtualExist...
         }
      }
   }
   if(T5.Enabled==1) {      
      S=T5_SignalOpen();
      if(S>-1){
         VirtualFilter(VIRT_TRADES, -1, -1, Symbol(), T5.Magic);
         if(Virt.Filter.Count==0) {
            R=VirtualRating(T5.Magic, Symbol(), T5.PeriodRating, 0, file);
            if(!VirtualExist(iTime(Symbol(), 0, 0), T5.Magic)){
               if(RatingON) Print("Rating 5 of system: ",R);
               if(S==OP_BUY) {
                  OpenPrice=MarketInfo(Symbol(),MODE_ASK);
                  StopLoss=OpenPrice-T5.SL*Point;
               } else {
                  OpenPrice=MarketInfo(Symbol(),MODE_BID);
                  StopLoss=OpenPrice+T5.SL*Point;
               }
               VirtualSend(Symbol(), S, T5.lot, OpenPrice, Slippage, StopLoss, 0, "R:"+DoubleToStr(R,1)+"%", T5.Magic, 0, file);
               if(R>MinRating){
                  if(!OrderExist(iTime(Symbol(), 0, 0), T5.Magic)){
                     if(S==OP_BUY){
                        BUY_pips(T5.lot*R/100, T5.SL, 0, T5.Magic, "System 5 (rating: "+DoubleToStr(R,1)+"%)");
                     }else if(S==OP_SELL){
                        SELL_pips(T5.lot*R/100, T5.SL, 0, T5.Magic, "System 5 (rating: "+DoubleToStr(R,1)+"%)");
                     }
                  }
               }
            }//if(!VirtualExist...
         }
      }
   }
}//Openings()
//+------------------------------------------------------------------+
int T1_SignalOpen() {
   //The function returns signal for opening a position:
   //-1 - don't open position
   // 0 - buy
   // 1 - sell
   double MA_Fast     =iMA(NULL,0, T1.Fast, 0, MODE_EMA, PRICE_CLOSE, 1);
   double MA_Fast_Last=iMA(NULL,0, T1.Fast, 0, MODE_EMA, PRICE_CLOSE, 2);
   double MA_Slow     =iMA(NULL,0, T1.Slow, 0, MODE_EMA, PRICE_CLOSE, 1);
   double MA_Slow_Last=iMA(NULL,0, T1.Slow, 0, MODE_EMA, PRICE_CLOSE, 2);
   if(MA_Slow>MA_Slow_Last){
      if(MA_Fast>MA_Slow && MA_Fast_Last<MA_Slow_Last){
         return(OP_BUY);
      }
   }
   if(MA_Slow<MA_Slow_Last){
      if(MA_Fast<MA_Slow && MA_Fast_Last>MA_Slow_Last){
         return(OP_SELL);
      }
   }
   return(-1);
}//T1_SignalOpen()
//+------------------------------------------------------------------+
bool T1_SignalClose(int type) {
   //The function returns signal for closing a position:
   // false - don't close position
   // true - close
   if(type==T1_SignalOpen()) return(false);
   double MA_Fast     =iMA(NULL,0, T1.Fast, 0, MODE_EMA, PRICE_CLOSE, 1);
   double MA_Slow     =iMA(NULL,0, T1.Slow, 0, MODE_EMA, PRICE_CLOSE, 1);
   if(type==OP_BUY){
      if(MA_Fast<MA_Slow) return(true);
   }else if(type==OP_SELL){
      if(MA_Fast>MA_Slow) return(true);
   }
   return(false);
}//T1_SignalClose()
//+------------------------------------------------------------------+
int T2_SignalOpen(int Candle=0) {
   //The function returns signal for opening a position:
   //-1 - don't open position
   // 0 - buy
   // 1 - sell
   double CCI=iCCI(NULL,0,T2.PeriodCCI,PRICE_TYPICAL,Candle+1);
   double CCILast=iCCI(NULL,0,T2.PeriodCCI,PRICE_TYPICAL,Candle+2);
   if((CCI<T2.LevelCCI)&&(CCILast>T2.LevelCCI)) return(OP_SELL);
   if((CCI>-T2.LevelCCI)&&(CCILast<-T2.LevelCCI)) return(OP_BUY);
   return(-1);
}//T2_SignalOpen()
//+------------------------------------------------------------------+
bool T2_SignalClose(int type) {
   //The function returns signal for closing a position:
   // false - don't close position
   // true - close
   int i=0;
   int SS=-1;
   while (SS==-1) {
      SS=T2_SignalOpen(i);
      i++;
   }
   if(type==SS) return(false);
   return(true);
}//T2_SignalClose()
//+------------------------------------------------------------------+
int T3_SignalOpen() {
   //The function returns signal for opening a position:
   //-1 - don't open position
   // 0 - buy
   // 1 - sell
   double MA_Fast     =iMA(NULL,0, T3.Fast, 0, MODE_EMA, PRICE_CLOSE, 1);
   double MA_Fast_Last=iMA(NULL,0, T3.Fast, 0, MODE_EMA, PRICE_CLOSE, 2);
   double MA_Slow     =iMA(NULL,0, T3.Slow, 0, MODE_EMA, PRICE_CLOSE, 1);
   double MA_Slow_Last=iMA(NULL,0, T3.Slow, 0, MODE_EMA, PRICE_CLOSE, 2);
   if(MA_Slow>MA_Slow_Last){
      if(MA_Fast>MA_Slow && MA_Fast_Last<MA_Slow_Last){
         return(OP_BUY);
      }
   }
   if(MA_Slow<MA_Slow_Last){
      if(MA_Fast<MA_Slow && MA_Fast_Last>MA_Slow_Last){
         return(OP_SELL);
      }
   }
   return(-1);
}//T3_SignalOpen()
//+------------------------------------------------------------------+
bool T3_SignalClose(int type) {
   //The function returns signal for closing a position:
   // false - don't close position
   // true - close
   if(type==T3_SignalOpen()) return(false);
   double MA_Fast     =iMA(NULL,0, T3.Fast, 0, MODE_EMA, PRICE_CLOSE, 1);
   double MA_Slow     =iMA(NULL,0, T3.Slow, 0, MODE_EMA, PRICE_CLOSE, 1);
   if(type==OP_BUY){
      if(MA_Fast<MA_Slow) return(true);
   }else if(type==OP_SELL){
      if(MA_Fast>MA_Slow) return(true);
   }
   return(false);
}//T3_SignalClose()
//+------------------------------------------------------------------+
int T4_SignalOpen(int CurrentCandle=0) { //Sergey Lozovik's strategy
   //The function returns signal for opening a position:
   //-1 - don't open position
   // 0 - buy
   // 1 - sell
   double LMA200=iMA(NULL,0,200,0,MODE_EMA,PRICE_OPEN,CurrentCandle+1);
   double  MA200=iMA(NULL,0,200,0,MODE_EMA,PRICE_OPEN,CurrentCandle);
   double LMA50 =iMA(NULL,0,50 ,0,MODE_EMA,PRICE_OPEN,CurrentCandle+1);
   double  MA50 =iMA(NULL,0,50 ,0,MODE_EMA,PRICE_OPEN,CurrentCandle);
   double LMA10 =iMA(NULL,0,10 ,0,MODE_EMA,PRICE_OPEN,CurrentCandle+1);
   double  MA10 =iMA(NULL,0,10 ,0,MODE_EMA,PRICE_OPEN,CurrentCandle);
   double LMACD=iMACD(NULL,0,12,26,9,PRICE_OPEN,MODE_MAIN,CurrentCandle+1);
   double  MACD=iMACD(NULL,0,12,26,9,PRICE_OPEN,MODE_MAIN,CurrentCandle);
   if(MA200>LMA200){
      if(MA50>LMA50 && MA50>MA200) {
         if(MA10>LMA10 && MA10>MA50) {
            if(MACD>LMACD && MACD>T4.LimitMACD) {
               return(0);
            }
         }
      }
   } else if(MA200<LMA200) {
      if(MA50<LMA50 && MA50<MA200) {
         if(MA10<LMA10 && MA10<MA50) {
            if(MACD<LMACD && MACD<-T4.LimitMACD) {
               return(1);
            }
         }
      }
   }
   return(-1);
}//T4_SignalOpen()
//+------------------------------------------------------------------+
bool T4_SignalClose(int type) {
   //The function returns signal for closing a position:
   // false - don't close position
   // true - close
   double MA50 = iMA(NULL,0,50 ,0,MODE_EMA,PRICE_OPEN,0);
   if(type==OP_BUY) {
      if(Close[1]<MA50) {
         return(true);
      }
   } else if(type==OP_SELL){
      if(Close[1]>MA50) {
         return(true);
      }
   }
   return(false);
}//T4_SignalClose()
//+------------------------------------------------------------------+
int T5_SignalOpen(int Candle=0) {
   //The function returns signal for opening a position:
   //-1 - don't open position
   // 0 - buy
   // 1 - sell
   double CCI=iCCI(NULL,0,T5.PeriodCCI,PRICE_TYPICAL,Candle+1);
   double CCILast=iCCI(NULL,0,T5.PeriodCCI,PRICE_TYPICAL,Candle+2);
   if((CCI>T5.LevelCCI)&&(CCILast<T5.LevelCCI)) return(OP_BUY);
   if((CCI<-T5.LevelCCI)&&(CCILast>-T5.LevelCCI)) return(OP_SELL);
   return(-1);
}//T2_SignalOpen()
//+------------------------------------------------------------------+
bool T5_SignalClose(int type) {
   //The function returns signal for closing a position:
   // false - don't close position
   // true - close
   int i=0;
   int SS=-1;
   double MyLevel, CCI;
   if(type==OP_BUY){
      MyLevel=T5.LevelCCI-T5.TralingCCI;
   }else{
      MyLevel=T5.LevelCCI+T5.TralingCCI;
   }
   while (SS==-1) {//Searching for a buy signal
      SS=T5_SignalOpen(i);
      i++;
      CCI=iCCI(NULL,0,T5.PeriodCCI,PRICE_TYPICAL,i);
      if(type==OP_BUY){
         if(CCI>MyLevel+2*T5.TralingCCI){
            MyLevel=MyLevel+T5.TralingCCI;
         }
      }else{
         if(CCI<MyLevel-2*T5.TralingCCI){
            MyLevel=MyLevel-T5.TralingCCI;
         }
      }
   }
   CCI=iCCI(NULL,0,T5.PeriodCCI,PRICE_TYPICAL,1);
   if(type==OP_BUY){
      if(CCI<MyLevel) return(true);
   }else{
      if(CCI>MyLevel) return(true);
   }
   return(false);
}//T2_SignalClose()
//+------------------------------------------------------------------+
bool Block() {
   if(!IsTradeAllowed() || IsTradeContextBusy() || !IsConnected()) {
      Print("Market is closed, no connection or the EA is not allowed to trade");
      return(true);
   }
   return(false);
}//Block()
//+------------------------------------------------------------------+


-----+


