Imports System
Imports System.IO
Imports System.Text
Imports System.Console
Imports Microsoft.VisualBasic

Module MQLEnigma
  Dim DivSymbols As String = "!&'*+/&\^{}|~%:<>" ' can not replace the "=" character, it must be processed individually. the "-" character can also be unary
  Dim DivSymbolsAdd As String = "()[]=-;, """ ' these characters are used to process descriptor operators
  Dim IdentificatorsEncoded() As String, IdentificatorsLen() As Integer, IdentificatorsCnt() As Integer

  Sub Main()
    DivSymbolsAdd = DivSymbolsAdd & vbCrLf & vbTab
    Dim l As Long
    Dim work, extractor, str As String, FunctionsBodies As String = "", p, p1, p2 As Integer

    Console.BackgroundColor = ConsoleColor.Black
    Console.ForegroundColor = ConsoleColor.Gray
    Console.Clear()
    Console.ForegroundColor = ConsoleColor.Magenta
    Write("MQLEnigma v1.00 ")
    Console.ForegroundColor = ConsoleColor.White
    WriteLine("MQL-files encoder.")
    Console.ForegroundColor = ConsoleColor.Gray
    Write("Copyright (c) 2006-2009, Sergey Kravchuk. ")
    Console.ForegroundColor = ConsoleColor.Yellow

    WriteLine("http://forextools.com.ua")
    Console.ForegroundColor = ConsoleColor.Gray
    WriteLine("")

    '============================================================================================
    ' Processing command line
    ' Check, that something was set in it
    Dim separators As String = " "
    Dim FileName As String = Interaction.Command()

    If FileName = "" Then
      Console.ForegroundColor = ConsoleColor.Red
      WriteLine("USAGE: MQLEnigma <MQL_Source_File_Name>")
      WriteLine("")
      Console.ForegroundColor = ConsoleColor.Gray
      WriteLine("Press ENTER to exit ...")
      Read()
      Console.ForegroundColor = ConsoleColor.Gray
      End
    End If

    ' for names with spaces concatenate the total filename and cut off the boundary "
    If GetChar(FileName, 1) = """" Then FileName = Mid(FileName, 2, Len(FileName) - 2)

    ' Check if set flag exists
    If Not My.Computer.FileSystem.FileExists(FileName) Then
      Console.ForegroundColor = ConsoleColor.Red
      WriteLine("File """ & FileName & """ not found")
      WriteLine("")
      Console.ForegroundColor = ConsoleColor.Gray
      WriteLine("Press ENTER to exit ...")
      Read()
      Console.ForegroundColor = ConsoleColor.Gray
      End
    End If


    '============================================================================================
    ' 1) read source file, collect all includes, write open file
    Console.ForegroundColor = ConsoleColor.Gray
    Write("File ")
    Console.ForegroundColor = ConsoleColor.White
    WriteLine(FileName)
    Console.ForegroundColor = ConsoleColor.Gray

    work = My.Computer.FileSystem.ReadAllText(FileName, System.Text.Encoding.Default)

    ' in order not to confuse characters fro, sting constants (may be "http://...")
    InsertDust(work)
    RemoveComents(work)

    ' insert all includes on their places, while garbaging comments and string constants
    InsertIncludes(work)

    ' prepare text to write open file
    RemoveComents(work)
    RemoveDust(work)
    PackText(work)

    ' write assembled and cleaned up file
    Console.ForegroundColor = ConsoleColor.Gray
    Write("Writing open file ")
    Console.ForegroundColor = ConsoleColor.Cyan
    WriteLine(Path.GetFileNameWithoutExtension(FileName) & "_Open" & Path.GetExtension(FileName))
    Console.ForegroundColor = ConsoleColor.Gray
    My.Computer.FileSystem.WriteAllText( _
        Path.GetFileNameWithoutExtension(FileName) & "_Open" & Path.GetExtension(FileName), _
        work, False, System.Text.Encoding.Default)

    '============================================================================================
    ' 2) selection of variable and identificators from the define
    extractor = work ' copy full file into working variable

    ' delete all parameters of expert in order not to touch their names
    RemoveBracesBodies(extractor, "extern", ";")

    Console.ForegroundColor = ConsoleColor.Gray
    WriteLine("Extracting identificators")

    ' select external identificators (outside function bodies and their parameters)
    str = FindExternalIdentificators(extractor, FunctionsBodies)

    ' add internal variables from bodies of their procedures
    str = str & FindInternalIdentificators(FunctionsBodies)

    ' remove reserved words in order not to replace them with ....
    RemoveReservedWords(str)


    ' disassemble string with identificators into array, sort it and remove duplicates
    Dim Identificators() As String = Split(str, vbCrLf), PrevElement As String = ""
    Dim IdentificatorsMax As Long = UBound(Identificators)

    Array.Sort(Identificators)
    str = ""
    For p = 0 To UBound(Identificators)
      If PrevElement <> Identificators(p) Then
        str = str + Identificators(p) + vbCrLf
        PrevElement = Identificators(p)
      End If
    Next

    str = Mid(str, 1, Len(str) - 2) ' cut off the last separators 0D0A in order not to create empty
    Identificators = Split(str, vbCrLf)
    Console.ForegroundColor = ConsoleColor.Gray
    Write("     total ")
    Console.ForegroundColor = ConsoleColor.White
    Write(UBound(Identificators))
    Console.ForegroundColor = ConsoleColor.Gray

    ' allocate parallel arrays and fill them 
    ReDim IdentificatorsCnt(0 To UBound(Identificators))
    ReDim IdentificatorsLen(0 To UBound(Identificators))
    ReDim IdentificatorsEncoded(0 To UBound(Identificators))

    Write(", in use ")
    str = ""
    Dim CntUsed As Long = 0
    Dim EncodedDigit = Integer.MaxValue ' maximal digit

    ' insert garbage into string variables
    InsertDust(work)

    Dim Rand As New Random(123)
    For p = 0 To UBound(Identificators)
      ' create garbage names
      IdentificatorsEncoded(p) = Chr(160) & Rand.Next(123, Integer.MaxValue) & EncodedDigit & Rand.Next(123, Integer.MaxValue / 40000) & Chr(160)
      EncodedDigit = EncodedDigit - 1

      ' remember lengths in order to sort by them when encoding
      IdentificatorsLen(p) = Len(Identificators(p))

      ' calculate number of usages of each identificator
      IdentificatorsCnt(p) = 0
      p1 = 1
      p1 = FindWholeWord(FunctionsBodies, p1, Identificators(p), False)
      While p1 > 0
        IdentificatorsCnt(p) = IdentificatorsCnt(p) + 1
        p1 = FindWholeWord(FunctionsBodies, p1 + 1, Identificators(p), False)
      End While
      If IdentificatorsCnt(p) > 0 Then CntUsed = CntUsed + 1
      IdentificatorsCnt(p) = IdentificatorsCnt(p)

      ' add string for subsequent write of identificator table
      str = str & IdentificatorsCnt(p) & vbTab & Identificators(p) & vbTab & IdentificatorsEncoded(p) & vbCrLf
    Next

    Console.ForegroundColor = ConsoleColor.White
    WriteLine(CntUsed)
    Console.ForegroundColor = ConsoleColor.Gray

    ' write file with identificators
    Console.ForegroundColor = ConsoleColor.Gray
    Write("Writing encodings to ")
    Console.ForegroundColor = ConsoleColor.Cyan
    WriteLine(Path.GetFileNameWithoutExtension(FileName) & "_Encodings.txt")
    Console.ForegroundColor = ConsoleColor.Gray

    ' remove garbage from constants
    RemoveDust(work)

    My.Computer.FileSystem.WriteAllText( _
        Path.GetFileNameWithoutExtension(FileName) & "_Encodings.txt", str, False, System.Text.Encoding.Default)


    '============================================================================================
    ' 3) Encoding

    Console.ForegroundColor = ConsoleColor.Magenta
    Write("Encoding ...")
    Dim Cnt As Long = 0

    ' insert garbage into constants in order not to change anything in them
    InsertDust(work)

    ' in order not to replace str twice in the str2str variable, make changes from the longest ones
    For l = 32 To 1 Step -1 ' begin from the longest ones
      For p = 0 To UBound(Identificators)
        If IdentificatorsLen(p) >= l Then
          IdentificatorsLen(p) = -IdentificatorsLen(p) ' in order not to touch it anymore
          work = ReplaceWord(work, Identificators(p), IdentificatorsEncoded(p))
        End If
      Next
    Next

    Console.ForegroundColor = ConsoleColor.Green
    Console.CursorLeft = Console.CursorLeft - 3
    WriteLine("OK ")
    Console.ForegroundColor = ConsoleColor.Gray

    ' remove garbage from constants
    RemoveDust(work)

    Console.ForegroundColor = ConsoleColor.Gray
    Write("Writing encoded file ")
    Console.ForegroundColor = ConsoleColor.Cyan
    WriteLine(Path.GetFileNameWithoutExtension(FileName) & "_Encoded" & Path.GetExtension(FileName))
    Console.ForegroundColor = ConsoleColor.Gray

    My.Computer.FileSystem.WriteAllText( _
        Path.GetFileNameWithoutExtension(FileName) & "_Encoded" & Path.GetExtension(FileName), _
        work, False, System.Text.Encoding.Default)

    '============================================================================================
    ' 4) End of work
    WriteLine("")
    WriteLine("Press ENTER to exit ...")

    ' pause to read all messages
    Read()
  End Sub


  '
  '        insert all #includes. Stop, if at least one file was not found
  Function InsertIncludes(ByRef str As String) As Boolean
    Dim p1, p2, p3 As Long, IncludeText, IncludeFile, s, sClose As String
    IncludeFile = ""

    p1 = FindWholeWord(str, 1, "#include")
    While p1 > 0
      ' find the name of inserted file
      p2 = SkipBlanks(str, p1 + 8)
      s = GetChar(str, p2)
      If s = "<" Then sClose = ">" Else sClose = """" ' identify the closing character
      IncludeFile = ""
      p2 = p2 + 1
      p3 = p2
      s = GetChar(str, p2)
      While s <> sClose
        If s <> Chr(3) Then IncludeFile = IncludeFile & s
        p3 = p3 + 1
        s = GetChar(str, p3)
      End While

      ' write the name of standard folder, if the file is in there
      If sClose = ">" Then IncludeFile = "include\" & IncludeFile

      ' Check if set flag exists
      If Not My.Computer.FileSystem.FileExists(IncludeFile) Then
        ' may be this file is in the experts subfolder - try one level higher
        IncludeFile = "..\" & IncludeFile
        If Not My.Computer.FileSystem.FileExists(IncludeFile) Then
          Console.ForegroundColor = ConsoleColor.Red
          Write("  ?? ")
          Console.ForegroundColor = ConsoleColor.White
          Write(Mid(IncludeFile, 4))
          Console.ForegroundColor = ConsoleColor.Red
          WriteLine(" not found")
          WriteLine("")
          Console.ForegroundColor = ConsoleColor.Gray
          WriteLine("Press ENTER to exit ...")
          Read()
          End
        End If
      End If

      ' get the contents of inserted file
      IncludeText = My.Computer.FileSystem.ReadAllText(IncludeFile, System.Text.Encoding.Default)
      InsertDust(IncludeText)
      RemoveComents(IncludeText)

      str = Left(str, p1 - 1) & vbCrLf _
                & IncludeText & vbCrLf & Mid(str, p3 + 1)

      Console.ForegroundColor = ConsoleColor.Gray
      Write("  -> ")
      Console.ForegroundColor = ConsoleColor.White
      Write(IncludeFile)
      Console.ForegroundColor = ConsoleColor.Green
      WriteLine(" Ok")
      Console.ForegroundColor = ConsoleColor.Gray

      p1 = FindWholeWord(str, p3, "#include")
    End While
  End Function

  '
  '        Extracting function bodies {...} and selection of variables descriptions from them 
  Function GetFunctionsBodies(ByVal str As String) As String
    Dim pstart, p, TextLength As Long, Cnt As Long
    GetFunctionsBodies = ""

    TextLength = Len(str)
    pstart = 1
    While 0 < pstart And pstart < TextLength
      ' find the beginning of block
      While 0 < pstart And pstart < TextLength And GetChar(str, pstart) <> "{"
        pstart = pstart + 1
      End While

      If pstart <= TextLength Then ' opening bracket found

        Cnt = 1 ' counter of open brackets
        p = pstart ' position of beginning search of the closing bracket 

        While p < TextLength And Cnt > 0
          p = p + 1
          If GetChar(str, p) = "{" Then Cnt = Cnt + 1
          If GetChar(str, p) = "}" Then Cnt = Cnt - 1
        End While
        GetFunctionsBodies = GetFunctionsBodies + Mid(str, pstart, p - pstart + 1) & " " & vbCrLf & " " & vbCrLf
        pstart = p + 1
      End If
    End While

  End Function

  '
  '        Selection of external identificators and function bodies for further processing
  Function FindExternalIdentificators(ByRef extractor As String, ByRef FunctionsBodies As String)
    Dim str As String

    Write("  <- external ")

    RemoveStrings(extractor) ' delete strings in "" as they shouldn't contain any descriptions
    RemoveComents(extractor)

    FunctionsBodies = GetFunctionsBodies(extractor)

    RemoveBracesBodies(extractor, "{", "}") ' delete all function bodies

    ' replace line breaks and tabulators with spaces, in order to search only it
    extractor = Replace(extractor, vbCrLf, " ")
    extractor = Replace(extractor, vbTab, " ")
    RemoveDubles(extractor, " ") ' delete repeating spaces

    ' before replacing with common separator, let's replace text that are passed by reference
    extractor = Replace(extractor, "int&", "int")
    extractor = Replace(extractor, "double&", "double")
    extractor = Replace(extractor, "color&", "color")
    extractor = Replace(extractor, "bool&", "bool")
    extractor = Replace(extractor, "datetime&", "datetime")
    extractor = Replace(extractor, "string&", "string")

    ' replace all separators with one character 4
    For p = 1 To Len(DivSymbols)
      extractor = Replace(extractor, GetChar(DivSymbols, p), Chr(4))
    Next

    ' delete all imported functions (from ; after closing bracket) as you can't change anything in them
    RemoveImportedFunctions(extractor)

    RemoveDubles(extractor, " ") ' delete repeating spaces
    extractor = Replace(extractor, " " & Chr(4), Chr(4))
    extractor = Replace(extractor, Chr(4) & " ", Chr(4))
    extractor = Replace(extractor, " =", "=")
    extractor = Replace(extractor, "= ", "=")
    extractor = Replace(extractor, "=;", ";")

    extractor = Replace(extractor, "=,", ",")
    extractor = Replace(extractor, "=)", ")")

    RemoveBracesBodies(extractor, "[", "]") ' delete all bodies of array indexes

    RemoveInitializations(extractor)

    ' replace specific types with common separator
    extractor = Replace(extractor, "void ", vbCrLf)
    extractor = Replace(extractor, "int ", vbCrLf)
    extractor = Replace(extractor, "double ", vbCrLf)
    extractor = Replace(extractor, "color ", vbCrLf)
    extractor = Replace(extractor, "bool ", vbCrLf)
    extractor = Replace(extractor, "datetime ", vbCrLf)
    extractor = Replace(extractor, "string ", vbCrLf)
    extractor = Replace(extractor, "#define ", vbCrLf)

    ' replace lists endings with common separator
    extractor = Replace(extractor, ";", vbCrLf)
    extractor = Replace(extractor, "(", "")
    extractor = Replace(extractor, ")", vbCrLf)
    extractor = Replace(extractor, ",", vbCrLf)

    ' package text
    extractor = Replace(extractor, Chr(4), " ")
    extractor = Replace(extractor, vbCrLf & " ", vbCrLf)
    extractor = Replace(extractor, vbCrLf & vbCrLf, vbCrLf)

    ' cut off assigned values in the #define
    extractor = Replace(extractor, " ", "//") ' replace space with the beginning of string comment
    RemoveComents(extractor) ' and cut it off

    '============================================================================================
    ' disassemble string into array, sort it and remove duplicates
    Dim PrevElement As String = ""
    Dim Identificators() As String = Split(extractor, vbCrLf)
    Array.Sort(Identificators)
    str = ""
    For p = 0 To UBound(Identificators)
      If PrevElement <> Identificators(p) Then
        str = str + Identificators(p) + vbCrLf
        PrevElement = Identificators(p)
      End If
    Next
    Identificators = Split(str, vbCrLf)

    Console.ForegroundColor = ConsoleColor.Green
    WriteLine("OK")
    Console.ForegroundColor = ConsoleColor.Gray

    FindExternalIdentificators = str

  End Function

  '
  '        Selection of external identificators and function bodies for further processing
  Function FindInternalIdentificators(ByRef FunctionsBodies As String)
    Dim str As String

    Write("  <- internal ")
    ' select all descriptions: after the type name and before the ;
    str = ""
    str = str & FindInternalDefinitions("int", FunctionsBodies)
    str = str & FindInternalDefinitions("bool", FunctionsBodies)
    str = str & FindInternalDefinitions("color", FunctionsBodies)
    str = str & FindInternalDefinitions("double", FunctionsBodies)
    str = str & FindInternalDefinitions("string", FunctionsBodies)
    str = str & FindInternalDefinitions("datetime", FunctionsBodies)

    FindInternalIdentificators = str

    Console.ForegroundColor = ConsoleColor.Green
    WriteLine("Ok")
    Console.ForegroundColor = ConsoleColor.Gray

  End Function

  '
  '        Selection of TypeName description from FunctionsBodies beginning from the p, which is "moving" after search
  Function FindInternalDefinitions(ByVal TypeName As String, ByVal FunctionsBodies As String)
    Dim p1, p2 As Long
    Dim TextLength As Long, s, extractor As String
    Dim str As String, PrevElement As String = ""

    p1 = 1
    FindInternalDefinitions = ""
    TypeName = TypeName
    extractor = ""
    str = ""

    FunctionsBodies = Replace(FunctionsBodies, vbCrLf, " ")
    FunctionsBodies = Replace(FunctionsBodies, vbTab, " ")
    RemoveDubles(FunctionsBodies, " ")

    TextLength = Len(FunctionsBodies)

    p1 = FindWholeWord(FunctionsBodies, p1, TypeName) ' find the next beginning of given type description

    While p1 > 0

      p1 = p1 + Len(TypeName) + 1 ' go to position after separator of type name

      p2 = p1
      s = GetChar(FunctionsBodies, p2)
      While p2 < TextLength - 1 And s <> ";"
        p2 = p2 + 1
        s = GetChar(FunctionsBodies, p2)
      End While

      extractor = Mid(FunctionsBodies, p1, p2 - p1 + 1)

      RemoveDubles(extractor, " ") ' delete repeating spaces
      extractor = Replace(extractor, " " & Chr(4), Chr(4))
      extractor = Replace(extractor, Chr(4) & " ", Chr(4))
      extractor = Replace(extractor, " =", "=")
      extractor = Replace(extractor, "= ", "=")
      extractor = Replace(extractor, "=;", ";")

      extractor = Replace(extractor, "=,", ",")
      extractor = Replace(extractor, "=)", ")")

      RemoveBracesBodies(extractor, "[", "]") ' delete all bodies of array indexes
      RemoveBracesBodies(extractor, "(", ")") ' delete all function calls

      RemoveInitializations(extractor, True) ''''''''???????

      str = str & vbCrLf & extractor

      p1 = FindWholeWord(FunctionsBodies, p1, TypeName) ' find the next beginning of given type description
    End While


    ' replace lists endings with common separator
    str = Replace(str, " ", "")
    str = Replace(str, Chr(4), "")
    str = Replace(str, ";", vbCrLf)
    str = Replace(str, ",", vbCrLf)

    ' package text
    While InStr(str, vbCrLf & vbCrLf) > 0
      str = Replace(str, vbCrLf & vbCrLf, vbCrLf)
    End While

    '============================================================================================
    ' disassemble string into array, sort it and remove duplicates
    Dim Identificators() As String = Split(str, vbCrLf)
    Array.Sort(Identificators)
    str = ""
    For p = 0 To UBound(Identificators)
      If Identificators(p) <> "" And PrevElement <> Identificators(p) Then
        str = str + Identificators(p) + vbCrLf
        PrevElement = Identificators(p)
      End If
    Next
    FindInternalDefinitions = str
  End Function

  '
  '   insert character with code 3 between each character inside text strings 
  Sub InsertDust(ByRef str As String)
    Dim p, TextLength As Long

    str = Replace(str, "D'", Chr(8)) ' special form of date constant

    ' insert garbage into constants
    p = 1
    TextLength = Len(str)
    While 0 < p And p < TextLength
      ' find the beginning of block
      While p < TextLength And GetChar(str, p) <> """"
        p = p + 1
      End While

      p = p + 1 ' move BEYOND the opening quote
      If p >= TextLength Then Exit While
      While p < TextLength - 1 And GetChar(str, p) <> """"
        str = Left(str, p) & Chr(3) & Mid(str, p + 1)
        TextLength = TextLength + 1
        p = p + 2
      End While
      p = p + 1

    End While

  End Sub
  '
  '   Delete garbage inside text string (character with code 3)
  Sub RemoveDust(ByRef str As String)
    str = Replace(str, Chr(3), "")
    str = Replace(str, Chr(8), "D'") ' special form of date constant
  End Sub
  '
  '   Delete comments. should be done after inserting garbage in order to cut off the http://....
  Sub RemoveComents(ByRef str As String)
    Dim CloseString As String
    Dim p1, p2, TextLength As Long

    p1 = 1
    TextLength = Len(str)
    Do While p1 < TextLength - 1
      CloseString = ""
      ' find the beginning of block
      While p1 < TextLength - 1
        If Mid(str, p1, 2) = "/*" Then
          CloseString = "*/"
          Exit While
        End If
        If Mid(str, p1, 2) = "//" Then
          CloseString = vbCrLf
          Exit While
        End If
        p1 = p1 + 1
      End While

      ' go BEYOND the comment opening
      p2 = p1 + 1

      If p2 >= TextLength - 1 Then Exit Do
      While p2 < TextLength - 1
        If Mid(str, p2, Len(CloseString)) = CloseString Then Exit While
        p2 = p2 + 1
      End While

      ' special processing of comment in string
      Dim devider As String = ""
      If CloseString = vbCrLf Then devider = vbCrLf

      str = Left(str, p1 - 1) & devider & Mid(str, p2 + Len(CloseString))
      TextLength = Len(str)
    Loop

  End Sub
  '
  '   Delete strings 
  Sub RemoveStrings(ByRef str As String)
    Dim pstart, p, TextLength As Long

    TextLength = Strings.Len(str)
    ' insert garbage into constants
    pstart = 1
    Do While pstart < TextLength - 1
      ' find the beginning of block
      TextLength = Strings.Len(str)
      While pstart < TextLength - 1 And Strings.GetChar(str, pstart) <> """"
        pstart = pstart + 1
      End While

      p = pstart + 1 ' move BEYOND the opening quote
      If p >= TextLength - 1 Then Exit Do
      While p < TextLength - 1 And Strings.GetChar(str, p) <> """"
        p = p + 1
      End While
      str = Strings.Left(str, pstart - 1) & Strings.Mid(str, p + 1)
      pstart = pstart + 1

    Loop

  End Sub
  '
  '   Delete bodies inside brackets along with brackets 
  Sub RemoveBracesBodies(ByRef str As String, ByVal OpenBrace As String, ByVal CloseBrace As String)
    Dim pstart, p, TextLength, BraceLength As Long, Cnt As Long

    TextLength = Len(str)
    pstart = 1
    While 0 < pstart And pstart < TextLength
      ' find the beginning of block
      BraceLength = Len(OpenBrace)
      While 0 < pstart And pstart < TextLength And Mid(str, pstart, BraceLength) <> OpenBrace
        pstart = pstart + 1
      End While

      If pstart >= TextLength Then Exit Sub ' opening bracket not found

      Cnt = 1 ' counter of open brackets

      p = pstart ' position of beginning search of the closing bracket 
      BraceLength = Len(CloseBrace)

      While p < TextLength And Cnt > 0
        p = p + 1
        If Mid(str, p, BraceLength) = OpenBrace Then Cnt = Cnt + 1
        If Mid(str, p, BraceLength) = CloseBrace Then Cnt = Cnt - 1
      End While
      str = Left(str, pstart - 1) & Mid(str, p + 1)
      TextLength = Len(str)
      pstart = pstart + 1

    End While

  End Sub
  '
  '   Delete variable initializations 
  Sub RemoveInitializations(ByRef str As String, Optional ByVal OnlyInternal As Boolean = False)
    Dim pstart, p, TextLength As Long, s As String

    TextLength = Len(str)
    pstart = 1
    While 0 < pstart And pstart < TextLength
      ' find the beginning of block
      While 0 < pstart And pstart < TextLength And GetChar(str, pstart) <> "="
        pstart = pstart + 1
      End While

      If pstart >= TextLength Then Exit Sub ' no initializations

      p = pstart ' beginning position of searching the initialization end

      While p <= TextLength
        p = p + 1
        s = GetChar(str, p)
        If (OnlyInternal = False And (s = ")" Or s = "," Or s = Chr(4) Or s = ";") Or _
           (OnlyInternal = True And (s = "," Or s = Chr(4) Or s = ";"))) Then Exit While

      End While
      str = Left(str, pstart - 1) & Mid(str, p)
      TextLength = Len(str)
    End While

  End Sub
  '
  '   Delete all imported functions (from the ; after closing bracket) as we can't change anything in them
  Sub RemoveImportedFunctions(ByRef str As String)
    Dim p1, p2 As Long

    ' package spaces before and after separators of parameters list
    While InStr(str, " ;") > 0
      str = Replace(str, " ;", ";")
    End While
    While InStr(str, " (") > 0
      str = Replace(str, " (", "(")
    End While

    p2 = InStr(str, ");")
    While p2 > 0 ' while functions are present - delete them
      p1 = p2 - 1 ' find the opening bracket
      While p1 > 0 And GetChar(str, p1) <> "("
        p1 = p1 - 1
      End While
      ' skip function name
      While p1 > 1 And GetChar(str, p1) <> " "
        p1 = p1 - 1
      End While
      p1 = p1 - 1 ' shift after the separating space
      ' skip the type of returned function value
      While GetChar(str, p1) <> " "
        p1 = p1 - 1
      End While

      str = Left(str, p1 - 1) & Mid(str, p2 + 2) ' +2 to );

      p2 = InStr(str, ");")
    End While
    str = ReplaceWord(str, "#import", "")
  End Sub
  '
  '   Delete repeating characters
  Sub RemoveDubles(ByRef str As String, Optional ByVal s As String = " ")
    While Strings.InStr(str, s & s) > 0
      str = Strings.Replace(str, s & s, s)
    End While
  End Sub
  '
  '   Delete reserved words
  Sub RemoveReservedWords(ByRef str As String)

    str = ReplaceWord(str, "start", "")
    str = ReplaceWord(str, "init", "")
    str = ReplaceWord(str, "deinit", "")

    str = ReplaceWord(str, "#define", "")
    str = ReplaceWord(str, "#include", "")
    str = ReplaceWord(str, "#import", "")
    str = ReplaceWord(str, "#property", "")
    str = ReplaceWord(str, "#pragma", "")
    str = ReplaceWord(str, "bool", "")
    str = ReplaceWord(str, "break", "")
    str = ReplaceWord(str, "case", "")
    str = ReplaceWord(str, "color", "")
    str = ReplaceWord(str, "continue", "")
    str = ReplaceWord(str, "datetime", "")
    str = ReplaceWord(str, "default", "")
    str = ReplaceWord(str, "double", "")
    str = ReplaceWord(str, "else", "")
    str = ReplaceWord(str, "extern", "")
    str = ReplaceWord(str, "false", "")
    str = ReplaceWord(str, "for", "")
    str = ReplaceWord(str, "if", "")
    str = ReplaceWord(str, "int", "")
    str = ReplaceWord(str, "return", "")
    str = ReplaceWord(str, "static", "")
    str = ReplaceWord(str, "string", "")
    str = ReplaceWord(str, "switch", "")
    str = ReplaceWord(str, "true", "")
    str = ReplaceWord(str, "void", "")
    str = ReplaceWord(str, "while", "")
    str = ReplaceWord(str, "AccountBalance", "")
    str = ReplaceWord(str, "AccountCompany", "")
    str = ReplaceWord(str, "AccountCredit", "")
    str = ReplaceWord(str, "AccountCurrency", "")
    str = ReplaceWord(str, "AccountEquity", "")
    str = ReplaceWord(str, "AccountFreeMargin", "")
    str = ReplaceWord(str, "AccountFreeMarginCheck", "")
    str = ReplaceWord(str, "AccountFreeMarginMode", "")
    str = ReplaceWord(str, "AccountLeverage", "")
    str = ReplaceWord(str, "AccountMargin", "")
    str = ReplaceWord(str, "AccountName", "")
    str = ReplaceWord(str, "AccountNumber", "")
    str = ReplaceWord(str, "AccountProfit", "")
    str = ReplaceWord(str, "AccountServer", "")
    str = ReplaceWord(str, "AccountStopoutLevel", "")
    str = ReplaceWord(str, "AccountStopoutMode", "")
    str = ReplaceWord(str, "Alert", "")
    str = ReplaceWord(str, "ArrayBsearch", "")
    str = ReplaceWord(str, "ArrayCopy", "")
    str = ReplaceWord(str, "ArrayCopyRates", "")
    str = ReplaceWord(str, "ArrayCopySeries", "")
    str = ReplaceWord(str, "ArrayDimension", "")
    str = ReplaceWord(str, "ArrayGetAsSeries", "")
    str = ReplaceWord(str, "ArrayInitialize", "")
    str = ReplaceWord(str, "ArrayIsSeries", "")
    str = ReplaceWord(str, "ArrayMaximum", "")
    str = ReplaceWord(str, "ArrayMinimum", "")
    str = ReplaceWord(str, "ArrayRange", "")
    str = ReplaceWord(str, "ArrayResize", "")
    str = ReplaceWord(str, "ArraySetAsSeries", "")
    str = ReplaceWord(str, "ArraySize", "")
    str = ReplaceWord(str, "ArraySort", "")
    str = ReplaceWord(str, "CharToStr", "")
    str = ReplaceWord(str, "Comment", "")
    str = ReplaceWord(str, "Day", "")
    str = ReplaceWord(str, "DayOfWeek", "")
    str = ReplaceWord(str, "DayOfYear", "")
    str = ReplaceWord(str, "DoubleToStr", "")
    str = ReplaceWord(str, "FileClose", "")
    str = ReplaceWord(str, "FileDelete", "")
    str = ReplaceWord(str, "FileFlush", "")
    str = ReplaceWord(str, "FileIsEnding", "")
    str = ReplaceWord(str, "FileIsLineEnding", "")
    str = ReplaceWord(str, "FileOpen", "")
    str = ReplaceWord(str, "FileOpenHistory", "")
    str = ReplaceWord(str, "FileReadArray", "")
    str = ReplaceWord(str, "FileReadDouble", "")
    str = ReplaceWord(str, "FileReadInteger", "")
    str = ReplaceWord(str, "FileReadNumber", "")
    str = ReplaceWord(str, "FileReadString", "")
    str = ReplaceWord(str, "FileSeek", "")
    str = ReplaceWord(str, "FileSize", "")
    str = ReplaceWord(str, "FileTell", "")
    str = ReplaceWord(str, "FileWrite", "")
    str = ReplaceWord(str, "FileWriteArray", "")
    str = ReplaceWord(str, "FileWriteDouble", "")
    str = ReplaceWord(str, "FileWriteInteger", "")
    str = ReplaceWord(str, "FileWriteString", "")
    str = ReplaceWord(str, "GetLastError", "")
    str = ReplaceWord(str, "GetTickCount", "")
    str = ReplaceWord(str, "GlobalVariableCheck", "")
    str = ReplaceWord(str, "GlobalVariableDel", "")
    str = ReplaceWord(str, "GlobalVariableGet", "")
    str = ReplaceWord(str, "GlobalVariableName", "")
    str = ReplaceWord(str, "GlobalVariableSet", "")
    str = ReplaceWord(str, "GlobalVariableSetOnCondition", "")
    str = ReplaceWord(str, "GlobalVariablesDeleteAll", "")
    str = ReplaceWord(str, "GlobalVariablesTotal", "")
    str = ReplaceWord(str, "HideTestIndicators", "")
    str = ReplaceWord(str, "Hour", "")
    str = ReplaceWord(str, "IndicatorBuffers", "")
    str = ReplaceWord(str, "IndicatorCounted", "")
    str = ReplaceWord(str, "IndicatorDigits", "")
    str = ReplaceWord(str, "IndicatorShortName", "")
    str = ReplaceWord(str, "IsConnected", "")
    str = ReplaceWord(str, "IsDemo", "")
    str = ReplaceWord(str, "IsDllsAllowed", "")
    str = ReplaceWord(str, "IsExpertEnabled", "")
    str = ReplaceWord(str, "IsLibrariesAllowed", "")
    str = ReplaceWord(str, "IsOptimization", "")
    str = ReplaceWord(str, "IsStopped", "")
    str = ReplaceWord(str, "IsTesting", "")
    str = ReplaceWord(str, "IsTradeAllowed", "")
    str = ReplaceWord(str, "IsTradeContextBusy", "")
    str = ReplaceWord(str, "IsVisualMode", "")
    str = ReplaceWord(str, "MarketInfo", "")
    str = ReplaceWord(str, "MathAbs", "")
    str = ReplaceWord(str, "MathArccos", "")
    str = ReplaceWord(str, "MathArcsin", "")
    str = ReplaceWord(str, "MathArctan", "")
    str = ReplaceWord(str, "MathCeil", "")
    str = ReplaceWord(str, "MathCos", "")
    str = ReplaceWord(str, "MathExp", "")
    str = ReplaceWord(str, "MathFloor", "")
    str = ReplaceWord(str, "MathLog", "")
    str = ReplaceWord(str, "MathMax", "")
    str = ReplaceWord(str, "MathMin", "")
    str = ReplaceWord(str, "MathMod", "")
    str = ReplaceWord(str, "MathPow", "")
    str = ReplaceWord(str, "MathRand", "")
    str = ReplaceWord(str, "MathRound", "")
    str = ReplaceWord(str, "MathSin", "")
    str = ReplaceWord(str, "MathSqrt", "")
    str = ReplaceWord(str, "MathSrand", "")
    str = ReplaceWord(str, "MathTan", "")
    str = ReplaceWord(str, "MessageBox", "")
    str = ReplaceWord(str, "Minute", "")
    str = ReplaceWord(str, "Month", "")
    str = ReplaceWord(str, "NormalizeDouble", "")
    str = ReplaceWord(str, "ObjectCreate", "")
    str = ReplaceWord(str, "ObjectDelete", "")
    str = ReplaceWord(str, "ObjectDescription", "")
    str = ReplaceWord(str, "ObjectFind", "")
    str = ReplaceWord(str, "ObjectGet", "")
    str = ReplaceWord(str, "ObjectGetFiboDescription", "")
    str = ReplaceWord(str, "ObjectGetShiftByValue", "")
    str = ReplaceWord(str, "ObjectGetValueByShift", "")
    str = ReplaceWord(str, "ObjectMove", "")
    str = ReplaceWord(str, "ObjectName", "")
    str = ReplaceWord(str, "ObjectSet", "")
    str = ReplaceWord(str, "ObjectSetFiboDescription", "")
    str = ReplaceWord(str, "ObjectSetText", "")
    str = ReplaceWord(str, "ObjectType", "")
    str = ReplaceWord(str, "ObjectsDeleteAll", "")
    str = ReplaceWord(str, "ObjectsTotal", "")
    str = ReplaceWord(str, "OrderClose", "")
    str = ReplaceWord(str, "OrderCloseBy", "")
    str = ReplaceWord(str, "OrderClosePrice", "")
    str = ReplaceWord(str, "OrderCloseTime", "")
    str = ReplaceWord(str, "OrderComment", "")
    str = ReplaceWord(str, "OrderCommission", "")
    str = ReplaceWord(str, "OrderDelete", "")
    str = ReplaceWord(str, "OrderExpiration", "")
    str = ReplaceWord(str, "OrderLots", "")
    str = ReplaceWord(str, "OrderMagicNumber", "")
    str = ReplaceWord(str, "OrderModify", "")
    str = ReplaceWord(str, "OrderOpenPrice", "")
    str = ReplaceWord(str, "OrderOpenTime", "")
    str = ReplaceWord(str, "OrderPrint", "")
    str = ReplaceWord(str, "OrderProfit", "")
    str = ReplaceWord(str, "OrderSelect", "")
    str = ReplaceWord(str, "OrderSend", "")
    str = ReplaceWord(str, "OrderStopLoss", "")
    str = ReplaceWord(str, "OrderSwap", "")
    str = ReplaceWord(str, "OrderSymbol", "")
    str = ReplaceWord(str, "OrderTakeProfit", "")
    str = ReplaceWord(str, "OrderTicket", "")
    str = ReplaceWord(str, "OrderType", "")
    str = ReplaceWord(str, "OrdersHistoryTotal", "")
    str = ReplaceWord(str, "OrdersTotal", "")
    str = ReplaceWord(str, "Period", "")
    str = ReplaceWord(str, "PlaySound", "")
    str = ReplaceWord(str, "Print", "")
    str = ReplaceWord(str, "RefreshRates", "")
    str = ReplaceWord(str, "Seconds", "")
    str = ReplaceWord(str, "SendFTP", "")
    str = ReplaceWord(str, "SendMail", "")
    str = ReplaceWord(str, "SetIndexArrow", "")
    str = ReplaceWord(str, "SetIndexBuffer", "")
    str = ReplaceWord(str, "SetIndexDrawBegin", "")
    str = ReplaceWord(str, "SetIndexEmptyValue", "")
    str = ReplaceWord(str, "SetIndexLabel", "")
    str = ReplaceWord(str, "SetIndexShift", "")
    str = ReplaceWord(str, "SetIndexStyle", "")
    str = ReplaceWord(str, "SetLevelStyle", "")
    str = ReplaceWord(str, "SetLevelValue", "")
    str = ReplaceWord(str, "Sleep", "")
    str = ReplaceWord(str, "StrToDouble", "")
    str = ReplaceWord(str, "StrToInteger", "")
    str = ReplaceWord(str, "StrToTime", "")
    str = ReplaceWord(str, "StringConcatenate", "")
    str = ReplaceWord(str, "StringFind", "")
    str = ReplaceWord(str, "StringGetChar", "")
    str = ReplaceWord(str, "StringLen", "")
    str = ReplaceWord(str, "StringSetChar", "")
    str = ReplaceWord(str, "StringSubstr", "")
    str = ReplaceWord(str, "StringTrimLeft", "")
    str = ReplaceWord(str, "StringTrimRight", "")
    str = ReplaceWord(str, "Symbol", "")
    str = ReplaceWord(str, "TerminalCompany", "")
    str = ReplaceWord(str, "TerminalName", "")
    str = ReplaceWord(str, "TerminalPath", "")
    str = ReplaceWord(str, "TimeCurrent", "")
    str = ReplaceWord(str, "TimeDay", "")
    str = ReplaceWord(str, "TimeDayOfWeek", "")
    str = ReplaceWord(str, "TimeDayOfYear", "")
    str = ReplaceWord(str, "TimeHour", "")
    str = ReplaceWord(str, "TimeLocal", "")
    str = ReplaceWord(str, "TimeMinute", "")
    str = ReplaceWord(str, "TimeMonth", "")
    str = ReplaceWord(str, "TimeSeconds", "")
    str = ReplaceWord(str, "TimeToStr", "")
    str = ReplaceWord(str, "TimeYear", "")
    str = ReplaceWord(str, "UninitializeReason", "")
    str = ReplaceWord(str, "WindowBarsPerChart", "")
    str = ReplaceWord(str, "WindowExpertName", "")
    str = ReplaceWord(str, "WindowFind", "")
    str = ReplaceWord(str, "WindowFirstVisibleBar", "")
    str = ReplaceWord(str, "WindowHandle", "")
    str = ReplaceWord(str, "WindowIsVisible", "")
    str = ReplaceWord(str, "WindowOnDropped", "")
    str = ReplaceWord(str, "WindowPriceMax", "")
    str = ReplaceWord(str, "WindowPriceMin", "")
    str = ReplaceWord(str, "WindowPriceOnDropped", "")
    str = ReplaceWord(str, "WindowRedraw", "")
    str = ReplaceWord(str, "WindowScreenShot", "")
    str = ReplaceWord(str, "WindowTimeOnDropped", "")
    str = ReplaceWord(str, "WindowXOnDropped", "")
    str = ReplaceWord(str, "WindowYOnDropped", "")
    str = ReplaceWord(str, "WindowsTotal", "")
    str = ReplaceWord(str, "Year", "")
    str = ReplaceWord(str, "deinit", "")
    str = ReplaceWord(str, "iBarShift", "")
    str = ReplaceWord(str, "iBars", "")
    str = ReplaceWord(str, "iClose", "")
    str = ReplaceWord(str, "iHigh", "")
    str = ReplaceWord(str, "iHighest", "")
    str = ReplaceWord(str, "iLow", "")
    str = ReplaceWord(str, "iLowest", "")
    str = ReplaceWord(str, "iOpen", "")
    str = ReplaceWord(str, "iTime", "")
    str = ReplaceWord(str, "iVolume", "")
    str = ReplaceWord(str, "init", "")
    str = ReplaceWord(str, "start", "")
    str = ReplaceWord(str, "iAC", "")
    str = ReplaceWord(str, "iAD", "")
    str = ReplaceWord(str, "iADX", "")
    str = ReplaceWord(str, "iAO", "")
    str = ReplaceWord(str, "iATR", "")
    str = ReplaceWord(str, "iAlligator", "")
    str = ReplaceWord(str, "iBWMFI", "")
    str = ReplaceWord(str, "iBands", "")
    str = ReplaceWord(str, "iBandsOnArray", "")
    str = ReplaceWord(str, "iBearsPower", "")
    str = ReplaceWord(str, "iBullsPower", "")
    str = ReplaceWord(str, "iCCI", "")
    str = ReplaceWord(str, "iCCIOnArray", "")
    str = ReplaceWord(str, "iCustom", "")
    str = ReplaceWord(str, "iDeMarker", "")
    str = ReplaceWord(str, "iEnvelopes", "")
    str = ReplaceWord(str, "iEnvelopesOnArray", "")
    str = ReplaceWord(str, "iForce", "")
    str = ReplaceWord(str, "iFractals", "")
    str = ReplaceWord(str, "iGator", "")
    str = ReplaceWord(str, "iIchimoku", "")
    str = ReplaceWord(str, "iMA", "")
    str = ReplaceWord(str, "iMACD", "")
    str = ReplaceWord(str, "iMAOnArray", "")
    str = ReplaceWord(str, "iMFI", "")
    str = ReplaceWord(str, "iMomentum", "")
    str = ReplaceWord(str, "iMomentumOnArray", "")
    str = ReplaceWord(str, "iOBV", "")
    str = ReplaceWord(str, "iOsMA", "")
    str = ReplaceWord(str, "iRSI", "")
    str = ReplaceWord(str, "iRSIOnArray", "")
    str = ReplaceWord(str, "iRVI", "")
    str = ReplaceWord(str, "iSAR", "")
    str = ReplaceWord(str, "iStdDev", "")
    str = ReplaceWord(str, "iStdDevOnArray", "")
    str = ReplaceWord(str, "iStochastic", "")
    str = ReplaceWord(str, "iWPR", "")
    str = ReplaceWord(str, "Ask", "")
    str = ReplaceWord(str, "Bars", "")
    str = ReplaceWord(str, "Bid", "")
    str = ReplaceWord(str, "Close", "")
    str = ReplaceWord(str, "Digits", "")
    str = ReplaceWord(str, "High", "")
    str = ReplaceWord(str, "Low", "")
    str = ReplaceWord(str, "Open", "")
    str = ReplaceWord(str, "Point", "")
    str = ReplaceWord(str, "Time", "")
    str = ReplaceWord(str, "Volume", "")
    str = ReplaceWord(str, "copyright", "")
    str = ReplaceWord(str, "indicator_buffers", "")
    str = ReplaceWord(str, "indicator_chart_window", "")
    str = ReplaceWord(str, "indicator_colorN", "")
    str = ReplaceWord(str, "indicator_levelN", "")
    str = ReplaceWord(str, "indicator_levelcolor", "")
    str = ReplaceWord(str, "indicator_levelstyle", "")
    str = ReplaceWord(str, "indicator_levelwidth", "")
    str = ReplaceWord(str, "indicator_maximum", "")
    str = ReplaceWord(str, "indicator_minimum", "")
    str = ReplaceWord(str, "indicator_separate_window", "")
    str = ReplaceWord(str, "indicator_styleN", "")
    str = ReplaceWord(str, "indicator_widthN", "")
    str = ReplaceWord(str, "library", "")
    str = ReplaceWord(str, "link", "")
    str = ReplaceWord(str, "show_confirm", "")
    str = ReplaceWord(str, "show_inputs", "")
    str = ReplaceWord(str, "stacksize", "")
    str = ReplaceWord(str, "AliceBlue", "")
    str = ReplaceWord(str, "AntiqueWhite", "")
    str = ReplaceWord(str, "Aqua", "")
    str = ReplaceWord(str, "Aquamarine", "")
    str = ReplaceWord(str, "Beige", "")
    str = ReplaceWord(str, "Bisque", "")
    str = ReplaceWord(str, "Black", "")
    str = ReplaceWord(str, "BlanchedAlmond", "")
    str = ReplaceWord(str, "Blue", "")
    str = ReplaceWord(str, "BlueViolet", "")
    str = ReplaceWord(str, "Brown", "")
    str = ReplaceWord(str, "BurlyWood", "")
    str = ReplaceWord(str, "CadetBlue", "")
    str = ReplaceWord(str, "Chartreuse", "")
    str = ReplaceWord(str, "Chocolate", "")
    str = ReplaceWord(str, "Coral", "")
    str = ReplaceWord(str, "CornflowerBlue", "")
    str = ReplaceWord(str, "Cornsilk", "")
    str = ReplaceWord(str, "Crimson", "")
    str = ReplaceWord(str, "DarkBlue", "")
    str = ReplaceWord(str, "DarkGoldenrod", "")
    str = ReplaceWord(str, "DarkGray", "")
    str = ReplaceWord(str, "DarkGreen", "")
    str = ReplaceWord(str, "DarkKhaki", "")
    str = ReplaceWord(str, "DarkOliveGreen", "")
    str = ReplaceWord(str, "DarkOrange", "")
    str = ReplaceWord(str, "DarkOrchid", "")
    str = ReplaceWord(str, "DarkSalmon", "")
    str = ReplaceWord(str, "DarkSeaGreen", "")
    str = ReplaceWord(str, "DarkSlateBlue", "")
    str = ReplaceWord(str, "DarkSlateGray", "")
    str = ReplaceWord(str, "DarkTurquoise", "")
    str = ReplaceWord(str, "DarkViolet", "")
    str = ReplaceWord(str, "DeepPink", "")
    str = ReplaceWord(str, "DeepSkyBlue", "")
    str = ReplaceWord(str, "DimGray", "")
    str = ReplaceWord(str, "DodgerBlue", "")
    str = ReplaceWord(str, "FireBrick", "")
    str = ReplaceWord(str, "ForestGreen", "")
    str = ReplaceWord(str, "Gainsboro", "")
    str = ReplaceWord(str, "Gold", "")
    str = ReplaceWord(str, "Goldenrod", "")
    str = ReplaceWord(str, "Gray", "")
    str = ReplaceWord(str, "Green", "")
    str = ReplaceWord(str, "GreenYellow", "")
    str = ReplaceWord(str, "Honeydew", "")
    str = ReplaceWord(str, "HotPink", "")
    str = ReplaceWord(str, "IndianRed", "")
    str = ReplaceWord(str, "Indigo", "")
    str = ReplaceWord(str, "Ivory", "")
    str = ReplaceWord(str, "Khaki", "")
    str = ReplaceWord(str, "Lavender", "")
    str = ReplaceWord(str, "LavenderBlush", "")
    str = ReplaceWord(str, "LawnGreen", "")
    str = ReplaceWord(str, "LemonChiffon", "")
    str = ReplaceWord(str, "LightBlue", "")
    str = ReplaceWord(str, "LightCoral", "")
    str = ReplaceWord(str, "LightCyan", "")
    str = ReplaceWord(str, "LightGoldenrod", "")
    str = ReplaceWord(str, "LightGray", "")
    str = ReplaceWord(str, "LightGreen", "")
    str = ReplaceWord(str, "LightPink", "")
    str = ReplaceWord(str, "LightSalmon", "")
    str = ReplaceWord(str, "LightSeaGreen", "")
    str = ReplaceWord(str, "LightSkyBlue", "")
    str = ReplaceWord(str, "LightSlateGray", "")
    str = ReplaceWord(str, "LightSteelBlue", "")
    str = ReplaceWord(str, "LightYellow", "")
    str = ReplaceWord(str, "Lime", "")
    str = ReplaceWord(str, "LimeGreen", "")
    str = ReplaceWord(str, "Linen", "")
    str = ReplaceWord(str, "Magenta", "")
    str = ReplaceWord(str, "Maroon", "")
    str = ReplaceWord(str, "MediumAquamarine", "")
    str = ReplaceWord(str, "MediumBlue", "")
    str = ReplaceWord(str, "MediumOrchid", "")
    str = ReplaceWord(str, "MediumPurple", "")
    str = ReplaceWord(str, "MediumSeaGreen", "")
    str = ReplaceWord(str, "MediumSlateBlue", "")
    str = ReplaceWord(str, "MediumSpringGreen", "")
    str = ReplaceWord(str, "MediumTurquoise", "")
    str = ReplaceWord(str, "MediumVioletRed", "")
    str = ReplaceWord(str, "MidnightBlue", "")
    str = ReplaceWord(str, "MintCream", "")
    str = ReplaceWord(str, "MistyRose", "")
    str = ReplaceWord(str, "Moccasin", "")
    str = ReplaceWord(str, "NavajoWhite", "")
    str = ReplaceWord(str, "Navy", "")
    str = ReplaceWord(str, "OldLace", "")
    str = ReplaceWord(str, "Olive", "")
    str = ReplaceWord(str, "OliveDrab", "")
    str = ReplaceWord(str, "Orange", "")
    str = ReplaceWord(str, "OrangeRed", "")
    str = ReplaceWord(str, "Orchid", "")
    str = ReplaceWord(str, "PaleGoldenrod", "")
    str = ReplaceWord(str, "PaleGreen", "")
    str = ReplaceWord(str, "PaleTurquoise", "")
    str = ReplaceWord(str, "PaleVioletRed", "")
    str = ReplaceWord(str, "PapayaWhip", "")
    str = ReplaceWord(str, "PeachPuff", "")
    str = ReplaceWord(str, "Peru", "")
    str = ReplaceWord(str, "Pink", "")
    str = ReplaceWord(str, "Plum", "")
    str = ReplaceWord(str, "PowderBlue", "")
    str = ReplaceWord(str, "Purple", "")
    str = ReplaceWord(str, "Red", "")
    str = ReplaceWord(str, "RosyBrown", "")
    str = ReplaceWord(str, "RoyalBlue", "")
    str = ReplaceWord(str, "SaddleBrown", "")
    str = ReplaceWord(str, "Salmon", "")
    str = ReplaceWord(str, "SandyBrown", "")
    str = ReplaceWord(str, "SeaGreen", "")
    str = ReplaceWord(str, "Seashell", "")
    str = ReplaceWord(str, "Sienna", "")
    str = ReplaceWord(str, "Silver", "")
    str = ReplaceWord(str, "SkyBlue", "")
    str = ReplaceWord(str, "SlateBlue", "")
    str = ReplaceWord(str, "SlateGray", "")
    str = ReplaceWord(str, "Snow", "")
    str = ReplaceWord(str, "SpringGreen", "")
    str = ReplaceWord(str, "SteelBlue", "")
    str = ReplaceWord(str, "Tan", "")
    str = ReplaceWord(str, "Teal", "")
    str = ReplaceWord(str, "Thistle", "")
    str = ReplaceWord(str, "Tomato", "")
    str = ReplaceWord(str, "Turquoise", "")
    str = ReplaceWord(str, "Violet", "")
    str = ReplaceWord(str, "Wheat", "")
    str = ReplaceWord(str, "White", "")
    str = ReplaceWord(str, "WhiteSmoke", "")
    str = ReplaceWord(str, "Yellow", "")
    str = ReplaceWord(str, "YellowGreen", "")

    str = ReplaceWord(str, "copyright", "")
    str = ReplaceWord(str, "link", "")
  End Sub

  '
  '   Slightly compact the text
  Sub PackText(ByRef str As String)
    While InStr(str, vbTab) > 0
      str = Replace(str, vbTab, "  ")
    End While
    While InStr(str, " " & vbCrLf) > 0
      str = Replace(str, " " & vbCrLf, vbCrLf)
    End While
    While InStr(str, vbCrLf & vbCrLf) > 0
      str = Replace(str, vbCrLf & vbCrLf, vbCrLf)
    End While
  End Sub

  '
  '        Find the set word in the str string beginning from the p position. Return 0 if it is not found
  Function FindWord(ByVal str As String, ByVal p As Long, _
                    ByVal WordToFind As String, Optional ByVal IgnoreCase As Boolean = True) As Long
    If IgnoreCase Then
      FindWord = InStr(p, UCase(str), UCase(WordToFind), CompareMethod.Binary)
    Else
      FindWord = InStr(p, str, WordToFind, CompareMethod.Binary)
    End If
  End Function

  '
  '        Find the set word in the str string beginning from the p position. Separators must be to the left and to the right!
  Function FindWholeWord(ByVal str As String, ByVal p As Long, _
                    ByVal WordToFind As String, Optional ByVal IgnoreCase As Boolean = True) As Long
    Dim p1 As Long, sLeft, sRight As String
    FindWholeWord = 0
    p1 = FindWord(str, p, WordToFind, False)
    While p1 > 0 And p1 < Strings.Len(str)
      If p1 = 1 Then sLeft = " " Else sLeft = Strings.GetChar(str, p1 - 1)
      If p1 >= Strings.Len(str) Then sRight = " " Else sRight = Strings.GetChar(str, p1 + Strings.Len(WordToFind))
      If (sLeft <> Chr(3) And sRight <> Chr(3)) And _
         (Strings.InStr(DivSymbols & DivSymbolsAdd, sLeft) > 0) And _
         (Strings.InStr(DivSymbols & DivSymbolsAdd, sRight) > 0) And _
         (Not (WordToFind = "D" And sRight = "'")) Then
        FindWholeWord = p1
        Exit Function
      Else
        p1 = FindWord(str, p1 + Strings.Len(WordToFind), WordToFind, False)
      End If
    End While
  End Function

  '
  '        Replace word. Separators must be to the left and to the right!
  Function ReplaceWord(ByVal str As String, ByVal find As String, ByVal replace As String) As String
    Dim p1, p As Long, sLeft, sRight As String
    p1 = 1
    p1 = FindWord(str, p1, find, False)
    While p1 > 0 And p1 < Strings.Len(str)
      If p1 = 1 Then sLeft = " " Else sLeft = Strings.GetChar(str, p1 - 1)
      sRight = Strings.GetChar(str, p1 + Strings.Len(find))
      If (sLeft <> Chr(3) And sRight <> Chr(3)) And _
         (Strings.InStr(DivSymbols & DivSymbolsAdd, sLeft) > 0) And _
         (Strings.InStr(DivSymbols & DivSymbolsAdd, sRight) > 0) And _
         (Not (find = "D" And sRight = "'")) Then
        str = Strings.Left(str, p1 - 1) & replace & Strings.Mid(str, p1 + Strings.Len(find))
      End If
      p1 = FindWord(str, p1 + 1, find, False)
    End While
    ReplaceWord = str
  End Function

  '
  '        Skip spaces and line breaks
  Function SkipBlanks(ByVal str As String, ByVal p As Long) As Long
    Dim TextLength As Long, s As String
    TextLength = Strings.Len(str)
    s = Strings.GetChar(str, p)
    While p < TextLength - 1 And (s = " " Or s = vbCrLf)
      p = p + 1
      s = Strings.GetChar(str, p)
    End While
    SkipBlanks = p
  End Function

End Module
