//+------------------------------------------------------------------+
//|                                              File Read Write.mq4 |
//|                      Copyright  2008, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2008, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net/"

//    _lopen
#define OF_READ               0
#define OF_WRITE              1
#define OF_READWRITE          2
#define OF_SHARE_COMPAT       3
#define OF_SHARE_DENY_NONE    4
#define OF_SHARE_DENY_READ    5
#define OF_SHARE_DENY_WRITE   6
#define OF_SHARE_EXCLUSIVE    7

#import "kernel32.dll"
   int _lopen  (string path, int of);
   int _lcreat (string path, int attrib);
   int _llseek (int handle, int offset, int origin);
   int _lread  (int handle, string buffer, int bytes);
   int _lwrite (int handle, string buffer, int bytes);
   int _lclose (int handle);
   int CreateDirectoryA(string path, int atrr[]);
#import

// _lopen  : p  . p:  .
// _lcreat :   .   p:  .
// _llseek :    p . p: 
//   .
// _lread  :   p    . 
// p:   ; 0 -   .
// _lwrite :    p   . p: 
//   .
// _lclose : p  . p: 0.
//    p     
// HFILE_ERROR=-1.
 
// path   : p, p    .
// of     :  .
// attrib : 0 -   ; 1 -  ; 2 -   
// 3 - .
// handle :  .
// offset :  ,  p p .
// origin :     p p: 0 - 
// p  ; 1 -   ; 2 -    .
// buffer : p/ p.
// bytes  :   .
 
//   ( of):
// int OF_READ            =0; //     
// int OF_WRITE           =1; //     
// int OF_READWRITE       =2; //     /
// int OF_SHARE_COMPAT    =3; //      
//  .         
//    .        
// ,   HFILE_ERROR.
// int OF_SHARE_DENY_NONE =4; //       
//    /  .    
//     OF_SHARE_COMPAT,   HFILE_ERROR.
// int OF_SHARE_DENY_READ =5; //        
//     .      
//   OF_SHARE_COMPAT / OF_READ  OF_READWRITE,  
//  HFILE_ERROR.
// int OF_SHARE_DENY_WRITE=6; //  ,     .
// int OF_SHARE_EXCLUSIVE =7; //       
//       /.      
//     ( ).    
//    .
//+------------------------------------------------------------------+
//|                            |
//+------------------------------------------------------------------+
string ReadFile (string path) 
  {
    int handle=_lopen (path,OF_READ);
    int read_size = 50;           
    string char50="x                                                 ";

    if(handle<0) 
      {
        Print("   ",path); 
        return ("");
      }
    int result=_llseek (handle,0,0);      
    if(result<0) 
      {
        Print("  " ); 
        return ("");
      }
    string buffer="";
    int count=0;
    int last;
    
    result=_lread (handle,char50,read_size);
    while(result>0 && result == read_size) 
      {
        buffer=buffer + char50;
        count++;
        result=_lread (handle,char50,read_size);
        last = result;
     }
    Print("      :", last);
    char50 = StringSubstr(char50,0,last);
    buffer = buffer + char50;    
    result=_lclose (handle);              
    if(result<0)  
      Print("   ",path);
    return (buffer);
  }
 
//+------------------------------------------------------------------+
//|                          |
//+------------------------------------------------------------------+
void WriteFile (string path, string buffer) 
  {
    int count=StringLen (buffer); 
    int result;
    int handle=_lopen (path,OF_WRITE);
    if(handle<0) 
      {
        handle=_lcreat (path,0);
        if(handle<0) 
          {
            Print ("   ",path);
            if (!CreateFullPath(path))
               {
               Print("   :",path);
               return;
               }
            else handle=_lcreat (path,0);   
          }
        result=_lclose (handle);
        handle = -1;
     }
    if (handle < 0) handle=_lopen (path,OF_WRITE);               
    if(handle<0) 
      {
        Print("   ",path); 
        return;
      }
    result=_llseek (handle,0,0);          
    if(result<0) 
      {
        Print("  "); 
        return;
      }
    result=_lwrite (handle,buffer,count); 
    if(result<0)  
        Print("    ",path," ",count," ");
    result=_lclose (handle);              
    if(result<0)  
        Print("   ",path);
    return;        
  }
//+------------------------------------------------------------------+
//|                               |
//+------------------------------------------------------------------+
bool CreateFullPath(string path)
   {
   bool res = false;
   if (StringLen(path)==0) return(false);
   Print(" =>",path);
//----
   string folders[];
   if (!ParsePath(folders, path)) return(false);
   Print("  :", ArraySize(folders));
   
   int empty[];
   int i = 0;
   while (CreateDirectoryA(folders[i],empty)==0) i++;
   Print(" :",folders[i]);
   i--;
   while (i>=0) 
      {
      CreateDirectoryA(folders[i],empty);
      Print(" :",folders[i]);
      i--;
      }
   if (i<0) res = true;   
//----
   return(res);
   }
   
//+------------------------------------------------------------------+
//|                                       |
//+------------------------------------------------------------------+
bool ParsePath(string & folder[], string path)
   {
   bool res = false;
   int k = StringLen(path);
   if (k==0) return(res);
   k--;

   Print(" =>", path);
   int folderNumber = 0;
//----
   int i = 0;
   while ( k >= 0 )
      {
      int char = StringGetChar(path, k);
      //Print("char = ",char, "=>",CharToStr(char));
      if ( char == 92) //    "\"
         {
         if (StringGetChar(path, k-1)!= 92)
            {
            folderNumber++;
            ArrayResize(folder,folderNumber);
            folder[folderNumber-1] = StringSubstr(path,0,k);
            Print(folderNumber,":",folder[folderNumber-1]);
            }
         else break;         
         }
      k--;   
      }
   if (folderNumber>0) res = true;   
//----
   return(res);   
   }   
  
//+------------------------------------------------------------------+
//| script program start function                                    |
//+------------------------------------------------------------------+
int start()
  {
//----
    int start = GetTickCount();
    string buffer=ReadFile("C:\\Text.txt");

    int middle = GetTickCount();
    int count=StringLen(buffer);

    Print(" :",count);

    WriteFile("C:\\folder_A\\folder_B\\folder_C\\folder_D\\Text2.txt",buffer);   
    int finish = GetTickCount();
    Print("  - ",count," bytes. :",(middle-start)," ms. :",(finish-middle)," ms.");
//----
   return(0);
  }
//+------------------------------------------------------------------+