//+------------------------------------------------------------------+
//|                                                    Coherence.mq5 |
//|                                  Copyright 2024, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2024, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"
#include<Math\Stat\Math.mqh>
#include<np.mqh>
#property indicator_separate_window
#property indicator_buffers 1
#property indicator_plots   1
//--- plot coherence
#property indicator_label1  "coherence"
#property indicator_type1   DRAW_LINE
#property indicator_color1  clrRed
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//--- input parameters
input int      period=5;
input string   symbols = "BTCUSD,DOGUSD,XRPUSD";
//---globals
int ibar,npred,lookback;
//double  total, diff, diff2;
double  minval, maxval, meanval ;
matrix covar;
CMatrixDouble evects;
CRowDouble evals;
double nonpar1[],nonpar2[];
string stringbuffer[];
//--- indicator buffers
double         coherenceBuffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
   npred = StringSplit(symbols,StringGetCharacter(",",0),stringbuffer);
   if(StringSubstr(symbols,StringLen(symbols)-1,1) == ",")
      npred--;

   if(npred<2)
     {
      Print(" Invalid inputs, there should be at least two symbols ");
      return INIT_FAILED;
     }

   lookback = period;

   if(!covar.Resize(npred,npred)||!evects.Resize(npred,npred)||!evals.Resize(npred)||
      ArrayResize(nonpar1,period)!=period || ArrayResize(nonpar2,period)!=period)
     {
      Print(" Memory allocation error ", GetLastError());
      return INIT_FAILED;
     }
//--- indicator buffers mapping
   SetIndexBuffer(0,coherenceBuffer,INDICATOR_DATA);
//---
   ArraySetAsSeries(coherenceBuffer,true);
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---
   bool incomplete_history=false;
   int stop = (prev_calculated<=0)?rates_total-lookback-1:rates_total-prev_calculated+1;
//---
   for(ibar=0 ; ibar<=stop ; ibar++)
     {

      for(uint i = 0; i<stringbuffer.Size(); i++)
        {
         if(!iClose(stringbuffer[i],PERIOD_CURRENT,ibar+lookback-1))
           {
            incomplete_history=true;
            break;
           }
        }

      if(incomplete_history)
        {
         coherenceBuffer[ibar] = 0.0;
         incomplete_history=false;
         continue;
        }

      covar[0][0] = 1.0 ;

      for(int i=1 ; i<npred ; i++)
        {
         for(int j=0 ; j<i ; j++)
           {
            for(int k=0 ; k<lookback ; k++)
              {
               nonpar1[k] = iClose(stringbuffer[i],PERIOD_CURRENT,ibar+k);
               nonpar2[k] = iClose(stringbuffer[j],PERIOD_CURRENT,ibar+k);
              }
            if(!MathCorrelationSpearman(nonpar1,nonpar2,covar[i][j]))
               Print(" MathCorrelationSpearman failed ", GetLastError(), " :", ibar);
           }
         covar[i][i] = 1.0 ;
        }
      CMatrixDouble cdata(covar);
      if(!CEigenVDetect::SMatrixEVD(cdata,cdata.Rows(),0,false,evals,evects))
        {
         Print(" EVD failed ", GetLastError(), " :", ibar);
         coherenceBuffer[ibar]=0.0;
         continue;
        }

      vector eval = evals.ToVector();

      if(!np::reverseVector(eval))
         Print(" failed vecter reversal operation : ", ibar);

      double center = 0.5 * (npred - 1) ;
      double sum = 0.0;
      for(ulong i=0 ; i<eval.Size() ; i++)
        {
         sum += (center - i) * eval[i] / center ;
        }

      coherenceBuffer[ibar] =  sum / eval.Sum();
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
