function varargout = FromTo(varargin)
% FROMTO M-file for FromTo.fig
%      FROMTO, by itself, creates a new FROMTO or raises the existing
%      singleton*.
%
%      H = FROMTO returns the handle to a new FROMTO or the handle to
%      the existing singleton*.
%
%      FROMTO('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in FROMTO.M with the given input arguments.
%
%      FROMTO('Property','Value',...) creates a new FROMTO or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before FromTo_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to FromTo_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Copyright 2002-2003 The MathWorks, Inc.

% Edit the above text to modify the response to help FromTo

% Last Modified by GUIDE v2.5 01-Jul-2007 17:08:01

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @FromTo_OpeningFcn, ...
                   'gui_OutputFcn',  @FromTo_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before FromTo is made visible.
function FromTo_OpeningFcn(hObject, eventdata, handles, varargin)
guiName = get(handles.figure1, 'Name'); %    GUI
name = [guiName '_saveparam.mat'];      %   
h=fopen(name);                          %   
if h==-1                                %   
    path='D:\';                         %   
else
    load(name);                         %      
    fclose(h);                          %  
end
set(handles.editPath,'String', path);   %     "editPath"
timers = timerfind; %  
if ~isempty(timers) %   
    delete(timers); %    
end
handles.t = timer('TimerFcn',{@checktime, handles},'ExecutionMode','fixedRate','Period',1.0,'UserData', 'NONE');
% Choose default command line output for FromTo
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes FromTo wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = FromTo_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



function editPath_Callback(hObject, eventdata, handles)
% hObject    handle to editPath (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editPath as text
%        str2double(get(hObject,'String')) returns contents of editPath as a double


% --- Executes during object creation, after setting all properties.
function editPath_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editPath (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushBrowse.
function pushBrowse_Callback(hObject, eventdata, handles)
path = get(handles.editPath,'String') %     editPath 
[partPath, partName, partExt] = fileparts(path)    %    
template = [partPath '\*.txt'];                     %    
[userName, userPath] = uigetfile(template);         %      
if userName~=0                                      %            
    path = [userPath userName];                     %  
end
set(handles.editPath,'String', path);               %     "editPath"
guiName = get(handles.figure1, 'Name');             %    GUI
save([guiName '_saveparam.mat'], 'path');           %  

% --- Executes on button press in pushStart.
% --- Executes on button press in pushStart.
function pushStart_Callback(hObject, eventdata, handles)
% process(handles);
statusT = get(handles.t, 'Running'); %   
if strcmp(statusT,'on')     %   - 
    stop(handles.t);        % 
    set(hObject,'ForegroundColor','b'); %     pushStart
    set(hObject,'String',['Start ' datestr(now)]); %    
end     
if strcmp(statusT,'off')    %   - 
    start(handles.t);       % 
    set(hObject,'ForegroundColor','r');%     pushStart
    set(hObject,'String',['Stop ' datestr(now)]); %    
end 

% --- Executes when user attempts to close figure1.
function figure1_CloseRequestFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% Hint: delete(hObject) closes the figure
delete(hObject);
%  ,  , , 
function process(handles)
set(handles.figure1,'HandleVisibility','on');
fullname = get(handles.editPath, 'String'); %    editPath
data = dlmread(fullname, ';', 2, 2);    %    
info = ['Last update: ' datestr(now)];  %   
set(handles.textInfo, 'String',info);   %  info   
 
high = data(:,1);   %  high     data
low = data(:,2);    % d low -- 
close = data(:,3);  % --/--
open = data(:,4);   %
len = length(open); %    open
 
axes(handles.axesChart); %   
hold off; %      
candle(high, low, close, open); %  ""  (  )
set(handles.axesChart,'XLim',[1 len]); %     

fitPoly2 = fit((1:len)',open,'poly4'); %   
fresult = fitPoly2(1:len); %   Y  X=( 1  len)
hold on; %     
stairs(fresult,'r'); % plot   - 'r'- red

[pathstr,name,ext,versn] = fileparts(fullname); %   
                                                %   
newName = [pathstr '\' name '_result' ext];     %    
fresult = flipud(fresult);  %   fresult
dlmwrite(newName, fresult);    %   

% ,  
% ,  
function checktime(obj, event, handles)
filename = get(handles.editPath, 'String'); %    
fileInfo = dir(filename);        %    
oldTime = get(obj, 'UserData');  %  
if ~strcmp(fileInfo.date, oldTime) %   
    process(handles);
end
set(obj,'UserData',fileInfo.date); %  
set(handles.pushStart,'String',['Stop ' datestr(now)]); %  