//+------------------------------------------------------------------+
//|                                                          SMI.mq4 |
//|                      Copyright  2005, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2005, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"
//----     
#property indicator_separate_window
//----   
#property indicator_buffers 2
//----  
#property indicator_color1 Blue
#property indicator_color2 Red
//----   
#property indicator_level1 0
//----    
extern int Period_Q = 2;
extern int Period_R = 8;
extern int Period_S = 5;
extern int Signal = 5;
//----  
double SMI_Buffer[];
double Signal_Buffer[];
double SM_Buffer[];
double EMA_SM[];
double EMA2_SM[];
double EMA_HQ[];
double EMA2_HQ[];
double HQ_Buffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//----    
   IndicatorBuffers(8);
//----   
   SetIndexStyle(0, DRAW_LINE);
   SetIndexStyle(1, DRAW_LINE);
//----    
   SetIndexBuffer(0, SMI_Buffer);
   SetIndexBuffer(1, Signal_Buffer);
   SetIndexBuffer(2, SM_Buffer);
   SetIndexBuffer(3, EMA_SM);
   SetIndexBuffer(4, EMA2_SM);
   SetIndexBuffer(5, EMA_HQ);
   SetIndexBuffer(6, EMA2_HQ);
   SetIndexBuffer(7, HQ_Buffer);
//----         
   IndicatorShortName("SMI(" + Period_Q + "," + Period_R + "," + 
                      Period_S + "," + Signal + ")");
   SetIndexLabel(0, "SMI");
   SetIndexLabel(1, "Signal SMI");
//----  
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int MinBars = Period_Q + Period_R + Period_S + Signal; 
//----       
   if(Bars < MinBars)
       return(0);
//----+        
   int MaxBar, bar, ii, limit, HighestBar, LowestBar, 
       counted_bars = IndicatorCounted();
//----    
   if(counted_bars < 0)
       return(-1);
//----       
   if(counted_bars > 0) 
       counted_bars--;
//----     , 
//         
   MaxBar = Bars - 1 - MinBars;
//----     , 
//         
   limit = Bars - counted_bars - 1; 
//----  
   if(limit > MaxBar)
     {
       for(ii = Bars - 1; ii >= MaxBar; ii--)
         {
           SMI_Buffer[ii] = 0.0;
           Signal_Buffer[ii] = 0.0;
           SM_Buffer[ii] = 0.0;
           EMA_SM[ii] = 0.0;
           EMA2_SM[ii] = 0.0;
           EMA_HQ[ii] = 0.0;
           EMA2_HQ[ii] = 0.0;
           HQ_Buffer[ii] = 0.0;
         }
       limit = MaxBar;
     } 
//----    SMI
   for(bar = limit; bar >= 0; bar--)
     {
       LowestBar = iLowest(NULL, 0, MODE_LOW, Period_Q, bar);    
       HighestBar = iHighest(NULL, 0, MODE_HIGH, Period_Q, bar);
       //----    
       HQ_Buffer[bar] = High[HighestBar] - Low[LowestBar];
       SM_Buffer[bar] = Close[bar] - (High[HighestBar] + Low[LowestBar]) / 2;
     }
//----    SMI
   for(bar = limit; bar >= 0; bar--)
     {
       EMA_SM[bar] = iMAOnArray(SM_Buffer, 0, Period_R, 0, MODE_EMA, bar);
       EMA_HQ[bar] = iMAOnArray(HQ_Buffer, 0, Period_R, 0, MODE_EMA, bar);
     }
//----    SMI
   for(bar = limit; bar >= 0; bar--)
     {
       EMA2_SM[bar] = iMAOnArray(EMA_SM, 0, Period_S, 0, MODE_EMA, bar);
       EMA2_HQ[bar] = iMAOnArray(EMA_HQ, 0, Period_S, 0, MODE_EMA, bar);
     }
//----    SMI
   for(bar = limit; bar >= 0; bar--)
     {
       if(EMA2_HQ[bar] != 0)
           SMI_Buffer[bar] = 100*EMA2_SM[bar] / EMA2_HQ[bar];
       else 
           SMI_Buffer[bar] = 0.0;
     }
//----     SMI
   for(bar=limit;bar>=0;bar--)
     {
       Signal_Buffer[bar] = iMAOnArray(SMI_Buffer, 0, Signal, 0, MODE_EMA, bar);
     }   
//----   
   return(0);
  }
//+------------------------------------------------------------------+