//+------------------------------------------------------------------+
//|                                                SignalNetwork.mqh |
//|                   Copyright 2009-2017, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#include <Expert\ExpertSignal.mqh>
#include <My\Network.mqh>
#define __PI 245850922/78256779
#define __PHI 0.61803398874989
// wizard description start
//+------------------------------------------------------------------+
//| Description of the class                                         |
//| Title=Signals based on Network-a classifier                      |
//| Type=SignalAdvanced                                              |
//| Name=Network                                                     |
//| ShortName=Network                                                |
//| Class=CSignalNetwork                                             |
//| Page=signal_network                                              |
//| Parameter=TrainSet,int,20,Training Set                           |
//| Parameter=Epochs,int,50,Epochs                                   |
//| Parameter=LearningRate,double,0.5,LearningRate                   |
//+------------------------------------------------------------------+
// wizard description end
//+------------------------------------------------------------------+
//| Class CSignalNetwork.                                            |
//| Purpose: Class of of trade signals based on Network-a classifier.|
//|            Derives from class CExpertSignal.                     |
//+------------------------------------------------------------------+
#define __LAYERS 3
#define __LONGS_INPUTS 3
#define __SHORTS_INPUTS 4
int                              __LONGS_SETTINGS[__LAYERS]

   =

{  __LONGS_INPUTS, 5, 1
};
int                              __SHORTS_SETTINGS[__LAYERS]

   =

{  __SHORTS_INPUTS, 5, 1
};
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CSignalNetwork                 : public CExpertSignal
{
protected:

   int                           m_train_set;                           // Epochs
   int                           m_epochs;                              // Epochs
   double                        m_learning_rate;                       // Epsilon
   
   double                        m_train_deposit;
   double                        m_train_criteria;

public:
                     CSignalNetwork(void);
                    ~CSignalNetwork(void);

   //--- method of verification of settings
   virtual bool                  ValidationSettings(void);
   //--- method of creating the indicator and timeseries
   virtual bool                  InitIndicators(CIndicators *indicators);
   //--- methods of checking if the market models are formed
   virtual int                   LongCondition(void);
   virtual int                   ShortCondition(void);
   //---
   void                          TrainSet(int value)
   {  m_train_set = value;
   }
   void                          Epochs(int value)
   {  m_epochs = value;
   }
   void                          LearningRate(double value)
   {  m_learning_rate = value;
   }
   

protected:
   double                        GetOutput();
   void                          SetOutput();
   
   int                           T(datetime Time);
   double                        G(vector &X,vector &Y);

   Cnetwork                      *N_LONGS;
   Cnetwork                      *N_SHORTS;

   struct                        Smodel
   {  matrix                     x;
      vector                     y;

                                 Smodel() {};
                                 ~Smodel() {};
   };

   Smodel                        m_model_longs;
   Smodel                        m_model_shorts;

};
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
void CSignalNetwork::CSignalNetwork(void)  :    m_train_set(20),
                                                m_epochs(50),
                                                m_learning_rate(0.5)
{
//--- initialization of protected data
   m_used_series = USE_SERIES_OPEN + USE_SERIES_HIGH + USE_SERIES_LOW + USE_SERIES_CLOSE + USE_SERIES_SPREAD + USE_SERIES_TIME;
   
}
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
void CSignalNetwork::~CSignalNetwork(void)
{  delete N_LONGS;
   delete N_SHORTS;
}
//+------------------------------------------------------------------+
//| Validation settings protected data.                              |
//+------------------------------------------------------------------+
bool CSignalNetwork::ValidationSettings(void)
{  if(!CExpertSignal::ValidationSettings())
      return(false);
//--- initial data checks
   if(m_epochs < 1)
   {  printf(__FUNCSIG__ + " epochs size should at least be 1! ");
      return(false);
   }
   if(m_learning_rate < 0.0)
   {  printf(__FUNCSIG__ + " learning rate should be greater than 0.0! ");
      return(false);
   }
   m_model_longs.x.Init(m_train_set,__LONGS_INPUTS);
   m_model_longs.y.Init(m_train_set);
   m_model_longs.x.Fill(0.0);
   m_model_longs.y.Fill(0.0);
   
   m_model_shorts.x.Init(m_train_set,__SHORTS_INPUTS);
   m_model_shorts.y.Init(m_train_set);
   m_model_shorts.x.Fill(0.0);
   m_model_shorts.y.Fill(0.0);
   
   N_LONGS = new Cnetwork(__LONGS_SETTINGS,m_symbol.Point()*2,0.0);
   N_SHORTS = new Cnetwork(__SHORTS_SETTINGS,m_symbol.Point()*2,0.0);
   
   m_train_deposit = AccountInfoDouble(ACCOUNT_BALANCE);
   
   m_train_criteria = 0.0;
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Create indicators.                                               |
//+------------------------------------------------------------------+
bool CSignalNetwork::InitIndicators(CIndicators *indicators)
{
//--- check pointer
   if(indicators == NULL)
      return(false);
//--- initialization of indicators and timeseries of additional filters
   if(!CExpertSignal::InitIndicators(indicators))
      return(false);
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| "Voting" that price will grow.                                   |
//+------------------------------------------------------------------+
int CSignalNetwork::LongCondition(void)
{  int result = 0;
   m_high.Refresh(-1);
   m_low.Refresh(-1);
   double _gap = GetOutput();
   int _range_size = 1;
   double _range = m_high.GetData(m_high.MaxIndex(StartIndex(), StartIndex() + _range_size)) - m_low.GetData(m_low.MinIndex(StartIndex(), StartIndex() + _range_size));
   _gap /= fmax(_range, m_symbol.Point());
   _gap *= 100.0;
   if(_gap > 0.0)
   {  result = int(fmin(100.0, round(_gap)));
      //printf(__FUNCSIG__+" gap is: "+DoubleToString(_gap)+", result is: "+IntegerToString(result));
   }
   //result = 0;
   return(result);
}
//+------------------------------------------------------------------+
//| "Voting" that price will fall.                                   |
//+------------------------------------------------------------------+
int CSignalNetwork::ShortCondition(void)
{  int result = 0;
   m_high.Refresh(-1);
   m_low.Refresh(-1);
   double _gap = GetOutput();
   int _range_size = 1;//m_set_size;
   double _range = m_high.GetData(m_high.MaxIndex(StartIndex(), StartIndex() + _range_size)) - m_low.GetData(m_low.MinIndex(StartIndex(), StartIndex() + _range_size));
   _gap /= fmax(_range, m_symbol.Point());
   _gap *= 100.0;
   if(_gap < 0.0)
   {  result = int(fmax(-100.0, round(_gap))) * -1;
      //printf(__FUNCSIG__+" gap is: "+DoubleToString(_gap)+", result is: "+IntegerToString(result));
   }
   //result = 0;
   return(result);
}
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double CSignalNetwork::GetOutput()
{  double _output = 0.0;
   m_open.Refresh(-1);
   m_high.Refresh(-1);
   m_low.Refresh(-1);
   m_close.Refresh(-1);
   m_time.Refresh(-1);//;
   m_model_longs.x.Fill(0.0);
   m_model_longs.y.Fill(0.0);
   m_model_shorts.x.Fill(0.0);
   m_model_shorts.y.Fill(0.0);
   for(int i = 0; i < m_train_set; i++)
   {  for(int ii = 0; ii < __LONGS_INPUTS; ii++)
      {  if(ii==0)//time
         {  m_model_longs.x[i][ii] = T(m_time.GetData(i));
         }
         else if(ii==1)//spatial matrix
         {  vector _x,_y;
            _x.CopyRates(m_symbol.Name(),m_period,2,StartIndex() + ii + i,2*m_train_set);
            _y.CopyRates(m_symbol.Name(),m_period,4,StartIndex() + ii + i,2*m_train_set);
            m_model_longs.x[i][ii] = G(_x,_y);
         }
         else if(ii==2)//demand
         {  m_model_longs.x[i][ii] = (m_high.GetData(StartIndex() + ii + i) - m_open.GetData(StartIndex() + ii + i));
         }
      }
      if(i > 0) //assign classifier 
      {  m_model_longs.y[i - 1] = (m_high.GetData(StartIndex() + i - 1) - m_open.GetData(StartIndex() + i - 1));
      }
   }
   for(int i = 0; i < m_train_set; i++)
   {  for(int ii = 0; ii < __SHORTS_INPUTS; ii++)
      {  if(ii==0)//time
         {  m_model_shorts.x[i][ii] = T(m_time.GetData(i));
         }
         else if(ii==1)//spatial matrix
         {  vector _x,_y;
            _x.CopyRates(m_symbol.Name(),m_period,4,StartIndex() + ii + i,2*m_train_set);
            _y.CopyRates(m_symbol.Name(),m_period,2,StartIndex() + ii + i,2*m_train_set);
            m_model_shorts.x[i][ii] = G(_x,_y);
         }  
         else if(ii==2)//demand
         {  m_model_shorts.x[i][ii] = (m_high.GetData(StartIndex() + ii + i) - m_open.GetData(StartIndex() + ii + i));
         }  
         else if(ii==3)//supply
         {  m_model_shorts.x[i][ii] = (m_open.GetData(StartIndex() + ii + i) - m_low.GetData(StartIndex() + ii + i));
         }
      }
      if(i > 0) //assign classifier
      {  m_model_shorts.y[i - 1] = (m_open.GetData(StartIndex() + i - 1) - m_low.GetData(StartIndex() + i - 1));
      }
   }
   vector _input_longs;
   _input_longs.Init(__LONGS_INPUTS);
   vector _target_longs;
   _target_longs.Init(1);
   vector _input_shorts;
   _input_shorts.Init(__SHORTS_INPUTS);
   vector _target_shorts;
   _target_shorts.Init(1);
   for(int i = m_train_set - 1; i >=0 ; i--)
   {  _input_longs.Fill(0.0);
      _input_shorts.Fill(0.0);
      for(int ii = 0; ii < __LONGS_INPUTS; ii++)
      {  _input_longs[ii] = m_model_longs.x[i][ii];
      }
      for(int ii = 0; ii < __SHORTS_INPUTS; ii++)
      {  _input_shorts[ii] = m_model_shorts.x[i][ii];
      }
      N_LONGS.Set(_input_longs);
      N_SHORTS.Set(_input_shorts);
      if(i > 0)
      {  _target_longs[0] = m_model_longs.y[i - 1];
         N_LONGS.Get(_target_longs);
         _target_shorts[0] = m_model_shorts.y[i - 1];
         N_SHORTS.Get(_target_shorts);
      }
// Training loop
      for (int iii = 0; iii < m_epochs; iii++)
      {  N_LONGS.Forward();
         N_SHORTS.Forward();
         if(i > 0)
         {  N_LONGS.Backward(m_learning_rate);
            N_SHORTS.Backward(m_learning_rate);
         }
      }
   }
   _output = N_LONGS.output[0]-N_SHORTS.output[0];
   return(_output);
}
//+------------------------------------------------------------------+
//| Weights & Biases exporting function for network                  |
//+------------------------------------------------------------------+
void CSignalNetwork::SetOutput(void)
{  if(AccountInfoDouble(ACCOUNT_EQUITY)-m_train_deposit > m_train_criteria && m_train_criteria >= 0.0)
   {  N_LONGS.Set(m_symbol.Name()+"_"+EnumToString(m_period)+"_longs",AccountInfoDouble(ACCOUNT_EQUITY)-m_train_deposit);
      N_SHORTS.Set(m_symbol.Name()+"_"+EnumToString(m_period)+"_shorts",AccountInfoDouble(ACCOUNT_EQUITY)-m_train_deposit);
   }
}
//+------------------------------------------------------------------+
//| Temporal (Time) Indexing function                                |
//+------------------------------------------------------------------+
int CSignalNetwork::T(datetime Time)
{  MqlDateTime _dt;
   if(TimeToStruct(Time,_dt))
   {  if(_dt.day_of_week==TUESDAY)
      {  return(1);
      }
      else if(_dt.day_of_week==WEDNESDAY)
      {  return(2);
      }
      else if(_dt.day_of_week==THURSDAY)
      {  return(3);
      }
      else if(_dt.day_of_week==FRIDAY||_dt.day_of_week==SATURDAY)
      {  return(4);
      }
   }
   return(0);
}
//+------------------------------------------------------------------+
//| Spatial (Space) Indexing function. Returns Matrix Determinant    |
//| This however can be customised to return all matrix values as    |
//| a vector, depending on the detail required.                      |
//+------------------------------------------------------------------+
double CSignalNetwork::G(vector &X,vector &Y)
{  matrix _m;
   if(X.Size()!=2*m_train_set||Y.Size()!=2*m_train_set)
   {  return(0.0);
   }
   _m.Init(2,2);
   vector _x1,_x2,_y1,_y2;
   _x1.Init(m_train_set);_x1.Fill(0.0);
   _x2.Init(m_train_set);_x2.Fill(0.0);
   _y1.Init(m_train_set);_y1.Fill(0.0);
   _y2.Init(m_train_set);_y2.Fill(0.0);
   for(int i=0;i<m_train_set;i++)
   {  _x1[i] = X[i];
      _x2[i] = X[i+m_train_set];
      _y1[i] = Y[i];
      _y2[i] = Y[i+m_train_set];
   }
   _m[0][0] = _x1.CorrCoef(_x2);
   _m[0][1] = _x1.CorrCoef(_y2);
   _m[1][0] = _y1.CorrCoef(_x2);
   _m[1][1] = _y1.CorrCoef(_y2);
   return(_m.Det());
}
//+------------------------------------------------------------------+
