#include "stdafx.h"

#pragma once

#ifndef WINVER          // Allow use of features specific to Windows XP or later.
#define WINVER 0x0501      // Change this to the appropriate value to target other versions of Windows.
#endif

#define WIN32_LEAN_AND_MEAN      // Exclude rarely-used stuff from Windows headers

//   Skype4COM.dll,   
//     Skype  http://developers.skype.com/
#import "Skype4COM.dll" rename("CreateEvent","CreatePluginEvent"), rename("SendMessage","SendChatMessage")


#define MT4_EXPFUNC __declspec(dllexport)

//      .
#define WM_PROC_SENDSKYPESMS WM_USER + 01
#define WM_PROC_SENDSKYPEMESSAGE WM_USER + 02

//   ,      
//  
HANDLE hUserThread;
DWORD ThreadId;

//     
// SendSkypeSMS
struct fcpSendSkypeSMS
{
  int ExitCode;
  char * UserNum;
  char * Message;
};

// SendSkypeMessage
struct fcpSendSkypeMessage
{
  int ExitCode;
  char * UserName;
  char * Message;
};

//---------------------------------------------------------------------------
//            Thread function
//---------------------------------------------------------------------------
DWORD WINAPI ThreadProc(LPVOID lpParameter)
{
  MSG msg;
  HANDLE hEvent;
  
  while(true)
  {
    if (PostThreadMessage(GetCurrentThreadId(),WM_USER,0,0))
      break;
  };
  //  COM
  CoInitialize(NULL);
  while(GetMessage(&msg,0,0,0))
  {
    if (msg.message==WM_QUIT)
    {
      break;
    }
	//   WM_PROC_SENDSKYPESMS
	else if (msg.message==WM_PROC_SENDSKYPESMS)
    {
		fcpSendSkypeSMS* fcp=(fcpSendSkypeSMS*)msg.wParam;
		hEvent=(HANDLE)msg.lParam;
		try
		{
			//  Skype 
			SKYPE4COMLib::ISkypePtr pSkype(__uuidof(SKYPE4COMLib::Skype));
			//   Skype. 6    
			HRESULT hr=pSkype->Attach(6,VARIANT_TRUE);
			//   ,    
			if (!FAILED(hr))
			{	
				try
				{
					fcp->ExitCode=1;
					//   SMS
					pSkype->SendSms(fcp->UserNum,fcp->Message,"");
				}
				catch(...)
				{
					fcp->ExitCode=-1;
				}
			}
			//  Skype
			pSkype = NULL;
		}
		catch(...)
		{
			MessageBox(0,L"SMS send error",L"Error",MB_OK);
		}
		//  
		SetEvent(hEvent);
    }
	//   WM_PROC_SENDSKYPEMESSAGE
	else if (msg.message==WM_PROC_SENDSKYPEMESSAGE)
    {
		fcpSendSkypeMessage* fcp=(fcpSendSkypeMessage*)msg.wParam;
		hEvent=(HANDLE)msg.lParam;
		
		try
		{
			//  Skype 
			SKYPE4COMLib::ISkypePtr pSkype(__uuidof(SKYPE4COMLib::Skype));
			//   Skype. 6    
			HRESULT hr=pSkype->Attach(6,VARIANT_TRUE);
			//   ,    
			if (!FAILED(hr))
			{
				try
				{
					fcp->ExitCode=1;
					//   
					pSkype->SendChatMessage (fcp->UserName,fcp->Message);
				}
				catch(...)
				{
					fcp->ExitCode=-1;
				}
			}
			//  Skype
			pSkype = NULL;
		}
		catch(...)
		{
			MessageBox(0,L"Message send error",L"Error",MB_OK);
		}
		
		//  
		SetEvent(hEvent);
    }
  };
  //  COM
  CoUninitialize();
  return 0;
}

// .
//---------------------------------------------------------------------------
//            DLL entry
//---------------------------------------------------------------------------
BOOL APIENTRY DllMain(HANDLE hModule,DWORD ul_reason_for_call,LPVOID lpReserved)
{
	if (ul_reason_for_call==DLL_PROCESS_ATTACH)
	{
		//         
		hUserThread=CreateThread(NULL,NULL,ThreadProc,NULL,0,&ThreadId);
		if (!hUserThread)
		{
			MessageBoxW(0,L"Thread failed",L"Error",MB_OK);
		};
	} else if (ul_reason_for_call==DLL_PROCESS_DETACH)
	{
		//      
		CloseHandle(hUserThread);
	}
   return(TRUE);
}

MT4_EXPFUNC bool __stdcall SendSkypeSMS(int &ExCode,char* sUserNum, char* sMessage)
{
	//   
	fcpSendSkypeSMS* fcp;
	// 
	HANDLE hEvent;
	//     false
	bool Result=false;

	//       
	fcp=new fcpSendSkypeSMS();
	memset(fcp,0,sizeof(fcpSendSkypeSMS));

	//  
	//       .
	fcp->ExitCode=-1;
	fcp->UserNum=sUserNum;
	fcp->Message=sMessage;

	//  
	hEvent=CreateEvent(NULL,FALSE,FALSE,NULL);
	//   WM_PROC_SENDSKYPESMS,        
	PostThreadMessage(ThreadId,WM_PROC_SENDSKYPESMS,(WPARAM)fcp,(LPARAM)hEvent);
	if (WAIT_OBJECT_0==WaitForSingleObject(hEvent,INFINITE))
	{
		
		Result=true;
	} else
	{
		//      ,     false
		return(Result);
	};
	//     
	ExCode=fcp->ExitCode;
	if (ExCode==-1) 
		Result=false;
	//      
	delete fcp;
	CloseHandle(hEvent);
	return(Result);
}

MT4_EXPFUNC bool __stdcall SendSkypeMessage(int &ExCode,char* sUserName, char* sMessage)
{
	//   
	fcpSendSkypeMessage* fcp;
	// 
	HANDLE hEvent;
	//     false
	bool Result=false;

	//       
	fcp=new fcpSendSkypeMessage();
	memset(fcp,0,sizeof(fcpSendSkypeMessage));

	//  
	//       .
	fcp->ExitCode=-1;
	fcp->UserName=sUserName;
	fcp->Message=sMessage;

	//  
	hEvent=CreateEvent(NULL,FALSE,FALSE,NULL);
	//   WM_PROC_SENDSKYPESMS,        
	PostThreadMessage(ThreadId,WM_PROC_SENDSKYPEMESSAGE,(WPARAM)fcp,(LPARAM)hEvent);
	if (WAIT_OBJECT_0==WaitForSingleObject(hEvent,INFINITE))
	{
		Result=true;
	} else
	{
		//      ,     false
		return(Result);
	};
	//     
	ExCode=fcp->ExitCode;
	if (ExCode==-1) 
		Result=false;
	//      
	delete fcp;
	CloseHandle(hEvent);
	return(Result);
}
