//+------------------------------------------------------------------+
//|                                            TC_BW_new_version.mq5 |
//|                                                         olyakish |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "olyakish"
#property link      "http://www.mql5.com"
#property version   "2.01"
#property description "Expert Advisor, based on"
#property description "the New Trading Dimensions book by Bill Williams"
// 
#include <h_TS_BW.mqh>
//+------------------------------------------------------------------+
//| Input parameters                                                 |
//+------------------------------------------------------------------+
input int alligator_jaw_period=13;           // Alligator: Jaw line period
input int alligator_jaw_shift=8;             // Alligator: Jaw line shift
input int alligator_teeth_period=8;          // Alligator: Teeth line period
input int alligator_teeth_shift=5;           // Alligator: Teeth line shift
input int alligator_lips_period=5;           // Alligator: Lips line period
input int alligator_lips_shift=3;            // Alligator: Lips line shift
input bool add_1_dimension=true;             // Add to opened position when Fractals
input bool add_2_dimension_bludce=true;      // Add to opened position when AO Saucer
input bool add_2_dimension_cross_zero=true;  // Add to opened position when AO Zero Line Crossover
input bool add_3_dimension_use_2_bars=true;  // Add to opened position when AC 2 bars 
input bool add_3_dimension_use_3_bars=true;  // Add to opened position when AC 3 bars
input bool add_4_dimension_zone=true;        // Add to opened position when Green/Red Zone
input bool add_5_dimension=true;             // Add to opened position when Balance line signals
input int  max_4_dimension_zone=5;           // Max zone 
input bool trall_4_dimension=false;          // enable 5 bars Trailing Stop 
input bool agress_trade_mm=false;            // Agressive money management
input double lot=0.1;                        // Trade volume
input type_support_position support_position=Not_used;  // Trailing Stop

C_TS_BW expert_TS_BW;                // Class instance
s_input_parametrs input_parametrs;   // Structure, used to pass input parameters to class instance

int h_parabolic;//////--- handle of the Parabolic SAR indicator
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
// copy input parameters to structure to pass them into the class instance
   input_parametrs.alligator_jaw_period=alligator_jaw_period;
   input_parametrs.alligator_jaw_shift=alligator_jaw_shift;
   input_parametrs.alligator_teeth_period=alligator_teeth_period;
   input_parametrs.alligator_teeth_shift= alligator_teeth_shift;
   input_parametrs.alligator_lips_period= alligator_lips_period;
   input_parametrs.alligator_lips_shift=alligator_lips_shift;
   input_parametrs.add_1_dimension=add_1_dimension;
   input_parametrs.add_2_dimension_bludce=add_2_dimension_bludce;
   input_parametrs.add_2_dimension_cross_zero=add_2_dimension_cross_zero;
   input_parametrs.add_3_dimension_use_2_bars=add_3_dimension_use_2_bars;
   input_parametrs.add_3_dimension_use_3_bars=add_3_dimension_use_3_bars;
   input_parametrs.add_4_dimension_zone=add_4_dimension_zone;
   input_parametrs.add_5_dimension=add_5_dimension;
   input_parametrs.max_4_dimension_zone=max_4_dimension_zone;
   input_parametrs.trall_4_dimension=trall_4_dimension;
   input_parametrs.agress_trade_mm=agress_trade_mm;
   input_parametrs.support_position=support_position;
   input_parametrs.lot=lot;

   expert_TS_BW.Init(Symbol(),PERIOD_CURRENT,input_parametrs);// initialization
   expert_TS_BW.actual_action.init(); // initialization of trade activity
   //h_parabolic=iSAR(Symbol(),PERIOD_CURRENT,0.02,0.2);
   return(0);
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//   double Sl[1];  
   if(expert_TS_BW.NewBar())            // if new bar
     {
      expert_TS_BW.CheckSignal();       // check signals
     }
   expert_TS_BW.CheckActionOnTick();     // check trade actions
//---******************* example of external management of the trade volume and stop loss
//--- example of lot setting when trading by signals from zones

//   if(expert_TS_BW.actual_action.zone_buy || expert_TS_BW.actual_action.zone_sell)
//     {expert_TS_BW.CalcLot(true,0.11,0);}
//--- set stop by parabolic SAR

//   CopyBuffer(h_parabolic,0,0,1,Sl);
//   if (Sl[0]>0){expert_TS_BW.SetStopLoss(Sl[0]);}
//---******************* end of example 

   expert_TS_BW.TrailingStop();           // trailing stop (if needed)
   expert_TS_BW.TradeActualSignals();     // trade actual signals
  }
//+------------------------------------------------------------------+
