/*
The operation of the indicator requires the following files 
JJMASeries.mqh 
PriceSeries.mqh 
to be placed in the folder (directory): MetaTrader\experts\include\
Heiken Ashi#.mq4
to be placed in the folder (directory): MetaTrader\indicators\
*/
//+X================================================================X+  
//|                                                        JFatl.mq4 | 
//|                        Copyright  2008,        Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+   
#property copyright "Copyright  2008, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//---- drawing the indicator in the main window
#property indicator_chart_window 
//---- number of indicator buffers
#property indicator_buffers 1 
//---- color of the indicator
#property indicator_color1 Blue 
//---+ INPUT PARAMETERS OF THE INDICATOR +---------------------------------------+
extern int Length = 3;  // depth of smoothing                              |
extern int Phase  = 100;// parameter that varies within the range -100 ... +100, |
                                 //impacts the transitional process quality; |
extern int Shift  = 0;   // shift of the indicator along the time axis              |
extern int IPC = 0;/* Prices based on which the indicator is calculated: | 
(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED,           |
7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,            |
11-Heiken Ashi Low, 12-Heiken Ashi High, 13-Heiken Ashi Open,               |
13-Heiken Ashi Open, 14-Heiken Ashi Close.) */                    //        |
//---+ +--------------------------------------------------------------------+
//---- indicator buffers
double JFatl[]; 
//---- variables with fixed values  
bool INIT;
int  FATLSize, StartBar;
//+X----------------------------------------------X+ 
//| Initialization of the coefficients of the digital filter  |
//+X----------------------------------------------X+ 
double FATLTable[] =
  {                                                           
    +0.4360409450, +0.3658689069, +0.2460452079, +0.1104506886, 
    -0.0054034585, -0.0760367731, -0.0933058722, -0.0670110374, 
    -0.0190795053, +0.0259609206, +0.0502044896, +0.0477818607, 
    +0.0249252327, -0.0047706151, -0.0272432537, -0.0338917071, 
    -0.0244141482, -0.0055774838, +0.0128149838, +0.0226522218, 
    +0.0208778257, +0.0100299086, -0.0036771622, -0.0136744850, 
    -0.0160483392, -0.0108597376, -0.0016060704, +0.0069480557, 
    +0.0110573605, +0.0095711419, +0.0040444064, -0.0023824623, 
    -0.0067093714, -0.0072003400, -0.0047717710, +0.0005541115,
    +0.0007860160, +0.0130129076, +0.0040364019
  }; 
//+X================================================================X+   
//| Declaration of the JJMASeries function                                    |
//| Declaration of the JJMASeriesResize function                              |
//| Declaration of the JJMASeriesAlert function                               |
//| Declaration of the JMA_ErrDescr function                                  |
//+X================================================================X+
#include <JJMASeries.mqh> 
//+X================================================================X+   
//| Declaration of the PriceSeries function                                   |
//| Declaration of the PriceSeriesAlert function                              |
//+X================================================================X+ 
#include <PriceSeries.mqh>
//+X================================================================X+   
//| JFATL initialization function                                    |
//+X================================================================X+ 
int init() 
 { 
//----+
   //---- setting the indicator rendering style 
   SetIndexStyle(0, DRAW_LINE); 
   //---- determining the buffer for calculation 
   SetIndexBuffer(0, JFatl);
   //---- setting the indicator values
                                  // that will not be visible in the chart
   SetIndexEmptyValue(0, 0.0);  
   //---- setting alerts for invalid values of external variables
   JJMASeriesAlert (0, "Length", Length);
   JJMASeriesAlert (1, "Phase", Phase);
   PriceSeriesAlert(IPC);
   //---- changing sizes of buffer variables of the JJMASeries function, 
                   //nJMAnumber = 1(One call of the JJMASeries function)
   if (JJMASeriesResize(1) != 1)
    {
     INIT = false;
     return(0);
    }
   //---- initialization of variables 
   FATLSize = ArraySize(FATLTable);
   StartBar = FATLSize + 30;
   //---- setting the number of the bar 
                    //starting from which the indicator will be drawn 
   SetIndexDrawBegin(0, StartBar); 
   //---- setting the accuracy format of the indicator
   IndicatorDigits(Digits);
   //---- initialization complete
   INIT = true;
   return(0);
//----+ 
 }
//+X================================================================X+  
//| JFATL iteration function                                         | 
//+X================================================================X+   
int start()
 {
//----+ 
   //---- getting the number of all bars
	int Bars_ = Bars;
	//---- checking if the initialization is complete,
        // checking for the sufficiency of the number of bars for the calculation
	if (!INIT || Bars_ <= StartBar)
			                    return(-1);
   //----
   Bars_--;
	//----+ declaration of floating point variables
	double FATL, Price, JFATL;
	//---- declaration of integer variables and getting the bars already counted
	int reset, MaxBar, limit, bar, counted_bars = IndicatorCounted();
	//---- check for possible errors
	if (counted_bars < 0)
				    return(-1);
	//---- the last counted bar should be recounted
	if (counted_bars > 0)
				counted_bars--;
	//---- determine the number of the oldest bar 
					//starting from which the new bars will be recounted 
	limit = Bars_ - counted_bars;
	//---- determine the number of the oldest bar 
					 //starting from which all bars will be recounted 
	MaxBar = Bars_ - FATLSize;
	//---- correction of the maximum number of the oldest bar 
					//starting from which the new bars will be recounted 
	//---- initialization to zero          
	if (counted_bars == 0)
	 {
	  for(bar = limit; bar >= MaxBar; bar--)
								            JFatl[bar] = 0.0; 
	  limit = MaxBar;
	 }

	//----+ main indicator calculation loop
	for(bar = limit; bar >= 0; bar--)
	 {
	  //---- formula for the FATL filter
	  FATL = 0.0;
	  for(int ii = 0; ii < FATLSize; ii++)
		 FATL += FATLTable[ii] * PriceSeries(IPC, bar + ii);

	  //---- JMA smoothing of the resulting indicator, 
			   //the nJMA.MaxBar parameter decreased by the size of FilterSize 
	  //---- calling the JJMASeries function for 0 number, 
			  //the nJMA.Phase and nJMA.Length parameters 
			                    //do not change on every bar (nJMA.din = 0)
	  JFATL = JJMASeries(0, 0, MaxBar, limit, 
	                                  Phase, Length, FATL, bar, reset);
	  //---- check for errors in the previous operation
	  if(reset != 0)
				  return(-1);
	  //----		  
	  JFatl[bar] = JFATL;
	  //----
	 }
	//---- end of calculations of indicator values
	return(0); 
//----+  
 } 
//+X----------------------+ <<< The End >>> +-----------------------X+

