/*
The operation of the indicator requires the following files 
JJMASeries.mqh  
PriceSeries.mqh 
3Color.mqh
to be placed in the folder (directory): MetaTrader\experts\include\
JFatl.mq4
Heiken Ashi#.mq4
to be placed in the folder (directory): MetaTrader\indicators\
*/
//+==================================================================+ 
//|                                                     3c_JFatl.mq4 | 
//|                             Copyright  2006,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+==================================================================+
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//---- drawing the indicator in the main window
#property indicator_chart_window 
//---- number of indicator buffers
#property indicator_buffers 6
//---- indicator colors
#property indicator_color1 Yellow
#property indicator_color2 Yellow
#property indicator_color3 Magenta 
#property indicator_color4 Magenta 
#property indicator_color5 Gray
#property indicator_color6 Gray
//---- width of indicator lines
#property indicator_width1 2
#property indicator_width2 2 
#property indicator_width3 2
#property indicator_width4 2
#property indicator_width5 2 
#property indicator_width6 2
//----+ INPUT PARAMETERS OF THE INDICATOR 
extern int              Length = 4;   // depth of smoothing 
extern int               Phase = 100; // parameter that varies within the range -100 ... +100, impacts the transitional process quality; 
extern int Input_Price_Customs = 0;/* Prices based on which the indicator is calculated 
(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
11-Heiken Ashi Low, 12-Heiken Ashi High,  13-Heiken Ashi Open, 14-Heiken Ashi Close.) */
//----+
//---- adding the digits() function for setting the accuracy format (number of decimal places) for visualization of indicator values 
int digits(){return(Digits);}
//---- Adding the COUNT_begin() function for calculation of the bar number starting from which the indicator will be drawn
int COUNT_begin(){return(39+30);}
//---- setting indicator values that will not be visible in the chart 
int EmptyValue=0;
string Label="JFatl";                 
//---- including the main text of the indicator in the indicator text
#include <3Color.mqh>
//---- adding the INDICATOR function -------------------------------------------------------------------------+
//---- calling the original indicator to get the initial values
double INDICATOR(int INDICATOR_bar)
 {
  return( iCustom(NULL,0,"JFatl",Length,Phase,0,Input_Price_Customs,0,INDICATOR_bar) );
 }
//---- ----------------------------------------------------------------------------------------------------+