//Version  November 26, 2007
//+X================================================================X+
//|                                                 iPriceSeries.mqh |
//|                        Copyright  2007,        Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+
/*                                                                   |
 The PriceSeries() function returns the input price of a bar by its    |
 Bar number and IPC price number:                                           |
 0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL,                |
 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW,            |
 10-0.5 * TRENDFOLLOW, 11-Heiken Ashi Low, 12-Heiken Ashi High,      |
 13-Heiken Ashi Open, 14-Heiken Ashi Close.                          |
 example: minuse = iPriceSeries("GBPJPY", 240, IPC, bar)              |
                  - iPriceSeries("GBPJPY", 240, IPC, bar + 1);       |
*/                                                              //   |
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  //+X================================================================X+   
//| iPriceSeries() function                                          |
//+X================================================================X+ 
double iPriceSeries(string symbol,int timeframe,int IPC,int Bar)
  {
   double diPriceSeries;
   switch(IPC)
     {
      case  0: diPriceSeries = iClose(symbol, timeframe, Bar); break;
      case  1: diPriceSeries = iOpen (symbol, timeframe, Bar); break;
      case  2: diPriceSeries = iHigh (symbol, timeframe, Bar); break;
      case  3: diPriceSeries = iLow  (symbol, timeframe, Bar); break;
      //----+
      case  4: diPriceSeries=
         (iHigh(symbol,timeframe,Bar)+iLow(symbol,timeframe,Bar))/2; break;
         //----+
      case  5: diPriceSeries=
         (iClose(symbol,timeframe,Bar)+iHigh(symbol,timeframe,Bar)
          +iLow(symbol,timeframe,Bar))/3; break;
      //----+                                                                  
      case  6: diPriceSeries=
         (iOpen(symbol,timeframe,Bar)+iHigh(symbol,timeframe,Bar)
          +iLow(symbol,timeframe,Bar)+iClose(symbol,timeframe,Bar))/4; break;
      //----+                                 
      case  7: diPriceSeries=
         (iOpen(symbol,timeframe,Bar)+iClose(symbol,timeframe,Bar))/2; break;
         //----+
      case  8: diPriceSeries=
         (iClose(symbol,timeframe,Bar)+iHigh(symbol,timeframe,Bar)
          +iLow(symbol,timeframe,Bar)+iClose(symbol,timeframe,Bar))/4; break;
      //----+                                
      case  9: diPriceSeries = iTrendFollow00(symbol, timeframe, Bar); break;
      case 10: diPriceSeries = iTrendFollow01(symbol, timeframe, Bar); break;
      //----+
      case 11: diPriceSeries = iCustom(symbol, timeframe, "Heiken Ashi#", 0, Bar); break;
      case 12: diPriceSeries = iCustom(symbol, timeframe, "Heiken Ashi#", 1, Bar); break;
      case 13: diPriceSeries = iCustom(symbol, timeframe, "Heiken Ashi#", 2, Bar); break;
      case 14: diPriceSeries = iCustom(symbol, timeframe, "Heiken Ashi#", 3, Bar); break;
      case 15:
        {
         double haOpen=iCustom(symbol,timeframe,"Heiken Ashi#",2,Bar);
         //----+
         diPriceSeries=(haOpen+
                        (iOpen(symbol,timeframe,Bar)+iHigh(symbol,timeframe,Bar)
                        +iLow(symbol,timeframe,Bar)+iClose(symbol,timeframe,Bar))/4)/2;
        }
      break;
      //----+
      //----+
      default: diPriceSeries=iClose(symbol,timeframe,Bar);
     }
   return(diPriceSeries);
  }
//+X================================================================X+   
//| iPriceSeriesAlert() function                                     |
//+X================================================================X+
/*
The iPriceSeriesAlert() function is intended for indicating an invalid 
IPC parameter value passed to the iPriceSeries() function.
*/
void iPriceSeriesAlert(int IPC)
  {
   if(IPC<0)
      Alert(StringConcatenate
            ("The IPC parameter value must be not less than 0",
            " You have entered the invalid value ",IPC," 0 will be used"));
//----+                     
   if(IPC>15)
      Alert(StringConcatenate
            ("The IPC parameter value must not exceed 15",
            " You have entered the invalid value ",IPC," 0 will be used"));
  }
//+X================================================================X+   
//| iTrendFollow00() function                                        |
//+X================================================================X+
double iTrendFollow00(string symbol,int timeframe,int Bar)
  {
   double diTrendFollow00;
   double high= iHigh(symbol,timeframe,Bar);
   double low =  iLow(symbol,timeframe,Bar);
   double open= iOpen(symbol,timeframe,Bar);
   double close=iClose(symbol,timeframe,Bar);
//----
   if(close>open)
      diTrendFollow00=high;
   else
     {
      if(close<open)
         diTrendFollow00 = low;
      else diTrendFollow00 = close;
     }

   return(diTrendFollow00);
  }
//+X================================================================X+   
//| iTrendFollow01() function                                        |
//+X================================================================X+
double iTrendFollow01(string symbol,int timeframe,int Bar)
  {
   double diTrendFollow01;
   double high= iHigh(symbol,timeframe,Bar);
   double low =  iLow(symbol,timeframe,Bar);
   double open= iOpen(symbol,timeframe,Bar);
   double close=iClose(symbol,timeframe,Bar);
//----
   if(close>open)
      diTrendFollow01=(high+close)/2;
   else
     {
      if(close<open)
         diTrendFollow01 = (low + close) / 2;
      else diTrendFollow01 =  close;
     }

   return(diTrendFollow01);
  }
//+X----------------------+ <<< The End >>> +-----------------------X+
