//Version  November 01, 2008
//+X================================================================X+
//|                                                  PriceSeries.mqh |
//|                        Copyright  2006,        Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+
/*                                                                   |
The PriceSeries() function returns the input price of a bar by its Bar |
number and the Input_Price_Customs price number:                                |
0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL,                 |
6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW,             |
10-0.5 * TRENDFOLLOW, 11-Heiken Ashi Low, 12-Heiken Ashi High,       |
13-Heiken Ashi Open, 14-Heiken Ashi Close.                           |
example: Momentum = PriceSeries(IPC, bar)                             |
                  - PriceSeries(IPC, bar + Momentum_Period);         |  
*/                                                              //   |
//+X================================================================X+   
//| PriceSeries() function                                           |
//+X================================================================X+  

double PriceSeries(int Input_Price_Customs, int Bar)
 {
  double dPriceSeries;
  switch(Input_Price_Customs)
   {
    case  0: dPriceSeries = Close[Bar]; break;
    case  1: dPriceSeries = Open [Bar]; break;
    case  2: dPriceSeries = High [Bar]; break;
    case  3: dPriceSeries = Low  [Bar]; break;
    case  4: dPriceSeries = (High [Bar] + Low  [Bar]) / 2.0; break;
    case  5: dPriceSeries = 
                  (Close[Bar] + High[Bar] + Low[Bar]) / 3.0; break;
    case  6: dPriceSeries = (Open [Bar] + High [Bar] 
                             + Low[Bar] + Close[Bar]) / 4.0; break;
    case  7: dPriceSeries = (Open [Bar] + Close[Bar]) / 2.0; break;
    case  8: dPriceSeries = (Close[Bar] + High [Bar]
                             + Low[Bar] + Close[Bar]) / 4.0; break;
    case  9: dPriceSeries = TrendFollow00(Bar); break;
    case 10: dPriceSeries = TrendFollow01(Bar); break;
    case 11: dPriceSeries = 
                   iCustom(NULL, 0, "Heiken Ashi#", 0, Bar); break;
    case 12: dPriceSeries = 
                   iCustom(NULL, 0, "Heiken Ashi#", 1, Bar); break;
    case 13: dPriceSeries = 
                   iCustom(NULL, 0, "Heiken Ashi#", 2, Bar); break;
    case 14: dPriceSeries = 
                   iCustom(NULL, 0, "Heiken Ashi#", 3, Bar); break;
    case 15: dPriceSeries = 
                  (iCustom(NULL, 0, "Heiken Ashi#", 2, Bar) 
                   +(Open[Bar] + High[Bar]
                      + Low[Bar] + Close[Bar]) / 4.0) / 2.0; break;
    //----+
    default: dPriceSeries = Close[Bar];
   }
  return(dPriceSeries);
 }
//+X================================================================X+   
//| TrendFollow00() function                                         |
//+X================================================================X+

double TrendFollow00(int Bar)
 {
  double dTrendFollow00, high, low, open, close;
  high = High [Bar];
  low =  Low  [Bar];
  open = Open [Bar];
  close = Close[Bar];
  //----
  if (close > open)
       dTrendFollow00 = high;
  else
   {
    if (close < open)
         dTrendFollow00 = low;
    else dTrendFollow00 = close;
   }
  //----
  return(dTrendFollow00);
 }
//+X================================================================X+   
//| TrendFollow01() function                                         |
//+X================================================================X+

double TrendFollow01(int Bar)
 {
  double dTrendFollow01, high, low, open, close;
  high = High [Bar];
  low =  Low  [Bar];
  open = Open [Bar];
  close = Close[Bar];
  //----
  if (close > open)
        dTrendFollow01 = (high + close) / 2;
  else
   {
    if (close < open)
         dTrendFollow01 = (low + close) / 2;
    else dTrendFollow01 = close;
   }
  //----
  return(dTrendFollow01);
 }
//+X================================================================X+   
//| PriceSeriesAlert() function                                      |
//+X================================================================X+
// The PriceSeriesAlert() function is intended for indicating    |
// an unacceptable PriceSeries.Input_Price_Customs parameter value |
// passed to the PriceSeries() function                             |
//+X- - - - - - - - - - - -- - - - - - - - - - - - - - - - - - - - -X+
void PriceSeriesAlert(int nPriceSeriesAlert.IPC)
 {
  if(nPriceSeriesAlert.IPC< 0)
      Alert(StringConcatenate
       ("The Input_Price_Customs parameter value must be not less than 0", 
                 " You have entered incorrect value ", nPriceSeriesAlert.IPC,
                                            " the value of 0 will be used"));
  if(nPriceSeriesAlert.IPC>15)
      Alert(StringConcatenate
       ("The Input_Price_Customs parameter value must not exceed 15", 
                 " You have entered incorrect value ", nPriceSeriesAlert.IPC, 
                                            " the value of 0 will be used"));
 }
//+X----------------------+ <<< The End >>> +-----------------------X+ 