//Version  January 20, 2009
//+X================================================================X+
//|                                                Lite_EXPERT2_.mqh |
//|                             Copyright  2009,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+

//---- Declaring an external variable for slippage in points 
extern int Slippage_ = 3;   
                                
//---- Declaring a global variable for storing 
                            //the time of the last server call 
int LastTime;

//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+   
/*                                                                   |
 The Margin_Mode external variable determines the lot size | 
 calculation                                                                |
 0 - MM based on free margin                              |
 1 - MM based on the account balance                                  |
 2 - MM based on losses on free margin                     |
 3 - MM based on losses on the account balance                       |
 4 - minimum lot between 0 and 2                                     |
 5 - minimum lot between 1 and 3                                     |
 by default - MM based on free margin                   |
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
 if Money_Management is negative, the trading function uses | 
 the absolute Money_Management value rounded to the nearest standard value |
 as the lot size.                      |
*/                                                                // |
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+

//+X================================================================X+
//| OpenBuyOrder1_()                                                 |
//+X================================================================X+
bool OpenBuyOrder1_
        (bool& BUY_Signal, int MagicNumber, datetime TimeLevel,
                           double Money_Management, int Margin_Mode, 
                             int STOPLOSS, int TAKEPROFIT, string Coment)
 {
//---+
  if (!BUY_Signal)
           return(true); 
  //---- Check if the minimum time interval has passed 
                                    //between two trading operations         
  if (TimeCurrent() < LastTime)
                          return(true); 
  //----
  string Symb = Symbol();
  
  //---- Check if the time limit with respect to the previous deal has expired
  if (!TradeTimeLevelCheck(Symb, MagicNumber, TimeLevel))
                                                  return(true);
  //---- Check for an open position 
          //with the magic number equal to the MagicNumber variable value
  if (Order_Select(Symb, MagicNumber))
                                 return(true);  
  //----
  string OpderPrice;
  bool   Order_Select; 
  int    ErrorCode, ticket, StLOSS, TkPROFIT;
  double Lot, ask, Stoploss, TakeProfit;  
  //----          
  ask = NormalizeDouble(Ask, Digits);
  if (ask == 0.0)
          return(false);   
  //---- 
  if (STOPLOSS > 0) 
   {           
     StLOSS = StopCorrect(Symb, STOPLOSS, Slippage_);
     if (StLOSS < 0)
          return(false);
     //----
     Stoploss = NormalizeDouble(ask - StLOSS * Point, Digits);
     if (Stoploss < 0)
           return(false);
     //---- 
   }
  else
   { 
    if (STOPLOSS < 0)
     {
      Print("OpenBuyOrder1_(): Invalid Stop Loss!!!");
      return(true);
     }
    //---- 
    Stoploss = 0.0;
   }
  //----   
  if (TAKEPROFIT > 0) 
   {           
     TkPROFIT = StopCorrect(Symb, TAKEPROFIT, Slippage_);
     if (TkPROFIT < 0)
          return(false);
     //----
     TakeProfit = NormalizeDouble(ask + TkPROFIT * Point, Digits);
     if (TakeProfit < 0)
                return(false);
   }
  else
   { 
    if (TAKEPROFIT < 0)
     {
      Print("OpenBuyOrder1_(): Invalid Take Profit!!!");
      return(true);
     }
    //---- 
    TakeProfit = 0.0;
   }  
  
  //---+ LOT SIZE CALCULATION FOR OPENING A POSITION
  Lot = BuyLotCount(Money_Management, Margin_Mode, StLOSS);
  //----
  if (Lot == -1)
            return(false);  
  else 
   if (Lot == 0)
             return(true);  
        
  //---+ check the lot size against the funds available in the account   
  if (!MarginCheck(Symb, OP_BUY, Lot))
                                  return(false);
  //----
  if (Lot == 0.0)
            return(true);  
  //----       
  Print(StringConcatenate
         ("Open a ", Symb,
            " Buy position with the magic number ", MagicNumber));
            
  //---+ Open a Buy position    
  ticket = OrderSend(Symb, OP_BUY, Lot, ask, Slippage_, 
            Stoploss, TakeProfit, Coment, MagicNumber, 0, Lime);
  
  //---- Calculation of the time interval between trading operations         
  CountLastTime(GetLastError());
  //----
  Order_Select = OrderSelect(ticket, SELECT_BY_TICKET);
  
  //---- Calculation of the time interval between trading operations         
  ReCountLastTime(GetLastError());
  //----
  if(ticket > 0 && Order_Select)
   {
	 //---- Play a sound
	 PlaySound("ok.wav");
	 //---- Blocking the OpenBuyOrder1_() function
	                    // from repeated performance of the operation
	 if(TimeLevel < 0)
	           BUY_Signal = false;
	 //----
	 if(TimeLevel > 0)
	    GlobalVariableSet(GetTimeLevelName(Symb, MagicNumber), TimeLevel);
	 //---- 
	 OpderPrice = DoubleToStr(OrderOpenPrice(), Digits);  
	 Print(StringConcatenate(Symb, " BUY order with ticket #",
	        ticket, " and magic number ", OrderMagicNumber(), 
	                                 " opened at the price ",OpderPrice));
   }
  else Print(StringConcatenate("Failed to open ", Symb, 
             " BUY order with the magic number ", MagicNumber, "!!!"));
  //---- 
  return(true);
//---+
 }
//+X================================================================X+
//| OpenSellOrder1_()                                                |
//+X================================================================X+
bool OpenSellOrder1_
        (bool& SELL_Signal, int MagicNumber, datetime TimeLevel, 
                            double Money_Management, int Margin_Mode, 
                              int STOPLOSS, int TAKEPROFIT, string Coment)
 {
//---+
  if (!SELL_Signal)
           return(true); 
  //---- Check if the minimum time interval has passed 
                                    //between two trading operations         
  if (TimeCurrent() < LastTime)
                          return(true);                    
  //----
  string Symb = Symbol();
  
  //---- Check if the time limit with respect to the previous deal has expired
  if (!TradeTimeLevelCheck(Symb, MagicNumber, TimeLevel))
                                                  return(true);
                              
  //---- Check for an open position 
          //with the magic number equal to the MagicNumber variable value
  if (Order_Select(Symb, MagicNumber))
                                  return(true);  
  //----
  string OpderPrice;
  bool   Order_Select;
  int    ticket, StLOSS, TkPROFIT, ErrorCode;
  double Lot, bid, Stoploss, TakeProfit;                                                                                                                                          
  //----
  bid = NormalizeDouble(Bid, Digits);
  if (bid == 0.0)
          return(false);
  //---- 
  if (STOPLOSS > 0) 
   {           
     StLOSS = StopCorrect(Symb, STOPLOSS, Slippage_);
     if (StLOSS < 0)
          return(false);
     //----
     Stoploss = NormalizeDouble(bid + StLOSS * Point, Digits);
     if (Stoploss < 0)
          return(false);
     //---- 
   }
  else
   { 
    if (STOPLOSS < 0)
     {
      Print("OpenSellOrder1_(): Invalid Stop Loss!!!");
      return(true);
     }
    //---- 
    Stoploss = 0.0;
   }
  //----   
  if (TAKEPROFIT > 0) 
   {           
     TkPROFIT = StopCorrect(Symb, TAKEPROFIT, Slippage_);
     if (TkPROFIT < 0)
           return(false);
     //----
     TakeProfit = NormalizeDouble(bid - TkPROFIT * Point, Digits);
     if (TakeProfit < 0)
           return(false);
     //---- 
   }
  else
   { 
    if (TAKEPROFIT < 0)
     {
      Print("OpenSellOrder1_(): Invalid Take Profit!!!");
      return(true);
     }
    //---- 
    TakeProfit = 0.0;
   }  
  
  //---+ LOT SIZE CALCULATION FOR OPENING A POSITION
  Lot = SellLotCount(Money_Management, Margin_Mode, StLOSS);
  //----
  if (Lot == -1)
            return(false);  
  else 
   if (Lot == 0)
             return(true);  
          
  //---+ check the lot size against the funds available in the account   
  if (!MarginCheck(Symb, OP_SELL, Lot))
                                  return(false);
  //----
  if (Lot == 0.0)
           return(true);
  //----              
  Print(StringConcatenate
         ("Open a ", Symb,
               " Sell position with the magic number ", MagicNumber)); 
                  
  //---+ Open a Sell position    
  ticket = OrderSend(Symb, OP_SELL, Lot, bid, Slippage_, 
            Stoploss, TakeProfit, Coment, MagicNumber, 0, Red);
              
  //---- Calculation of the time interval between trading operations         
  CountLastTime(GetLastError());
  //----
  Order_Select = OrderSelect(ticket, SELECT_BY_TICKET);
  
  //---- Calculation of the time interval between trading operations         
  ReCountLastTime(GetLastError());
  //----
  if(ticket > 0 && Order_Select)
   {
    //---- Play a sound
    PlaySound("ok.wav");
    //---- Blocking the OpenSellOrder1_() function
                       // from repeated performance of the operation
    if(TimeLevel < 0)
              SELL_Signal = false;
    //----
    if(TimeLevel > 0)
       GlobalVariableSet(GetTimeLevelName(Symb, MagicNumber), TimeLevel);
    //---- 
    OpderPrice = DoubleToStr(OrderOpenPrice(), Digits);  
    Print(StringConcatenate(Symb, " SELL order with ticket #",
            ticket, " and magic number ", OrderMagicNumber(), 
                                       " opened at the price " ,OpderPrice));
    }
   else Print(StringConcatenate("Failed to open ", Symb, 
               " SELL order with the magic number ", MagicNumber, "!!!"));
  //----  
  return(true);
//---+  
 }
//+X================================================================X+
//| OpenBuyOrder2_()                                                 |
//+X================================================================X+
bool OpenBuyOrder2_
        (bool& BUY_Signal, int MagicNumber, datetime TimeLevel,
                           double Money_Management, int Margin_Mode, 
                             int STOPLOSS, int TAKEPROFIT, string Coment)
 {
//---+
  //---- Check if the minimum time interval has passed 
                                    //between two trading operations         
  if (TimeCurrent() < LastTime)
                          return(true); 
  //----                        
  bool IfOrderExists;
  static bool IfOrderModify[];
  //----
  if (ArraySize(IfOrderModify) < MagicNumber + 1) 
                    ArrayResize(IfOrderModify, MagicNumber + 1); 
  //----
  if (!BUY_Signal)
   if (IfOrderModify[MagicNumber])
                        return(true);                  
  //----
  string Symb = Symbol();

  //---- Check if the time limit with respect to the previous deal has expired
  if (!TradeTimeLevelCheck(Symb, MagicNumber, TimeLevel))
                                                  return(true);
  //---- Check correctness of pending orders
  if (STOPLOSS < 0)
   {
    Print("OpenBuyOrder2_(): Invalid Stop Loss!!!");
    return(true);
   }
  //---- 
  if (TAKEPROFIT < 0)
   {
    Print("OpenBuyOrder2_(): Invalid Take Profit!!!");
    return(true);
   }
   
  //---- Check for an open position with set Stop Loss and Take Profit
                       //with the magic number equal to the MagicNumber variable value    
  if (Order_Select(Symb, MagicNumber))
    {
      if (OrderType() != OP_BUY)
                            return(true);
      IfOrderExists = true;
      //----
      if ((OrderTakeProfit() == 0 && TAKEPROFIT != 0)
            || (OrderStopLoss() == 0 && STOPLOSS != 0))                                                  
                          IfOrderModify[MagicNumber] = false;
      else
       if (OrderStopLoss() != 0 
               && OrderTakeProfit() != 0) 
        {
         IfOrderModify[MagicNumber] = true;
         return(true);
        }    
    }
  else 
    if (!BUY_Signal)
     {
      IfOrderModify[MagicNumber] = true;
      return(true);
     }
  //---- 
  string OpderPrice;
  bool   Order_Modify, Order_Select;
  int    ticket, StLOSS, TkPROFIT, ErrorCode;
  double Lot, ask, Stoploss, TakeProfit;                                                 
  //----
  if (BUY_Signal && !IfOrderExists)
   {                                                                                  
    STOPLOSS = StopCorrect(Symb, STOPLOSS, Slippage_);
    if (STOPLOSS < 0)
          return(false);
    //---+ LOT SIZE CALCULATION FOR OPENING A POSITION
    Lot = BuyLotCount(Money_Management, Margin_Mode, STOPLOSS);
    //----
    if (Lot == -1)
              return(false);  
    else 
     if (Lot == 0)
               return(true);
               
    //---+ check the lot size against the funds available in the account   
    if (!MarginCheck(Symb, OP_BUY, Lot))
                               return(false);
    //----
    if (Lot == 0.0)
            return(true);
    //----
    ask = NormalizeDouble(Ask, Digits);
    if (ask == 0.0)
          return(false);
    //---- 
    Print(StringConcatenate
         ("Open a ", Symb,
                " Buy position with the magic number ", MagicNumber));
    //---+ Open a Buy position    
    ticket = OrderSend(Symb, OP_BUY, Lot, ask, Slippage_, 
                             0, 0, Coment, MagicNumber, 0, Lime);
     
    //---- Calculation of the time interval between trading operations         
    CountLastTime(GetLastError());
    //----
    Order_Select = OrderSelect(ticket, SELECT_BY_TICKET);
  
    //---- Calculation of the time interval between trading operations         
    ReCountLastTime(GetLastError());
    //----
    if(ticket > 0 && Order_Select)
     {
      //---- Play a sound
      PlaySound("ok.wav");
      //---- Blocking the OpenBuyOrder2_() function
                         // from repeated performance of the operation
      if(TimeLevel < 0)
                BUY_Signal = false;
      //----
      if(TimeLevel > 0)
         GlobalVariableSet(GetTimeLevelName(Symb, MagicNumber), TimeLevel);
      //----         
      OpderPrice = DoubleToStr(OrderOpenPrice(), Digits);  
      Print(StringConcatenate(Symb, " BUY order with ticket #",
                   ticket, " and magic number ", OrderMagicNumber(), 
                                                  " opened at the price ",OpderPrice));
      //----
      IfOrderModify[MagicNumber] = false;
     }
    else
     {
       Print(StringConcatenate("Failed to open ", Symb, 
                         " BUY order with the magic number ", MagicNumber, "!!!"));
       return(true);
     }
   }
  //---+ Open order modification 
  if (!IfOrderModify[MagicNumber])
   {   
    if (STOPLOSS == 0 && TAKEPROFIT == 0)
     {
      IfOrderModify[MagicNumber] = true;
      return(true);
     }
    //----       
    if (STOPLOSS > 0) 
     {           
      StLOSS = StopCorrect(Symb, STOPLOSS, Slippage_);
      if (StLOSS < 0)
          return(false);
      //----
      Stoploss = NormalizeDouble(OrderOpenPrice() - StLOSS * Point, Digits);  
      if (Stoploss < 0)
           return(false);
     }
    else Stoploss = 0.0;
    //----   
    if (TAKEPROFIT > 0) 
     {           
      TkPROFIT = StopCorrect(Symb, TAKEPROFIT, Slippage_);
      if (TkPROFIT < 0)
          return(false);
      //----
      TakeProfit = NormalizeDouble(OrderOpenPrice() + TkPROFIT * Point, Digits);
      if (TakeProfit < 0)
               return(false);
     }
    else TakeProfit = 0.0;      
    //---- 
    Print(StringConcatenate
         ("Modify the ", Symb,
                       " BUY order with ticket #", OrderTicket(), 
                                             " with the magic number ", MagicNumber));       
    Order_Modify = OrderModify(OrderTicket(), 
                   OrderOpenPrice(), Stoploss, TakeProfit, 0, Blue);
                   
    //---- Calculation of the time interval between trading operations         
    CountLastTime(GetLastError());
    //----                               
    if (Order_Modify)
     {
       Print(StringConcatenate(Symb, " BUY order with ticket #",
                                         OrderTicket(), " and the magic number ", 
                                             OrderMagicNumber(), " has been modified"));
       //----
       IfOrderModify[MagicNumber] = true;                                     
     }
    else Print(StringConcatenate("Failed to modify the BUY ", 
                            Symb, " order with ticket #", OrderTicket(), 
                                  " and the magic number ", OrderMagicNumber()));     
   }
    
  return(true);
//---+
 }
//+X================================================================X+
//| OpenSellOrder2_()                                                |
//+X================================================================X+
bool OpenSellOrder2_
        (bool& SELL_Signal, int MagicNumber, datetime TimeLevel, 
                            double Money_Management, int Margin_Mode, 
                              int STOPLOSS, int TAKEPROFIT, string Coment)
 {
//---+
  //---- Check if the minimum time interval has passed 
                                    //between two trading operations         
  if (TimeCurrent() < LastTime)
                          return(true); 
  //----                        
  bool IfOrderExists;
  static bool IfOrderModify[];
  //----
  if (ArraySize(IfOrderModify) < MagicNumber + 1) 
                    ArrayResize(IfOrderModify, MagicNumber + 1); 
  //----
  if (!SELL_Signal)
   if (IfOrderModify[MagicNumber])
                        return(true);                  
  //----
  string Symb = Symbol();
  
  //---- Check if the time limit with respect to the previous deal has expired
  if (!TradeTimeLevelCheck(Symb, MagicNumber, TimeLevel))
                                                  return(true);
  
  //---- Check correctness of pending orders
  if (STOPLOSS < 0)
   {
    Print("OpenSellOrder2_(): Invalid Stop Loss!!!");
    return(true);
   }
  //---- 
  if (TAKEPROFIT < 0)
   {
    Print("OpenSellOrder2_(): Invalid Take Profit!!!");
    return(true);
   }
   
  //---- Check for an open position with set Stop Loss and Take Profit
                       //with the magic number equal to the MagicNumber variable value    
  if (Order_Select(Symb, MagicNumber))
    {
      if (OrderType() != OP_SELL)
                            return(true);
      IfOrderExists = true;
      //----
      if ((OrderTakeProfit() == 0 && TAKEPROFIT != 0)
            || (OrderStopLoss() == 0 && STOPLOSS != 0))                                                  
                          IfOrderModify[MagicNumber] = false;
      else
       if (OrderStopLoss() != 0 
               && OrderTakeProfit() != 0)
        {
         IfOrderModify[MagicNumber] = true;
         return(true);
        }    
    }
  else 
    if (!SELL_Signal)
     {
      IfOrderModify[MagicNumber] = true;
      return(true);
     }
  //---- 
  string OpderPrice;
  bool   Order_Modify, Order_Select;
  int    ticket, StLOSS, TkPROFIT, ErrorCode;
  double Lot, bid, Stoploss, TakeProfit;                                                                                                  
  //----
  if (SELL_Signal && !IfOrderExists)
   {                                
    STOPLOSS = StopCorrect(Symb, STOPLOSS, Slippage_);
    if (STOPLOSS < 0)
          return(false);
    //---+ LOT SIZE CALCULATION FOR OPENING A POSITION
    Lot = SellLotCount(Money_Management, Margin_Mode, STOPLOSS);
    //----
    if (Lot == -1)
              return(false);  
    else 
     if (Lot == 0)
               return(true);
          
    //---+ check the lot size against the funds available in the account   
    if (!MarginCheck(Symb, OP_SELL, Lot))
                                    return(false);
    //----
     if (Lot == 0.0)
            return(true);
    //----
    bid = NormalizeDouble(Bid, Digits);
    if (bid == 0.0)
            return(false);
  
    Print(StringConcatenate
           ("Open a ", Symb,
                       " Sell position with the magic number ", MagicNumber));    
    //---+ Open a Sell position    
    ticket = OrderSend(Symb, OP_SELL, Lot, bid, Slippage_, 
                             0, 0, Coment, MagicNumber, 0, Red); 
     
    //---- Calculation of the time interval between trading operations         
    CountLastTime(GetLastError());
    //----
    Order_Select = OrderSelect(ticket, SELECT_BY_TICKET);
  
    //---- Calculation of the time interval between trading operations         
    ReCountLastTime(GetLastError());
    //----
    if(ticket > 0 && Order_Select)
     {
      //---- Play a sound
      PlaySound("ok.wav");
      //---- Blocking the OpenSellOrder2_() function
                         // from repeated performance of the operation
      if(TimeLevel < 0)
                SELL_Signal = false;
      //----
      if(TimeLevel > 0)
         GlobalVariableSet(GetTimeLevelName(Symb, MagicNumber), TimeLevel);
      //----          
      OpderPrice = DoubleToStr(OrderOpenPrice(), Digits);  
       Print(StringConcatenate(Symb, " SELL order with ticket #",
                    ticket, " and magic number ", OrderMagicNumber(), 
                                                  " opened at the price ",OpderPrice));
      //----
      IfOrderModify[MagicNumber] = false;
     }
    else
     {
      Print(StringConcatenate("Failed to open ", Symb, 
                         " SELL order with the magic number ", MagicNumber, "!!!"));
      return(true);
     }
   }
  
  //---+ Open order modification 
  if (!IfOrderModify[MagicNumber])
   {   
    if (STOPLOSS == 0 && TAKEPROFIT == 0)
     {
      IfOrderModify[MagicNumber] = true;
      return(true);
     }
    //----
    if (STOPLOSS > 0) 
     {           
      StLOSS = StopCorrect(Symb, STOPLOSS, Slippage_);
      if (StLOSS < 0)
          return(false);
      //----
      Stoploss = NormalizeDouble(OrderOpenPrice() + StLOSS * Point, Digits); 
      if (Stoploss < 0)
           return(false);
     }
    else Stoploss = 0.0;
    //----   
    if (TAKEPROFIT > 0) 
     {           
      TkPROFIT = StopCorrect(Symb, TAKEPROFIT, Slippage_);
      if (TkPROFIT < 0)
          return(false);
      //----
      TakeProfit = NormalizeDouble(OrderOpenPrice() - TkPROFIT * Point, Digits);
      if (TakeProfit < 0)
               return(false);
     }
    else TakeProfit = 0.0;      
    //---- 
    Print(StringConcatenate
         ("Modify the ", Symb,
                       " SELL order with ticket #", OrderTicket(), 
                                             " with the magic number ", MagicNumber));       
    //----
    Order_Modify = OrderModify(OrderTicket(), 
                     OrderOpenPrice(), Stoploss, TakeProfit, 0, Blue);
                     
    //---- Calculation of the time interval between trading operations           
    CountLastTime(GetLastError());
    //----       
    if (Order_Modify)
     {
       Print(StringConcatenate(Symb, " SELL order with ticket #",
                                         OrderTicket(), " and the magic number ", 
                                             OrderMagicNumber(), " has been modified"));
       IfOrderModify[MagicNumber] = true;                                     
     }
    else Print(StringConcatenate("Failed to modify the SELL ", 
                            Symb, " order with ticket #", OrderTicket(), 
                                  " and the magic number ", OrderMagicNumber()));     
   }
   
  return(true);
//---+  
 }
//+X================================================================X+
//| dOpenBuyOrder1_()                                                |
//+X================================================================X+
bool dOpenBuyOrder1_
        (bool& BUY_Signal, int MagicNumber, 
           datetime TimeLevel,double Money_Management, int Margin_Mode, 
                        double dSTOPLOSS, double dTAKEPROFIT, string Coment)
 {
//---+
  if (!BUY_Signal)
           return(true); 
  //---- Check if the minimum time interval has passed 
                                    //between two trading operations         
  if (TimeCurrent() < LastTime)
                          return(true); 
  //----
  string Symb = Symbol();
  
  //---- Check if the time limit with respect to the previous deal has expired
  if (!TradeTimeLevelCheck(Symb, MagicNumber, TimeLevel))
                                                  return(true);
                                 
  //---- Check for an open position 
          //with the magic number equal to the MagicNumber variable value
  if (Order_Select(Symb, MagicNumber))
                                 return(true);  
  //----
  string OpderPrice;
  bool   Order_Select;
  int    STOPLOSS, TAKEPROFIT ; 
  int    ErrorCode, ticket, StLOSS, TkPROFIT;
  double Lot, ask, Stoploss, TakeProfit;
  //----          
  ask = NormalizeDouble(Ask, Digits);
  if (ask == 0.0)
          return(false);  
  //----
  if (dSTOPLOSS > 0)
   {
    STOPLOSS = (ask - dSTOPLOSS) / Point;
    if (STOPLOSS <= 0)
     {
      Print("dOpenBuyOrder1_(): Invalid Stop Loss!!!");
      return(true);
     }
    //---- 
    StLOSS = StopCorrect(Symb, STOPLOSS, Slippage_);
    if (StLOSS < 0)
         return(false);
    //----
    Stoploss = NormalizeDouble(ask - StLOSS * Point, Digits);
    if (Stoploss < 0)
          return(false);
   }
  else
   {
    if (dSTOPLOSS < 0)
     {
      Print("dOpenBuyOrder1_(): Invalid Stop Loss!!!");
      return(true);
     }
    //---- 
    Stoploss = 0.0;
   }
  //----
  if (dTAKEPROFIT > 0)
   {
    TAKEPROFIT = (dTAKEPROFIT - ask) / Point;
    if (TAKEPROFIT <= 0)
     {
      Print("dOpenBuyOrder1_(): Invalid Take Profit!!!");
      return(true);
     }
    //---- 
    TkPROFIT = StopCorrect(Symb, TAKEPROFIT, Slippage_);
    if (TkPROFIT < 0)
         return(false);
    //----
    TakeProfit = NormalizeDouble(ask + TkPROFIT * Point, Digits);
    if (TakeProfit < 0)
               return(false);
   }
  else
   {
    if (dTAKEPROFIT < 0)
     {
      Print("dOpenBuyOrder1_(): Invalid Take Profit!!!");
      return(true);
     }
    //---- 
    TakeProfit = 0.0;
   }
    
  //---+ LOT SIZE CALCULATION FOR OPENING A POSITION
  Lot = BuyLotCount(Money_Management, Margin_Mode, StLOSS);
  //----
  if (Lot == -1)
            return(false);  
  else 
   if (Lot == 0)
             return(true);  
        
  //---+ check the lot size against the funds available in the account   
  if (!MarginCheck(Symb, OP_BUY, Lot))
                                  return(false);
  //----
  if (Lot == 0.0)
            return(true);   
  //----     
  Print(StringConcatenate
         ("Open a ", Symb,
            " Buy position with the magic number ", MagicNumber));
            
  //---+ Open a Buy position    
  ticket = OrderSend(Symb, OP_BUY, Lot, ask, Slippage_, 
            Stoploss, TakeProfit, Coment, MagicNumber, 0, Lime);
  
  //---- Calculation of the time interval between trading operations         
  CountLastTime(GetLastError());
  //----
  Order_Select = OrderSelect(ticket, SELECT_BY_TICKET);
  
  //---- Calculation of the time interval between trading operations         
  ReCountLastTime(GetLastError());
  //----
  if(ticket > 0 && Order_Select)
   {
    //---- Play a sound
    PlaySound("ok.wav");
    //---- Blocking the dOpenBuyOrder1_() function
                       // from repeated performance of the operation
    if(TimeLevel < 0)
              BUY_Signal = false;
    //----
    if(TimeLevel > 0)
       GlobalVariableSet(GetTimeLevelName(Symb, MagicNumber), TimeLevel);
    //----
    OpderPrice = DoubleToStr(OrderOpenPrice(), Digits);  
    Print(StringConcatenate(Symb, " BUY order with ticket #",
          ticket, " and magic number ", OrderMagicNumber(), 
                                   " opened at the price ",OpderPrice));                                
   }
  else Print(StringConcatenate("Failed to open ", Symb, 
           " BUY order with the magic number ", MagicNumber, "!!!"));
  //---- 
  return(true);
//---+
 }
//+X================================================================X+
//| dOpenSellOrder1_()                                               |
//+X================================================================X+
bool dOpenSellOrder1_
        (bool& SELL_Signal, int MagicNumber, 
           datetime TimeLevel,double Money_Management, int Margin_Mode, 
                        double dSTOPLOSS, double dTAKEPROFIT, string Coment)
 {
//---+
  if (!SELL_Signal)
           return(true); 
  //---- Check if the minimum time interval has passed 
                                    //between two trading operations         
  if (TimeCurrent() < LastTime)
                          return(true);                    
  //----
  string Symb = Symbol();

  //---- Check if the time limit with respect to the previous deal has expired
  if (!TradeTimeLevelCheck(Symb, MagicNumber, TimeLevel))
                                                  return(true); 
                                 
  //---- Check for an open position 
          //with the magic number equal to the MagicNumber variable value
  if (Order_Select(Symb, MagicNumber))
                                 return(true);  
  //----
  string OpderPrice;
  bool   Order_Select;
  int    STOPLOSS, TAKEPROFIT; 
  int    ticket, StLOSS, TkPROFIT, ErrorCode;
  double Lot, bid, Stoploss, TakeProfit;
  //----
  bid = NormalizeDouble(Bid, Digits);
  if (bid == 0.0)
          return(false);
  //----
  if (dSTOPLOSS > 0)
   {
    STOPLOSS = (dSTOPLOSS - bid) / Point;
    if (STOPLOSS <= 0)
     {
      Print("dOpenSellOrder1_(): Invalid Stop Loss!!!");
      return(true);
     }
    //---- 
    StLOSS = StopCorrect(Symb, STOPLOSS, Slippage_);
    if (StLOSS < 0)
         return(false);
    //----
    Stoploss = NormalizeDouble(bid + StLOSS * Point, Digits);
    if (Stoploss < 0)
         return(false);
   }
  else
   {
    if (dSTOPLOSS < 0)
     {
      Print("dOpenSellOrder1_(): Invalid Stop Loss!!!");
      return(true);
     }
    //---- 
    Stoploss = 0.0;
   }
  //----
  if (dTAKEPROFIT > 0)
   {
    TAKEPROFIT = (bid - dTAKEPROFIT) / Point;
    if (TAKEPROFIT <= 0)
     {
      Print("dOpenSellOrder1_(): Invalid Take Profit!!!");
      return(true);
     }
    //---- 
    TkPROFIT = StopCorrect(Symb, TAKEPROFIT, Slippage_);
    if (TkPROFIT < 0)
           return(false);
    //----
    TakeProfit = NormalizeDouble(bid - TkPROFIT * Point, Digits);
    if (TakeProfit < 0)
           return(false);
   }
  else
   {
    if (dTAKEPROFIT < 0)
     {
      Print("dOpenSellOrder1_(): Invalid Take Profit!!!");
      return(true);
     }
    //---- 
    TakeProfit = 0.0;
   }
   
  //---+ LOT SIZE CALCULATION FOR OPENING A POSITION
  Lot = SellLotCount(Money_Management, Margin_Mode, StLOSS);
  //----
  if (Lot == -1)
            return(false);  
  else 
   if (Lot == 0)
             return(true);  
          
  //---+ check the lot size against the funds available in the account   
  if (!MarginCheck(Symb, OP_SELL, Lot))
                                  return(false);
  //----
  if (Lot == 0.0)
            return(true);
  //----  
  Print(StringConcatenate
         ("Open a ", Symb,
               " Sell position with the magic number ", MagicNumber)); 
                  
  //---+ Open a Sell position    
  ticket = OrderSend(Symb, OP_SELL, Lot, bid, Slippage_, 
            Stoploss, TakeProfit, Coment, MagicNumber, 0, Red);
              
  //---- Calculation of the time interval between trading operations         
  CountLastTime(GetLastError());
  //----
  Order_Select = OrderSelect(ticket, SELECT_BY_TICKET);
  
  //---- Calculation of the time interval between trading operations         
  ReCountLastTime(GetLastError());
  //----
  if(ticket > 0 && Order_Select)
   {
    //---- Play a sound
    PlaySound("ok.wav");
    //---- Blocking the dOpenSellOrder1_() function
                        // from repeated performance of the operation
    if(TimeLevel < 0)
              SELL_Signal = false;
    //----
    if(TimeLevel > 0)
       GlobalVariableSet(GetTimeLevelName(Symb, MagicNumber), TimeLevel);
    //----
    OpderPrice = DoubleToStr(OrderOpenPrice(), Digits);  
    Print(StringConcatenate(Symb, " SELL order with ticket #",
           ticket, " and magic number ", OrderMagicNumber(), 
                                      " opened at the price " ,OpderPrice));
    }
   else Print(StringConcatenate("Failed to open ", Symb, 
              " SELL order with the magic number ", MagicNumber, "!!!"));
  //----  
  return(true);
//---+  
 }
//+X================================================================X+
//| dOpenBuyOrder2_()                                                |
//+X================================================================X+
bool dOpenBuyOrder2_
        (bool& BUY_Signal, int MagicNumber, 
           datetime TimeLevel,double Money_Management, int Margin_Mode, 
                        double dSTOPLOSS, double dTAKEPROFIT, string Coment)
 {
//---+
  //---- Check if the minimum time interval has passed 
                                    //between two trading operations         
  if (TimeCurrent() < LastTime)
                          return(true); 
  //----                        
  bool IfOrderExists;
  static bool IfOrderModify[];
  //----
  if (ArraySize(IfOrderModify) < MagicNumber + 1) 
                    ArrayResize(IfOrderModify, MagicNumber + 1); 
  //----
  if (!BUY_Signal)
   if (IfOrderModify[MagicNumber])
                        return(true);                  
  //----
  string Symb = Symbol();

  //---- Check if the time limit with respect to the previous deal has expired
  if (!TradeTimeLevelCheck(Symb, MagicNumber, TimeLevel))
                                                  return(true); 
  //----
  int STOPLOSS, TAKEPROFIT; 
  //----
  if (dSTOPLOSS > 0)
   {
    STOPLOSS = (Ask - dSTOPLOSS) / Point;
    if (STOPLOSS <= 0)
     {
      Print("dOpenBuyOrder2_(): Invalid Stop Loss!!!");
      return(true);
     }
   }
  else
   {
    if (dSTOPLOSS < 0)
     {
      Print("dOpenBuyOrder2_(): Invalid Stop Loss!!!");
      return(true);
     }
    //---- 
    STOPLOSS = 0;
   }
  //----
  if (dTAKEPROFIT > 0)
   {
    TAKEPROFIT = (dTAKEPROFIT - Ask) / Point;
    if (TAKEPROFIT < 0)
     {
      Print("dOpenBuyOrder2_(): Invalid Take Profit!!!");
      return(true);
     }
   }
  else
   {
    if (dTAKEPROFIT < 0)
     {
      Print("dOpenBuyOrder2_(): Invalid Take Profit!!!");
      return(true);
     }
    //---- 
    TAKEPROFIT = 0;
   }
  
  //---- Check for an open position with set Stop Loss and Take Profit
                       //with the magic number equal to the MagicNumber variable value    
  if (Order_Select(Symb, MagicNumber))
    {
      if (OrderType() != OP_BUY)
                            return(true);
      IfOrderExists = true;
      //----
      if ((OrderTakeProfit() == 0 && TAKEPROFIT != 0)
            || (OrderStopLoss() == 0 && STOPLOSS != 0))                                                  
                          IfOrderModify[MagicNumber] = false;
      else
       if (OrderStopLoss() != 0 
               && OrderTakeProfit() != 0)
        {
         IfOrderModify[MagicNumber] = true;
         return(true);
        }    
    }
  else 
    if (!BUY_Signal)
     {
      IfOrderModify[MagicNumber] = true;
      return(true);
     }
  //---- 
  string OpderPrice;
  bool   Order_Modify, Order_Select;
  int    ticket, StLOSS, TkPROFIT, ErrorCode;
  double Lot, ask, Stoploss, TakeProfit;                                                 
  //----
  if (BUY_Signal && !IfOrderExists)
   {                                                                                  
    //----
    STOPLOSS = StopCorrect(Symb, STOPLOSS, Slippage_);
    if (STOPLOSS < 0)
          return(false);
    //---+ LOT SIZE CALCULATION FOR OPENING A POSITION
    Lot = BuyLotCount(Money_Management, Margin_Mode, STOPLOSS);
    //----
    if (Lot == -1)
              return(false);  
    else 
     if (Lot == 0)
               return(true);
               
    //---+ check the lot size against the funds available in the account   
    if (!MarginCheck(Symb, OP_BUY, Lot))
                               return(false);
    //----
    if (Lot == 0.0)
            return(true);
    //----
    ask = NormalizeDouble(Ask, Digits);
    if (ask == 0.0)
          return(false);
    //---- 
    Print(StringConcatenate
         ("Open a ", Symb,
                       " Buy position with the magic number ", MagicNumber));
    //---+ Open a Buy position    
    ticket = OrderSend(Symb, OP_BUY, Lot, ask, Slippage_, 
                             0, 0, Coment, MagicNumber, 0, Lime); 
     
    //---- Calculation of the time interval between trading operations         
    CountLastTime(GetLastError());
    //----
    Order_Select = OrderSelect(ticket, SELECT_BY_TICKET);
  
    //---- Calculation of the time interval between trading operations         
    ReCountLastTime(GetLastError());
    //----
    if(ticket > 0 && Order_Select)
     {
      //---- Play a sound
      PlaySound("ok.wav");
      //---- Blocking the dOpenBuyOrder2_() function
                         // from repeated performance of the operation
      if(TimeLevel < 0)
                BUY_Signal = false;
      //----
      if(TimeLevel > 0)
         GlobalVariableSet(GetTimeLevelName(Symb, MagicNumber), TimeLevel);
      //----
      OpderPrice = DoubleToStr(OrderOpenPrice(), Digits);  
      Print(StringConcatenate(Symb, " BUY order with ticket #",
                   ticket, " and magic number ", OrderMagicNumber(), 
                                                  " opened at the price ",OpderPrice));
      //----
      IfOrderModify[MagicNumber] = false;
     }
    else
     {
       Print(StringConcatenate("Failed to open ", Symb, 
                         " BUY order with the magic number ", MagicNumber, "!!!"));
       return(true);
     }
   }
  //---+ Open order modification 
  if (!IfOrderModify[MagicNumber])
   {   
    if (STOPLOSS == 0 && TAKEPROFIT == 0)
     {
      IfOrderModify[MagicNumber] = true;
      return(true);
     }
    //----       
    if (STOPLOSS > 0) 
     {           
      StLOSS = StopCorrect(Symb, STOPLOSS, Slippage_);
      if (StLOSS < 0)
           return(false);
      //----
      Stoploss = NormalizeDouble(OrderOpenPrice() - StLOSS * Point, Digits);  
      if (Stoploss < 0)
           return(false);
     }
    else 
      Stoploss = 0.0;
    //----   
    if (TAKEPROFIT > 0) 
     {           
      TkPROFIT = StopCorrect(Symb, TAKEPROFIT, Slippage_);
      if (TkPROFIT < 0)
          return(false);
      //----
      TakeProfit = NormalizeDouble(OrderOpenPrice() + TkPROFIT * Point, Digits);
      if (TakeProfit < 0)
               return(false);
     }
    else 
      TakeProfit = 0.0;
    //----     
    Print(StringConcatenate
         ("Modify the ", Symb,
                       " BUY order with ticket #", OrderTicket(), 
                                             " with the magic number ", MagicNumber));       
    //----
    Order_Modify = OrderModify(OrderTicket(), 
                    OrderOpenPrice(), Stoploss, TakeProfit, 0, Blue);
                    
    //---- Calculation of the time interval between trading operations         
    CountLastTime(GetLastError());
    //----                      
    if (Order_Modify)
     {
       Print(StringConcatenate(Symb, " BUY order with ticket #",
                                         OrderTicket(), " and the magic number ", 
                                             OrderMagicNumber(), " has been modified"));
       //----
       IfOrderModify[MagicNumber] = true;                                     
     }
    else Print(StringConcatenate("Failed to modify the BUY ", 
                            Symb, " order with ticket #", OrderTicket(), 
                                  " and the magic number ", OrderMagicNumber()));     
   }
    
  return(true);
//---+
 }
//+X================================================================X+
//| dOpenSellOrder2_()                                               |
//+X================================================================X+
bool dOpenSellOrder2_
        (bool& SELL_Signal, int MagicNumber, 
           datetime TimeLevel,double Money_Management, int Margin_Mode, 
                        double dSTOPLOSS, double dTAKEPROFIT, string Coment)
 {
//---+
  //---- Check if the minimum time interval has passed 
                                    //between two trading operations         
  if (TimeCurrent() < LastTime)
                          return(true); 
  //----                        
  bool IfOrderExists;
  static bool IfOrderModify[];
  //----
  if (ArraySize(IfOrderModify) < MagicNumber + 1) 
                    ArrayResize(IfOrderModify, MagicNumber + 1); 
  //----
  if (!SELL_Signal)
   if (IfOrderModify[MagicNumber])
                        return(true);                  
  //----
  string Symb = Symbol();

  //---- Check if the time limit with respect to the previous deal has expired
  if (!TradeTimeLevelCheck(Symb, MagicNumber, TimeLevel))
                                                  return(true); 
  //----
  int STOPLOSS, TAKEPROFIT;
  //----
  if (dSTOPLOSS > 0)
   {
    STOPLOSS = (dSTOPLOSS - Bid) / Point;
    if (STOPLOSS < 0)
     {
      Print("dOpenSellOrder2_(): Invalid Stop Loss!!!");
      return(true);
     }
   }
  else
   {
    if (dSTOPLOSS < 0)
     {
      Print("dOpenSellOrder2_(): Invalid Stop Loss!!!");
      return(true);
     }
    //---- 
    STOPLOSS = 0;
   }
  //----
  if (dTAKEPROFIT > 0)
   {
    TAKEPROFIT = (Bid - dTAKEPROFIT) / Point;
    if (TAKEPROFIT < 0)
     {
      Print("dOpenSellOrder2_(): Invalid Take Profit!!!");
      return(true);
     }
   }
  else
   {
    if (dTAKEPROFIT < 0)
     {
      Print("dOpenSellOrder2_(): Invalid Take Profit!!!");
      return(true);
     }
    //----  
    TAKEPROFIT = 0;
   }
  //----  
  
  //---- Check for an open position with set Stop Loss and Take Profit
                       //with the magic number equal to the MagicNumber variable value    
  if (Order_Select(Symb, MagicNumber))
    {
      if (OrderType() != OP_SELL)
                            return(true);
      IfOrderExists = true;
      //----
      if ((OrderTakeProfit() == 0 && TAKEPROFIT != 0)
            || (OrderStopLoss() == 0 && STOPLOSS != 0))                                                  
                          IfOrderModify[MagicNumber] = false;
      else
       if (OrderStopLoss() != 0 && OrderTakeProfit() != 0) 
        {
         IfOrderModify[MagicNumber] = true;
         return(true);
        }    
    }
  else 
    if (!SELL_Signal)
     {
      IfOrderModify[MagicNumber] = true;
      return(true);
     }
  //----       
  string OpderPrice;
  bool   Order_Modify, Order_Select; 
  int    ticket, StLOSS, TkPROFIT, ErrorCode;
  double Lot, bid, Stoploss, TakeProfit;                                                                                                  
  //----
  if (SELL_Signal && !IfOrderExists)
   {                                
    //----
    STOPLOSS = StopCorrect(Symb, STOPLOSS, Slippage_);
    if (STOPLOSS < 0)
          return(false);
    //---+ LOT SIZE CALCULATION FOR OPENING A POSITION
    Lot = SellLotCount(Money_Management, Margin_Mode, STOPLOSS);
    //----
    if (Lot == -1)
              return(false);  
    else 
     if (Lot == 0)
               return(true);
          
    //---+ check the lot size against the funds available in the account   
    if (!MarginCheck(Symb, OP_SELL, Lot))
                                    return(false);
    //----
     if (Lot == 0.0)
            return(true);
    //----
    bid = NormalizeDouble(Bid, Digits);
    if (bid == 0.0)
            return(false);
  
    Print(StringConcatenate
           ("Open a ", Symb,
                       " Sell position with the magic number ", MagicNumber));    
    //---+ Open a Sell position    
    ticket = OrderSend(Symb, OP_SELL, Lot, bid, 
                        Slippage_, 0, 0, Coment, MagicNumber, 0, Red); 
     
    //---- Calculation of the time interval between trading operations         
    CountLastTime(GetLastError());
    //----
    Order_Select = OrderSelect(ticket, SELECT_BY_TICKET);
  
    //---- Calculation of the time interval between trading operations         
    ReCountLastTime(GetLastError());
    //----
    if(ticket > 0 && Order_Select)
     {
      //---- Play a sound
      PlaySound("ok.wav");
      //---- Blocking the dOpenSellOrder2_() function
                         // from repeated performance of the operation
      if(TimeLevel < 0)
                SELL_Signal = false;
      //----
      if(TimeLevel > 0)
         GlobalVariableSet(GetTimeLevelName(Symb, MagicNumber), TimeLevel);
      //----
      OpderPrice = DoubleToStr(OrderOpenPrice(), Digits);  
      Print(StringConcatenate(Symb, " SELL order with ticket #",
                   ticket, " and magic number ", OrderMagicNumber(), 
                                                  " opened at the price ",OpderPrice));
      //----
      IfOrderModify[MagicNumber] = false;
     }
    else
     {
      Print(StringConcatenate("Failed to open ", Symb, 
                         " SELL order with the magic number ", MagicNumber, "!!!"));
      return(true);
     }
   }
  
  //---+ Open order modification 
  if (!IfOrderModify[MagicNumber])
   {   
    
    if (STOPLOSS > 0) 
     {           
      if (STOPLOSS == 0 && TAKEPROFIT == 0)
       {
        IfOrderModify[MagicNumber] = true;
        return(true);
       }
      //----
      StLOSS = StopCorrect(Symb, STOPLOSS, Slippage_);
      if (StLOSS < 0)
          return(false);
      //----
      Stoploss = NormalizeDouble(OrderOpenPrice() + StLOSS * Point, Digits); 
      if (Stoploss < 0)
           return(false);
     }
    else 
      Stoploss = 0.0;
    //----   
    if (TAKEPROFIT > 0) 
     {           
      TkPROFIT = StopCorrect(Symb, TAKEPROFIT, Slippage_);
      if (TkPROFIT < 0)
          return(false);
      //----
      TakeProfit = NormalizeDouble(OrderOpenPrice() - TkPROFIT * Point, Digits);
      if (TakeProfit < 0)
               return(false);
     }
    else 
      TakeProfit = 0.0;
    //---- 
    Print(StringConcatenate
         ("Modify the ", Symb,
                       " SELL order with ticket #", OrderTicket(), 
                                             " with the magic number ", MagicNumber));       
    //----
    Order_Modify = OrderModify(OrderTicket(), 
                     OrderOpenPrice(), Stoploss, TakeProfit, 0, Blue);
                     
    //---- Calculation of the time interval between trading operations           
    CountLastTime(GetLastError());
    //----       
    if (Order_Modify)
     {
       Print(StringConcatenate(Symb, " SELL order with ticket #",
                                         OrderTicket(), " and the magic number ", 
                                             OrderMagicNumber(), " has been modified"));
       IfOrderModify[MagicNumber] = true;                                     
     }
    else Print(StringConcatenate("Failed to modify the SELL ", 
                            Symb, " order with ticket #", OrderTicket(), 
                                  " and the magic number ", OrderMagicNumber()));      
   }
   
  return(true);
//---+  
 }
//+X================================================================X+
//| OpenBuyLimitOrder1_()                                            |
//+X================================================================X+
bool OpenBuyLimitOrder1_
        (bool& Order_Signal, int MagicNumber, 
           datetime TimeLevel, double Money_Management, 
              int Margin_Mode, int STOPLOSS, int TAKEPROFIT, int LEVEL, 
                                          datetime Expiration, string Coment)
 {
//---+
  if (!Order_Signal)
              return(true); 
  //---- Check if the minimum time interval has passed 
                                    //between two trading operations         
  if (TimeCurrent() < LastTime)
                          return(true); 
                          
  //----
  string Symb = Symbol();

  //---- Check if the time limit with respect to the previous deal has expired
  if (!TradeTimeLevelCheck(Symb, MagicNumber, TimeLevel))
                                                  return(true);
                                  
  //---- Check for a placed order or open position
             //with the magic number equal to the MagicNumber variable value
  if (Order_Select(Symb, MagicNumber))
                                 return(true);
                                 
  //---- Check correctness of pending orders
  if (STOPLOSS < 0)
   {
    Print("OpenBuyLimitOrder1_(): Invalid Stop Loss!!!");
    return(true);
   }
  //---- 
  if (TAKEPROFIT < 0)
   {
    Print("OpenBuyLimitOrder1_(): Invalid Take Profit!!!");
    return(true);
   }
  //---- 
  if (LEVEL < 0)
   {
    Print("OpenBuyLimitOrder1_(): Invalid BuyLimit order!!!");
    return(true);
   }
  //---- 
  string OpderPrice;
  bool   Order_Select;
  int    ticket, StLOSS, TkPROFIT, Level, ErrorCode;
  double Lot, OpenPrice, Stoploss, TakeProfit;                                                 
  //----        
  Level = StopCorrect(Symb, LEVEL, 0);
  //----
  OpenPrice = NormalizeDouble(Ask - Level * Point, Digits);
  if (OpenPrice == 0.0)
               return(false);
  //---- 
  if (STOPLOSS > 0) 
   {           
     StLOSS = StopCorrect(Symb, STOPLOSS, 0);
     if (StLOSS < 0)
          return(false);
     //----
     Stoploss = NormalizeDouble(OpenPrice - StLOSS * Point, Digits);
     if (Stoploss < 0)
           return(false);
     //---- 
   }
  else Stoploss = 0.0;
  //----   
  if (TAKEPROFIT > 0) 
   {           
     TkPROFIT = StopCorrect(Symb, TAKEPROFIT, 0);
     if (TkPROFIT < 0)
          return(false);
     //----
     TakeProfit = NormalizeDouble(OpenPrice + TkPROFIT * Point, Digits);
     if (TakeProfit < 0)
                return(false);
     //---- 
   }
  else TakeProfit = 0.0;
  
  //---+ LOT SIZE CALCULATION FOR OPENING A POSITION
  Lot = BuyLotCount(Money_Management, Margin_Mode, StLOSS);
  //----
  if (Lot == -1)
            return(false);  
  else 
   if (Lot == 0)
             return(true);
  //----
  Print(StringConcatenate
         ("Set a ", Symb,
                  " pending BUY LIMIT order with the magic number ", MagicNumber));
              
  //---+ Set a BUY LIMIT order   
  ticket = OrderSend(Symb, OP_BUYLIMIT, Lot, OpenPrice, 0, 
            Stoploss, TakeProfit, Coment, MagicNumber, Expiration, Blue); 
  
  //---- Calculation of the time interval between trading operations         
  CountLastTime(GetLastError());
  //----
  Order_Select = OrderSelect(ticket, SELECT_BY_TICKET);
  
  //---- Calculation of the time interval between trading operations         
  ReCountLastTime(GetLastError());
  //----
  if(ticket > 0 && Order_Select)
   {
    //---- Play a sound
    PlaySound("ok.wav");
    //---- Blocking the OpenBuyLimitOrder1_() function
                        // from repeated performance of the operation
    if(TimeLevel < 0)
              Order_Signal = false;
    //----
    if(TimeLevel > 0)
       GlobalVariableSet(GetTimeLevelName(Symb, MagicNumber), TimeLevel);
    //----  
    OpderPrice = DoubleToStr(OrderOpenPrice(), Digits);
     Print(StringConcatenate("Pending BUY LIMIT ",Symb, 
       " order with ticket #",  ticket, " and the magic number ", 
            OrderMagicNumber(), " has been set. The order triggering price is ",OpderPrice,
                          ". The calculated price was ", DoubleToStr(OpenPrice, Digits)));
   }
  else
   Print(StringConcatenate("Failed to set a pending BUY LIMIT ", Symb, 
                               " order with the magic number ", MagicNumber, "!!!"));
  //----  
  return(true);
//---+
 }
//+X================================================================X+
//| OpenBuyStopOrder1_()                                             |
//+X================================================================X+
bool OpenBuyStopOrder1_
        (bool& Order_Signal, int MagicNumber, 
           datetime TimeLevel, double Money_Management, 
              int Margin_Mode, int STOPLOSS, int TAKEPROFIT, int LEVEL, 
                                          datetime Expiration, string Coment)
 {
//---+
  if (!Order_Signal)
             return(true); 
  //---- Check if the minimum time interval has passed 
                                    //between two trading operations         
  if (TimeCurrent() < LastTime)
                          return(true);
  //----
  string Symb = Symbol();

  //---- Check if the time limit with respect to the previous deal has expired
  if (!TradeTimeLevelCheck(Symb, MagicNumber, TimeLevel))
                                                  return(true);
                                  
  //---- Check for a placed order or open position
             //with the magic number equal to the MagicNumber variable value
  if (Order_Select(Symb, MagicNumber))
                                 return(true);
                                 
  //---- Check correctness of pending orders
  if (STOPLOSS < 0)
   {
    Print("OpenBuyStopOrder1_(): Invalid Stop Loss!!!");
    return(true);
   }
  //---- 
  if (TAKEPROFIT < 0)
   {
    Print("OpenBuyStopOrder1_(): Invalid Take Profit!!!");
    return(true);
   }
  //---- 
  if (LEVEL < 0)
   {
    Print("OpenBuyStopOrder1_(): Invalid BuyStop order!!!");
    return(true);
   }
  //----  
  string OpderPrice;
  bool   Order_Select; 
  int    ticket, StLOSS, TkPROFIT, Level, ErrorCode;
  double Lot, OpenPrice, Stoploss, TakeProfit;                                                     
  //----         
  Level = StopCorrect(Symb, LEVEL, 0);
  //----
  OpenPrice = NormalizeDouble(Ask + Level * Point, Digits);
  if (OpenPrice == 0.0)
          return(false);
  //---- 
  if (STOPLOSS > 0) 
   {           
     StLOSS = StopCorrect(Symb, STOPLOSS, 0);
     if (StLOSS < 0)
          return(false);
     //----
     Stoploss = NormalizeDouble(OpenPrice - StLOSS * Point, Digits);
     if (Stoploss < 0)
           return(false);
     //---- 
   }
  else Stoploss = 0.0;
  //----   
  if (TAKEPROFIT > 0) 
   {           
     TkPROFIT = StopCorrect(Symb, TAKEPROFIT, 0);
     if (TkPROFIT < 0)
          return(false);
     //----
     TakeProfit = NormalizeDouble(OpenPrice + TkPROFIT * Point, Digits);
     if (TakeProfit < 0)
                return(false);
     //---- 
   }
  else TakeProfit = 0.0;
                                                                                                    
  //---+ LOT SIZE CALCULATION FOR OPENING A POSITION
  Lot = BuyLotCount(Money_Management, Margin_Mode, StLOSS);
  //----
  if (Lot == -1)
            return(false);  
  else 
   if (Lot == 0)
             return(true);          
  //---- 
  Print(StringConcatenate
         ("Set a ", Symb,
                  " pending BUY STOP order with the magic number ", MagicNumber));
  //---+ Set a BUY STOP order   
  ticket = OrderSend(Symb, OP_BUYSTOP, Lot, OpenPrice, 0, 
            Stoploss, TakeProfit, Coment, MagicNumber, Expiration, Blue); 
  
  //---- Calculation of the time interval between trading operations         
  CountLastTime(GetLastError());
  //----
  Order_Select = OrderSelect(ticket, SELECT_BY_TICKET);
  
  //---- Calculation of the time interval between trading operations         
  ReCountLastTime(GetLastError());
  //----
  if(ticket > 0 && Order_Select)
   {
    //---- Play a sound
    PlaySound("ok.wav");
    //---- Blocking the OpenBuyStopOrder1_() function
                       // from repeated performance of the operation
    if(TimeLevel < 0)
               Order_Signal = false;
    //----
    if(TimeLevel > 0)
       GlobalVariableSet(GetTimeLevelName(Symb, MagicNumber), TimeLevel);
    //----   
    OpderPrice = DoubleToStr(OrderOpenPrice(), Digits);
     Print(StringConcatenate("Pending BUY STOP ",Symb, 
       " order with ticket #",  ticket, " and the magic number ", 
         OrderMagicNumber(), " has been set. The order triggering price ", OpderPrice,
                      ". The calculated price was ", DoubleToStr(OpenPrice, Digits)));
   }
  else
   Print(StringConcatenate("Failed to set a pending BUY STOP ", Symb, 
                               " order with the magic number ", MagicNumber, "!!!"));
  //----      
  return(true);
//---+
 }
//+X================================================================X+
//| OpenSellLimitOrder1_()                                           |
//+X================================================================X+
bool OpenSellLimitOrder1_
        (bool& Order_Signal, int MagicNumber, 
           datetime TimeLevel, double Money_Management, 
              int Margin_Mode, int STOPLOSS, int TAKEPROFIT, int LEVEL, 
                                          datetime Expiration, string Coment)
 {
//---+
  if (!Order_Signal)
           return(true); 
  //---- Check if the minimum time interval has passed 
                                    //between two trading operations         
  if (TimeCurrent() < LastTime)
                          return(true);
  //----
  string Symb = Symbol();

  //---- Check if the time limit with respect to the previous deal has expired
  if (!TradeTimeLevelCheck(Symb, MagicNumber, TimeLevel))
                                                  return(true);
                                  
  //---- Check for a placed order or open position
             //with the magic number equal to the MagicNumber variable value
  if (Order_Select(Symb, MagicNumber))
                                 return(true); 
                                 
  //---- Check correctness of pending orders
  if (STOPLOSS < 0)
   {
    Print("OpenSellLimitOrder1_(): Invalid Stop Loss!!!");
    return(true);
   }
  //---- 
  if (TAKEPROFIT < 0)
   {
    Print("OpenSellLimitOrder1_(): Invalid Take Profit!!!");
    return(true);
   }
  //---- 
  if (LEVEL < 0)
   {
    Print("OpenSellLimitOrder1_(): Invalid SellLimit order!!!");
    return(true);
   }
  //----
  string OpderPrice;
  bool   Order_Select;
  int    ticket, StLOSS, TkPROFIT, Level, ErrorCode;
  double Lot, OpenPrice, Stoploss, TakeProfit;                                                                                                                                                                     
  //---- 
  Level = StopCorrect(Symb, LEVEL, 0);        
  //----
  OpenPrice = NormalizeDouble(Bid  + Level * Point, Digits);
  if (OpenPrice == 0.0)
               return(false);
  //---- 
  if (STOPLOSS > 0) 
   {           
     StLOSS = StopCorrect(Symb, STOPLOSS, 0);
     if (StLOSS < 0)
          return(false);
     //----
     Stoploss = NormalizeDouble(OpenPrice + StLOSS * Point, Digits);
     if (Stoploss < 0)
           return(false);
     //---- 
   }
  else Stoploss = 0.0;
  //----   
  if (TAKEPROFIT > 0) 
   {           
     TkPROFIT = StopCorrect(Symb, TAKEPROFIT, 0);
     if (TkPROFIT < 0)
          return(false);
     //----
     TakeProfit = NormalizeDouble(OpenPrice - TkPROFIT * Point, Digits);
     if (TakeProfit < 0)
                return(false);
     //---- 
   }
  else TakeProfit = 0.0;
  
  //---+ LOT SIZE CALCULATION FOR OPENING A POSITION
  Lot = SellLotCount(Money_Management, Margin_Mode, StLOSS);
  //----
  if (Lot == -1)
            return(false);  
  else 
   if (Lot == 0)
             return(true);      
  //---- 
  Print(StringConcatenate
         ("Set a ", Symb,
                  " pending SELL LIMIT order with the magic number ", MagicNumber));
  //---+ Set a SELL LIMIT order  
  ticket = OrderSend(Symb, OP_SELLLIMIT, Lot, OpenPrice, 0, 
            Stoploss, TakeProfit, Coment, MagicNumber, Expiration, Magenta); 
  
  //---- Calculation of the time interval between trading operations         
  CountLastTime(GetLastError());
  //----
  Order_Select = OrderSelect(ticket, SELECT_BY_TICKET);
  
  //---- Calculation of the time interval between trading operations         
  ReCountLastTime(GetLastError());
  //----
  if(ticket > 0 && Order_Select)
   {
    //---- Play a sound
    PlaySound("ok.wav");
    //---- Blocking the OpenSellLimitOrder1_() function
                       // from repeated performance of the operation
    if(TimeLevel < 0)
              Order_Signal = false;
    //----
    if(TimeLevel > 0)
      GlobalVariableSet(GetTimeLevelName(Symb, MagicNumber), TimeLevel);
    //---- 
    OpderPrice = DoubleToStr(OrderOpenPrice(), Digits);
    Print(StringConcatenate("Pending SELL LIMIT " ,Symb, 
         " order with ticket #",  ticket, " and the magic number ", 
           OrderMagicNumber(), " has been set. The order triggering price is ",OpderPrice,
                          ". The calculated price was ", DoubleToStr(OpenPrice, Digits)));
   }
  else
   Print(StringConcatenate("Failed to set a pending SELL LIMIT ", Symb, 
                               " order with the magic number ", MagicNumber, "!!!"));
  //----       
  return(true);
//---+  
 }
//+X================================================================X+
//| OpenSellStopOrder1_()                                            |
//+X================================================================X+
bool OpenSellStopOrder1_
        (bool& Order_Signal, int MagicNumber, 
           datetime TimeLevel, double Money_Management, 
              int Margin_Mode, int STOPLOSS, int TAKEPROFIT, int LEVEL, 
                                          datetime Expiration, string Coment)
 {
//---+
  if (!Order_Signal)
           return(true); 
  //---- Check if the minimum time interval has passed 
                                    //between two trading operations         
  if (TimeCurrent() < LastTime)
                          return(true);
  //----
  string Symb = Symbol();

  //---- Check if the time limit with respect to the previous deal has expired
  if (!TradeTimeLevelCheck(Symb, MagicNumber, TimeLevel))
                                                  return(true);
                                  
  //---- Check for a placed order or open position
             //with the magic number equal to the MagicNumber variable value
  if (Order_Select(Symb, MagicNumber))
                                 return(true); 
                                 
  //---- Check correctness of pending orders
  if (STOPLOSS < 0)
   {
    Print("OpenSellStopOrder1_(): Invalid Stop Loss!!!");
    return(true);
   }
  //---- 
  if (TAKEPROFIT < 0)
   {
    Print("OpenSellStopOrder1_(): Invalid Take Profit!!!");
    return(true);
   }
  //---- 
  if (LEVEL < 0)
   {
    Print("OpenSellStopOrder1_(): Invalid SellStop order!!!");
    return(true);
   }
  //----
  string OpderPrice;
  bool   Order_Select; 
  int    ticket, StLOSS, TkPROFIT, Level, ErrorCode;
  double Lot, OpenPrice, Stoploss, TakeProfit;                                                                                                                      
  //---- 
  Level = StopCorrect(Symb, LEVEL, 0);        
  //----
  OpenPrice = NormalizeDouble(Bid - Level * Point, Digits);
  if (OpenPrice == 0.0)
               return(false);   
  //---- 
  if (STOPLOSS > 0) 
   {           
     StLOSS = StopCorrect(Symb, STOPLOSS, 0);
     if (StLOSS < 0)
          return(false);
     //----
     Stoploss = NormalizeDouble(OpenPrice + StLOSS * Point, Digits);
     if (Stoploss < 0)
           return(false);
     //---- 
   }
  else Stoploss = 0.0;
  //----   
  if (TAKEPROFIT > 0) 
   {           
     TkPROFIT = StopCorrect(Symb, TAKEPROFIT, 0);
     if (TkPROFIT < 0)
          return(false);
     //----
     TakeProfit = NormalizeDouble(OpenPrice - TkPROFIT * Point, Digits);
     if (TakeProfit < 0)
                return(false);
     //---- 
   }
  else TakeProfit = 0.0;
  
  //---+ LOT SIZE CALCULATION FOR OPENING A POSITION
  Lot = SellLotCount(Money_Management, Margin_Mode, StLOSS);
  //----
  if (Lot == -1)
            return(false);  
  else 
   if (Lot == 0)
             return(true);      
  //---- 
  Print(StringConcatenate
         ("Set a ", Symb,
                  " pending SELL STOP order with the magic number ", MagicNumber));
  //---+ Set a SELL STOP order 
  ticket = OrderSend(Symb, OP_SELLSTOP, Lot, OpenPrice, 0, 
            Stoploss, TakeProfit, Coment, MagicNumber, Expiration, Magenta);
             
  //---- Calculation of the time interval between trading operations         
  CountLastTime(GetLastError());
  //----
  Order_Select = OrderSelect(ticket, SELECT_BY_TICKET);
  
  //---- Calculation of the time interval between trading operations         
  ReCountLastTime(GetLastError());
  //----
  if(ticket > 0 && Order_Select)
   { 
    //---- Play a sound
    PlaySound("ok.wav");
    //---- Blocking the OpenSellStopOrder1_() function
                       // from repeated performance of the operation
    if(TimeLevel < 0)
              Order_Signal = false;
    //----
    if(TimeLevel > 0)
       GlobalVariableSet(GetTimeLevelName(Symb, MagicNumber), TimeLevel);
    //---- 
    OpderPrice = DoubleToStr(OrderOpenPrice(), Digits);
     Print(StringConcatenate("Pending SELL STOP ",Symb, 
         " order with ticket #",  ticket, " and the magic number ", 
            OrderMagicNumber(), " has been set. The order triggering price is ",OpderPrice, 
                         ". The calculated price was ", DoubleToStr(OpenPrice, Digits)));
   }
  else   
   Print(StringConcatenate("Failed to set a pending SELL STOP ", Symb, 
                               " order with the magic number ", MagicNumber, "!!!"));
  //----       
  return(true);
//---+  
 }
//+X================================================================X+
//| dOpenBuyLimitOrder1_()                                           |
//+X================================================================X+
bool dOpenBuyLimitOrder1_
       (bool& Order_Signal, int MagicNumber, datetime TimeLevel,
         double Money_Management, int Margin_Mode, double dSTOPLOSS, 
          double dTAKEPROFIT,double dLEVEL, datetime Expiration, string Coment)
 {
//---+
  if (!Order_Signal)
              return(true); 
  //---- Check if the minimum time interval has passed 
                                    //between two trading operations         
  if (TimeCurrent() < LastTime)
                          return(true);                     
  //----
  if (dLEVEL == 0.0)
            return(true);
  //----
  string Symb = Symbol();

  //---- Check if the time limit with respect to the previous deal has expired
  if (!TradeTimeLevelCheck(Symb, MagicNumber, TimeLevel))
                                                  return(true);
                                  
  //---- Check for a placed order or open position
             //with the magic number equal to the MagicNumber variable value
  if (Order_Select(Symb, MagicNumber))
                                 return(true); 
  string OpderPrice;
  bool   Order_Select;
  int    LEVEL, STOPLOSS, TAKEPROFIT;
  int    ticket, StLOSS, TkPROFIT, Level, ErrorCode;
  double Lot, OpenPrice, Stoploss, TakeProfit;
  double point = Point, digits = Digits;                                                
  //----                                                         
  LEVEL = (Ask - dLEVEL) / point;
  if (LEVEL <= 0)
   {
    Print("dOpenBuyLimitOrder1_(): Invalid order triggering level!!!");
    return(true);
   }
  //----
  Level = StopCorrect(Symb, LEVEL, 0);
  //----
  OpenPrice = NormalizeDouble(Ask - Level * point, digits);
  if (OpenPrice == 0.0)
               return(false);            
  //----
  if (dSTOPLOSS > 0)
   {
    STOPLOSS = (OpenPrice - dSTOPLOSS) / point;
    if (STOPLOSS <= 0)
     {
      Print("dOpenBuyLimitOrder1_(): Invalid Stop Loss!!!");
      return(true);
     }
    //---- 
    StLOSS = StopCorrect(Symb, STOPLOSS, 0);
    if (StLOSS < 0)
          return(false);
    //----
    Stoploss = NormalizeDouble(OpenPrice - StLOSS * point, digits);
    if (Stoploss < 0)
          return(false);
   }
  else
   {
    if (dSTOPLOSS < 0)
     {
      Print("dOpenBuyLimitOrder1_(): Invalid Stop Loss!!!");
      return(true);
     }
    //----
    Stoploss = 0.0;
   }
  //----
  if (dTAKEPROFIT > 0)
   {
    TAKEPROFIT = (dTAKEPROFIT - OpenPrice) / point;
    if (TAKEPROFIT <= 0)
     {
      Print("dOpenBuyLimitOrder1_(): Invalid Take Profit!!!");
      return(true);
     }
    //---- 
    TkPROFIT = StopCorrect(Symb, TAKEPROFIT, 0);
    if (TkPROFIT < 0)
            return(false);
    //----
    TakeProfit = NormalizeDouble(OpenPrice + TkPROFIT * point, digits);
    if (TakeProfit < 0)
            return(false);
   }
  else
   {
    if (dTAKEPROFIT < 0)
     {
      Print("dOpenBuyLimitOrder1_(): Invalid Take Profit!!!");
      return(true);
     }
    //---- 
    TakeProfit = 0.0;
   }
  //----
  
  //---+ LOT SIZE CALCULATION FOR OPENING A POSITION
  Lot = BuyLotCount(Money_Management, Margin_Mode, StLOSS);
  //----
  if (Lot == -1)
            return(false);  
  else 
   if (Lot == 0)
             return(true);
  //----        
  Print(StringConcatenate
         ("Set a ", Symb,
                  " pending BUY LIMIT order with the magic number ", MagicNumber));
              
  //---+ Set a BUY LIMIT order    
  ticket = OrderSend(Symb, OP_BUYLIMIT, Lot, OpenPrice, 0, 
            Stoploss, TakeProfit, Coment, MagicNumber, Expiration, Blue); 
  
  //---- Calculation of the time interval between trading operations         
  CountLastTime(GetLastError());
  //----
  Order_Select = OrderSelect(ticket, SELECT_BY_TICKET);
  
  //---- Calculation of the time interval between trading operations         
  ReCountLastTime(GetLastError());
  //----
  if(ticket > 0 && Order_Select)
   {
    //---- Play a sound
    PlaySound("ok.wav");
    //---- Blocking the dOpenBuyLimitOrder1_() function
                       // from repeated performance of the operation
    if(TimeLevel < 0)
              Order_Signal = false;
    //----
    if(TimeLevel > 0)
       GlobalVariableSet(GetTimeLevelName(Symb, MagicNumber), TimeLevel);
   //----
   OpderPrice = DoubleToStr(OrderOpenPrice(), digits);
    Print(StringConcatenate("Pending BUY LIMIT ",Symb, 
      " order with ticket #",  ticket, " and the magic number ", 
           OrderMagicNumber(), " has been set. The order triggering price is ",OpderPrice,
                          ". The calculated price was ", DoubleToStr(OpenPrice, digits)));
   }
  else Print(StringConcatenate("Failed to set a pending BUY LIMIT ", Symb, 
                                   " order with the magic number ", MagicNumber, "!!!"));
  //----  
  return(true);
//---+
 }
//+X================================================================X+
//| dOpenBuyStopOrder1_()                                            |
//+X================================================================X+
bool dOpenBuyStopOrder1_
       (bool& Order_Signal, int MagicNumber, datetime TimeLevel,
         double Money_Management, int Margin_Mode, double dSTOPLOSS, 
          double dTAKEPROFIT,double dLEVEL, datetime Expiration, string Coment)
 {
//---+
  if (!Order_Signal)
             return(true); 
  //---- Check if the minimum time interval has passed 
                                    //between two trading operations         
  if (TimeCurrent() < LastTime)
                          return(true);
  //----
  if (dLEVEL == 0.0)
            return(true);
  //----
  string Symb = Symbol();

  //---- Check if the time limit with respect to the previous deal has expired
  if (!TradeTimeLevelCheck(Symb, MagicNumber, TimeLevel))
                                                  return(true);
                                  
  //---- Check for a placed order or open position
             //with the magic number equal to the MagicNumber variable value
  if (Order_Select(Symb, MagicNumber))
                                 return(true); 
  string OpderPrice;
  bool   Order_Select;
  int    LEVEL, STOPLOSS, TAKEPROFIT;
  int    ticket, StLOSS, TkPROFIT, Level, ErrorCode;
  double Lot, OpenPrice, Stoploss, TakeProfit;
  double point = Point, digits = Digits;                                                 
  //----                                                         
  LEVEL = (dLEVEL - Ask) / point;
  if (LEVEL <= 0)
   {
    Print("dOpenBuyStopOrder1_(): Invalid order triggering level!!!");
    return(true);
   }
  //----                                                                                                  
  Level = StopCorrect(Symb, LEVEL, 0);
  //----
  OpenPrice = NormalizeDouble(Ask + Level * point, digits);
  if (OpenPrice == 0.0)
          return(false);
  //----
  if (dSTOPLOSS > 0)
   {
    STOPLOSS = (OpenPrice - dSTOPLOSS) / point;
    if (STOPLOSS <= 0)
     {
       Print("dOpenBuyStopOrder1_(): Invalid Stop Loss!!!");
      return(true);
     }
    //---- 
    StLOSS = StopCorrect(Symb, STOPLOSS, 0);
    if (StLOSS < 0)
          return(false);
    //----
    Stoploss = NormalizeDouble(OpenPrice - StLOSS * point, digits);
    if (Stoploss < 0)
          return(false);
   }
  else
   {
    if (dSTOPLOSS < 0)
     {
      Print("dOpenBuyStopOrder1_(): Invalid Stop Loss!!!");
      return(true);
     }
    //----
    Stoploss = 0.0;
   }
  //----
  if (dTAKEPROFIT > 0)
   {
    TAKEPROFIT = (dTAKEPROFIT - OpenPrice) / point;
    if (TAKEPROFIT <= 0)
     {
       Print("dOpenBuyStopOrder1_(): Invalid Take Profit!!!");
      return(true);
     }
    //---- 
    TkPROFIT = StopCorrect(Symb, TAKEPROFIT, 0);
    if (TkPROFIT < 0)
            return(false);
    //----
    TakeProfit = NormalizeDouble(OpenPrice + TkPROFIT * point, digits);
    if (TakeProfit < 0)
            return(false);
   }
 else
   {
    if (dTAKEPROFIT < 0)
     {
      Print("dOpenBuyStopOrder1_(): Invalid Take Profit!!!");
      return(true);
     }
    //---- 
    TakeProfit = 0.0;
   }
  
  //---+ LOT SIZE CALCULATION FOR OPENING A POSITION
  Lot = BuyLotCount(Money_Management, Margin_Mode, StLOSS);
  //----
  if (Lot == -1)
            return(false);  
  else 
   if (Lot == 0)
             return(true);       
  //----         
  Print(StringConcatenate
         ("Set a ", Symb,
                  " pending BUY STOP order with the magic number ", MagicNumber));
  //---+ Set a BUY STOP order    
  ticket = OrderSend(Symb, OP_BUYSTOP, Lot, OpenPrice, 0, 
            Stoploss, TakeProfit, Coment, MagicNumber, Expiration, Blue); 
  
  //---- Calculation of the time interval between trading operations         
  CountLastTime(GetLastError());
  //----
  Order_Select = OrderSelect(ticket, SELECT_BY_TICKET);
  
  //---- Calculation of the time interval between trading operations         
  ReCountLastTime(GetLastError());
  //----
  if(ticket > 0 && Order_Select)
   {
    //---- Play a sound
    PlaySound("ok.wav");
    //---- Blocking the dOpenBuyStopOrder1_() function
                       // from repeated performance of the operation
    if(TimeLevel < 0)
              Order_Signal = false;
    //----
    if(TimeLevel > 0)
        GlobalVariableSet(GetTimeLevelName(Symb, MagicNumber), TimeLevel);
    //----
    OpderPrice = DoubleToStr(OrderOpenPrice(), digits);
    Print(StringConcatenate("Pending BUY STOP ",Symb, 
       " order with ticket #",  ticket, " and the magic number ", 
          OrderMagicNumber(), " has been set. The order triggering price ", OpderPrice,
                          ". The calculated price was ", DoubleToStr(OpenPrice, digits)));
   }
  else 
    Print(StringConcatenate("Failed to set a pending BUY STOP ", Symb, 
                                   " order with the magic number ", MagicNumber, "!!!"));
  //----      
  return(true);
//---+
 }
//+X================================================================X+
//| dOpenSellLimitOrder1_()                                          |
//+X================================================================X+
bool dOpenSellLimitOrder1_
       (bool& Order_Signal, int MagicNumber, datetime TimeLevel,
         double Money_Management, int Margin_Mode, double dSTOPLOSS, 
          double dTAKEPROFIT,double dLEVEL, datetime Expiration, string Coment)
 {
//---+
  if (!Order_Signal)
           return(true); 
  //---- Check if the minimum time interval has passed 
                                    //between two trading operations         
  if (TimeCurrent() < LastTime)
                          return(true);
  //----
  if (dLEVEL == 0.0)
            return(true);
  //----
  string Symb = Symbol();

  //---- Check if the time limit with respect to the previous deal has expired
  if (!TradeTimeLevelCheck(Symb, MagicNumber, TimeLevel))
                                                  return(true);
                                  
  //---- Check for a placed order or open position
             //with the magic number equal to the MagicNumber variable value
  if (Order_Select(Symb, MagicNumber))
                                 return(true); 
  string OpderPrice;
  bool   Order_Select;
  int    LEVEL, STOPLOSS, TAKEPROFIT;
  int    ticket, StLOSS, TkPROFIT, Level, ErrorCode;
  double Lot, OpenPrice, Stoploss, TakeProfit;
  double point = Point, digits = Digits;                                                                                                                                                                     
  //----                                                         
  LEVEL = (dLEVEL - Bid) / point;
  if (LEVEL <= 0)
   {
    Print("dOpenSellLimitOrder1_(): Invalid order triggering level!!!");
    return(true);
   }
  //----
  Level = StopCorrect(Symb, LEVEL, 0);        
  //----
  OpenPrice = NormalizeDouble(Bid  + Level * point, digits);
  if (OpenPrice == 0.0)
               return(false);
  //----
  if (dSTOPLOSS > 0)
   {
    STOPLOSS = (dSTOPLOSS - OpenPrice) / point;
    if (STOPLOSS <= 0)
     {
      Print("dOpenSellLimitOrder1_(): Invalid Stop Loss!!!");
      return(true);
     }
    //---- 
    StLOSS = StopCorrect(Symb, STOPLOSS, 0);
    if (StLOSS < 0)
          return(false);
    //----
    Stoploss = NormalizeDouble(OpenPrice + StLOSS * point, digits);
    if (Stoploss < 0)
          return(false);
   }
  else
   {
    if (dSTOPLOSS < 0)
     {
      Print("dOpenSellLimitOrder1_(): Invalid Stop Loss!!!");
      return(true);
     }
    //----
    Stoploss = 0.0;
   }
  //----
  if (dTAKEPROFIT > 0)
   {
    TAKEPROFIT = (OpenPrice - dTAKEPROFIT) / point;
    if (TAKEPROFIT <= 0)
     {
      Print("dOpenSellLimitOrder1_(): Invalid Take Profit!!!");
      return(true);
     }
    //---- 
    TkPROFIT = StopCorrect(Symb, TAKEPROFIT, 0);
    if (TkPROFIT < 0)
            return(false);
    //----
    TakeProfit = NormalizeDouble(OpenPrice - TkPROFIT * point, digits);
    if (TakeProfit < 0)
            return(false);
   }
  else
   {
    if (dTAKEPROFIT < 0)
     {
      Print("dOpenSellLimitOrder1_(): Invalid Take Profit!!!");
      return(true);
     }
    //---- 
    TakeProfit = 0.0;
   }
  
  //---+ LOT SIZE CALCULATION FOR OPENING A POSITION
  Lot = SellLotCount(Money_Management, Margin_Mode, StLOSS);  
  //----
  if (Lot == -1)
            return(false);  
  else 
   if (Lot == 0)
             return(true);
  //---- 
  Print(StringConcatenate
         ("Set a ", Symb,
                  " pending SELL LIMIT order with the magic number ", MagicNumber));
  //---+ Set a SELL LIMIT order    
  ticket = OrderSend(Symb, OP_SELLLIMIT, Lot, OpenPrice, 0, 
            Stoploss, TakeProfit, Coment, MagicNumber, Expiration, Magenta); 
  
  //---- Calculation of the time interval between trading operations         
  CountLastTime(GetLastError());
  //----
  Order_Select = OrderSelect(ticket, SELECT_BY_TICKET);
  
  //---- Calculation of the time interval between trading operations         
  ReCountLastTime(GetLastError());
  //----
  if(ticket > 0 && Order_Select)
   {
    //---- Play a sound
    PlaySound("ok.wav");
    //---- Blocking the dOpenSellLimitOrder1_() function
                       // from repeated performance of the operation
    if(TimeLevel < 0)
              Order_Signal = false;
    //----
    if(TimeLevel > 0)
       GlobalVariableSet(GetTimeLevelName(Symb, MagicNumber), TimeLevel);
    //----
    OpderPrice = DoubleToStr(OrderOpenPrice(), digits);
     Print(StringConcatenate("Pending SELL LIMIT " ,Symb, 
       " order with ticket #",  ticket, " and the magic number ", 
           OrderMagicNumber(), " has been set. The order triggering price is ",OpderPrice,
                          ". The calculated price was ", DoubleToStr(OpenPrice, digits)));
   }
  else Print(StringConcatenate("Failed to set a pending SELL LIMIT ", Symb, 
                                   " order with the magic number ", MagicNumber, "!!!"));
  //----       
  return(true);
//---+  
 }
//+X================================================================X+
//| dOpenSellStopOrder1_()                                           |
//+X================================================================X+
bool dOpenSellStopOrder1_
       (bool& Order_Signal, int MagicNumber, datetime TimeLevel,
         double Money_Management, int Margin_Mode, double dSTOPLOSS, 
          double dTAKEPROFIT,double dLEVEL, datetime Expiration, string Coment)
 {
//---+
  if (!Order_Signal)
           return(true); 
  //---- Check if the minimum time interval has passed 
                                    //between two trading operations         
  if (TimeCurrent() < LastTime)
                          return(true);
  //----
  if (dLEVEL == 0.0)
            return(true);
  //----
  string Symb = Symbol();

  //---- Check if the time limit with respect to the previous deal has expired
  if (!TradeTimeLevelCheck(Symb, MagicNumber, TimeLevel))
                                                  return(true);
                                  
  //---- Check for a placed order or open position
             //with the magic number equal to the MagicNumber variable value
  if (Order_Select(Symb, MagicNumber))
                                 return(true); 
  string OpderPrice;
  bool   Order_Select;
  int    LEVEL, STOPLOSS, TAKEPROFIT;
  int    ticket, StLOSS, TkPROFIT, Level, ErrorCode;
  double Lot, OpenPrice, Stoploss, TakeProfit;
  double point = Point, digits = Digits;                                                                                                                        
  //----                                                         
  LEVEL = (Bid - dLEVEL) / point;
  if (LEVEL <= 0)
   {
    Print("dOpenSellStopOrder1_(): Invalid order triggering level!!!");
    return(true);
   }
  //----
  Level = StopCorrect(Symb, LEVEL, 0);        
  //----
  OpenPrice = NormalizeDouble(Bid - Level * point, digits);
  if (OpenPrice == 0.0)
               return(false);   
  //----
  if (dSTOPLOSS > 0)
   {
    STOPLOSS = (dSTOPLOSS - OpenPrice) / point;
    if (STOPLOSS <= 0)
     {
      Print("dOpenSellStopOrder1_(): Invalid Stop Loss!!!");
      return(true);
     }
    //---- 
    StLOSS = StopCorrect(Symb, STOPLOSS, 0);
    if (StLOSS < 0)
          return(false);
    //----
    Stoploss = NormalizeDouble(OpenPrice + StLOSS * point, digits);
    if (Stoploss < 0)
          return(false);
   }
  else
   {
    if (dSTOPLOSS < 0)
     {
      Print("dOpenSellStopOrder1_(): Invalid Stop Loss!!!");
      return(true);
     }
    //----
    Stoploss = 0.0;
   }
  //----
  if (dTAKEPROFIT > 0)
   {
    TAKEPROFIT = (OpenPrice - dTAKEPROFIT) / point;
    if (TAKEPROFIT <= 0)
     {
      Print("dOpenSellStopOrder1_(): Invalid Take Profit!!!");
      return(true);
     }
    //---- 
    TkPROFIT = StopCorrect(Symb, TAKEPROFIT, 0);
    if (TkPROFIT < 0)
            return(false);
    //----
    TakeProfit = NormalizeDouble(OpenPrice - TkPROFIT * point, digits);
    if (TakeProfit < 0)
            return(false);
   }
  else
   {
    if (dTAKEPROFIT < 0)
     {
      Print("dOpenSellStopOrder1_(): Invalid Take Profit!!!");
      return(true);
     }
    //---- 
    TakeProfit = 0.0;
   }
  
  //---+ LOT SIZE CALCULATION FOR OPENING A POSITION
  Lot = SellLotCount(Money_Management, Margin_Mode, StLOSS);
  //----
  if (Lot == -1)
            return(false);  
  else 
   if (Lot == 0)
             return(true);
  //---- 
  Print(StringConcatenate
         ("Set a ", Symb,
                  " pending SELL STOP order with the magic number ", MagicNumber));
  //---+ Set a SELL STOP order 
  ticket = OrderSend(Symb, OP_SELLSTOP, Lot, OpenPrice, 0, 
            Stoploss, TakeProfit, Coment, MagicNumber, Expiration, Magenta);
             
  //---- Calculation of the time interval between trading operations         
  CountLastTime(GetLastError());
  //----
  Order_Select = OrderSelect(ticket, SELECT_BY_TICKET);
  
  //---- Calculation of the time interval between trading operations         
  ReCountLastTime(GetLastError());
  //----
  if(ticket > 0 && Order_Select)
   { 
    //---- Play a sound
    PlaySound("ok.wav");
    //---- Blocking the dOpenSellLimitOrder1_() function
                       // from repeated performance of the operation
    if(TimeLevel < 0)
              Order_Signal = false;
    //----
    if(TimeLevel > 0)
       GlobalVariableSet(GetTimeLevelName(Symb, MagicNumber), TimeLevel);
    //----
    Print(StringConcatenate("Pending SELL STOP ",Symb, 
          " order with ticket #",  ticket, " and the magic number ", 
            OrderMagicNumber(), " has been set. The order triggering price is ",OpderPrice, 
                          ". The calculated price was ", DoubleToStr(OpenPrice, digits)));
   }
  else Print(StringConcatenate("Failed to set a pending SELL STOP ", Symb, 
                                   " order with the magic number ", MagicNumber, "!!!"));
  //----       
  return(true);
//---+  
 }
//+X================================================================X+
//| CloseBuyOrder1_() function                                       |
//+X================================================================X+

bool CloseBuyOrder1_(bool& CloseStop, int MagicNumber)
  {
//----+
   if (!CloseStop)
          return(true);
   //---- Check if the minimum time interval has passed 
                                    //between two trading operations  
   if (TimeCurrent() < LastTime)
                          return(true); 
   //----                
   int total = OrdersTotal(); 
   if (total == 0)
            return(true);
   //----
   double priceClose;
   bool   Close_Order;
   color  Order_Color;
   //---- 
   int    FreezeLevelT, FreezeLevelS;
   int    ticket, DIGITS, FREEZELEVEL;
   string ClosePrice, Symb, Order_Type;
   
   //---- search for an open position with the required magic number 
   if (!OrderSelect_(Symbol(), OP_BUY, MagicNumber, MODE_TRADES))
                                                          return(true);
   //---- 
   ticket = OrderTicket(); 
   Symb = OrderSymbol();
   //---- 
   DIGITS = MarketInfo(OrderSymbol(), MODE_DIGITS); 
   if (DIGITS == 0)
             return(false);
                
   //----+ Getting values to delete the order
   priceClose = MarketInfo(Symb, MODE_BID);
   if (priceClose == 0)
                return(false);
   Order_Type =" BUY";
   Order_Color = Red;
 
   //----+ Check the order for freezing 
   FREEZELEVEL = MarketInfo(OrderSymbol(), MODE_FREEZELEVEL);
   FreezeLevelT = MathAbs(priceClose - OrderTakeProfit()) / Point;
   FreezeLevelS = MathAbs(priceClose - OrderStopLoss()) / Point;
   //----
   if (FreezeLevelT <= FREEZELEVEL
        || FreezeLevelS <= FREEZELEVEL)
                               return(true);
   
   //----+  Close the open position                                 
   Print(StringConcatenate("Close ",
                 Symb, Order_Type, " order with ticket #", ticket,
                                   " and the magic number ", MagicNumber));
   //---- 
   Close_Order = OrderClose(ticket, OrderLots(), priceClose, Slippage_, Order_Color);
   //---- Calculation of the time interval between trading operations         
   CountLastTime(GetLastError());
   //----                                        
   if(Close_Order)
     {
       CloseStop = false;
       ClosePrice = DoubleToStr(OrderClosePrice(), DIGITS);  
       Print(StringConcatenate(Symb, Order_Type, " order with ticket #",
                       ticket, " and magic number ", OrderMagicNumber(), 
                                             " closed at the price ", ClosePrice));
     }
   else Print(StringConcatenate("Failed to close the ", Symb, 
          Order_Type," order with ticket #", ticket, " and the magic number ", 
                                                         MagicNumber, "!!!"));
   //----   
   return(true);
//----+
  }  
//+X================================================================X+
//| CloseSellOrder1_() function                                      |
//+X================================================================X+

bool CloseSellOrder1_(bool& CloseStop, int MagicNumber)
  {
//----+
   if (!CloseStop)
          return(true);
   //---- Check if the minimum time interval has passed 
                                    //between two trading operations  
   if (TimeCurrent() < LastTime)
                          return(true); 
   //----                
   int total = OrdersTotal(); 
   if (total == 0)
            return(true);
   //----
   double priceClose;
   bool   Close_Order;
   color  Order_Color;
   //---- 
   int    FreezeLevelT, FreezeLevelS;
   int    ticket, DIGITS, FREEZELEVEL;
   string ClosePrice, Symb, Order_Type;
   
   //---- search for an open position with the required magic number 
   if (!OrderSelect_(Symbol(), OP_SELL, MagicNumber, MODE_TRADES))
                                                          return(true);
   //---- 
   ticket = OrderTicket(); 
   Symb = OrderSymbol();
   //---- 
   DIGITS = MarketInfo(OrderSymbol(), MODE_DIGITS); 
   if (DIGITS == 0)
             return(false);
                
   //----+ Getting values to delete the order
   priceClose = MarketInfo(Symb, MODE_ASK);
   if (priceClose == 0)
                return(false);
   Order_Type =" SELL";
   Order_Color = Lime;

   //----+ Check the order for freezing 
   FREEZELEVEL = MarketInfo(OrderSymbol(), MODE_FREEZELEVEL);
   FreezeLevelT = MathAbs(priceClose - OrderTakeProfit()) / Point;
   FreezeLevelS = MathAbs(priceClose - OrderStopLoss()) / Point;
   //----
   if (FreezeLevelT <= FREEZELEVEL
         || FreezeLevelS <= FREEZELEVEL)
                               return(true);
   
   //----+  Close the open position                                 
   Print(StringConcatenate("Close ",
                 Symb, Order_Type, " order with ticket #", ticket,
                                   " and the magic number ", MagicNumber));
   //---- 
   Close_Order = OrderClose(ticket, OrderLots(), priceClose, Slippage_, Order_Color);
   
   //---- Calculation of the time interval between trading operations         
   CountLastTime(GetLastError());
   //----                                        
   if(Close_Order)
     {
       CloseStop = false;
       ClosePrice = DoubleToStr(OrderClosePrice(), DIGITS);  
       Print(StringConcatenate(Symb, Order_Type, " order with ticket #",
                       ticket, " and magic number ", OrderMagicNumber(), 
                                             " closed at the price ", ClosePrice));
     }
   else Print(StringConcatenate("Failed to close the ", Symb, 
          Order_Type," order with ticket #", ticket, " and the magic number ", 
                                                         MagicNumber, "!!!"));
   //----   
   return(true);
//----+
  } 
//+X================================================================X+
//| CloseAllBuyOrders1_() function                                   |
//+X================================================================X+

bool CloseAllBuyOrders1_(bool CloseStop)
  {
//----+
   if (!CloseStop)
          return(true);
          
   bool CloseStop_;
   //---- Check if the minimum time interval has passed 
                                    //between two trading operations  
   if (TimeCurrent() < LastTime)
                          return(true); 
   //----                
   int total = OrdersTotal(); 
            
   //---- search for a long open position
   for(int pos = total - 1; pos >= 0; pos--)                                                 
     {
      if (OrderSelect(pos, SELECT_BY_POS))
       if (OrderSymbol() == Symbol())
        if (OrderType() == OP_BUY)
         {
          CloseStop_ = true;
          if (!CloseBuyOrder1_(CloseStop_, OrderMagicNumber()))
            return(false);
         }
     }
   //----   
   return(true);
//----+
  } 
//+X================================================================X+
//| CloseAllSellOrders1_() function                                  |
//+X================================================================X+

bool CloseAllSellOrders1_(bool CloseStop)
  {
//----+
   if (!CloseStop)
          return(true);
          
   bool CloseStop_;
   //---- Check if the minimum time interval has passed 
                                    //between two trading operations  
   if (TimeCurrent() < LastTime)
                          return(true); 
   //----                
   int total = OrdersTotal(); 
            
   //---- search for a long open position
   for(int pos = total - 1; pos >= 0; pos--)                                                 
     {
      if (OrderSelect(pos, SELECT_BY_POS))
       if (OrderSymbol() == Symbol())
        if (OrderType() == OP_SELL)
         {
          CloseStop_ = true;
          if (!CloseBuyOrder1_(CloseStop_, OrderMagicNumber()))
            return(false);
         }
     }
   //----   
   return(true);
//----+
  }
//+X================================================================X+
//| CloseOrder1_() function                                          |
//+X================================================================X+

bool CloseOrder1_(bool& CloseStop, int cmd, int MagicNumber)
  {
//----+
   if (!CloseStop)
          return(true);
   //---- Check if the minimum time interval has passed 
                                    //between two trading operations  
   if (TimeCurrent() < LastTime)
                          return(true); 
   //----                
   int total = OrdersTotal(); 
   if (total == 0)
            return(true);
   //---- 
   double price;
   bool   Close_Order;
   int    FreezeLevel;
   int    ticket, FREEZELEVEL;
   string Symb, Order_Type;
   color  Order_Color = Gray;
   
   //---- search for an open position with the required magic number 
   if (!OrderSelect_(Symbol(), cmd, MagicNumber, MODE_TRADES))
                                                      return(true);
   //---- 
   ticket = OrderTicket(); 
   Symb = OrderSymbol();
   switch(cmd)
    {
     case OP_BUYLIMIT: 
      Order_Type =" BUY LIMIT";
      price = Ask; 
      break;
     //---- 
     case OP_BUYSTOP: 
      Order_Type =" BUY STOP";
      price = Ask; 
      break;
     //----
     case OP_SELLLIMIT: 
      Order_Type =" SELL LIMIT";
      price = Bid;
      break;
     //---- 
     case OP_SELLSTOP: 
      Order_Type =" SELL STOP";
      price = Bid;
      break;
     //----                                                                 
     default:  return(true);
    }
                
   Order_Type =" BUY LIMIT";

   //----+ Check the order for freezing 
   FREEZELEVEL = MarketInfo(OrderSymbol(), MODE_FREEZELEVEL);
   FreezeLevel = MathAbs(price - OrderOpenPrice()) / Point;
   //----
   if (FreezeLevel <= FREEZELEVEL)
                               return(true);
   
   //----+  Delete the pending order                                 
   Print(StringConcatenate("Close ",
                 Symb, Order_Type, " order with ticket #", ticket,
                                   " and the magic number ", MagicNumber));
   //---- 
   Close_Order = OrderDelete(ticket, Order_Color); 
   
   //---- Calculation of the time interval between trading operations         
   CountLastTime(GetLastError());
   //----                                        
   if(Close_Order)
     {
       CloseStop = false; 
       Print(StringConcatenate(Symb, Order_Type, " order with ticket #",
              ticket, " and the magic number ", OrderMagicNumber(), " has been deleted"));
     }
   else Print(StringConcatenate("Failed to close the ", Symb, 
          Order_Type," order with ticket #", ticket, " and the magic number ", 
                                                          MagicNumber, "!!!"));
   //----   
   return(true);
//----+
  }
//+X================================================================X+
//| CloseAllOrders1_() function                                      |
//+X================================================================X+

bool CloseAllOrders1_(bool CloseStop, int cmd)
  {
//----+
   if (cmd < 2)
        return(true);
          
   if (!CloseStop)
          return(true);
          
   bool CloseStop_;
   //---- Check if the minimum time interval has passed 
                                    //between two trading operations  
   if (TimeCurrent() < LastTime)
                          return(true); 
   //----                
   int total = OrdersTotal(); 
            
   //---- search for a long open position
   for(int pos = total - 1; pos >= 0; pos--)                                                 
     {
      if (OrderSelect(pos, SELECT_BY_POS))
       if (OrderSymbol() == Symbol())
        if (OrderType() == cmd)
         {
          CloseStop_ = true;
          if (!CloseOrder1_(CloseStop, cmd, OrderMagicNumber()))
            return(false);
         }
     }
   //----   
   return(true);
//----+
  }
//+X================================================================X+
//| dModifyOpenBuyOrder_() function                                  |
//+X================================================================X+
bool dModifyOpenBuyOrder_
          (bool& Modify_Signal, 
                int MagicNumber, datetime ModifyTimeLevel_, 
                         double dSTOPLOSS, double dTAKEPROFIT)
 {
  if (!Modify_Signal)
               return(true);
  //---- 
  if( dSTOPLOSS == 0 && dTAKEPROFIT == 0)
                                 return(true); 
  //---- Check if the minimum time interval has passed 
                                  //between two trading operations         
  if (TimeCurrent() < LastTime)
                          return(true);
  //----    
  if (OrdersTotal() == 0)
                 return(true);                          
  //----
  string symb = Symbol();

  //---- Check if the time limit with respect to the previous trailing stop has expired
  if (!ModifyTimeLevelCheck_(symb, MagicNumber, ModifyTimeLevel_))
                                                         return(true);    
  //---- Check for an open position 
          //with the magic number equal to the MagicNumber variable value
  if (!OrderSelect_(symb, OP_BUY, MagicNumber, MODE_TRADES))
                                                       return(true);            
  //---- 
  bool Order_Modify;          
  color Order_Color;
  double NewStopLoss, NewTakeProfit; 
  double  bid, point, price, StopLevel;
  //----
  string Order_Type, PriceName;
  string NEWSTOPLOSS, NEWTAKEPROFIT;
  int STOPLEVEL, ticket, FreezeLevelS;
  int FREEZELEVEL, FreezeLevelT, digits;
  
  //----
  symb = OrderSymbol();                
  ticket = OrderTicket(); 
  //----
  digits = MarketInfo(symb, MODE_DIGITS); 
  if (digits == 0)
            return(false);
  //----
  bid = NormalizeDouble(MarketInfo(symb, MODE_BID), digits); 
  if (bid == 0)
           return(false);
  //----
  point = MarketInfo(symb, MODE_POINT); 
  if (point == 0)
           return(false); 
  //----
  STOPLEVEL = MarketInfo(symb, MODE_STOPLEVEL);
  if (STOPLEVEL < 0)
           return(false);
  StopLevel = point * STOPLEVEL;

  //---+ Getting values for order modification
  if ((bid - dSTOPLOSS > StopLevel && dSTOPLOSS > 0) ||
                               dTAKEPROFIT - bid > StopLevel)
   {
    price = bid;
    if (dSTOPLOSS > 0)
     {
      if (bid - dSTOPLOSS > StopLevel)
           NewStopLoss = NormalizeDouble(dSTOPLOSS, digits);
      else NewStopLoss = OrderStopLoss();
     }
    else NewStopLoss = OrderStopLoss();
    //----
    if (dTAKEPROFIT > 0)
     {                    
      if (dTAKEPROFIT - bid > StopLevel)
           NewTakeProfit = NormalizeDouble(dTAKEPROFIT, digits);
      else NewTakeProfit = OrderTakeProfit();
     }
    else NewTakeProfit = OrderTakeProfit();
    //----
    Order_Type =" BUY";
    Order_Color = Lime;
    PriceName = StringConcatenate(" BID = ", 
                       DoubleToStr(bid, digits));
   }
  else return(true);
 
  //---+ Check the position for freezing 
  FREEZELEVEL = MarketInfo(OrderSymbol(), MODE_FREEZELEVEL);
  FreezeLevelT = MathAbs(price - OrderTakeProfit()) / point;
  FreezeLevelS = MathAbs(price - OrderStopLoss()) / point;
  //----
  if (FreezeLevelT <= FREEZELEVEL 
      || FreezeLevelS <= FREEZELEVEL)
							    	return(true);
										
  //---+ Modify the order 
  if(OrderCloseTime() != 0)
                    return(true);
  Print("Modify the Stop Loss and Take Profit of the open position");
  Print(StringConcatenate("Modify the Stop Loss and Take Profit. ", 
                        symb, Order_Type, " order with ticket #",ticket, 
                                      " and the magic number ", MagicNumber)); 
  //----
  Order_Modify = OrderModify(ticket, OrderOpenPrice(), 
                   NewStopLoss, NewTakeProfit, 0, Order_Color);
  //---- Calculation of the time interval between trading operations         
  CountLastTime(GetLastError());
  //----  
  if(Order_Modify)
   {
    Print(StringConcatenate(symb, Order_Type, " order with ticket #", 
    ticket, " and the magic number ", OrderMagicNumber(), " has been modified"));
    //----
    if (NewStopLoss > 0.0)
     {                               
      NEWSTOPLOSS = DoubleToStr(OrderStopLoss(), digits);  
      Print(StringConcatenate("New Stop Loss of the order ", 
                       NEWSTOPLOSS, ". The calculated Stop Loss ", 
                         DoubleToStr(NewStopLoss, digits), ".", PriceName));
     }
    //---- 
    if (NewTakeProfit > 0.0)
     {                    
      NEWTAKEPROFIT = DoubleToStr(OrderTakeProfit(), digits);  
      Print(StringConcatenate("New Take Profit of the order ", 
                      NEWTAKEPROFIT, ". The calculated Take Profit ", 
                       DoubleToStr(NewTakeProfit, digits), ".", PriceName));
     } 
 
    //---- Blocking the dModifyOpenBuyOrder_() function
                                   // from repeated performance of the operation
    if(ModifyTimeLevel_ < 0)
              Modify_Signal = false;
    //----
    if(ModifyTimeLevel_ > 0)
       GlobalVariableSet
          (GetModifyTimeLevelName_(symb, MagicNumber), ModifyTimeLevel_);
    //----
   }
  else Print("Failed to modify ", symb, Order_Type, 
          " order with ticket #",ticket, " and the magic number ", 
                                                   OrderMagicNumber());
  //----    
  return(true);   
//----
  } 
//+X================================================================X+
//| dModifyOpenSellOrder_() function                                 |
//+X================================================================X+
bool dModifyOpenSellOrder_
          (bool& Modify_Signal, 
                int MagicNumber, datetime ModifyTimeLevel_, 
                         double dSTOPLOSS, double dTAKEPROFIT)
 {
  if (!Modify_Signal)
               return(true);
  //---- 
  if( dSTOPLOSS == 0 && dTAKEPROFIT == 0)
                                 return(true); 
  //---- Check if the minimum time interval has passed 
                                  //between two trading operations         
  if (TimeCurrent() < LastTime)
                          return(true);   
  if (OrdersTotal() == 0)
                 return(true); 
  //----
  string symb = Symbol();

  //---- Check if the time limit with respect to the previous trailing stop has expired
  if (!ModifyTimeLevelCheck_(symb, MagicNumber, ModifyTimeLevel_))
                                                         return(true); 
  //---- Check for an open position 
          //with the magic number equal to the MagicNumber variable value
  if (!OrderSelect_(symb, OP_SELL, MagicNumber, MODE_TRADES))
                                                       return(true);            
  //---- 
  bool Order_Modify;          
  color Order_Color;
  double NewStopLoss, NewTakeProfit; 
  double  ask, point, price, StopLevel;
  //----
  string Order_Type, PriceName;
  string NEWSTOPLOSS, NEWTAKEPROFIT;
  int STOPLEVEL, ticket, FreezeLevelS;
  int FREEZELEVEL, FreezeLevelT, digits;
  
  //----
  symb = OrderSymbol();                  
  ticket = OrderTicket(); 
  //----
  digits = MarketInfo(symb, MODE_DIGITS); 
  if (digits == 0)
            return(false);
  //----
  ask = NormalizeDouble(MarketInfo(symb, MODE_ASK), digits); 
  if (ask == 0)
           return(false);
  //----
  point = MarketInfo(symb, MODE_POINT); 
  if (point == 0)
           return(false); 
  //----
  STOPLEVEL = MarketInfo(symb, MODE_STOPLEVEL);
  if (STOPLEVEL < 0)
           return(false);
  StopLevel = point * STOPLEVEL;

  //---+ Getting values for order modification
  if (dSTOPLOSS - ask > StopLevel ||
         (ask - dTAKEPROFIT > StopLevel && dTAKEPROFIT > 0))
   {
    price = ask;
    if (dSTOPLOSS > 0)
     {
      if (dSTOPLOSS - ask > StopLevel)
           NewStopLoss = NormalizeDouble(dSTOPLOSS, digits);
      else NewStopLoss = OrderStopLoss();
     }
    else NewStopLoss = OrderStopLoss();
    //----
    if (dTAKEPROFIT > 0)
     {                    
      if (ask - dTAKEPROFIT > StopLevel)
           NewTakeProfit = NormalizeDouble(dTAKEPROFIT, digits);
      else NewTakeProfit = OrderTakeProfit();
     }
    else NewTakeProfit = OrderTakeProfit();
    //----
    Order_Type =" Sell";
    Order_Color = Red;
    PriceName = StringConcatenate(" ASK = ", 
                       DoubleToStr(ask, digits));
   }
  else return(true);
 
  //---+ Check the position for freezing 
  FREEZELEVEL = MarketInfo(OrderSymbol(), MODE_FREEZELEVEL);
  FreezeLevelT = MathAbs(price - OrderTakeProfit()) / point;
  FreezeLevelS = MathAbs(price - OrderStopLoss()) / point;
  //----
  if (FreezeLevelT <= FREEZELEVEL 
      || FreezeLevelS <= FREEZELEVEL)
							    	return(true);
										
  //---+ Modify the order 
  if(OrderCloseTime() != 0)
                    return(true);
  Print("Modify the Stop Loss and Take Profit of the open position");
  Print(StringConcatenate("Modify the Stop Loss and Take Profit. ", 
                        symb, Order_Type, " order with ticket #",ticket, 
                                      " and the magic number ", MagicNumber)); 
  //----
  Order_Modify = OrderModify(ticket, OrderOpenPrice(), 
                   NewStopLoss, NewTakeProfit, 0, Order_Color);
                   
  //---- Calculation of the time interval between trading operations         
  CountLastTime(GetLastError());
  //----                 
  if(Order_Modify)
   {
    Print(StringConcatenate(symb, Order_Type, " order with ticket #", 
             ticket, " and the magic number ", OrderMagicNumber(), " has been modified"));
    //----
    if (NewStopLoss > 0.0)
     {                               
      NEWSTOPLOSS = DoubleToStr(OrderStopLoss(), digits);  
      Print(StringConcatenate("New Stop Loss of the order ", 
                       NEWSTOPLOSS, ". The calculated Stop Loss ", 
                         DoubleToStr(NewStopLoss, digits), ".", PriceName));
     }
    //---- 
    if (NewTakeProfit > 0.0)
     {                    
      NEWTAKEPROFIT = DoubleToStr(OrderTakeProfit(), digits);  
      Print(StringConcatenate("New Take Profit of the order ", 
                      NEWTAKEPROFIT, ". The calculated Take Profit ", 
                       DoubleToStr(NewTakeProfit, digits), ".", PriceName));
     } 
     
    //---- Blocking the dModifyOpenSellOrder_() function
                                   // from repeated performance of the operation
    if(ModifyTimeLevel_ < 0)
              Modify_Signal = false;
    //----
    if(ModifyTimeLevel_ > 0)
       GlobalVariableSet
          (GetModifyTimeLevelName_(symb, MagicNumber), ModifyTimeLevel_);
    //----
   }
  else Print("Failed to modify ", symb, Order_Type, 
          " order with ticket #",ticket, " and the magic number ", 
                                                   OrderMagicNumber());
  //----    
  return(true);   
//----
  }
//+X================================================================X+
//| dModifyOpenBuyOrderS() function                                  |
//+X================================================================X+
bool dModifyOpenBuyOrderS
          (bool& Modify_Signal, double dSTOPLOSS, double dTAKEPROFIT)
 {
  if (!Modify_Signal)
               return(true);
  //---- 
  if( dSTOPLOSS == 0 && dTAKEPROFIT == 0)
                                 return(true); 
  //---- Check if the minimum time interval has passed 
                                  //between two trading operations         
  if (TimeCurrent() < LastTime)
                          return(true); 
  //----                        
  int  FREEZELEVEL, FreezeLevelT, FreezeLevelS;     
  
  //---- Check for the selected order 
  if (OrderType() != OP_BUY)
   if (OrderSymbol() != Symbol())
                          return(true);            
  //---- 
  bool Order_Modify;          
  color Order_Color;
  double NewStopLoss, NewTakeProfit; 
  double bid, point, price, StopLevel;
  //----
  string NEWSTOPLOSS, NEWTAKEPROFIT;
  string Order_Type, PriceName, symb = OrderSymbol();
  //----
  int    STOPLEVEL, ticket, digits;       
  //----           
  ticket = OrderTicket(); 
  //----
  digits = MarketInfo(symb, MODE_DIGITS); 
  if (digits == 0)
            return(false);
  //----
  bid = NormalizeDouble(MarketInfo(symb, MODE_BID), digits); 
  if (bid == 0)
           return(false);
  //----
  point = MarketInfo(symb, MODE_POINT); 
  if (point == 0)
           return(false); 
  //----
  STOPLEVEL = MarketInfo(symb, MODE_STOPLEVEL);
  if (STOPLEVEL < 0)
           return(false);
  StopLevel = point * STOPLEVEL;

  //---+ Getting values for order modification
  if ((bid - dSTOPLOSS > StopLevel && dSTOPLOSS > 0) ||
                               dTAKEPROFIT - bid > StopLevel)
   {
    price = bid;
    if (dSTOPLOSS > 0)
     {
      if (bid - dSTOPLOSS > StopLevel)
           NewStopLoss = NormalizeDouble(dSTOPLOSS, digits);
      else NewStopLoss = OrderStopLoss();
     }
    else NewStopLoss = OrderStopLoss();
    //----
    if (dTAKEPROFIT > 0)
     {                    
      if (dTAKEPROFIT - bid > StopLevel)
           NewTakeProfit = NormalizeDouble(dTAKEPROFIT, digits);
      else NewTakeProfit = OrderTakeProfit();
     }
    else NewTakeProfit = OrderTakeProfit();
    //----
    Order_Type =" BUY";
    Order_Color = Lime;
    PriceName = StringConcatenate(" BID = ", 
                       DoubleToStr(bid, digits));
   }
  else return(true);
 
  //---+ Check the position for freezing 
  FREEZELEVEL = MarketInfo(OrderSymbol(), MODE_FREEZELEVEL);
  FreezeLevelT = MathAbs(price - OrderTakeProfit()) / point;
  FreezeLevelS = MathAbs(price - OrderStopLoss()) / point;
  //----
  if (FreezeLevelT <= FREEZELEVEL 
      || FreezeLevelS <= FREEZELEVEL)
							    	return(true);
										
  //---+ Modify the order 
  if(OrderCloseTime() != 0)
                    return(true);
  Print("Modify the Stop Loss and Take Profit of the open position");
  Print(StringConcatenate("Modify the Stop Loss and Take Profit. ", 
                        symb, Order_Type, " order with ticket #")); 
  //----
  Order_Modify = OrderModify(ticket, OrderOpenPrice(), 
                   NewStopLoss, NewTakeProfit, 0, Order_Color);
  //---- Calculation of the time interval between trading operations         
  CountLastTime(GetLastError());
  //----  
  if(Order_Modify)
   {
    Print(StringConcatenate(symb, Order_Type,
                          " order with ticket #", ticket, " has been modified"));
    //----
    if (NewStopLoss > 0.0)
     {                               
      NEWSTOPLOSS = DoubleToStr(OrderStopLoss(), digits);  
      Print(StringConcatenate("New Stop Loss of the order ", 
                       NEWSTOPLOSS, ". The calculated Stop Loss ", 
                         DoubleToStr(NewStopLoss, digits), ".", PriceName));
     }
    //---- 
    if (NewTakeProfit > 0.0)
     {                    
      NEWTAKEPROFIT = DoubleToStr(OrderTakeProfit(), digits);  
      Print(StringConcatenate("New Take Profit of the order ", 
                      NEWTAKEPROFIT, ". The calculated Take Profit ", 
                       DoubleToStr(NewTakeProfit, digits), ".", PriceName));
     } 
 
    //---- Blocking the ModifyOpenOrder_() function from repeated performance of the operation
    Modify_Signal = false;
   }
  else Print("Failed to modify ", symb, Order_Type, 
                                    " order with ticket #",ticket);
  //----    
  return(true);   
//----
  } 
//+X================================================================X+
//| dModifyOpenSellOrderS() function                                 |
//+X================================================================X+
bool dModifyOpenSellOrderS
          (bool& Modify_Signal, double dSTOPLOSS, double dTAKEPROFIT)
 {
  if (!Modify_Signal)
               return(true);
  //---- 
  if( dSTOPLOSS == 0 && dTAKEPROFIT == 0)
                                 return(true); 
  //---- Check if the minimum time interval has passed 
                                  //between two trading operations         
  if (TimeCurrent() < LastTime)
                          return(true); 
  //----                        
  int  FREEZELEVEL, FreezeLevelT, FreezeLevelS;     
  
  //---- Check for the selected order 
  if (OrderType() != OP_SELL)
   if (OrderSymbol() != Symbol())
                          return(true);            
  //---- 
  bool Order_Modify;          
  color Order_Color;
  double NewStopLoss, NewTakeProfit; 
  double ask, point, price, StopLevel;
  //----
  string NEWSTOPLOSS, NEWTAKEPROFIT;
  string Order_Type, PriceName, symb = OrderSymbol();
  //----
  int    STOPLEVEL, ticket, digits;       
  //----           
  ticket = OrderTicket(); 
  //----
  digits = MarketInfo(symb, MODE_DIGITS); 
  if (digits == 0)
            return(false);
  //----
  ask = NormalizeDouble(MarketInfo(symb, MODE_ASK), digits); 
  if (ask == 0)
           return(false);
  //----
  point = MarketInfo(symb, MODE_POINT); 
  if (point == 0)
           return(false); 
  //----
  STOPLEVEL = MarketInfo(symb, MODE_STOPLEVEL);
  if (STOPLEVEL < 0)
           return(false);
  StopLevel = point * STOPLEVEL;

  //---+ Getting values for order modification
  if (dSTOPLOSS - ask > StopLevel ||
         (ask - dTAKEPROFIT > StopLevel && dTAKEPROFIT > 0))
   {
    price = ask;
    if (dSTOPLOSS > 0)
     {
      if (dSTOPLOSS - ask > StopLevel)
           NewStopLoss = NormalizeDouble(dSTOPLOSS, digits);
      else NewStopLoss = OrderStopLoss();
     }
    else NewStopLoss = OrderStopLoss();
    //----
    if (dTAKEPROFIT > 0)
     {                    
      if (ask - dTAKEPROFIT > StopLevel)
           NewTakeProfit = NormalizeDouble(dTAKEPROFIT, digits);
      else NewTakeProfit = OrderTakeProfit();
     }
    else NewTakeProfit = OrderTakeProfit();
    //----
    Order_Type =" Sell";
    Order_Color = Red;
    PriceName = StringConcatenate(" ASK = ", 
                       DoubleToStr(ask, digits));
   }
  else return(true);
 
  //---+ Check the position for freezing 
  FREEZELEVEL = MarketInfo(OrderSymbol(), MODE_FREEZELEVEL);
  FreezeLevelT = MathAbs(price - OrderTakeProfit()) / point;
  FreezeLevelS = MathAbs(price - OrderStopLoss()) / point;
  //----
  if (FreezeLevelT <= FREEZELEVEL 
      || FreezeLevelS <= FREEZELEVEL)
							    	return(true);
										
  //---+ Modify the order 
  if(OrderCloseTime() != 0)
                    return(true);
  Print("Modify the Stop Loss and Take Profit of the open position");
  Print(StringConcatenate("Modify the Stop Loss and Take Profit. ", 
                        symb, Order_Type, " order with ticket #",ticket)); 
  //----
  Order_Modify = OrderModify(ticket, OrderOpenPrice(), 
                   NewStopLoss, NewTakeProfit, 0, Order_Color);
                   
  //---- Calculation of the time interval between trading operations         
  CountLastTime(GetLastError());
  //----                 
  if(Order_Modify)
   {
    Print(StringConcatenate(symb, Order_Type, 
                           " order with ticket #", ticket, " has been modified"));
    //----
    if (NewStopLoss > 0.0)
     {                               
      NEWSTOPLOSS = DoubleToStr(OrderStopLoss(), digits);  
      Print(StringConcatenate("New Stop Loss of the order ", 
                       NEWSTOPLOSS, ". The calculated Stop Loss ", 
                         DoubleToStr(NewStopLoss, digits), ".", PriceName));
     }
    //---- 
    if (NewTakeProfit > 0.0)
     {                    
      NEWTAKEPROFIT = DoubleToStr(OrderTakeProfit(), digits);  
      Print(StringConcatenate("New Take Profit of the order ", 
                      NEWTAKEPROFIT, ". The calculated Take Profit ", 
                       DoubleToStr(NewTakeProfit, digits), ".", PriceName));
     } 
     
    //---- Blocking the ModifyOpenOrder_() function from repeated performance of the operation
    Modify_Signal = false;
   }
  else  Print("Failed to modify ", symb, Order_Type, 
                                         " order with ticket #",ticket);
  //----    
  return(true);   
//----
  }  
//+X================================================================X+
//| Make_BuyTrailingStop_() function                                 |
//+X================================================================X+
bool Make_BuyTrailingStop_
                (bool& TrailSignal, int MagicNumber, 
                          datetime TrailTimeLevel, int TRAILINGSTOP)
 {
//----+
  if(TRAILINGSTOP <= 0 || !TrailSignal)
                                return(true);
  //---- Check if the minimum time interval has passed 
                                  //between two trading operations         
  if (TimeCurrent() < LastTime)
                          return(true);
   
  //----
  string symb = Symbol();

  //---- Check if the time limit with respect to the previous trailing stop has expired
  if (!TrailTimeLevelCheck(symb, MagicNumber, TrailTimeLevel))
                                                     return(true);
  //----    
  if (OrdersTotal() == 0)
                 return(true);
              
  //---- Check for an open position 
        //with the magic number equal to the MagicNumber variable value  
  if (!OrderSelect_(symb, OP_BUY, MagicNumber, MODE_TRADES))
                                                    return(true);            
  //---- 
  bool Order_Modify;          
  color Order_Color;
  //----
  double NewStopLoss, bid, point, TRStop, price;
  string NEWSTOPLOSS, Order_Type, PriceName;
  //----
  int FREEZELEVEL, ticket, digits;
  int FreezeLevelT, FreezeLevelS;      
  //----
  symb = OrderSymbol();           
  ticket = OrderTicket(); 
  //----
  symb = OrderSymbol();          
  ticket = OrderTicket(); 
  //----
  digits = MarketInfo(symb, MODE_DIGITS); 
  if (digits == 0)
            return(false);
  //----
  bid = NormalizeDouble(MarketInfo(symb, MODE_BID), digits); 
  if (bid == 0)
          return(false);
  //----
  point = MarketInfo(symb, MODE_POINT); 
  if (point == 0)
           return(false); 
  //----
  TRStop = StopCorrect(symb, TRAILINGSTOP, 0) * point;
  if (TRStop < 0)
           return(false);

  //---+ Getting values for order modification
  if(bid - OrderStopLoss() > TRStop)
	{
	 price = bid;
	 NewStopLoss = NormalizeDouble(bid - TRStop, digits);
	 Order_Type =" BUY";
	 Order_Color = Lime;
	 PriceName = StringConcatenate(" BID = ", 
									DoubleToStr(bid, digits));
	}
  else return(true);
  
  //---- Check if the Stop Loss value is sufficient for modification
  if (NewStopLoss <= OrderStopLoss())
                             return(true);
  		
  //---+ Check the position for freezing 
  FREEZELEVEL = MarketInfo(OrderSymbol(), MODE_FREEZELEVEL);
  FreezeLevelT = MathAbs(price - OrderTakeProfit()) / point;
  FreezeLevelS = MathAbs(price - OrderStopLoss()) / point;
  //----
  if (FreezeLevelT <= FREEZELEVEL 
      || FreezeLevelS <= FREEZELEVEL)
							    	return(true);
										
  //---+ Modify the order 
  if(OrderCloseTime() != 0)
							return(true);
  Print(StringConcatenate("Move the Stop Loss using the Trailing Stop of ", 
            									        TRAILINGSTOP, " points"));
  Print(StringConcatenate("Modify the Stop Loss. ",
						 symb, Order_Type, " order with ticket #",ticket, 
										     " and the magic number ", MagicNumber)); 
  //----
  Order_Modify = OrderModify(ticket, OrderOpenPrice(), NewStopLoss, 
       											OrderTakeProfit(), 0, Order_Color);
  //---- Calculation of the time interval between trading operations
  CountLastTime(GetLastError());
  //----                                   
  if (Order_Modify)
   {
    //---- Blocking the Make_BuyTrailingStop_() function
                                   // from repeated performance of the operation
    if(TrailTimeLevel < 0)
              TrailSignal = false;
    //----
    if(TrailTimeLevel > 0)
       GlobalVariableSet(GetTrailTimeLevelName(symb, MagicNumber), TrailTimeLevel);
    //----
    Print(StringConcatenate(symb, Order_Type, " order with ticket #", 
		ticket, " and the magic number ", OrderMagicNumber(), " has been modified"));
	 //----              
	 NEWSTOPLOSS = DoubleToStr(OrderStopLoss(), digits);  
	 Print(StringConcatenate("New Stop Loss of the order ", 
							NEWSTOPLOSS, ". The calculated Stop Loss ", 
								DoubleToStr(NewStopLoss, digits), ".", PriceName)); 
   }
  else Print("Failed to modify ", symb, Order_Type, 
						" order with ticket #",ticket, " and the magic number ", 
																		OrderMagicNumber());
  //----    
  return(true);   
//----+
  } 
//+X================================================================X+
//| Make_SellTrailingStop_() function                                |
//+X================================================================X+
bool Make_SellTrailingStop_
                (bool& TrailSignal, int MagicNumber, 
                          datetime TrailTimeLevel, int TRAILINGSTOP)
 {
//----+
  if(TRAILINGSTOP <= 0)
                     return(true); 
  //---- Check if the minimum time interval has passed 
                                  //between two trading operations         
  if (TimeCurrent() < LastTime)
                          return(true); 
  //----
  string symb = Symbol();

  //---- Check if the time limit with respect to the previous trailing stop has expired
  if (!TrailTimeLevelCheck(symb, MagicNumber, TrailTimeLevel))
                                                     return(true);
  //----    
  if (OrdersTotal() == 0)
                 return(true);
              
  //---- Check for an open position 
        //with the magic number equal to the MagicNumber variable value  
  if (!OrderSelect_(symb, OP_SELL, MagicNumber, MODE_TRADES))
                                                         return(true);            
  //---- 
  bool Order_Modify;          
  color Order_Color;
  //----
  double NewStopLoss, ask, point, TRStop, price;
  string NEWSTOPLOSS, Order_Type, PriceName;
  //----
  int FREEZELEVEL, ticket, digits;
  int FreezeLevelT, FreezeLevelS;      
  //----
  symb = OrderSymbol();           
  ticket = OrderTicket(); 
  //----
  digits = MarketInfo(symb, MODE_DIGITS); 
  if (digits == 0)
            return(false);
  //----
  ask = NormalizeDouble(MarketInfo(symb, MODE_ASK), digits); 
  if (ask == 0)
          return(false);
  //----
  point = MarketInfo(symb, MODE_POINT); 
  if (point == 0)
           return(false); 
  //----
  TRStop = StopCorrect(symb, TRAILINGSTOP, 0) * point;
  if (TRStop < 0)
           return(false);

  //---+ Getting values for order modification
  if(OrderStopLoss() - ask > TRStop)
	{
	 price = ask;
	 NewStopLoss = NormalizeDouble(ask + TRStop, digits);
	 Order_Type =" SELL";
	 Order_Color = Red;
	 PriceName = StringConcatenate(" ASK = ", 
									DoubleToStr(ask, digits));
	}
  else return(true);
  
  //---- Check if the Stop Loss value is sufficient for modification
  if (NewStopLoss >= OrderStopLoss())
                             return(true);
  	
  //---+ Check the position for freezing 
  FREEZELEVEL = MarketInfo(OrderSymbol(), MODE_FREEZELEVEL);
  FreezeLevelT = MathAbs(price - OrderTakeProfit()) / point;
  FreezeLevelS = MathAbs(price - OrderStopLoss()) / point;
  //----
  if (FreezeLevelT <= FREEZELEVEL 
      || FreezeLevelS <= FREEZELEVEL)
							    	return(true);
										
  //---+ Modify the order 
  if(OrderCloseTime() != 0)
							return(true);
  Print(StringConcatenate("Move the Stop Loss using the Trailing Stop of ", 
            											TRAILINGSTOP, " points"));
  Print(StringConcatenate("Modify the Stop Loss. ",
						symb, Order_Type, " order with ticket #",ticket, 
											" and the magic number ", MagicNumber)); 
  //----
  Order_Modify = OrderModify(ticket, OrderOpenPrice(), NewStopLoss, 
       											OrderTakeProfit(), 0, Order_Color);
  //---- Calculation of the time interval between trading operations
  CountLastTime(GetLastError());
  //----                                   
  if(Order_Modify)
   {
    //---- Blocking the Make_SellTrailingStop_() function 
                                   // from repeated performance of the operation
    if(TrailTimeLevel < 0)
              TrailSignal = false;
    //----
    if(TrailTimeLevel > 0)
       GlobalVariableSet(GetTrailTimeLevelName(symb, MagicNumber), TrailTimeLevel);
    //----
    Print(StringConcatenate(symb, Order_Type, " order with ticket #", 
		ticket, " and the magic number ", OrderMagicNumber(), " has been modified"));
	 //----              
    NEWSTOPLOSS = DoubleToStr(OrderStopLoss(), digits);  
	 Print(StringConcatenate("New Stop Loss of the order ", 
							NEWSTOPLOSS, ". The calculated Stop Loss ", 
								DoubleToStr(NewStopLoss, digits), ".", PriceName)); 
   }
  else Print("Failed to modify ", symb, Order_Type, 
						" order with ticket #",ticket, " and the magic number ", 
																		OrderMagicNumber());
  //----    
  return(true);   
//----+
  }
//+X================================================================X+
//| dMake_BuyTrailingStop_() function                                |
//+X================================================================X+
bool dMake_BuyTrailingStop_
            (bool& TrailSignal, int MagicNumber, 
                 datetime TrailTimeLevel_, double dTRAILINGSTOP)
 {
//----+
  if(dTRAILINGSTOP <= 0 || !TrailSignal)
                                return(true);
  //---- Check if the minimum time interval has passed 
                                  //between two trading operations         
  if (TimeCurrent() < LastTime)
                          return(true); 
  //----
  string symb = Symbol();
  //----    
  if (OrdersTotal() == 0)
              return(true);  
              
  //---- Check if the time limit with respect to the previous trailing stop has expired
  if (!TrailTimeLevelCheck_(symb, MagicNumber, TrailTimeLevel_))
                                                     return(true);    
              
  //---- Check for a long open position 
        //with the magic number equal to the MagicNumber variable value          
  if (!OrderSelect_(symb, OP_BUY, MagicNumber, MODE_TRADES))
                                                      return(true);        
  //---- 
  bool Order_Modify;         
  color Order_Color;
  //----
  int ticket, digits, TRAILINGSTOP;
  int FREEZELEVEL, FreezeLevelT, FreezeLevelS; 
  //---- 
  double NewStopLoss, bid, point, TRStop, price;
  string NEWSTOPLOSS, Order_Type, PriceName;      
  //----
  symb = OrderSymbol();           
  ticket = OrderTicket(); 
  //----
  digits = MarketInfo(symb, MODE_DIGITS); 
  if (digits == 0)
            return(false);
  //----
  bid = NormalizeDouble(MarketInfo(symb, MODE_BID), digits); 
  if (bid == 0)
          return(false);
  //----
  point = MarketInfo(symb, MODE_POINT); 
  if (point == 0)
           return(false); 
  //----         
  TRAILINGSTOP = (bid - dTRAILINGSTOP) / point;  
  if (TRAILINGSTOP <= 0)
   {
    Print("dMake_BuyTrailingStop_(): Invalid Trailing Stop!!!");
    return(true);
   }     
  //----
  TRStop = StopCorrect(symb, TRAILINGSTOP, 0) * point;
  if (TRStop < 0)
           return(false);                                       

  //---+ Getting values for order modification
  if(bid - OrderStopLoss() > TRStop)
	{
	 price = bid;
	 NewStopLoss = NormalizeDouble(bid - TRStop, digits);
	 Order_Type =" BUY";
	 Order_Color = Lime;
	 PriceName = StringConcatenate(" BID = ", 
									DoubleToStr(bid, digits));
	}
  else return(true);
  
  //---- Check if the Stop Loss value is sufficient for modification
  if (NewStopLoss <= OrderStopLoss())
                             return(true);
  		
  //---+ Check the position for freezing 
  FREEZELEVEL = MarketInfo(OrderSymbol(), MODE_FREEZELEVEL);
  FreezeLevelT = MathAbs(price - OrderTakeProfit()) / point;
  FreezeLevelS = MathAbs(price - OrderStopLoss()) / point;
  //----
  if (FreezeLevelT <= FREEZELEVEL 
      || FreezeLevelS <= FREEZELEVEL)
							    	return(true);
										
  //---+ Modify the order 
  if(OrderCloseTime() != 0)
							return(true);
  Print(StringConcatenate("Move the Stop Loss using the Trailing Stop of ", 
            											TRAILINGSTOP, " points"));
  Print(StringConcatenate("Modify the Stop Loss. ",
                symb, Order_Type, " order with ticket #",ticket, 
											" and the magic number ", MagicNumber)); 
  //----
  Order_Modify = OrderModify(ticket, OrderOpenPrice(), NewStopLoss, 
       											OrderTakeProfit(), 0, Order_Color);
  //---- Calculation of the time interval between trading operations
  CountLastTime(GetLastError());
  //----                                   
  if(Order_Modify)
   {
    //---- Blocking the dMake_BuyTrailingStop_() function 
                                   // from repeated performance of the operation
    if(TrailTimeLevel_ < 0)
              TrailSignal = false;
    //----
    if(TrailTimeLevel_ > 0)
       GlobalVariableSet(GetTrailTimeLevelName_(symb, MagicNumber), TrailTimeLevel_);
    //----
    Print(StringConcatenate(symb, Order_Type, " order with ticket #", 
		ticket, " and the magic number ", OrderMagicNumber(), " has been modified"));
	//----              
	NEWSTOPLOSS = DoubleToStr(OrderStopLoss(), digits);  
	Print(StringConcatenate("New Stop Loss of the order ", 
							NEWSTOPLOSS, ". The calculated Stop Loss ", 
								DoubleToStr(NewStopLoss, digits), ".", PriceName)); 
   }
  else Print("Failed to modify ", symb, Order_Type, 
						" order with ticket #",ticket, " and the magic number ", 
																		OrderMagicNumber());
  //----    
  return(true);   
//----+
  } 
//+X================================================================X+
//| dMake_SellTrailingStop_() function                               |
//+X================================================================X+
bool dMake_SellTrailingStop_
            (bool& TrailSignal, int MagicNumber, 
                 datetime TrailTimeLevel_, double dTRAILINGSTOP)
 {
//----+
  if(dTRAILINGSTOP <= 0 || !TrailSignal)
                                return(true); 
  //---- Check if the minimum time interval has passed 
                                  //between two trading operations         
  if (TimeCurrent() < LastTime)
                          return(true); 
  //----
  string symb = Symbol();
  //----  
  if (OrdersTotal() == 0)
              return(true);
              
  //---- Check if the time limit with respect to the previous trailing stop has expired
  if (!TrailTimeLevelCheck_(symb, MagicNumber, TrailTimeLevel_))
                                                     return(true);
                                                     
  //---- Check for a short open position 
        //with the magic number equal to the MagicNumber variable value  
  if (!OrderSelect_(symb, OP_SELL, MagicNumber, MODE_TRADES))
                                                      return(true);            
  //---- 
  bool Order_Modify;          
  color Order_Color;
  //----
  int ticket, digits, TRAILINGSTOP;
  int FREEZELEVEL, FreezeLevelT, FreezeLevelS; 
  //---- 
  double NewStopLoss, ask, point, TRStop, price;
  string NEWSTOPLOSS, Order_Type, PriceName;      
  //----
  symb = OrderSymbol();          
  ticket = OrderTicket();
  //----
  digits = MarketInfo(symb, MODE_DIGITS); 
  if (digits == 0)
            return(false);
  //----
  ask = NormalizeDouble(MarketInfo(symb, MODE_ASK), digits); 
  if (ask == 0)
          return(false);
  //----
  point = MarketInfo(symb, MODE_POINT); 
  if (point == 0)
           return(false); 
  //----         
  TRAILINGSTOP = (dTRAILINGSTOP - ask) / point;  
  if (TRAILINGSTOP <= 0)
   {
    Print("dMake_SellTrailingStop_(): Invalid Trailing Stop!!!");
    return(true);
   }     
  //----
  TRStop = StopCorrect(symb, TRAILINGSTOP, 0) * point;
  if (TRStop < 0)
           return(false);

  //---+ Getting values for order modification
  if(OrderStopLoss() - ask > TRStop)
	{
	 price = ask;
	 NewStopLoss = NormalizeDouble(ask + TRStop, digits);
	 Order_Type =" SELL";
	 Order_Color = Red;
	 PriceName = StringConcatenate(" ASK = ", 
									DoubleToStr(ask, digits));
	}
  else return(true);
  
  //---- Check if the Stop Loss value is sufficient for modification
  if (NewStopLoss >= OrderStopLoss())
                             return(true);
  	
  //---+ Check the position for freezing 
  FREEZELEVEL = MarketInfo(OrderSymbol(), MODE_FREEZELEVEL);
  FreezeLevelT = MathAbs(price - OrderTakeProfit()) / point;
  FreezeLevelS = MathAbs(price - OrderStopLoss()) / point;
  //----
  if (FreezeLevelT <= FREEZELEVEL 
      || FreezeLevelS <= FREEZELEVEL)
							    	return(true);
										
  //---+ Modify the order 
  if(OrderCloseTime() != 0)
							return(true);
  Print(StringConcatenate("Move the Stop Loss using the Trailing Stop of ", 
            											TRAILINGSTOP, " points"));
  Print(StringConcatenate("Modify the Stop Loss. ",
						symb, Order_Type, " order with ticket #",ticket, 
											" and the magic number ", MagicNumber)); 
  //----
  Order_Modify = OrderModify(ticket, OrderOpenPrice(), NewStopLoss, 
       											OrderTakeProfit(), 0, Order_Color);
  //---- Calculation of the time interval between trading operations
  CountLastTime(GetLastError());
  //----                                   
  if(Order_Modify)
   {
    //---- Blocking the dMake_SellTrailingStop_() function 
                                   // from repeated performance of the operation
    if(TrailTimeLevel_ < 0)
              TrailSignal = false;
    //----
    if(TrailTimeLevel_ > 0)
       GlobalVariableSet(GetTrailTimeLevelName_(symb, MagicNumber), TrailTimeLevel_);
    //----
    Print(StringConcatenate(symb, Order_Type, " order with ticket #", 
		ticket, " and the magic number ", OrderMagicNumber(), " has been modified"));
	//----              
	NEWSTOPLOSS = DoubleToStr(OrderStopLoss(), digits);  
	Print(StringConcatenate("New Stop Loss of the order ", 
							NEWSTOPLOSS, ". The calculated Stop Loss ", 
								DoubleToStr(NewStopLoss, digits), ".", PriceName)); 
   }
  else Print("Failed to modify ", symb, Order_Type, 
						" order with ticket #",ticket, " and the magic number ", 
																		OrderMagicNumber());
  //----    
  return(true);   
//----+
  }
//+X================================================================X+
//| BuyStoplossCorrect() function                                    |
//+X================================================================X+
bool BuyStoplossCorrect
           (int MagicNumber, int ExtPointProfit, int StoplossProfit)
  {
//---+
   if (!OrderSelect_
         (Symbol(), OP_BUY, MagicNumber, MODE_TRADES))
                                            return(true);
   //----                                                     
   bool Signal = true;
   double NewStopLoss;
   int PointProfit, LossProfit, NEWSTOPLOSS;
   //----
   if (OrderProfit() <= 0.0)
                       return(true);
   //----
   LossProfit = (OrderStopLoss() - OrderOpenPrice()) / Point;
   //---- 
   if (LossProfit < StoplossProfit)
    {                   
     PointProfit = (Bid - OrderOpenPrice()) / Point;
     if (PointProfit >= ExtPointProfit)
      {
       NewStopLoss = OrderOpenPrice() + StoplossProfit * Point;
       NEWSTOPLOSS = (Bid - NewStopLoss) / Point;
       //----
       if (NEWSTOPLOSS <= 0)
                    NEWSTOPLOSS = 1;
       //----
       NEWSTOPLOSS = StopCorrect(Symbol(), NEWSTOPLOSS, 0);
       NewStopLoss = Bid - NEWSTOPLOSS * Point;
       //----
       if (!dModifyOpenBuyOrder_
            (Signal, MagicNumber, 0, NewStopLoss, 0.0))
                                            return(false);
      }
    }
   //----   
   return(true);
//---+
  } 
//+X================================================================X+
//| SellStoplossCorrect() function                                   |
//+X================================================================X+
bool SellStoplossCorrect
           (int MagicNumber, int ExtPointProfit, int StoplossProfit)
  {
//---+
   //----
   if (!OrderSelect_
         (Symbol(), OP_SELL, MagicNumber, MODE_TRADES))
                                             return(true);
   bool Signal = true;
   double NewStopLoss;
   int PointProfit, LossProfit, NEWSTOPLOSS;
   //----                                                     
   if (OrderProfit() <= 0.0)
                       return(true);
   //----
   LossProfit = (OrderOpenPrice() - OrderStopLoss()) / Point;
   //---- 
   if (LossProfit < StoplossProfit)
    {                   
     PointProfit = (OrderOpenPrice() - Ask) / Point;
     if (PointProfit >= ExtPointProfit)
      {
       NewStopLoss = OrderOpenPrice() - StoplossProfit * Point;
       NEWSTOPLOSS = (NewStopLoss - Ask) / Point;
       //----
       if (NEWSTOPLOSS <= 0)
                    NEWSTOPLOSS = 1;
       //----
       NEWSTOPLOSS = StopCorrect(Symbol(), NEWSTOPLOSS, 0);
       NewStopLoss = NEWSTOPLOSS * Point - Ask;
       //----
       if (!dModifyOpenSellOrder_
            (Signal, MagicNumber, 0, NewStopLoss, 0.0))
                                              return(false);
      }
    }
   //---   
   return(true);
//---+
  } 
//+X================================================================X+
//| AllBuyStoplossCorrects() function                                |
//+X================================================================X+
bool AllBuyStoplossCorrects(int ExtPointProfit, int StoplossProfit)
  {
//---+
   bool Signal;
   double NewStopLoss;
   int PointProfit, LossProfit, NEWSTOPLOSS;                    
   int total = OrdersTotal();
   //---+  
   for(int pos = total - 1; pos >= 0; pos--)     
    if (OrderSelect(pos, SELECT_BY_POS, MODE_TRADES))
     if (OrderSymbol() == Symbol())
      if (OrderType() == OP_BUY)
       {
        //----                                                     
        if (OrderProfit() <= 0.0)
                           continue;
        //----
        LossProfit = (OrderStopLoss() - OrderOpenPrice()) / Point;
        //---- 
        if (LossProfit < StoplossProfit)
         {                   
          PointProfit = (Bid - OrderOpenPrice()) / Point;
          if (PointProfit >= ExtPointProfit)
           {
            NewStopLoss = OrderOpenPrice() + StoplossProfit * Point;
            NEWSTOPLOSS = (Bid - NewStopLoss) / Point;
            //----
            if (NEWSTOPLOSS <= 0)
                    NEWSTOPLOSS = 1;
            //----
            NEWSTOPLOSS = StopCorrect(Symbol(), NEWSTOPLOSS, 0);
            NewStopLoss = Bid - NEWSTOPLOSS * Point;
            //----
            Signal = true;
            if (!dModifyOpenBuyOrderS(Signal, NewStopLoss, 0.0))
              return(false);
           }
         }
        }
   //---+  
   return(true);
//---+
  }
//+X================================================================X+
//| AllSellStoplossCorrects() function                               |
//+X================================================================X+
bool AllSellStoplossCorrects(int ExtPointProfit, int StoplossProfit)
  {
//---+
   bool Signal;
   double NewStopLoss;
   int PointProfit, LossProfit, NEWSTOPLOSS;                    
   int total = OrdersTotal();
   //---+  
   for(int pos = total - 1; pos >= 0; pos--)     
    if (OrderSelect(pos, SELECT_BY_POS, MODE_TRADES))
     if (OrderSymbol() == Symbol())
      if (OrderType() == OP_SELL)
       {
        //----                                                     
        if (OrderProfit() <= 0.0)
                           continue;
        //----
        LossProfit = (OrderOpenPrice() - OrderStopLoss()) / Point;
        //---- 
        if (LossProfit < StoplossProfit)
         {                   
          PointProfit = (OrderOpenPrice() - Ask) / Point;
          if (PointProfit >= ExtPointProfit)
           {
            NewStopLoss = OrderOpenPrice() - StoplossProfit * Point;
            NEWSTOPLOSS = (NewStopLoss - Ask) / Point;
            //----
            if (NEWSTOPLOSS <= 0)
                    NEWSTOPLOSS = 1;
            //----
            NEWSTOPLOSS = StopCorrect(Symbol(), NEWSTOPLOSS, 0);
            NewStopLoss = NEWSTOPLOSS * Point - Ask;
            //----
            Signal = true;
            if (!dModifyOpenSellOrderS(Signal, NewStopLoss, 0.0))
              return(false);
           }
         }
        }
   //---+  
   return(true);
//---+
  } 
//+X================================================================X+
//| TimeLevelGlobalVariableDel() functions                           |
//+X================================================================X+
void TimeLevelGlobalVariableDel(string symbol, int MagicNumber)
  {
//---+
   if (IsTesting() || IsOptimization())
    {
     GlobalVariableDel(GetTimeLevelName       (symbol, MagicNumber));
     GlobalVariableDel(GetTrailTimeLevelName  (symbol, MagicNumber));
     GlobalVariableDel(GetTrailTimeLevelName_ (symbol, MagicNumber));
     GlobalVariableDel(GetModifyTimeLevelName_(symbol, MagicNumber)); 
     GlobalVariableDel(GetModifyTimeLevelName_(symbol, MagicNumber));                           
    }
//---+ 
  }
//+X================================================================X+
//| TimeframeCheck() functions                                       |
//+X================================================================X+
void TimeframeCheck(string TimeframeName, int Timeframe)
  {
//---+
   //---- Check correctness of the Timeframe variable value
   if (Timeframe != 1)
    if (Timeframe != 5)
     if (Timeframe != 15)
      if (Timeframe != 30)
       if (Timeframe != 60)
        if (Timeframe != 240)
         if (Timeframe != 1440)
           Print(StringConcatenate("TimeframeCheck: The parameter ",
            TimeframeName, " cannot ", "be equal to ", Timeframe, "!!!"));    
//---+ 
  }

//+X================================================================X+
//| dGhartVelueCorrect() functions                                   |
//+X================================================================X+
double dGhartVelueCorrect(int cmd, double& GhartVelue)
  {
//---+
   switch(cmd)
    {
     case OP_BUY: GhartVelue += Ask - Close[0]; break;
     case OP_BUYLIMIT: GhartVelue += Ask - Close[0]; break;
     case OP_BUYSTOP: GhartVelue += Ask - Close[0]; break;
     //----
     case OP_SELL: GhartVelue -= Close[0] - Bid; break;
     case OP_SELLLIMIT: GhartVelue -= Close[0] - Bid; break;
     case OP_SELLSTOP: GhartVelue -= Close[0] - Bid; break;
     //----                                                                 
     default:  GhartVelue += 0.0;
    }
   return(GhartVelue); 
//---+ 
  }
//+X================================================================X+
//| LevelCorrect() functions                                         |
//+X================================================================X+
int LevelCorrect(int& Level, int MinPointLevel)
  {
//---+
   if (Level <= 0.0)
    {
     Print("LevelCorrect(): Invalid value of the external variable Level");
     return(Level);
    }
   //----
   if (MinPointLevel <= 0)
    {
     Print("LevelCorrect(): Invalid value of the external variable MinPointLevel");
     return(Level);
    }
   //----
   if (Level < MinPointLevel)
         Level = MinPointLevel;
   //----
   return(Level); 
//---+ 
  }
//+X================================================================X+
//| LevelCorrect() functions                                         |
//+X================================================================X+
double LevelCorrect_(double& Level, double MinPointLevel)
  {
//---+
   if (Level <= 0.0)
    {
     Print("LevelCorrect_(): Invalid value of the external variable Level");
     return(Level);
    }
   //----
   if (MinPointLevel <= 0)
    {
     Print("LevelCorrect_(): Invalid value of the external variable MinPointLevel");
     return(Level);
    }
   //----
   if (Level < MinPointLevel)
         Level = MinPointLevel;
   //----
   return(Level); 
//---+ 
  }  
//+X================================================================X+
//| dLevelCorrect() functions                                        |
//+X================================================================X+
double dLevelCorrect
            (double Price, double& GhartLevel, int MinPointLevel)
  {
//---+
   if (Price <= 0.0)
    {
     Print("dLevelCorrect(): Invalid value of the external variable Price");
     return(GhartLevel);
    }
   //----
   if (GhartLevel <= 0.0)
    {
     Print("dLevelCorrect(): Invalid value of the external variable GhartLevel");
     return(GhartLevel);
    }
   //----
   if (MinPointLevel <= 0)
    {
     Print("dLevelCorrect(): Invalid value of the external variable MinPointLevel");
     return(GhartLevel);
    }
   //----
   int PointLevel = (Price - GhartLevel) / Point;
   int AbsPointLevel = MathAbs(PointLevel);
   //----
   if (AbsPointLevel < MinPointLevel)
    {
     AbsPointLevel = MinPointLevel;
     //----
     if (PointLevel > 0)
          GhartLevel = Price + AbsPointLevel * Point;
     else GhartLevel = Price - AbsPointLevel * Point; 
    }
   
   return(GhartLevel); 
//---+ 
  } 
//+X================================================================X+
//| OrderSelect_() functions                                         |
//+X================================================================X+
bool OrderSelect_(string symbol, int cmd, int MagicNumber, int pool)
  {
//---+
   //----                       
   int total;
   //----
   if (pool == MODE_TRADES)
         total = OrdersTotal();
   else 
    if (pool == MODE_HISTORY)           
         total = OrdersHistoryTotal();
  
   //---- Check for an open position 
          //with the magic number equal to the MagicNumber variable value
   for(int pos = total - 1; pos >= 0; pos--)     
      if (OrderSelect(pos, SELECT_BY_POS, pool))
       if (OrderType() == cmd)
        if (OrderSymbol() == symbol)
         if (OrderMagicNumber() == MagicNumber)
                                          return(true); 
   return(false); 
//---+ 
  }
//+X================================================================X+
//| Order_Select() functions                                         |
//+X================================================================X+
bool Order_Select(string symbol, int MagicNumber)
  {
//---+
   //----                       
   int total = OrdersTotal();
  
   //---- Check for an open position or order 
          //with the magic number equal to the MagicNumber variable value
   for(int pos = total - 1; pos >= 0; pos--)     
      if (OrderSelect(pos, SELECT_BY_POS, MODE_TRADES))
        if (OrderSymbol() == symbol)
         if (OrderMagicNumber() == MagicNumber)
                                          return(true); 
   return(false); 
//---+ 
  }
//+X================================================================X+
//| MarginCheck() function                                           |
//+X================================================================X+ 
bool MarginCheck(string symbol, int Cmd, double& Lot) 
 {
//---+
   int  Margin_Check;
   //---
   double MINLOT = MarketInfo(symbol, MODE_MINLOT);
   if (MINLOT == 0)
              return(false);
   //---          
   if (Lot < MINLOT)
    {
     Lot = 0.0;
     return(true);
    }
   //---           
   double LOTSTEP = MarketInfo(symbol, MODE_LOTSTEP);
   if (LOTSTEP == 0)
              return(false);
   //---           
   Lot = LOTSTEP * MathFloor(Lot / LOTSTEP); 
   //---
   while(Lot >= MINLOT && Margin_Check <= 0)
     {
       Margin_Check =
         AccountFreeMarginCheck(symbol, Cmd, Lot);
       //---              
       if (Margin_Check < 0)
                     Lot -= LOTSTEP; 
       //---              
       if (Lot < MINLOT)
        {
         Lot = 0.0;
         return(true);
        }
     }
            
  return(true);
//---+
 }
//+X================================================================X+
//| CountLastTime() function                                         |
//+X================================================================X+
void CountLastTime(int Error)
  {
//---+
   int TimeCurr = TimeCurrent();
   //---
   switch(Error)
       {
        case 000: LastTime = TimeCurr + 000; break;
        case 001: LastTime = TimeCurr + 060; break;
        case 002: LastTime = TimeCurr + 300; break;
        case 003: LastTime = TimeCurr + 300; break;                                                                  
        case 004: LastTime = TimeCurr + 180; break; 
        case 005: LastTime = TimeCurr + 000; break;
        case 006: LastTime = TimeCurr + 006; break;
        case 008: LastTime = TimeCurr + 011; break;
        case 064: LastTime = TimeCurr + 300; break;
        case 065: LastTime = TimeCurr + 180; break;                                                     
        case 128: LastTime = TimeCurr + 065; break; 
        case 129: LastTime = TimeCurr + 008; break; 
        case 130: LastTime = TimeCurr + 008; break;  
        case 131: LastTime = TimeCurr + 300; break;
        case 132: LastTime = TimeCurr + 180; break;
        case 133: LastTime = TimeCurr + 300; break;
        case 134: LastTime = TimeCurr + 008; break; 
        case 135: LastTime = TimeCurr + 000; break;
        case 136: LastTime = TimeCurr + 008; break; 
        case 138: LastTime = TimeCurr + 000; break;
        case 139: LastTime = TimeCurr + 011; break;
        case 140: LastTime = TimeCurr + 011; break; 
        case 141: LastTime = TimeCurr + 011; break;
        case 142: LastTime = TimeCurr + 065; break; 
        case 143: LastTime = TimeCurr + 065; break; 
        case 144: LastTime = TimeCurr + 011; break; 
        case 145: LastTime = TimeCurr + 017; break;  
        case 146: LastTime = TimeCurr + 300; break;
        case 147: LastTime = TimeCurr + 011; break;
        case 148: LastTime = TimeCurr + 300; break;
        default:  LastTime = TimeCurr + 000; break;
       }
//---+
  }
//+X================================================================X+
//| ReCountLastTime() function                                       |
//+X================================================================X+
void ReCountLastTime(int Error)
  {
//---+
   //---
   switch(Error)
       {
        case 000: LastTime += 000; break;
        case 001: LastTime += 060; break;
        case 002: LastTime += 300; break;
        case 003: LastTime += 300; break;                                                                  
        case 004: LastTime += 180; break; 
        case 005: LastTime += 000; break;
        case 006: LastTime += 006; break;
        case 008: LastTime += 011; break;
        case 064: LastTime += 300; break;
        case 065: LastTime += 180; break;                                                     
        case 128: LastTime += 065; break; 
        case 129: LastTime += 007; break; 
        case 130: LastTime += 007; break;  
        case 131: LastTime += 300; break;
        case 132: LastTime += 180; break;
        case 133: LastTime += 300; break;
        case 134: LastTime += 007; break; 
        case 135: LastTime += 000; break;
        case 136: LastTime += 007; break; 
        case 138: LastTime += 000; break;
        case 139: LastTime += 011; break;
        case 140: LastTime += 011; break; 
        case 141: LastTime += 011; break;
        case 142: LastTime += 065; break; 
        case 143: LastTime += 065; break; 
        case 144: LastTime += 011; break; 
        case 145: LastTime += 017; break;  
        case 146: LastTime += 300; break;
        case 147: LastTime += 011; break;
        case 148: LastTime += 300; break;
        default:  LastTime += 000; break;
       }
//---+
  }
//+X================================================================X+
//| GetFreeMargin() function                                         |
//+X================================================================X+
double GetFreeMargin()
  {
//---+
   switch(AccountFreeMarginMode())
    {     
     case 0: return(AccountFreeMargin() + AccountProfit());
     case 1: return(AccountFreeMargin());
     case 2: if (AccountProfit() > 0) 
                  return(AccountFreeMargin());
             else return(AccountFreeMargin() - AccountProfit());
     case 3: if (AccountProfit() < 0) 
                  return(AccountFreeMargin());
             else return(AccountFreeMargin() - AccountProfit());
    }
//---+
  } 
//+X================================================================X+
//| StopCorrect() function                                           |
//+X================================================================X+
int StopCorrect(string symbol, int Stop, int slippage_)
  {
//---+
   int CorrStop, Extrem_Stop;
   //---
   Extrem_Stop = MarketInfo(symbol, MODE_STOPLEVEL) + slippage_;
   //---             
   if(Stop < Extrem_Stop)
        CorrStop = Extrem_Stop;
   else CorrStop = Stop;
   //---   
   return(CorrStop);
//---+
  }
//+X================================================================X+
//| GetTimeLevelName() function                                      |
//+X================================================================X+
string GetTimeLevelName(string symbol, int MagicNumber)
  {
//---+
   string G_Name_;
   static string G_Name_0;
   static bool SecondStart;
   //---- Initialization to zero
   if (!SecondStart)
    {
     G_Name_0 = StringConcatenate
             ("TimeLevel", "_", AccountNumber(), "_");
     //----  
     if (IsTesting() || IsOptimization())
          G_Name_0 = StringConcatenate(G_Name_0, "_Test_");
     //----              
     SecondStart = true;
    }
   //----
   G_Name_ = StringConcatenate(G_Name_0, symbol, "_", MagicNumber);   
   //----   
   return(G_Name_);
//---+
  }
//+X================================================================X+
//| GetModifyTimeLevelName_() function                               |
//+X================================================================X+
string GetModifyTimeLevelName_(string symbol, int MagicNumber)
  {
//---+
   string G_Name_;
   static string G_Name_0;
   static bool SecondStart;
   //---- Initialization to zero
   if (!SecondStart)
    {
     G_Name_0 = StringConcatenate
             ("ModifyTimeLevel_", "_", AccountNumber(), "_");
     //----  
     if (IsTesting() || IsOptimization())
          G_Name_0 = StringConcatenate(G_Name_0, "_Test_");
     //----              
     SecondStart = true;
    }
   //----
   G_Name_ = StringConcatenate(G_Name_0, symbol, "_", MagicNumber);   
   //----   
   return(G_Name_);
//---+
  }
//+X================================================================X+
//| GetTrailTimeLevelName() function                                 |
//+X================================================================X+
string GetTrailTimeLevelName(string symbol, int MagicNumber)
  {
//---+
   string G_Name_;
   static string G_Name_0;
   static bool SecondStart;
   //---- Initialization to zero
   if (!SecondStart)
    {
     G_Name_0 = StringConcatenate
             ("TrailTimeLevel", "_", AccountNumber(), "_");
     //----  
     if (IsTesting() || IsOptimization())
          G_Name_0 = StringConcatenate(G_Name_0, "_Test_");
     //----              
     SecondStart = true;
    }
   //----
   G_Name_ = StringConcatenate(G_Name_0, symbol, "_", MagicNumber);   
   //----   
   return(G_Name_);
//---+
  }
//+X================================================================X+
//| GetTrailTimeLevelName_() function                                |
//+X================================================================X+
string GetTrailTimeLevelName_(string symbol, int MagicNumber)
  {
//---+
   string G_Name_;
   static string G_Name_0;
   static bool SecondStart;
   //---- Initialization to zero
   if (!SecondStart)
    {
     G_Name_0 = StringConcatenate
             ("TrailTimeLevel_", "_", AccountNumber(), "_");
     //----  
     if (IsTesting() || IsOptimization())
          G_Name_0 = StringConcatenate(G_Name_0, "_Test_");
     //----              
     SecondStart = true;
    }
   //----
   G_Name_ = StringConcatenate(G_Name_0, symbol, "_", MagicNumber);   
   //----   
   return(G_Name_);
//---+
  }
//+X================================================================X+
//| TradeTimeLevelCheck() function                                   |
//+X================================================================X+
bool TradeTimeLevelCheck
             (string symbol, int MagicNumber, datetime TradeTimeLevel)
  {
//---+
   //----
  if (TradeTimeLevel > 0)
   {
    //---- Getting the name of a global 
          //variable for storing the time limit
    string G_Name_ = GetTimeLevelName(symbol, MagicNumber);
  
    //---- Check if the time limit with respect to the previous deal has expired 
    if (TimeCurrent() < GlobalVariableGet(G_Name_))
                                            return(false); 
    } 
   return(true);
//---+
  }
//+X================================================================X+
//| ModifyTimeLevelCheck() function                                  |
//+X================================================================X+
bool ModifyTimeLevelCheck_
           (string symbol, int MagicNumber, datetime ModifyTimeLevel_)
  {
//---+
   //----
  if (ModifyTimeLevel_ > 0)
   {
    //---- Getting the name of a global 
          //variable for storing the time limit
    string G_Name_ = GetModifyTimeLevelName_(symbol, MagicNumber);
  
    //---- Check if the time limit with respect to the previous deal has expired 
    if (TimeCurrent() < GlobalVariableGet(G_Name_))
                                            return(false); 
    } 
   return(true);
//---+
  }
//+X================================================================X+
//| TrailTimeLevelCheck() function                                   |
//+X================================================================X+
bool TrailTimeLevelCheck
             (string symbol, int MagicNumber, datetime TrailTimeLevel)
  {
//---+
   //----
  if (TrailTimeLevel > 0)
   {
    //---- Getting the name of a global 
          //variable for storing the time limit
    string G_Name_ = GetTrailTimeLevelName(symbol, MagicNumber);
  
    //---- Check if the time limit with respect to the previous deal has expired 
    if (TimeCurrent() < GlobalVariableGet(G_Name_))
                                            return(false); 
    } 
   return(true);
//---+
  }
//+X================================================================X+
//| TrailTimeLevelCheck_() function                                  |
//+X================================================================X+
bool TrailTimeLevelCheck_
            (string symbol, int MagicNumber, datetime TrailTimeLevel_)
  {
//---+
   //----
  if (TrailTimeLevel_ > 0)
   {
    //---- Getting the name of a global 
          //variable for storing the time limit
    string G_Name_ = GetTrailTimeLevelName_(symbol, MagicNumber);
  
    //---- Check if the time limit with respect to the previous deal has expired 
    if (TimeCurrent() < GlobalVariableGet(G_Name_))
                                            return(false); 
    } 
   return(true);
//---+
  }
//+X================================================================X+
//| BuyLotCount_() function                                          |  
//+X================================================================X+
/*                                                                   |
 The Margin_Mode external variable determines the lot size | 
 calculation                                                                |
 0 - MM based on free margin                              |
 1 - MM based on the account balance                                  |
 2 - MM based on losses on free margin                     |
 3 - MM based on losses on the account balance                       |
 by default - MM based on free margin                   |
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
 if Money_Management is negative, the trading function uses | 
 the absolute Money_Management value rounded to the nearest standard value |
 as the lot size.                      |
*/                                                                // |
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
double BuyLotCount_
           (double Money_Management, int Margin_Mode, int STOPLOSS)
  {
//---+
  string Symb = Symbol(); 
  int    StLOSS;
  double LOTSTEP, MINLOT, MAXLOT, MARGINREQUIRED, TICKVALUE;
  double FreeMargin, LotVel, Lot;                                             

  //---1+ LOT SIZE CALCULATION FOR OPENING A POSITION
  if (Money_Management < 0)
       LotVel = MathAbs(Money_Management);
  else      
   switch(Margin_Mode)
    {
     //---+ Lot calculations based on free margin
     case  0:       
      MARGINREQUIRED = MarketInfo(Symb, MODE_MARGINREQUIRED);
      if (MARGINREQUIRED == 0.0)     
                           return(-1);             
      //----              
      LotVel = GetFreeMargin()
                * Money_Management / MARGINREQUIRED;               
      break;
  
    //---+ Lot calculation based on the account balance
    case  1:     
     MARGINREQUIRED = MarketInfo(Symb, MODE_MARGINREQUIRED);
     if (MARGINREQUIRED == 0.0)    
                       return(-1);          
     //----                
     LotVel = AccountBalance()
                  * Money_Management / MARGINREQUIRED;            
     break;
  
    //---+ Lot calculation based on losses on free margin             
    case  2:
     if (STOPLOSS <= 0)
      {
       Print("BuyLotCount(): Invalid Stop Loss!!!");
       STOPLOSS = 0;
      }
     //---- 
     StLOSS = StopCorrect(Symb, STOPLOSS, Slippage_);
     if (StLOSS <= 0)     
                return(-1);
     //----
     TICKVALUE = MarketInfo(Symb, MODE_TICKVALUE);
     if (TICKVALUE == 0.0)  
                   return(-1);            
     //----               
     LotVel = GetFreeMargin() *  MathAbs(Money_Management)
                                     / (TICKVALUE * StLOSS);
     break;
   
    //---+ Lot calculation based on losses on the account balance
    case  3:
     if (STOPLOSS <= 0)
      {
       Print("BuyLotCount(): Invalid Stop Loss!!!");
       STOPLOSS = 0;
      }
     //---- 
     StLOSS = StopCorrect(Symb, STOPLOSS, Slippage_);
     if (StLOSS <= 0)    
              return(-1);
     //----
     TICKVALUE = MarketInfo(Symb, MODE_TICKVALUE);
     if (TICKVALUE == 0.0)     
                    return(-1);            
     //----               
     LotVel = AccountBalance()
                *  MathAbs(Money_Management) 
                               / (TICKVALUE * StLOSS);
     break;
  
    //---+ Lot calculation based on free margin by default
    default:      
     MARGINREQUIRED = MarketInfo(Symb, MODE_MARGINREQUIRED);
     if (MARGINREQUIRED == 0.0)    
                        return(-1);              
     //----               
     LotVel = GetFreeMargin()
               * Money_Management / MARGINREQUIRED;         
    }
   //---1+   
   
  LOTSTEP = MarketInfo(Symb, MODE_LOTSTEP);
  if (LOTSTEP <= 0)    
           return(-1);
           
  //---- lot size normalization to the nearest standard value 
  Lot = LOTSTEP * MathFloor(LotVel / LOTSTEP);  
  
  //---+ check the lot for the minimum allowable value
  MINLOT = MarketInfo(Symb, MODE_MINLOT);
  if (MINLOT < 0)    
           return(-1);
  //----        
  if (Lot < MINLOT)  
            return(0);        
          
  //---+ check the lot for the maximum allowable value
  MAXLOT = MarketInfo(Symb, MODE_MAXLOT);
  if (MAXLOT < 0)    
           return(-1);         
  //----
  if (Lot > MAXLOT)
          Lot = MAXLOT;
  //----              
  return(Lot);        
//---+
  }   
//+X================================================================X+
//| SellLotCount_() function                                         |
//+X================================================================X+
/*                                                                   |
 The Margin_Mode external variable determines the lot size | 
 calculation                                                                |
 0 - MM based on free margin                              |
 1 - MM based on the account balance                                  |
 2 - MM based on losses on free margin                     |
 3 - MM based on losses on the account balance                       |
 by default - MM based on free margin                   |
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
 if Money_Management is negative, the trading function uses | 
 the absolute Money_Management value rounded to the nearest standard value |
 as the lot size.                      |
*/                                                                // |
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
double SellLotCount_
            (double Money_Management, int Margin_Mode, int STOPLOSS)
  {
//---+
  string Symb = Symbol(); 
  int    SPREAD, StLOSS;
  double LOTSTEP, MINLOT, MAXLOT, MARGINREQUIRED;
  double LotVel, Lot, TICKVALUE, TICKSIZE;                                               
  
  //---1+ LOT SIZE CALCULATION FOR OPENING A POSITION
  if (Money_Management < 0)
       LotVel = MathAbs(Money_Management);
  else      
   switch(Margin_Mode)
    {
     //---+ Lot calculations based on free margin
     case  0:     
      MARGINREQUIRED = MarketInfo(Symb, MODE_MARGINREQUIRED);
      if (MARGINREQUIRED == 0.0)    
                           return(-1);           
      //---
      SPREAD = MarketInfo(Symb, MODE_SPREAD);
      //---
      TICKVALUE = MarketInfo(Symb, MODE_TICKVALUE);
      //---
      LotVel = GetFreeMargin() * Money_Management / 
                   (MARGINREQUIRED - (SPREAD * TICKVALUE));                  
      break;
  
    //---+ Lot calculation based on the account balance
    case  1:      
     MARGINREQUIRED = MarketInfo(Symb, MODE_MARGINREQUIRED);
     if (MARGINREQUIRED == 0.0)    
                        return(-1);          
     //---
     SPREAD = MarketInfo(Symb, MODE_SPREAD);
     //---
     TICKVALUE = MarketInfo(Symb, MODE_TICKVALUE);
     //---
     LotVel = AccountBalance() * Money_Management / 
                   (MARGINREQUIRED - (SPREAD * TICKVALUE));                  
     break;
 
    //---+ Lot calculation based on losses on free margin
    case  2:
     if (STOPLOSS <= 0)
      {
       Print("SellLotCount(): Invalid Stop Loss!!!");
       STOPLOSS = 0;
      }
     //---- 
     StLOSS = StopCorrect(Symb, STOPLOSS, Slippage_);
     if (StLOSS <= 0)    
                return(-1);
     //----  
     TICKVALUE = MarketInfo(Symb, MODE_TICKVALUE);
     if (TICKVALUE == 0.0)   
                    return(-1);          
     //---
     SPREAD = MarketInfo(Symb, MODE_SPREAD);
     //---              
     LotVel = GetFreeMargin()
                * MathAbs(Money_Management) 
                      / (TICKVALUE * (StLOSS + SPREAD));
     break;
   
    //---+ Lot calculation based on losses on the account balance  
    case  3:
     if (STOPLOSS <= 0)
      {
       Print("SellLotCount(): Invalid Stop Loss!!!");
       STOPLOSS = 0;
      }
     //---- 
     StLOSS = StopCorrect(Symb, STOPLOSS, Slippage_);
     if (StLOSS <= 0)    
               return(-1);
     //----  
     TICKVALUE = MarketInfo(Symb, MODE_TICKVALUE);
     if (TICKVALUE == 0.0)   
                    return(-1);            
     //---
     SPREAD = MarketInfo(Symb, MODE_SPREAD);
     //---              
     LotVel = AccountBalance()
               * MathAbs(Money_Management) 
                      / (TICKVALUE * (StLOSS + SPREAD));
     break;                                                                                
   
    //---+ Lot calculation based on free margin by default
    default:        
     MARGINREQUIRED = MarketInfo(Symb, MODE_MARGINREQUIRED);
     if (MARGINREQUIRED == 0.0)     
                        return(-1);             
     //---
     SPREAD = MarketInfo(Symb, MODE_SPREAD);
     //---
     TICKVALUE = MarketInfo(Symb, MODE_TICKVALUE);
     //---
     LotVel = GetFreeMargin() * Money_Management / 
                  (MARGINREQUIRED - (SPREAD * TICKVALUE));                   
    }
   
  //----  
  LOTSTEP = MarketInfo(Symb, MODE_LOTSTEP); 
  if (LOTSTEP <= 0)    
           return(-1);
             
  //---- lot size normalization to the nearest standard value   
  Lot = LOTSTEP * MathFloor(LotVel / LOTSTEP);
  
  //---+ check the lot for the minimum allowable value
  MINLOT = MarketInfo(Symb, MODE_MINLOT);
  if (MINLOT < 0)    
           return(-1);            
   
  if (Lot < MINLOT)   
            return(0);           
          
  //---+ check the lot for the maximum allowable value
  MAXLOT = MarketInfo(Symb, MODE_MAXLOT);
  if (MAXLOT < 0)    
        return(-1);           
   
  if (Lot > MAXLOT)
          Lot = MAXLOT;
  //----       
  return(Lot);
//---+
  }
//+X================================================================X+
//| BuyLotCount() function                                           |  
//+X================================================================X+
/*                                                                   |
 The Margin_Mode external variable determines the lot size | 
 calculation                                                                |
 0 - MM based on free margin                              |
 1 - MM based on the account balance                                  |
 2 - MM based on losses on free margin                     |
 3 - MM based on losses on the account balance                       |
 4 - minimum lot between 0 and 2                                     |
 5 - minimum lot between 1 and 3                                     |
 by default - MM based on free margin                   |
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
 if Money_Management is negative, the trading function uses | 
 the absolute Money_Management value rounded to the nearest standard value |
 as the lot size.                      |
*/                                                                // |
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
double BuyLotCount
      (double Money_Management, int Margin_Mode, int STOPLOSS)
  {
//---+
   if (Money_Management < 0)
                 return(BuyLotCount_(Money_Management, 0, 0));
   //----
   double LotA, LotB;
   int MarModeA, MarModeB;
   //----
   switch(Margin_Mode)
    {
     case 4: 
      MarModeA = 0;
      MarModeB = 2;
      break;      
      //----
     case 5:
      MarModeA = 1;
      MarModeB = 3;
      break;
      //----                                                                 
     default: return(BuyLotCount_(Money_Management, 
                                      Margin_Mode, STOPLOSS));
    }
    
    LotA = BuyLotCount_(Money_Management, MarModeA, STOPLOSS);
    if (LotA == -1)
              return(-1);
    //----          
    LotB = BuyLotCount_(Money_Management, MarModeB, STOPLOSS);
    if (LotB == -1)
              return(-1);
   //----              
   if (LotA < LotB)
        return(LotA);
   else return(LotB);         
//---+
  }
//+X================================================================X+
//| SellLotCount() function                                          |  
//+X================================================================X+   
/*                                                                   |
 The Margin_Mode external variable determines the lot size | 
 calculation                                                                |
 0 - MM based on free margin                              |
 1 - MM based on the account balance                                  |
 2 - MM based on losses on free margin                     |
 3 - MM based on losses on the account balance                       |
 4 - minimum lot between 0 and 2                                     |
 5 - minimum lot between 1 and 3                                     |
 by default - MM based on free margin                   |
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
 if Money_Management is negative, the trading function uses | 
 the absolute Money_Management value rounded to the nearest standard value |
 as the lot size.                      |
*/                                                                // |
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
double SellLotCount
      (double Money_Management, int Margin_Mode, int STOPLOSS)
  {
//---+
   if (Money_Management < 0)
                return(SellLotCount_(Money_Management, 0, 0));
   //----
   double LotA, LotB;
   int MarModeA, MarModeB;
   //----
   switch(Margin_Mode)
    {
     case 4: 
      MarModeA = 0;
      MarModeB = 2;
      break;      
      //----
     case 5:
      MarModeA = 1;
      MarModeB = 3;
      break;
      //----                                                                 
     default: return(SellLotCount_(Money_Management, 
                                       Margin_Mode, STOPLOSS));
    }
    
    LotA = SellLotCount_(Money_Management, MarModeA, STOPLOSS);
    if (LotA == -1)
              return(-1);
    //----          
    LotB = SellLotCount_(Money_Management, MarModeB, STOPLOSS);
    if (LotB == -1)
              return(-1);
   //----              
   if (LotA < LotB)
        return(LotA);
   else return(LotB);         
//---+
  }
//+X================================================================X+
//| IndicatorCounted_() function                                     |  
//+X================================================================X+
// Analog of the IndicatorCounted() function that operates in EAs
int IndicatorCounted_(int Number, string symbol, int timeframe)
  {
//---+
   static int OldBars[1];
   static datetime BarTime[1];
   //----
   datetime _iTime;
   int Resalt, Bars_, size = Number + 1; 
   
   //---- Get the initial values
   Bars_ = iBars(symbol, timeframe) - 1;
   _iTime = iTime(symbol, timeframe, Bars_);
   
   //---- Check for errors
   if (Bars_ <= 0 || _iTime == 0)
                           return(-1);
   
   //---- Allocation of memory for arrays
   if (ArraySize(OldBars) < size)
    {
     if (ArrayResize(OldBars, size) < size)
      {
       
       PlaySound("alert.wav");
       Print(StringConcatenate
           ("IndicatorCounted_(Number = ", Number, 
            "): Failed to resize the OldBars buffer!!!"));
       //----    
       return(-1);
      }
     if (ArrayResize(BarTime, size) < size)
      {
       PlaySound("alert.wav");
       Print(StringConcatenate
           ("IndicatorCounted_(Number = ", Number, 
            "): Failed to resize the BarTime buffer!!!"));
       //----    
       return(-1);
      }
    }
    
   //---- Check if the history loads
   if (BarTime[Number] != _iTime)
    {
     OldBars[Number] = Bars_;
     BarTime[Number] = _iTime;
     return(0);
    }
   //----
   Resalt = OldBars[Number];
   
   //---- Check for the bar change
   if (Bars_ != OldBars[Number])
    {
     OldBars[Number] = Bars_;
    }
   //----
   return(Resalt);         
//---+
  }
//+X================================================================X+
//| GetLimit() function                                              |  
//+X================================================================X+
int GetLimit(int Number, string symbol, int timeframe)
  {
//---+
   int limit, counted_bars, IBars = iBars(symbol, timeframe);
   //----
   if (IBars <= 0)
           return(-1);

   //---- Get the bars already counted
   counted_bars = IndicatorCounted_(Number, symbol, timeframe);
   //---- Check for possible errors
   if (counted_bars < 0)
                 return(-1);
                 
   //---- Determine the number of the oldest bar 
               //starting from which the new bars will be recounted
   limit = iBars(symbol, timeframe) - counted_bars - 1;
//---- 
   //----
   return(limit);         
//---+
  }
//+X================================================================X+
//| ReSetAsIndexBuffer() function                                    |  
//+X================================================================X+
int ReSetAsIndexBuffer(string symbol, int timeframe, double& array[])
  {
//---+
   int IBars = iBars(symbol, timeframe);
   //----
   if (IBars <= 0)
           return(-1);

   //---- INDICATOR BUFFER EMULATION
   if (ArrayRange(array, 0) < IBars)
    {
     ArraySetAsSeries(array, false);
     //----
     if (ArrayResize(array, IBars) < IBars)
      {
       Print("ReSetAsIndexBuffer(): Failed to resize the buffer!!!");
       PlaySound("alert.wav");
       //----    
       return(-1);
      }
     //---- 
     ArraySetAsSeries(array, true);
    } 
//---- 
   //----
   return(IBars);         
//---+
  }
//+X================================================================X+
//| ReSetAsIndexBuffer_() function                                   |  
//+X================================================================X+
// The function converts the Array[] array to an indicator buffer analog   |
// with the number of elements equal to the ArrSize variable value   |
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
bool ReSetAsIndexBuffer_
         (string symbol, int timeframe, double& Array[], int ArrSize)
  {
//---+
   double Velue;
   int count, newcount, shift, Size = ArrSize + 1;

   //---- 
   if (ArrayRange(Array, 0) < Size)
    if (ArrayResize(Array, Size) < Size)  // error
     {
      Print("ReSetAsIndexBuffer_: Failed to resize the buffer!!!");
      PlaySound("alert.wav");
      //----    
      return(false);
     }
   //----
   if (Array[ArrSize] != 0)
     shift = iBarShift(symbol, timeframe, Array[ArrSize], true) - 2;   
   else Array[ArrSize] = iTime(symbol, timeframe, 2);
   //----
   if (shift == 0) // no bar change
       return(true);
   else if (shift < 0) // error
          return(false);
   //----
   Array[ArrSize] = iTime(symbol, timeframe, 2);
   //----
   Size -= 2;
   
   //---- INDICATOR BUFFER EMULATION  
   for(count = ArrSize - 1; count >= 0; count--) 
    {
     newcount = count + shift;
     Velue = Array[count];
     Array[count] = 0.0;
     //----
     if (newcount <= Size)
        Array[newcount] = Velue;
    } 
   //----
   return(true);         
//---+
  }
//+X================================================================X+
//| IsNewBar() function                                              |  
//+X================================================================X+
bool IsNewBar(int Number, string symbol, int timeframe)
  {
//---+
   datetime Time2_;
   int Size = Number + 1;
   static datetime Time2[];  

   //---- Allocation of memory for the Time2[] array
   if (ArrayRange(Time2, 0) < Size)
     if (ArrayResize(Time2, Size) < Size)
      {
       Print("IsNewBar(): Failed to resize the Time2[] buffer!!!");
       PlaySound("alert.wav");    
       return(false);
      }
   //----
   Time2_ = iTime(symbol, timeframe, 2);
   if (Time2_ == 0)
           return(false);
   
   //---- Check for a new bar       
   if (Time2_ != Time2[Number])
    {
     Time2[Number] = Time2_; 
     return(true);
    } 
   //----
   return(false);         
//---+
  } 
//+X================================================================X+
//| MinBarCheck() function                                           |  
//+X================================================================X+
bool MinBarCheck(string symbol, int timeframe, int MinBarTotal)
  {
//---+
   if (iBars(symbol, timeframe) < MinBarTotal)
                                      return(false); 
   //----
   return(true);         
//---+
  }
//+X================================================================X+
//| MaxBarCheck() function                                           |  
//+X================================================================X+
bool MaxBarCheck(string symbol, int timeframe, int MaxBarTotal)
  {
//---+
   if (iBars(symbol, timeframe) > MaxBarTotal)
                                      return(false); 
   //----
   return(true);         
//---+
  }
//+X================================================================X+
//| MaxLimitCheck() function                                         |  
//+X================================================================X+
void MaxLimitCheck
          (string symbol, int timeframe, int MinBarTotal, int& Limit)
  {
//---+
   int MaxLimit = iBars(symbol, timeframe) - MinBarTotal;
   //----
   if (Limit > MaxLimit)
            Limit = MaxLimit; 
   //----        
//---+
  }
//+X================================================================X+
//| IsBuySignal() function                                           |  
//+X================================================================X+
bool IsBuySignal(double Series3, double Series2, double Series1)
  {
//---+
   if (Series3 > Series2)
       if (Series2 < Series1)
                    return(true); 
   //----
   return(false);         
//---+
  }
//+X================================================================X+
//| IsSellSignal() function                                          |  
//+X================================================================X+
bool IsSellSignal(double Series3, double Series2, double Series1)
  {
//---+
   if (Series3 < Series2)
       if (Series2 > Series1)
                    return(true); 
   //----
   return(false);         
//---+
  }
//+X================================================================X+
//| IsBuySignal() function                                           |  
//+X================================================================X+
bool IsBuySignal_
        (double Trend, double Series3, double Series2, double Series1)
  {
//---+
   if (Trend > 0)
     if (Series3 > Series2)
       if (Series2 < Series1)
                    return(true); 
   //----
   return(false);         
//---+
  }
//+X================================================================X+
//| IsSellSignal() function                                          |  
//+X================================================================X+
bool IsSellSignal_
        (double Trend, double Series3, double Series2, double Series1)
  {
//---+
   if (Trend < 0)
     if (Series3 < Series2)
       if (Series2 > Series1)
                    return(true); 
   //----
   return(false);         
//---+
  }                                                                         
//+X----------------------+ <<< The End >>> +-----------------------X+             