//Version  January 7, 2007 Final
//+X================================================================X+
//|                                             JJMASeries1(Exp).mqh |
//|                       JMA code: Copyright  1998, Jurik Research |
//|                                          http://www.jurikres.com | 
//|             MQL4 JJMASeries1: Copyright  2006, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+ 
/*
  +-------------------------------------- <<< JJMASeries1() function >>> ----------------------------------------------+

  +-----------------------------------------+ <<< Purpose >>> +----------------------------------------------------+

  The JJMASeries1() function is intended for using the JMA algorithm when writing EAs in order to replace the calculation 
  of the classical smoothing with this algorithm. The file should be placed in the MetaTrader\experts\include\ folder. Please note
  that if nJMA1_bar is greater than nJMA1_MaxBar, the JJMASeries1() function will return zero! on that bar!
  So this value cannot be in the denominator of any fraction when calculating the indicator! This
  version of the JJMASeries1() function does not support EAs when used in custom indicators called
  by an Expert Advisor.  This version of the JJMASeries1() function supports EAs when used in the code of an indicator
  that is added to the code of an Expert Advisor, along with all loop operators and variables! When writing EAs
  using the JJMASeries1() function, it is not recommended to name variables in such a way that they will start with nJMA1_... or dJMA1_...
  The JJMASeries1() function can be used within other custom functions but in this case
  you should bear in mind that in calling such custom function, each call of JJMASeries1()
  should have its unique number nJMA1_number.  This version of the JJMASeries1() function should be used in EAs
  working with the first bar. The JJMASeries1() function can be used within other custom
  functions but in this case you should bear in mind that in calling such custom function, each
  call of JJMASeries1() should have its unique number (nJMA1_number). 
  
  
  +-------------------------------------+ <<< Input parameters >>> +-------------------------------------------------+

  nJMA1_number - JJMASeries1() function call number. (0, 1, 2, 3, etc.)
  nJMA1_dinJ   - parameter that allows you to change the nJMA1_Length and nJMA1_Phase parameters on each bar. 0 - any parameter 
                 changes are not allows, any other value indicates permission.
  nJMA1_MaxBar - the maximum value that can be taken on by the calculated bar number.    It is usually equal to 
                 Bars-1-period; where "period" is the number of bars on which the initial dJMA1_series value is not 
                 calculated;
  nJMA1_limit  - number of uncounted bars or the number of the last uncounted bar,    
  nJMA1_Length - depth of smoothing
  nJMA1_Phase  - parameter that varies within the range -100 ... +100, impacts the transitional process quality;
  dJMA1_series - Input parameter based on which the JJMASeries1 is calculated;
  nJMA1_bar    - number of the calculated bar; the loop operator changes the parameter from the maximum value to 
                 the first one!    That said, its maximum value should always be equal to the nJMA1_limit parameter value!!!

  +------------------------------------+ <<< Output parameters >>> +-------------------------------------------------+

  JJMASeries1()- dJMA1_JMA function value. If nJMA1_bar is greater than nJMA1_MaxBar-30, the JJMASeries1() function 
                 always returns zero!!!
  nJMA1_reset  - parameter that by reference returns the value different from 0, if an error occurred in the function calculation,
                 0 - if the calculation was successful. This parameter can only be a variable but not a value!!!!
                 
  +-----------------------------------+ <<< Function initialization >>> +-----------------------------------------------+
  
  Before calling the JJMASeries1() function, internal buffer variables of the function should be resized in the
  initialization block. For this purpose, you need to call the JJMASeries1() function through the auxiliary
  JJMASeries1Resize() function using the following parameters: JJMASeries1Resize(nJMA1_number+1);
  nJMA1_number(MaxJMA.number) should be made equal to the number of JJMASeries1() function calls, i.e. one more than 
  the maximum nJMA1_number. 
  
  +--------------------------------------+ <<< Indication of errors >>> +-------------------------------------------------+
  
  When debugging indicators and EAs, their codes may contain errors the cause of which should be determined using the log
  file.  The JJMASeries1() function writes all errors to the log file under \MetaTrader\EXPERTS\LOGS\. If before calling the
  JJMASeries1() function, an MQL4 error occurs in the code preceding the function, the function will write the error code and description
  to the log file. If when executing the JJMASeries1() function, an MQL4 error occurs in the JJMASeries1() algorithm,
  the function will also write the code error and description to the log file. In case of incorrect setting of the
  JJMASeries1() function call number, nJMA1_number, or incorrectly determined size of buffer variables nJJMAResize_Size, the log file 
  will contain the relevant messages regarding these parameters being incorrectly determined. The log file also contains information regarding the incorrectly
  determined nJMA1_limit parameter.  If during execution of the initialization function init(), an error occurs when resizing
  buffer variables of the JJMASeries1() function, the JJMASeries1Resize() function will write the relevant information regarding
  the failure to resize buffer variables to the log file. If when calling the JJMASeries1() function through an external loop
  operator, the correct sequence of nJMA1_bar parameter modification was disrupted, the log file will also contain
  the relevant information. It should be noted that some program code errors will give rise to further errors in the code execution,
  so if the JJMASeries1() function adds several errors to the log around the same time, they should be fixed according
  to the time of their occurrence. In a correctly written Expert Advisor, the JJMASeries1() function can add entries to the log file only
  in case of errors in the operating system work.  The only exception is writing of changes in buffer variable sizes upon
  reloading an Expert Advisor at every init() function call. 
  
  +---------------------------------+ <<< Function call example >>> +--------------------------------------------+

//----+ determining the JJMASeries1() functions
#include <JJMASeries1.mqh>
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- determining the chart plotting style
SetIndexStyle (0,DRAW_LINE); 
//---- 1 indicator buffer used for calculation
SetIndexBuffer(0,Ind_Buffer);
//----+ Resizing buffer variables of the JJMASeries1, nJMA1_number=1(One call of the JJMASeries1 function)
if(JJMASeries1Resize(1)==0)return(-1);
return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator function                                        |
//+------------------------------------------------------------------+
int start()
{
//----+ Introducing integer variables and getting bars already counted
int reset,bar,MaxBar,limit,counted_bars=IndicatorCounted(); 
//---- check for possible errors
if (counted_bars<0)return(-1);
//---- the last counted bar should be recounted (without recounting, the JJMASeries1() function will not proceed with its calculations!!!)
if (counted_bars>0) counted_bars--;
//---- determining the number of the oldest bar starting from which the new bars will be recounted
int limit=Bars-counted_bars-1;
MaxBar=Bars-1;
//----+ 
for(bar=limit;bar>=0;bar--)
 (
  double Series=Close[bar];
  //----+ Calling the JJMASeries1() function under number 0 for the Ind_Buffer[] buffer calculation, 
  //the nJMA1_Phase and nJMA1_Length parameters do not change on every bar (nJMA1_din=0)
  double Resalt=JJMASeries1(0,0,MaxBar,limit,Phase,Length,Series,bar,reset);
  if (reset!=0)return(-1);
  Ind_Buffer[bar]=Resalt;
 }
return(0);
}
//----+ 

  */
//+X================================================================X+
//|  JJMASeries1() function                                          |
//+X================================================================X+

//----++ <<< Declaration of variables >>> 
double dJMA1_f18[1],dJMA1_f38[1],dJMA1_fA8[1],dJMA1_fC0[1],dJMA1_fC8[1],dJMA1_s8[1],dJMA1_s18[1],dJMA1_v1[1],dJMA1_v2[1];
double dJMA1_v3[1],dJMA1_f90[1],dJMA1_f78[1],dJMA1_f88[1],dJMA1_f98[1],dJMA1_JMA[1],dJMA1_list[1][128],dJMA1_ring1[1][128];
double dJMA1_ring2[1][11],dJMA1_buffer[1][62],dJMA1_Kg[1],dJMA1_Pf[1];
//--+
int    nJMA1_s28[1],nJMA1_s30[1],nJMA1_s38[1],nJMA1_s40[1],nJMA1_s48[1],nJMA1_f0[1],nJMA1_s50[1],nJMA1_s70[1],nJMA1_LP2[1];
int    nJMA1_LP1[1],nJMA1_Test[1];

//--+ +-------------------------------------------------------------------------------------------------------------+
double dJMA1_fA0,dJMA1_vv,dJMA1_v4,dJMA1_f70,dJMA1_s20,dJMA1_s10,dJMA1_fB0,dJMA1_fD0,dJMA1_f8,dJMA1_f60,dJMA1_f20,dJMA1_f28;
double dJMA1_f30,dJMA1_f40,dJMA1_f48,dJMA1_f58,dJMA1_f68;
//--+
int    nJMA1_v5,nJMA1_v6,nJMA1_fE0,nJMA1_fD8,nJMA1_fE8,nJMA1_val,nJMA1_s58,nJMA1_s60,nJMA1_s68,nJMA1_size;
int    nJMA1_ii,nJMA1_jj,nJMA1_n,nJMA1_Error,nJMA1_Resize;
//----++ <<< Declaration of the JJMASeries1() function >>> 

double JJMASeries1
(
 int nJMA1_number,int nJMA1_din,int nJMA1_MaxBar,int nJMA1_limit,
 int nJMA1_Phase,int nJMA1_Length,double dJMA1_series,int nJMA1_bar,int &nJMA1_reset
 )
//----++
  {
   nJMA1_n=nJMA1_number;

   nJMA1_reset=1;
//=====+ <<< Checking for errors >>> ====================================================================================================+
   if(nJMA1_bar==nJMA1_limit)
     {
      //----++ checking for the JJMASeries1() function initialization
      if(nJMA1_Resize<1)
        {
         Print(StringConcatenate("JJMASeries1 number =",nJMA1_n,
               ". Buffer variables have not been resized using the JJMASeries1Resize() function"));
         if(nJMA1_Resize==0)
            Print(StringConcatenate("JJMASeries1 number =",nJMA1_n,
                  ". The JJMASeries1Resize() function call should be added to the initialization block"));
         return(0.0);
        }
      //----++ checking for error in the execution of the program code preceding the JJMASeries1() function
      nJMA1_Error=GetLastError();
      if(nJMA1_Error>4000)
        {
         Print(StringConcatenate("JJMASeries1 number =",nJMA1_n,
               ". An error occurred in the code preceding the JJMASeries1() function call number = ",nJMA1_n," error!!!"));
         Print(StringConcatenate("JJMASeries1 number =",nJMA1_n,". ",JMA_ErrDescr1(nJMA1_Error)));
        }

      //----++ checking for error in setting the nJMA1_number and nJMA1Resize_Number variables
      nJMA1_size=ArraySize(dJMA1_JMA);
      if(nJMA1_size<nJMA1_n)
        {
         Print(StringConcatenate("JJMASeries1 number =",nJMA1_n,
               ". Error!!! Invalid value of nJMA1_number=",
               nJMA1_n," of the JJMASeries1() function"));
         Print(StringConcatenate("JJMASeries1 number =",nJMA1_n,
               ". Or invalid value of nJJMAResize_Size=",
               nJMA1_size," of the JJMASeries1Resize() function"));
         return(0.0);
        }
     }
//----++ +==============================================================================================================================+  
   if(nJMA1_bar>nJMA1_MaxBar){nJMA1_reset=0;return(0.0);}
   if((nJMA1_bar==nJMA1_MaxBar) || (nJMA1_din!=0))
     {
      //----++ <<< Calculation of coefficients  >>> 
      nJMA1_Test[nJMA1_n]=1;
      double nJMA1_Dr,nJMA1_Ds,nJMA1_Dl;
      if(nJMA1_Length<1.0000000002) nJMA1_Dr=0.0000000001;
      else nJMA1_Dr=(nJMA1_Length-1.0)/2.0;
      if((nJMA1_Phase>=-100) && (nJMA1_Phase<=100))dJMA1_Pf[nJMA1_n]=nJMA1_Phase/100.0+1.5;
      if(nJMA1_Phase>100) dJMA1_Pf[nJMA1_n]=2.5;
      if(nJMA1_Phase<-100) dJMA1_Pf[nJMA1_n]=0.5;
      nJMA1_Dr= nJMA1_Dr * 0.9; dJMA1_Kg[nJMA1_n] = nJMA1_Dr/(nJMA1_Dr+2.0);
      nJMA1_Ds=MathSqrt(nJMA1_Dr);nJMA1_Dl=MathLog(nJMA1_Ds);
      dJMA1_v1[nJMA1_n]=nJMA1_Dl;dJMA1_v2[nJMA1_n]=dJMA1_v1[nJMA1_n];
      if((dJMA1_v1[nJMA1_n]/MathLog(2.0))+2.0<0.0) dJMA1_v3[nJMA1_n]=0.0;
      else dJMA1_v3[nJMA1_n]=(dJMA1_v2[nJMA1_n]/MathLog(2.0))+2.0;
      dJMA1_f98[nJMA1_n]=dJMA1_v3[nJMA1_n];
      if(dJMA1_f98[nJMA1_n] >= 2.5 ) dJMA1_f88[nJMA1_n] = dJMA1_f98[nJMA1_n] - 2.0;
      else dJMA1_f88[nJMA1_n]= 0.5;
      dJMA1_f78[nJMA1_n]= nJMA1_Ds * dJMA1_f98[nJMA1_n];
      dJMA1_f90[nJMA1_n]= dJMA1_f78[nJMA1_n] / (dJMA1_f78[nJMA1_n] + 1.0);
      //----++
     }
//--+

   if(nJMA1_LP1[nJMA1_n]<61){nJMA1_LP1[nJMA1_n]++; dJMA1_buffer[nJMA1_n][nJMA1_LP1[nJMA1_n]]=dJMA1_series;}
   if(nJMA1_LP1[nJMA1_n]>30)
     {
      //++++++++++++++++++
      if(nJMA1_f0[nJMA1_n]!=0)
        {
         nJMA1_f0[nJMA1_n]=0;
         nJMA1_v5=1;
         nJMA1_fD8=nJMA1_v5*30;
         if(nJMA1_fD8==0) dJMA1_f38[nJMA1_n]=dJMA1_series; else dJMA1_f38[nJMA1_n]=dJMA1_buffer[nJMA1_n][1];
         dJMA1_f18[nJMA1_n]=dJMA1_f38[nJMA1_n];
         if(nJMA1_fD8>29) nJMA1_fD8=29;
        }
      else nJMA1_fD8=0;
      for(nJMA1_ii=nJMA1_fD8; nJMA1_ii>=0; nJMA1_ii--)
        {
         nJMA1_val=31-nJMA1_ii;
         if(nJMA1_ii==0) dJMA1_f8=dJMA1_series; else dJMA1_f8=dJMA1_buffer[nJMA1_n][nJMA1_val];
         dJMA1_f28=dJMA1_f8-dJMA1_f18[nJMA1_n]; dJMA1_f48=dJMA1_f8-dJMA1_f38[nJMA1_n];
         if(MathAbs(dJMA1_f28)>MathAbs(dJMA1_f48)) dJMA1_v2[nJMA1_n]=MathAbs(dJMA1_f28); else dJMA1_v2[nJMA1_n]=MathAbs(dJMA1_f48);
         dJMA1_fA0=dJMA1_v2[nJMA1_n]; dJMA1_vv=dJMA1_fA0+0.0000000001; //{1.0e-10;}
         if(nJMA1_s48[nJMA1_n] <= 1) nJMA1_s48[nJMA1_n] = 127; else nJMA1_s48[nJMA1_n] = nJMA1_s48[nJMA1_n] - 1;
         if(nJMA1_s50[nJMA1_n] <= 1) nJMA1_s50[nJMA1_n] = 10;  else nJMA1_s50[nJMA1_n] = nJMA1_s50[nJMA1_n] - 1;
         if(nJMA1_s70[nJMA1_n]<128) nJMA1_s70[nJMA1_n]=nJMA1_s70[nJMA1_n]+1;
         dJMA1_s8[nJMA1_n]=dJMA1_s8[nJMA1_n]+dJMA1_vv-dJMA1_ring2[nJMA1_n][nJMA1_s50[nJMA1_n]];
         dJMA1_ring2[nJMA1_n][nJMA1_s50[nJMA1_n]]=dJMA1_vv;
         if(nJMA1_s70[nJMA1_n]>10) dJMA1_s20=dJMA1_s8[nJMA1_n]/10.0; else dJMA1_s20=dJMA1_s8[nJMA1_n]/nJMA1_s70[nJMA1_n];
         if(nJMA1_s70[nJMA1_n]>127)
           {
            dJMA1_s10=dJMA1_ring1[nJMA1_n][nJMA1_s48[nJMA1_n]];
            dJMA1_ring1[nJMA1_n][nJMA1_s48[nJMA1_n]]=dJMA1_s20; nJMA1_s68=64; nJMA1_s58=nJMA1_s68;
            while(nJMA1_s68>1)
              {
               if(dJMA1_list[nJMA1_n][nJMA1_s58]<dJMA1_s10){nJMA1_s68=nJMA1_s68 *0.5; nJMA1_s58=nJMA1_s58+nJMA1_s68;}
               else
               if(dJMA1_list[nJMA1_n][nJMA1_s58]<=dJMA1_s10) nJMA1_s68=1; else{nJMA1_s68=nJMA1_s68 *0.5; nJMA1_s58=nJMA1_s58-nJMA1_s68;}
              }
           }
         else
           {
            dJMA1_ring1[nJMA1_n][nJMA1_s48[nJMA1_n]]=dJMA1_s20;
            if(nJMA1_s28[nJMA1_n]+nJMA1_s30[nJMA1_n]>127){nJMA1_s30[nJMA1_n]=nJMA1_s30[nJMA1_n]-1; nJMA1_s58=nJMA1_s30[nJMA1_n];}
            else{nJMA1_s28[nJMA1_n]=nJMA1_s28[nJMA1_n]+1; nJMA1_s58=nJMA1_s28[nJMA1_n];}
            if(nJMA1_s28[nJMA1_n] > 96) nJMA1_s38[nJMA1_n] = 96; else nJMA1_s38[nJMA1_n] = nJMA1_s28[nJMA1_n];
            if(nJMA1_s30[nJMA1_n] < 32) nJMA1_s40[nJMA1_n] = 32; else nJMA1_s40[nJMA1_n] = nJMA1_s30[nJMA1_n];
           }
         nJMA1_s68=64; nJMA1_s60=nJMA1_s68;
         while(nJMA1_s68>1)
           {
            if(dJMA1_list[nJMA1_n][nJMA1_s60]>=dJMA1_s20)
              {
               if(dJMA1_list[nJMA1_n][nJMA1_s60-1]<=dJMA1_s20) nJMA1_s68=1; else {nJMA1_s68=nJMA1_s68 *0.5; nJMA1_s60=nJMA1_s60-nJMA1_s68; }
              }
            else{nJMA1_s68=nJMA1_s68 *0.5; nJMA1_s60=nJMA1_s60+nJMA1_s68;}
            if((nJMA1_s60 == 127) &&(dJMA1_s20>dJMA1_list[nJMA1_n][127])) nJMA1_s60 = 128;
           }
         if(nJMA1_s70[nJMA1_n]>127)
           {
            if(nJMA1_s58>=nJMA1_s60)
              {
               if((nJMA1_s38[nJMA1_n]+1>nJMA1_s60) && (nJMA1_s40[nJMA1_n]-1<nJMA1_s60)) dJMA1_s18[nJMA1_n]=dJMA1_s18[nJMA1_n]+dJMA1_s20;
               else
               if((nJMA1_s40[nJMA1_n]+0>nJMA1_s60) && (nJMA1_s40[nJMA1_n]-1<nJMA1_s58)) dJMA1_s18[nJMA1_n]
                  =dJMA1_s18[nJMA1_n]+dJMA1_list[nJMA1_n][nJMA1_s40[nJMA1_n]-1];
              }
            else
            if(nJMA1_s40[nJMA1_n]>=nJMA1_s60) 
              {
               if((nJMA1_s38[nJMA1_n]+1<nJMA1_s60) && (nJMA1_s38[nJMA1_n]+1>nJMA1_s58)) dJMA1_s18[nJMA1_n]
                  =dJMA1_s18[nJMA1_n]+dJMA1_list[nJMA1_n][nJMA1_s38[nJMA1_n]+1]; 
              }
            else if(nJMA1_s38[nJMA1_n]+2>nJMA1_s60) dJMA1_s18[nJMA1_n]=dJMA1_s18[nJMA1_n]+dJMA1_s20;
            else if((nJMA1_s38[nJMA1_n]+1<nJMA1_s60) && (nJMA1_s38[nJMA1_n]+1>nJMA1_s58)) dJMA1_s18[nJMA1_n]
               =dJMA1_s18[nJMA1_n]+dJMA1_list[nJMA1_n][nJMA1_s38[nJMA1_n]+1];
            if(nJMA1_s58>nJMA1_s60)
              {
               if((nJMA1_s40[nJMA1_n]-1<nJMA1_s58) && (nJMA1_s38[nJMA1_n]+1>nJMA1_s58)) dJMA1_s18[nJMA1_n]=dJMA1_s18[nJMA1_n]-dJMA1_list[nJMA1_n][nJMA1_s58];
               else
                  if((nJMA1_s38[nJMA1_n]<nJMA1_s58) && (nJMA1_s38[nJMA1_n]+1>nJMA1_s60)) dJMA1_s18[nJMA1_n]=dJMA1_s18[nJMA1_n]-dJMA1_list[nJMA1_n][nJMA1_s38[nJMA1_n]];
              }
            else
              {
               if((nJMA1_s38[nJMA1_n]+1>nJMA1_s58) && (nJMA1_s40[nJMA1_n]-1<nJMA1_s58)) dJMA1_s18[nJMA1_n]=dJMA1_s18[nJMA1_n]-dJMA1_list[nJMA1_n][nJMA1_s58];
               else
                  if((nJMA1_s40[nJMA1_n]+0>nJMA1_s58) && (nJMA1_s40[nJMA1_n]-0<nJMA1_s60)) dJMA1_s18[nJMA1_n]=dJMA1_s18[nJMA1_n]-dJMA1_list[nJMA1_n][nJMA1_s40[nJMA1_n]];
              }
           }
         if(nJMA1_s58<=nJMA1_s60)
           {
            if(nJMA1_s58>=nJMA1_s60)
              {
               dJMA1_list[nJMA1_n][nJMA1_s60]=dJMA1_s20;
              }
            else
              {
               for(nJMA1_jj=nJMA1_s58+1; nJMA1_jj<=nJMA1_s60-1;nJMA1_jj++)dJMA1_list[nJMA1_n][nJMA1_jj-1]=dJMA1_list[nJMA1_n][nJMA1_jj];
               dJMA1_list[nJMA1_n][nJMA1_s60-1]=dJMA1_s20;
              }
           }
         else
           {
            for(nJMA1_jj=nJMA1_s58-1; nJMA1_jj>=nJMA1_s60;nJMA1_jj--) dJMA1_list[nJMA1_n][nJMA1_jj+1]=dJMA1_list[nJMA1_n][nJMA1_jj];
            dJMA1_list[nJMA1_n][nJMA1_s60]=dJMA1_s20;
           }
         if(nJMA1_s70[nJMA1_n]<=127)
           {
            dJMA1_s18[nJMA1_n]=0;
            for(nJMA1_jj=nJMA1_s40[nJMA1_n]; nJMA1_jj<=nJMA1_s38[nJMA1_n];nJMA1_jj++) dJMA1_s18[nJMA1_n]=dJMA1_s18[nJMA1_n]+dJMA1_list[nJMA1_n][nJMA1_jj];
           }
         dJMA1_f60=dJMA1_s18[nJMA1_n]/(nJMA1_s38[nJMA1_n]-nJMA1_s40[nJMA1_n]+1.0);
         if(nJMA1_LP2[nJMA1_n]+1>31) nJMA1_LP2[nJMA1_n]=31; else nJMA1_LP2[nJMA1_n]=nJMA1_LP2[nJMA1_n]+1;
         if(nJMA1_LP2[nJMA1_n]<=30)
           {
            if(dJMA1_f28 > 0.0) dJMA1_f18[nJMA1_n] = dJMA1_f8; else dJMA1_f18[nJMA1_n] = dJMA1_f8 - dJMA1_f28 * dJMA1_f90[nJMA1_n];
            if(dJMA1_f48 < 0.0) dJMA1_f38[nJMA1_n] = dJMA1_f8; else dJMA1_f38[nJMA1_n] = dJMA1_f8 - dJMA1_f48 * dJMA1_f90[nJMA1_n];
            dJMA1_JMA[nJMA1_n]=dJMA1_series;
            if(nJMA1_LP2[nJMA1_n]!=30) continue;
            if(nJMA1_LP2[nJMA1_n]==30)
              {
               dJMA1_fC0[nJMA1_n]=dJMA1_series;
               if(MathCeil(dJMA1_f78[nJMA1_n])>=1) dJMA1_v4=MathCeil(dJMA1_f78[nJMA1_n]); else dJMA1_v4=1.0;

               if(dJMA1_v4>0)nJMA1_fE8=MathFloor(dJMA1_v4);else{if(dJMA1_v4<0)nJMA1_fE8=MathCeil(dJMA1_v4);else nJMA1_fE8=0.0;}

               if(MathFloor(dJMA1_f78[nJMA1_n])>=1) dJMA1_v2[nJMA1_n]=MathFloor(dJMA1_f78[nJMA1_n]); else dJMA1_v2[nJMA1_n]=1.0;

               if(dJMA1_v2[nJMA1_n]>0)nJMA1_fE0=MathFloor(dJMA1_v2[nJMA1_n]);else{if(dJMA1_v2[nJMA1_n]<0)nJMA1_fE0=MathCeil(dJMA1_v2[nJMA1_n]);else nJMA1_fE0=0.0;}

               if(nJMA1_fE8==nJMA1_fE0) dJMA1_f68=1.0; else {dJMA1_v4=nJMA1_fE8-nJMA1_fE0; dJMA1_f68=(dJMA1_f78[nJMA1_n]-nJMA1_fE0)/dJMA1_v4;}
               if(nJMA1_fE0 <= 29) nJMA1_v5 = nJMA1_fE0; else nJMA1_v5 = 29;
               if(nJMA1_fE8 <= 29) nJMA1_v6 = nJMA1_fE8; else nJMA1_v6 = 29;
               dJMA1_fA8[nJMA1_n]=(dJMA1_series-dJMA1_buffer[nJMA1_n][nJMA1_LP1[nJMA1_n]-nJMA1_v5]) *(1.0-dJMA1_f68)/nJMA1_fE0+(dJMA1_series
                                   -dJMA1_buffer[nJMA1_n][nJMA1_LP1[nJMA1_n]-nJMA1_v6])*dJMA1_f68/nJMA1_fE8;
              }
           }
         else
           {
            if(dJMA1_f98[nJMA1_n] >= MathPow(dJMA1_fA0/dJMA1_f60, dJMA1_f88[nJMA1_n])) dJMA1_v1[nJMA1_n] = MathPow(dJMA1_fA0/dJMA1_f60, dJMA1_f88[nJMA1_n]);
            else dJMA1_v1[nJMA1_n] = dJMA1_f98[nJMA1_n];
            if(dJMA1_v1[nJMA1_n]<1.0) dJMA1_v2[nJMA1_n]=1.0;
            else
              {
               if(dJMA1_f98[nJMA1_n]>=MathPow(dJMA1_fA0/dJMA1_f60,dJMA1_f88[nJMA1_n])) dJMA1_v3[nJMA1_n]=MathPow(dJMA1_fA0/dJMA1_f60,dJMA1_f88[nJMA1_n]);
               else dJMA1_v3[nJMA1_n]=dJMA1_f98[nJMA1_n]; dJMA1_v2[nJMA1_n]=dJMA1_v3[nJMA1_n];
              }
            dJMA1_f58=dJMA1_v2[nJMA1_n]; dJMA1_f70=MathPow(dJMA1_f90[nJMA1_n],MathSqrt(dJMA1_f58));
            if(dJMA1_f28 > 0.0) dJMA1_f18[nJMA1_n] = dJMA1_f8; else dJMA1_f18[nJMA1_n] = dJMA1_f8 - dJMA1_f28 * dJMA1_f70;
            if(dJMA1_f48 < 0.0) dJMA1_f38[nJMA1_n] = dJMA1_f8; else dJMA1_f38[nJMA1_n] = dJMA1_f8 - dJMA1_f48 * dJMA1_f70;
           }
        }
      if(nJMA1_LP2[nJMA1_n]>30)
        {
         dJMA1_f30=MathPow(dJMA1_Kg[nJMA1_n],dJMA1_f58);
         dJMA1_fC0[nJMA1_n] =(1.0 - dJMA1_f30) * dJMA1_series + dJMA1_f30 * dJMA1_fC0[nJMA1_n];
         dJMA1_fC8[nJMA1_n] =(dJMA1_series - dJMA1_fC0[nJMA1_n]) * (1.0 - dJMA1_Kg[nJMA1_n]) + dJMA1_Kg[nJMA1_n] * dJMA1_fC8[nJMA1_n];
         dJMA1_fD0 = dJMA1_Pf[nJMA1_n] * dJMA1_fC8[nJMA1_n] + dJMA1_fC0[nJMA1_n];
         dJMA1_f20 = dJMA1_f30 *(-2.0);
         dJMA1_f40 = dJMA1_f30 * dJMA1_f30;
         dJMA1_fB0 = dJMA1_f20 + dJMA1_f40 + 1.0;
         dJMA1_fA8[nJMA1_n] =(dJMA1_fD0 - dJMA1_JMA[nJMA1_n]) * dJMA1_fB0 + dJMA1_f40 * dJMA1_fA8[nJMA1_n];
         dJMA1_JMA[nJMA1_n] = dJMA1_JMA[nJMA1_n] + dJMA1_fA8[nJMA1_n];
        }
     }
//++++++++++++++++++
   if(nJMA1_LP1[nJMA1_n]<=30)dJMA1_JMA[nJMA1_n]=0.0;
//----+ 

//----++ checking for error in the execution of the JJMASeries1() function code
   nJMA1_Error=GetLastError();
   if(nJMA1_Error>4000)
     {
      Print(StringConcatenate("JJMASeries1 number =",nJMA1_n,
            ". Error when executing the JJMASeries1() function!!!"));
      Print(StringConcatenate("JJMASeries1 number =",nJMA1_n,". ",JMA_ErrDescr1(nJMA1_Error)));
      return(0.0);
     }

   nJMA1_reset=0;
   return(dJMA1_JMA[nJMA1_n]);
//----+  End of JJMASeries1() function calculations ----------------+
  }
//+X================================================================X+
//| JJMASeries1Resize() function                                     |
//+X================================================================X+
// JJMASeries1Resize is an additional function for resizing      |
// and initialization of buffer variables of the JJMASeries1 function. |
// Call example: JJMASeries1Resize(5); where 5 is the number    |
// of calls of JJMASeries1() in the text of the indicator. This call     |
// of the JJMASeries1Resize function should be added                      |
// to the initialization block of a custom indicator or EA    |                         
//+X================================================================X+
int JJMASeries1Resize(int nJJMAResize_Size)
  {
//----+
   int kkk,nJJMAResize_reset,nJJMAResize_cycle;
//--+
   while(nJJMAResize_cycle==0)
     {
      //----++ <<< resizing buffer variables >>> +--------------------------+
      if(ArrayResize(dJMA1_list,   nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA1_ring1,  nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA1_ring2,  nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA1_buffer, nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA1_Kg,     nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA1_Pf,     nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA1_f18,    nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA1_f38,    nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA1_fA8,    nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA1_fC0,    nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA1_fC8,    nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA1_s8,     nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA1_s18,    nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA1_JMA,    nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(nJMA1_s50,    nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(nJMA1_s70,    nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(nJMA1_LP2,    nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(nJMA1_LP1,    nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(nJMA1_s38,    nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(nJMA1_s40,    nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(nJMA1_s48,    nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA1_v1,     nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA1_v2,     nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA1_v3,     nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA1_f90,    nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA1_f78,    nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA1_f88,    nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA1_f98,    nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(nJMA1_s28,    nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(nJMA1_s30,    nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(nJMA1_f0,     nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(nJMA1_Test,   nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      //+--------------------------------------------------------------------------------+
      nJJMAResize_cycle=1;
     }
//--+
   if(nJJMAResize_reset==-1)
     {
      Print(StringConcatenate("JJMASeries1Resize: Error!!!",
            " Failed to resize buffer variables of the JJMASeries1() function!!!"));
      //----                                                                                                                                                                                                               
      nJMA1_Resize=-2;
      return(0);
     }
   else
     {
      Print(StringConcatenate("JJMASeries1Resize: JJMASeries1 Size = ",nJJMAResize_Size,""));

      //----
      ArrayInitialize(nJMA1_f0,1);
      ArrayInitialize(nJMA1_s28,63);
      ArrayInitialize(nJMA1_s30,64);
      //----
      for(int rrr=0; rrr<nJJMAResize_Size; rrr++)
        {
         for(kkk=0; kkk<=nJMA1_s28[rrr]; kkk++)
            dJMA1_list[rrr][kkk]=-1000000.0;

         for(kkk=nJMA1_s30[rrr]; kkk<=127; kkk++)
            dJMA1_list[rrr][kkk]=+1000000.0;
        }
      //----
      nJMA1_Resize=nJJMAResize_Size;
      return(nJJMAResize_Size);
     }
//----+
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
/*
//+X=================================================================================================X+
JJMASeries1Alert is an additional function for indication of error when setting | 
the nJMA1_Length and nJMA1_Phase external variables of the JJMASeries1 function.                                                       |
  -------------------------- input parameters  --------------------------                            |
JJMASeries1Alert_Number                                                                               |
JJMASeries1Alert_ExternVar - value of the external variable for the nJMA1_Length parameter                     |
JJMASeries1Alert_name - name of the external variable for the nJMA1_Phase parameter if JJMASeries1Alert_Number=0|
or nJMA1_Phase if JJMASeries1Alert_Number=1.                                                      |
  -------------------------- Application example  -----------------------                            |
  int init()                                                                                          |
//----                                                                                                |
Some initialization of variables and buffers can be here                                                     |
                                                                                                      |
//---- setting alerts for invalid values of external variables                                  |
JJMASeries1Alert(0,"Length1",Length1);                                                                |
JJMASeries1Alert(0,"Length2",Length2);                                                                |
JJMASeries1Alert(1,"Phase1",Phase1);                                                                  |                                                            
JJMASeries1Alert(1,"Phase2",Phase2);                                                                  |                                                          
//---- initialization complete                                                                       |
return(0);                                                                                            |
}                                                                                                     |
//+X=================================================================================================X+
*/
void JJMASeries1Alert
(
 int JJMASeries1Alert_Number,string JJMASeries1Alert_name,int JJMASeries1Alert_ExternVar
 )
  {
//---- setting alerts for invalid values of input parameters ==========================+ 
   if(JJMASeries1Alert_Number==0)
      if(JJMASeries1Alert_ExternVar<1)
         Print(StringConcatenate(
               "The ",JJMASeries1Alert_name," parameter must not be less than 1",
               " You have entered invalid ",JJMASeries1Alert_ExternVar," the value of 1 will be used"));

   if(JJMASeries1Alert_Number==1)
     {
      if(JJMASeries1Alert_ExternVar<-100 || JJMASeries1Alert_ExternVar>100)
         Print(StringConcatenate(
               "The ",JJMASeries1Alert_name," parameter must be from -100 to +100",
               " You have entered invalid ",JJMASeries1Alert_ExternVar," the value of -100 will be used"));
     }

   if(JJMASeries1Alert_Number!=0 && JJMASeries1Alert_Number!=1)
      Print(StringConcatenate(
            "The JJMASeries1Alert_Number parameter can only be equal to 0 and 1",
            " You have entered invalid ",JJMASeries1Alert_Number,"!!!"));
  }
//--+ --------------------------------------------------------------------------------------------+

/*
// Russian translation provided by Nikolay Kositsin, 17.07.2008 
//+X================================================================X+
                                         JMA_ErrDescr1(MQL4_RUS).mqh |
                         Copyright  2004, MetaQuotes Software Corp. |
                                          http://www.metaquotes.net/ |
//+X================================================================X+
 by the MQL4 error code the JMA_ErrDescr1() function returns the string   |
 containing the error code and description.                                |
  -------------------- Application example  ----------------------- | 
 int Error=GetLastError();                                           |
 if(Error>4000)Print(JMA_ErrDescr1(Error));                          |
//+X================================================================X+
*/
string JMA_ErrDescr1(int error_code)
  {
   string error_string;
//----
   switch(error_code)
     {
      //---- Codes returned by the trade server
      case    0:                                                                                                                                 break;
      case    1: error_string = StringConcatenate("Error code = ", error_code, ". No errors");                                                  break;
      case    2: error_string = StringConcatenate("Error code = ", error_code, ". Common error");                                                break;
      case    3: error_string = StringConcatenate("Error code = ", error_code, ". Invalid trade parameters");                             break;
      case    4: error_string = StringConcatenate("Error code = ", error_code, ". Trade server is busy");                                       break;
      case    5: error_string = StringConcatenate("Error code = ", error_code, ". Old version of the client terminal");                       break;
      case    6: error_string = StringConcatenate("Error code = ", error_code, ". No connection with trade server");                          break;
      case    7: error_string = StringConcatenate("Error code = ", error_code, ". Not enough rights");                                           break;
      case    8: error_string = StringConcatenate("Error code = ", error_code, ". Too frequent trade server requests");                   break;
      case    9: error_string = StringConcatenate("Error code = ", error_code, ". Malfunctional trade operation");  break;
      case   64: error_string = StringConcatenate("Error code = ", error_code, ". Account disabled");                                           break;
      case   65: error_string = StringConcatenate("Error code = ", error_code, ". Invalid account number");                                    break;
      case  128: error_string = StringConcatenate("Error code = ", error_code, ". Trade timeout");                       break;
      case  129: error_string = StringConcatenate("Error code = ", error_code, ". Invalid price");                                             break;
      case  130: error_string = StringConcatenate("Error code = ", error_code, ". Invalid stops");                                             break;
      case  131: error_string = StringConcatenate("Error code = ", error_code, ". Invalid trade volume");                                   break;
      case  132: error_string = StringConcatenate("Error code = ", error_code, ". Market is closed");                                                break;
      case  133: error_string = StringConcatenate("Error code = ", error_code, ". Trade is disabled");                                          break;
      case  134: error_string = StringConcatenate("Error code = ", error_code, ". Not enough money to perform the operation");                  break;
      case  135: error_string = StringConcatenate("Error code = ", error_code, ". Price changed");                                             break;
      case  136: error_string = StringConcatenate("Error code = ", error_code, ". Off quotes");                                                     break;
      case  137: error_string = StringConcatenate("Error code = ", error_code, ". Broker is busy");                                                break;
      case  138: error_string = StringConcatenate("Error code = ", error_code, ". Requote");                                                  break;
      case  139: error_string = StringConcatenate("Error code = ", error_code, ". Order is locked and being processed");                     break;
      case  140: error_string = StringConcatenate("Error code = ", error_code, ". Long positions only allowed");                                    break;
      case  141: error_string = StringConcatenate("Error code = ", error_code, ". Too many requests");                                      break;
      case  145: error_string = StringConcatenate("Error code = ", error_code, ". Modification denied because the order is too close to market"); break;
      case  146: error_string = StringConcatenate("Error code = ", error_code, ". Trade context is busy");                                  break;
      case  147: error_string = StringConcatenate("Error code = ", error_code, ". Expirations are denied by broker");      break;
      case  148: error_string = StringConcatenate("Error code = ", error_code, ". The number of open and pending orders",
                                                  " has reached the limit set by the broker"); break;
         //---- MQL4 errors 
         case 4000: error_string = StringConcatenate("Error code = ", error_code, ". No errors");                                                  break;
      case 4001: error_string = StringConcatenate("Error code = ", error_code, ". Wrong function pointer");                              break;
      case 4002: error_string = StringConcatenate("Error code = ", error_code, ". Array index is out of range");                 break;
      case 4003: error_string = StringConcatenate("Error code = ", error_code, ". No memory for function call stack");                                break;
      case 4004: error_string = StringConcatenate("Error code = ", error_code, ". Recursive stack overflow");                break;
      case 4005: error_string = StringConcatenate("Error code = ", error_code, ". Not enough stack for parameter");                 break;
      case 4006: error_string = StringConcatenate("Error code = ", error_code, ". No memory for string parameter");                         break;
      case 4007: error_string = StringConcatenate("Error code = ", error_code, ". No memory for temp string");                             break;
      case 4008: error_string = StringConcatenate("Error code = ", error_code, ". Uninitialized string");                                 break;
      case 4009: error_string = StringConcatenate("Error code = ", error_code, ". Uninitialized string in array");                       break;
      case 4010: error_string = StringConcatenate("Error code = ", error_code, ". No memory for string array");                           break;
      case 4011: error_string = StringConcatenate("Error code = ", error_code, ". String too long");                                      break;
      case 4012: error_string = StringConcatenate("Error code = ", error_code, ". Remainder from zero divide");                                  break;
      case 4013: error_string = StringConcatenate("Error code = ", error_code, ". Zero divide");                                             break;
      case 4014: error_string = StringConcatenate("Error code = ", error_code, ". Unknown command");                                         break;
      case 4015: error_string = StringConcatenate("Error code = ", error_code, ". Wrong jump (never generated error)");                break;
      case 4016: error_string = StringConcatenate("Error code = ", error_code, ". Uninitialized array");                                 break;
      case 4017: error_string = StringConcatenate("Error code = ", error_code, ". DLL calls are not allowed");                                     break;
      case 4018: error_string = StringConcatenate("Error code = ", error_code, ". Cannot load the library");                             break;
      case 4019: error_string = StringConcatenate("Error code = ", error_code, ". Cannot call the function");                                  break;
      case 4020: error_string = StringConcatenate("Error code = ", error_code, ". Calls of external library functions are not allowed");            break;
      case 4021: error_string = StringConcatenate("Error code = ", error_code, ". Not enough memory for returned string");     break;
      case 4022: error_string = StringConcatenate("Error code = ", error_code, ". System is busy (never generated error)");                      break;
      case 4050: error_string = StringConcatenate("Error code = ", error_code, ". Invalid number of function parameters");                  break;
      case 4051: error_string = StringConcatenate("Error code = ", error_code, ". Invalid function parameter value");                     break;
      case 4052: error_string = StringConcatenate("Error code = ", error_code, ". String function internal error");                         break;
      case 4053: error_string = StringConcatenate("Error code = ", error_code, ". Array error");                                              break;
      case 4054: error_string = StringConcatenate("Error code = ", error_code, ". Incorrect use of time series array");                break;
      case 4055: error_string = StringConcatenate("Error code = ", error_code, ". Custom indicator error");                         break;
      case 4056: error_string = StringConcatenate("Error code = ", error_code, ". Incompatible arrays");                                        break;
      case 4057: error_string = StringConcatenate("Error code = ", error_code, ". Global variable processing error");                     break;
      case 4058: error_string = StringConcatenate("Error code = ", error_code, ". Global variable not found");                         break;
      case 4059: error_string = StringConcatenate("Error code = ", error_code, ". Function is not allowed in testing mode");                      break;
      case 4060: error_string = StringConcatenate("Error code = ", error_code, ". Function is not confirmed");                                     break;
      case 4061: error_string = StringConcatenate("Error code = ", error_code, ". Mail sending error");                                       break;
      case 4062: error_string = StringConcatenate("Error code = ", error_code, ". String parameter expected");                              break;
      case 4063: error_string = StringConcatenate("Error code = ", error_code, ". Integer parameter expected");                             break;
      case 4064: error_string = StringConcatenate("Error code = ", error_code, ". Double parameter expected");                              break;
      case 4065: error_string = StringConcatenate("Error code = ", error_code, ". Array expected as parameter");                       break;
      case 4066: error_string = StringConcatenate("Error code = ", error_code, ". Requested history data are being updated");      break;
      case 4067: error_string = StringConcatenate("Error code = ", error_code, ". Error when executing trading operation");                     break;
      case 4099: error_string = StringConcatenate("Error code = ", error_code, ". End of file");                                                 break;
      case 4100: error_string = StringConcatenate("Error code = ", error_code, ". Error when working with file");                                  break;
      case 4101: error_string = StringConcatenate("Error code = ", error_code, ". Wrong file name");                                      break;
      case 4102: error_string = StringConcatenate("Error code = ", error_code, ". Too many open files");                               break;
      case 4103: error_string = StringConcatenate("Error code = ", error_code, ". Cannot open the file");                                     break;
      case 4104: error_string = StringConcatenate("Error code = ", error_code, ". Incompatible file access mode");                         break;
      case 4105: error_string = StringConcatenate("Error code = ", error_code, ". No order selected");                                     break;
      case 4106: error_string = StringConcatenate("Error code = ", error_code, ". Unknown symbol");                                          break;
      case 4107: error_string = StringConcatenate("Error code = ", error_code, ". Invalid price parameter for trading function");             break;
      case 4108: error_string = StringConcatenate("Error code = ", error_code, ". Invalid ticket number");                                       break;
      case 4109: error_string = StringConcatenate("Error code = ", error_code, ". Trade is not allowed");                                       break;
      case 4110: error_string = StringConcatenate("Error code = ", error_code, ". Long positions are not allowed");                                break;
      case 4111: error_string = StringConcatenate("Error code = ", error_code, ". Short positions are not allowed");                               break;
      case 4200: error_string = StringConcatenate("Error code = ", error_code, ". Object already exists");                                       break;
      case 4201: error_string = StringConcatenate("Error code = ", error_code, ". Unknown object property requested");                      break;
      case 4202: error_string = StringConcatenate("Error code = ", error_code, ". Object does not exist");                                        break;
      case 4203: error_string = StringConcatenate("Error code = ", error_code, ". Unknown object type");                                     break;
      case 4204: error_string = StringConcatenate("Error code = ", error_code, ". No object name");                                           break;
      case 4205: error_string = StringConcatenate("Error code = ", error_code, ". Object coordinates error");                                    break;
      case 4206: error_string = StringConcatenate("Error code = ", error_code, ". The specified subwindow cannot be found");                                break;
      case 4207: error_string = StringConcatenate("Error code = ", error_code, ". Error when working with the object");                                break;
      default:   error_string = StringConcatenate("Error code = ", error_code, ". unknown error");
     }
//----
   return(error_string);
  }
//+X----------------------------------------------------------------X+
