//Version  January 7, 2007 Final
//+X================================================================X+
//|                                                 JJMASeries().mqh |
//|                       JMA code: Copyright  1998, Jurik Research |
//|                                          http://www.jurikres.com | 
//|              MQL4 JJMASeries: Copyright  2006, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+ 
/*
  +-------------------------------------- <<< JJMASeries() function >>> -----------------------------------------------+

  +-----------------------------------------+ <<< Purpose >>> +----------------------------------------------------+

  The JJMASeries() function is intended for using the JMA algorithm when writing any technical indicators and
  EAs, in order to replace the calculation of the classical smoothing with this algorithm.  The function does not work if the
  nJMA_limit parameter is equal to zero! All indicators I have developed for JJMASeries() are implemented with this restriction
  in mind.  The file should be placed in the MetaTrader\experts\include\ folder. Please note that if nJMA_bar is greater than
  nJMA_MaxBar, the JJMASeries() function will return zero! on that bar! So this value
  cannot be in the denominator of any fraction when calculating the indicator! This version of the JJMASeries() function
  supports EAs when used in custom indicators called by an Expert Advisor. This version
  of the JJMASeries() function supports EAs when used in the code of an indicator that is added to the code
  of an Expert Advisor, along with all loop operators and variables! When writing indicators and EAs using
  the JJMASeries() function, it is not recommended to name variables in such a way that they will start with nJMA_...  or dJMA_... The
  JJMASeries() function can be used within other custom functions but in this case
  you should bear in mind that in calling such custom function, each call of JJMASeries() should
  have its unique number nJMA_number.  The JJMASeries() function can be used within other
  custom functions but in this case you should bear in mind that in calling such custom
  function, each call of JJMASeries() should have its unique number (nJMA_number). 
  
  +-------------------------------------+ <<< Input parameters >>> +-------------------------------------------------+

  nJMA_number - JJMASeries() function call number. (0, 1, 2, 3, etc.)
  nJMA_dinJ   - parameter that allows you to change the nJMA_Length and nJMA_Phase parameters on each bar. 0 -  any parameter changes 
                are not allowed, any other value indicates permission.
  nJMA_MaxBar - the maximum value that can be taken on by the calculated bar number.     It is usually equal to 
                Bars-1-period;    where "period" is the number of bars on which the initial dJMA_series value is not 
                calculated;
  nJMA_limit  - number of uncounted bars plus one or the number of the last uncounted bar; it should always be 
                equal to Bars-IndicatorCounted()-1;
  nJMA_Length - depth of smoothing
  nJMA_Phase  - parameter that varies within the range -100 ... +100, impacts the transitional process quality;
  dJMA_series - Input parameter based on which the JJMASeries() function is calculated;
  nJMA_bar    - number of the calculated bar; the loop operator changes the parameter from the maximum value to 
                zero. That said, its maximum value should always be equal to the nJMA_limit parameter value!!!

  +------------------------------------+ <<< Output parameters >>> +-------------------------------------------------+

  JJMASeries()- dJMA_JMA function value.   If nJMA_bar is greater than nJMA_MaxBar-30 function JJMASeries() 
                always returns zero!!!
  nJMA_reset  - parameter that by reference returns the value different from 0, if an error occurred in the function calculation,
                0 - if the calculation was successful. This parameter can only be a variable but not a value!!!!
                 
  +-----------------------------------+ <<< Function initialization >>> +-----------------------------------------------+
  
  Before calling the JJMASeries() function, when the number of the counted bars is 0 (this is better done in the
  initialization block of a custom indicator or Expert Advisor), you should change the size of internal buffer
  variables of the function. For this purpose, you need to call the JJMASeries() function through the auxiliary
  JJMASeriesResize() function using the following parameters:   JJMASeriesResize(nJMA_number+1); the
  nJMA_number(MaxJMA_number) parameter should be made equal to the number of JJMASeries() function calls, i.e. one more than
  the maximum nJMA_number. 
  
  +--------------------------------------+ <<< Indication of errors >>> +-------------------------------------------------+
  
  When debugging indicators and EAs, their codes may contain errors the cause of which should be determined using the log
  file.  The JJMASeries() function writes all errors to the log file under \MetaTrader\EXPERTS\LOGS\. If before calling the
  JJMASeries() function, an MQL4 error occurs in the code preceding the function, the function will write the error code and description
  to the log file. If when executing the JJMASeries() function, an MQL4 error occurs in the JJMASeries() algorithm,
  the function will also write the code error and description to the log file. In case of incorrect setting of the
  JJMASeries() function call number, nJMA_number, or incorrectly determined size of buffer variables nJJMAResize_Size, the log file
  will contain the relevant messages regarding these parameters being incorrectly determined. The log file also contains information regarding the incorrectly
  determined nJMA_limit parameter.  If during execution of the initialization function init(), an error occurs when resizing
  buffer variables of the JJMASeries() function,  the JJMASeriesResize function will write the relevant information regarding
  the failure to resize buffer variables to the log file. If when calling the JJMASeries() function through an external loop
  operator, the correct sequence of the nJMA_bar parameter modification was disrupted, the log file will also contain
  the relevant information. It should be noted that some program code errors will give rise to further errors in the code execution,
  so if the JJMASeries() function adds several errors to the log around the same time, they should be fixed according
  to the time of their occurrence.  In a correctly written indicator the JJMASeries() function can add entries to the log file only
  in case of errors in the operating system work. The only exception is writing of changes in buffer variable sizes upon
  reloading an indicator or Expert Advisor at every init() function call. 
  
  +---------------------------------+ <<< Function call example >>> +--------------------------------------------+

//----+ determining the JJMASeries() functions
#include <JJMASeries.mqh>
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- determining the chart plotting style
SetIndexStyle (0,DRAW_LINE); 
//---- 1 indicator buffer used for calculation
SetIndexBuffer(0,Ind_Buffer);
//----+ Resizing buffer variables of the JJMASeries function, nJMA_number=1(One call of the JJMASeries function)
if(JJMASeriesResize(1)==0)return(-1);
return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator function                                        |
//+------------------------------------------------------------------+
int start()
{
//----+ Introducing integer variables and getting bars already counted
int reset,bar,MaxBar,limit,counted_bars=IndicatorCounted(); 
//---- check for possible errors
if (counted_bars<0)return(-1);
//---- the last counted bar should be recounted (without recounting, the JJMASeries() function will not proceed with its calculations!!!)
if (counted_bars>0) counted_bars--;
//---- determining the number of the oldest bar starting from which the new bars will be recounted
int limit=Bars-counted_bars-1;
MaxBar=Bars-1;
//----+ 
for(bar=limit;bar>=0;bar--)
 (
  double Series=Close[bar];
  //----+ Calling the JJMASeries() function under number 0 for the Ind_Buffer[] buffer calculation, 
  //the nJMA_Phase and nJMA_Length parameters do not change on every bar (nJMA_din=0)
  double Resalt=JJMASeries(0,0,MaxBar,limit,Phase,Length,Series,bar,reset);
  if (reset!=0)return(-1);
  Ind_Buffer[bar]=Resalt;
 }
return(0);
}
//----+ 

  */
//+X================================================================X+
//|  JJMASeries() function                                           |
//+X================================================================X+  

//----++ <<< Declaration of global variables >>> +-----------------------------------------------------------------+
double dJMA_f18[1],dJMA_f38[1],dJMA_fA8[1],dJMA_fC0[1],dJMA_fC8[1],dJMA_s8[1],dJMA_s18[1],dJMA_v1[1],dJMA_v2[1];
double dJMA_v3[1],dJMA_f90[1],dJMA_f78[1],dJMA_f88[1],dJMA_f98[1],dJMA_JMA[1],dJMA_list[1][128],dJMA_ring1[1][128];
double dJMA_ring2[1][11],dJMA_buffer[1][62],dJMA_mem1[1][8],dJMA_mem3[1][128],dJMA_RING1[1][128],dJMA_RING2[1][11];
double dJMA_LIST[1][128],dJMA_Kg[1],dJMA_Pf[1];
//--+
int    nJMA_s28[1],nJMA_s30[1],nJMA_s38[1],nJMA_s40[1],nJMA_s48[1],nJMA_f0[1],nJMA_s50[1],nJMA_s70[1],nJMA_LP2[1];
int    nJMA_LP1[1],nJMA_mem2[1][7],nJMA_mem7[1][11];
int    nJMA_TIME[1];
//--+ +-------------------------------------------------------------------------------------------------------------+
double dJMA_fA0,dJMA_vv,dJMA_v4,dJMA_f70,dJMA_s20,dJMA_s10,dJMA_fB0,dJMA_fD0,dJMA_f8,dJMA_f60,dJMA_f20,dJMA_f28;
double dJMA_f30,dJMA_f40,dJMA_f48,dJMA_f58,dJMA_f68;
//--+
int    nJMA_v5,nJMA_v6,nJMA_fE0,nJMA_fD8,nJMA_fE8,nJMA_val,nJMA_s58,nJMA_s60,nJMA_s68,nJMA_aa,nJMA_size;
int    nJMA_ii,nJMA_jj,nJMA_m,nJMA_n,nJMA_Tnew,nJMA_Told,nJMA_Error,nJMA_Resize;
//----++ <<< Declaration of the JJMASeries() function >>> +--------------------------------------+

double JJMASeries
(
 int nJMA_number,int nJMA_din,int nJMA_MaxBar,int nJMA_limit,
 int nJMA_Phase,int nJMA_Length,double dJMA_series,int nJMA_bar,int &nJMA_reset
 )
//----++ +------------------------------------------------------------------------------+
  {
   nJMA_n=nJMA_number;

   nJMA_reset=1;
//=====+ <<< Checking for errors >>> --------------------------------+
   if(nJMA_bar==nJMA_limit)
     {
      //----++ checking for the JJMASeries() function initialization
      if(nJMA_Resize<1)
        {
         Print(StringConcatenate("JJMASeries number =",nJMA_n,
               ". Buffer variables have not been resized using the JJMASeriesResize() function"));
         if(nJMA_Resize==0)
            Print(StringConcatenate("JJMASeries number =",nJMA_n,
                  ". The JJMASeriesResize() function call should be added to the initialization block"));
         return(0.0);
        }
      //----++ checking for error in the execution of the program code preceding the JJMASeries() function
      nJMA_Error=GetLastError();
      if(nJMA_Error>4000)
        {
         Print(StringConcatenate("JJMASeries number =",nJMA_n,
               ". An error occurred in the code preceding the JJMASeries() function call number = ",nJMA_n," !!!"));

         Print(StringConcatenate("JJMASeries number =",nJMA_n+". ",JMA_ErrDescr(nJMA_Error)));
        }

      //----++ checking for error in setting the nJMA_number and nJMAResize_Number variables
      nJMA_size=ArraySize(dJMA_JMA);
      if(nJMA_size<nJMA_n)
        {
         Print(StringConcatenate("JJMASeries number =",nJMA_n,
               ". Error!!! Invalid value of nJMA_number=",
               nJMA_n," of the JJMASeries() function"));
         Print(StringConcatenate("JJMASeries number =",nJMA_n,
               ". Or invalid value of nJJMAResize_Size=",
               nJMA_size," of the JJMASeriesResize() function"));
         return(0.0);
        }
     }
//----++ checking for error in the sequence of nJMA_bar variable modifications
   if(nJMA_limit>=nJMA_MaxBar && nJMA_bar==0)
      if(nJMA_MaxBar>30 && nJMA_TIME[nJMA_n]==0)
         Print(StringConcatenate("JJMASeries number =",nJMA_n,
               ". Error!!! Invalid sequence of",
               " nJMA_bar parameter modifications by an external loop operator!!!"));
//----++ +----------------------------------------------------------------+ 
   if(nJMA_bar>nJMA_MaxBar){nJMA_reset=0; return(0.0);}
   if(nJMA_bar==nJMA_MaxBar || nJMA_din!=0)
     {
      //----++ <<< Calculation of coefficients  >>> +--------------------------------------------------+
      double nJMA_Dr,nJMA_Ds,nJMA_Dl;
      if(nJMA_Length<1.0000000002) nJMA_Dr=0.0000000001;
      else nJMA_Dr=(nJMA_Length-1.0)/2.0;
      if(nJMA_Phase>=-100 && nJMA_Phase<=100)dJMA_Pf[nJMA_n]=nJMA_Phase/100.0+1.5;
      if(nJMA_Phase>100) dJMA_Pf[nJMA_n]=2.5;
      if(nJMA_Phase<-100) dJMA_Pf[nJMA_n]=0.5;
      nJMA_Dr = nJMA_Dr * 0.9; dJMA_Kg[nJMA_n] = nJMA_Dr / (nJMA_Dr + 2.0);
      nJMA_Ds = MathSqrt(nJMA_Dr);
      nJMA_Dl = MathLog(nJMA_Ds);
      dJMA_v1[nJMA_n]= nJMA_Dl;
      dJMA_v2[nJMA_n]= dJMA_v1[nJMA_n];
      if(dJMA_v1[nJMA_n]/MathLog(2.0)+2.0<0.0) dJMA_v3[nJMA_n]=0.0;
      else dJMA_v3[nJMA_n]=(dJMA_v2[nJMA_n]/MathLog(2.0))+2.0;
      dJMA_f98[nJMA_n]=dJMA_v3[nJMA_n];
      if(dJMA_f98[nJMA_n] >= 2.5) dJMA_f88[nJMA_n] = dJMA_f98[nJMA_n] - 2.0;
      else dJMA_f88[nJMA_n]= 0.5;
      dJMA_f78[nJMA_n]= nJMA_Ds * dJMA_f98[nJMA_n];
      dJMA_f90[nJMA_n]= dJMA_f78[nJMA_n]/(dJMA_f78[nJMA_n]+1.0);
      //----++----------------------------------------------------------------------------------+
     }
//--+
   if(nJMA_bar==nJMA_limit && nJMA_limit<nJMA_MaxBar)
     {
      //----+ <<< Restoring values of variables >>> +----------------------------------------------------------------------------+
      nJMA_Tnew = Time[nJMA_limit + 1];
      nJMA_Told = nJMA_TIME[nJMA_n];
      //--+
      if(nJMA_Tnew==nJMA_Told)
        {
         for(nJMA_aa = 127; nJMA_aa >= 0; nJMA_aa--)dJMA_list [nJMA_n][nJMA_aa] = dJMA_LIST [nJMA_n][nJMA_aa];
         for(nJMA_aa = 127; nJMA_aa >= 0; nJMA_aa--)dJMA_ring1[nJMA_n][nJMA_aa] = dJMA_RING1[nJMA_n][nJMA_aa];
         for(nJMA_aa = 10;  nJMA_aa >= 0; nJMA_aa--)dJMA_ring2[nJMA_n][nJMA_aa] = dJMA_RING2[nJMA_n][nJMA_aa];
         //--+
         dJMA_fC0[nJMA_n] = dJMA_mem1[nJMA_n][00]; dJMA_fC8[nJMA_n] = dJMA_mem1[nJMA_n][01]; dJMA_fA8[nJMA_n] = dJMA_mem1[nJMA_n][02];
         dJMA_s8 [nJMA_n] = dJMA_mem1[nJMA_n][03]; dJMA_f18[nJMA_n] = dJMA_mem1[nJMA_n][04]; dJMA_f38[nJMA_n] = dJMA_mem1[nJMA_n][05];
         dJMA_s18[nJMA_n] = dJMA_mem1[nJMA_n][06]; dJMA_JMA[nJMA_n] = dJMA_mem1[nJMA_n][07]; nJMA_s38[nJMA_n] = nJMA_mem2[nJMA_n][00];
         nJMA_s48[nJMA_n] = nJMA_mem2[nJMA_n][01]; nJMA_s50[nJMA_n] = nJMA_mem2[nJMA_n][02]; nJMA_LP1[nJMA_n] = nJMA_mem2[nJMA_n][03];
         nJMA_LP2[nJMA_n] = nJMA_mem2[nJMA_n][04]; nJMA_s40[nJMA_n] = nJMA_mem2[nJMA_n][05]; nJMA_s70[nJMA_n] = nJMA_mem2[nJMA_n][06];
        }
      //--+ checking for errors
      if(nJMA_Tnew!=nJMA_Told)
        {
         nJMA_reset=-1;
         //--+ indication of error in the calculation of the nJMA_limit input parameter of the JJMASeries() function
         if(nJMA_Tnew>nJMA_Told)
           {
            Print(StringConcatenate("JJMASeries number =",nJMA_n,
                  ". Error!!! The nJMA_limit parameter of the JJMASeries() function is less than required"));
           }
         else
           {
            int nJMA_LimitERROR=nJMA_limit+1-iBarShift(NULL,0,nJMA_Told,TRUE);

            Print(StringConcatenate("JMASerries number =",nJMA_n,
                  ". Error!!! The nJMA_limit parameter of the JJMASeries() function is greater than required by ",
                  nJMA_LimitERROR,""));
           }
         //--+ Return through nJMA_reset=-1; JJMASeries function calculation errors
         return(0);
        }
      //----+--------------------------------------------------------------------------------------------------------------------------+
     }
   if(nJMA_bar==1)
      if(nJMA_limit!=1 || Time[nJMA_limit+2]==nJMA_TIME[nJMA_n])
        {
         //--+ <<< Saving values of variables >>> +-------------------------------------------------------------------------------+
         for(nJMA_aa = 127; nJMA_aa >= 0; nJMA_aa--)dJMA_LIST [nJMA_n][nJMA_aa] = dJMA_list [nJMA_n][nJMA_aa];
         for(nJMA_aa = 127; nJMA_aa >= 0; nJMA_aa--)dJMA_RING1[nJMA_n][nJMA_aa] = dJMA_ring1[nJMA_n][nJMA_aa];
         for(nJMA_aa = 10;  nJMA_aa >= 0; nJMA_aa--)dJMA_RING2[nJMA_n][nJMA_aa] = dJMA_ring2[nJMA_n][nJMA_aa];
         //--+
         dJMA_mem1[nJMA_n][00] = dJMA_fC0[nJMA_n]; dJMA_mem1[nJMA_n][01] = dJMA_fC8[nJMA_n]; dJMA_mem1[nJMA_n][02] = dJMA_fA8[nJMA_n];
         dJMA_mem1[nJMA_n][03] = dJMA_s8 [nJMA_n]; dJMA_mem1[nJMA_n][04] = dJMA_f18[nJMA_n]; dJMA_mem1[nJMA_n][05] = dJMA_f38[nJMA_n];
         dJMA_mem1[nJMA_n][06] = dJMA_s18[nJMA_n]; dJMA_mem1[nJMA_n][07] = dJMA_JMA[nJMA_n]; nJMA_mem2[nJMA_n][00] = nJMA_s38[nJMA_n];
         nJMA_mem2[nJMA_n][01] = nJMA_s48[nJMA_n]; nJMA_mem2[nJMA_n][02] = nJMA_s50[nJMA_n]; nJMA_mem2[nJMA_n][03] = nJMA_LP1[nJMA_n];
         nJMA_mem2[nJMA_n][04] = nJMA_LP2[nJMA_n]; nJMA_mem2[nJMA_n][05] = nJMA_s40[nJMA_n]; nJMA_mem2[nJMA_n][06] = nJMA_s70[nJMA_n];
         nJMA_TIME[nJMA_n]=Time[2];
         //--+-------------------------------------------------------------------------------------------------------------------------+
        }
//----+
   if(nJMA_LP1[nJMA_n]<61){nJMA_LP1[nJMA_n]++; dJMA_buffer[nJMA_n][nJMA_LP1[nJMA_n]]=dJMA_series;}
   if(nJMA_LP1[nJMA_n]>30)
     {
      //++++++++++++++++++
      if(nJMA_f0[nJMA_n]!=0)
        {
         nJMA_f0[nJMA_n]=0;
         nJMA_v5=1;
         nJMA_fD8=nJMA_v5*30;
         if(nJMA_fD8==0) dJMA_f38[nJMA_n]=dJMA_series; else dJMA_f38[nJMA_n]=dJMA_buffer[nJMA_n][1];
         dJMA_f18[nJMA_n]=dJMA_f38[nJMA_n];
         if(nJMA_fD8>29) nJMA_fD8=29;
        }
      else nJMA_fD8=0;
      for(nJMA_ii=nJMA_fD8; nJMA_ii>=0; nJMA_ii--)
        {
         nJMA_val=31-nJMA_ii;
         if(nJMA_ii==0) dJMA_f8=dJMA_series; else dJMA_f8=dJMA_buffer[nJMA_n][nJMA_val];
         dJMA_f28=dJMA_f8-dJMA_f18[nJMA_n]; dJMA_f48=dJMA_f8-dJMA_f38[nJMA_n];
         if(MathAbs(dJMA_f28)>MathAbs(dJMA_f48)) dJMA_v2[nJMA_n]=MathAbs(dJMA_f28); else dJMA_v2[nJMA_n]=MathAbs(dJMA_f48);
         dJMA_fA0=dJMA_v2[nJMA_n]; dJMA_vv=dJMA_fA0+0.0000000001; //{1.0e-10;}
         if(nJMA_s48[nJMA_n] <= 1) nJMA_s48[nJMA_n] = 127; else nJMA_s48[nJMA_n] = nJMA_s48[nJMA_n] - 1;
         if(nJMA_s50[nJMA_n] <= 1) nJMA_s50[nJMA_n] = 10;  else nJMA_s50[nJMA_n] = nJMA_s50[nJMA_n] - 1;
         if(nJMA_s70[nJMA_n]<128) nJMA_s70[nJMA_n]=nJMA_s70[nJMA_n]+1;
         dJMA_s8[nJMA_n]=dJMA_s8[nJMA_n]+dJMA_vv-dJMA_ring2[nJMA_n][nJMA_s50[nJMA_n]];
         dJMA_ring2[nJMA_n][nJMA_s50[nJMA_n]]=dJMA_vv;
         if(nJMA_s70[nJMA_n]>10) dJMA_s20=dJMA_s8[nJMA_n]/10.0; else dJMA_s20=dJMA_s8[nJMA_n]/nJMA_s70[nJMA_n];
         if(nJMA_s70[nJMA_n]>127)
           {
            dJMA_s10=dJMA_ring1[nJMA_n][nJMA_s48[nJMA_n]];
            dJMA_ring1[nJMA_n][nJMA_s48[nJMA_n]]=dJMA_s20; nJMA_s68=64; nJMA_s58=nJMA_s68;
            while(nJMA_s68>1)
              {
               if(dJMA_list[nJMA_n][nJMA_s58]<dJMA_s10){nJMA_s68=nJMA_s68 *0.5; nJMA_s58=nJMA_s58+nJMA_s68;}
               else
               if(dJMA_list[nJMA_n][nJMA_s58]<=dJMA_s10) nJMA_s68=1; else{nJMA_s68=nJMA_s68 *0.5; nJMA_s58=nJMA_s58-nJMA_s68;}
              }
           }
         else
           {
            dJMA_ring1[nJMA_n][nJMA_s48[nJMA_n]]=dJMA_s20;
            if(nJMA_s28[nJMA_n]+nJMA_s30[nJMA_n]>127){nJMA_s30[nJMA_n]=nJMA_s30[nJMA_n]-1; nJMA_s58=nJMA_s30[nJMA_n];}
            else{nJMA_s28[nJMA_n]=nJMA_s28[nJMA_n]+1; nJMA_s58=nJMA_s28[nJMA_n];}
            if(nJMA_s28[nJMA_n] > 96) nJMA_s38[nJMA_n] = 96; else nJMA_s38[nJMA_n] = nJMA_s28[nJMA_n];
            if(nJMA_s30[nJMA_n] < 32) nJMA_s40[nJMA_n] = 32; else nJMA_s40[nJMA_n] = nJMA_s30[nJMA_n];
           }
         nJMA_s68=64; nJMA_s60=nJMA_s68;
         while(nJMA_s68>1)
           {
            if(dJMA_list[nJMA_n][nJMA_s60]>=dJMA_s20)
              {
               if(dJMA_list[nJMA_n][nJMA_s60-1]<=dJMA_s20) nJMA_s68=1; else {nJMA_s68=nJMA_s68 *0.5; nJMA_s60=nJMA_s60-nJMA_s68; }
              }
            else{nJMA_s68=nJMA_s68 *0.5; nJMA_s60=nJMA_s60+nJMA_s68;}
            if((nJMA_s60 == 127) &&(dJMA_s20>dJMA_list[nJMA_n][127])) nJMA_s60 = 128;
           }
         if(nJMA_s70[nJMA_n]>127)
           {
            if(nJMA_s58>=nJMA_s60)
              {
               if((nJMA_s38[nJMA_n]+1>nJMA_s60) && (nJMA_s40[nJMA_n]-1<nJMA_s60)) dJMA_s18[nJMA_n]=dJMA_s18[nJMA_n]+dJMA_s20;
               else
               if((nJMA_s40[nJMA_n]+0>nJMA_s60) && (nJMA_s40[nJMA_n]-1<nJMA_s58)) dJMA_s18[nJMA_n]
                  =dJMA_s18[nJMA_n]+dJMA_list[nJMA_n][nJMA_s40[nJMA_n]-1];
              }
            else
            if(nJMA_s40[nJMA_n]>=nJMA_s60) 
              {
               if((nJMA_s38[nJMA_n]+1<nJMA_s60) && (nJMA_s38[nJMA_n]+1>nJMA_s58)) dJMA_s18[nJMA_n]
                  =dJMA_s18[nJMA_n]+dJMA_list[nJMA_n][nJMA_s38[nJMA_n]+1]; 
              }
            else if(nJMA_s38[nJMA_n]+2>nJMA_s60) dJMA_s18[nJMA_n]=dJMA_s18[nJMA_n]+dJMA_s20;
            else if((nJMA_s38[nJMA_n]+1<nJMA_s60) && (nJMA_s38[nJMA_n]+1>nJMA_s58)) dJMA_s18[nJMA_n]
               =dJMA_s18[nJMA_n]+dJMA_list[nJMA_n][nJMA_s38[nJMA_n]+1];
            if(nJMA_s58>nJMA_s60)
              {
               if((nJMA_s40[nJMA_n]-1<nJMA_s58) && (nJMA_s38[nJMA_n]+1>nJMA_s58)) dJMA_s18[nJMA_n]=dJMA_s18[nJMA_n]-dJMA_list[nJMA_n][nJMA_s58];
               else
                  if((nJMA_s38[nJMA_n]<nJMA_s58) && (nJMA_s38[nJMA_n]+1>nJMA_s60)) dJMA_s18[nJMA_n]=dJMA_s18[nJMA_n]-dJMA_list[nJMA_n][nJMA_s38[nJMA_n]];
              }
            else
              {
               if((nJMA_s38[nJMA_n]+1>nJMA_s58) && (nJMA_s40[nJMA_n]-1<nJMA_s58)) dJMA_s18[nJMA_n]=dJMA_s18[nJMA_n]-dJMA_list[nJMA_n][nJMA_s58];
               else
                  if((nJMA_s40[nJMA_n]+0>nJMA_s58) && (nJMA_s40[nJMA_n]-0<nJMA_s60)) dJMA_s18[nJMA_n]=dJMA_s18[nJMA_n]-dJMA_list[nJMA_n][nJMA_s40[nJMA_n]];
              }
           }
         if(nJMA_s58<=nJMA_s60)
           {
            if(nJMA_s58>=nJMA_s60)
              {
               dJMA_list[nJMA_n][nJMA_s60]=dJMA_s20;
              }
            else
              {
               for(nJMA_jj=nJMA_s58+1; nJMA_jj<=nJMA_s60-1;nJMA_jj++)dJMA_list[nJMA_n][nJMA_jj-1]=dJMA_list[nJMA_n][nJMA_jj];
               dJMA_list[nJMA_n][nJMA_s60-1]=dJMA_s20;
              }
           }
         else
           {
            for(nJMA_jj=nJMA_s58-1; nJMA_jj>=nJMA_s60;nJMA_jj--) dJMA_list[nJMA_n][nJMA_jj+1]=dJMA_list[nJMA_n][nJMA_jj];
            dJMA_list[nJMA_n][nJMA_s60]=dJMA_s20;
           }
         if(nJMA_s70[nJMA_n]<=127)
           {
            dJMA_s18[nJMA_n]=0;
            for(nJMA_jj=nJMA_s40[nJMA_n]; nJMA_jj<=nJMA_s38[nJMA_n];nJMA_jj++) dJMA_s18[nJMA_n]=dJMA_s18[nJMA_n]+dJMA_list[nJMA_n][nJMA_jj];
           }
         dJMA_f60=dJMA_s18[nJMA_n]/(nJMA_s38[nJMA_n]-nJMA_s40[nJMA_n]+1.0);
         if(nJMA_LP2[nJMA_n]+1>31) nJMA_LP2[nJMA_n]=31; else nJMA_LP2[nJMA_n]=nJMA_LP2[nJMA_n]+1;
         if(nJMA_LP2[nJMA_n]<=30)
           {
            if(dJMA_f28 > 0.0) dJMA_f18[nJMA_n] = dJMA_f8; else dJMA_f18[nJMA_n] = dJMA_f8 - dJMA_f28 * dJMA_f90[nJMA_n];
            if(dJMA_f48 < 0.0) dJMA_f38[nJMA_n] = dJMA_f8; else dJMA_f38[nJMA_n] = dJMA_f8 - dJMA_f48 * dJMA_f90[nJMA_n];
            dJMA_JMA[nJMA_n]=dJMA_series;
            if(nJMA_LP2[nJMA_n]!=30) continue;
            if(nJMA_LP2[nJMA_n]==30)
              {
               dJMA_fC0[nJMA_n]=dJMA_series;
               if(MathCeil(dJMA_f78[nJMA_n])>=1) dJMA_v4=MathCeil(dJMA_f78[nJMA_n]); else dJMA_v4=1.0;

               if(dJMA_v4>0)nJMA_fE8=MathFloor(dJMA_v4);else{if(dJMA_v4<0)nJMA_fE8=MathCeil(dJMA_v4);else nJMA_fE8=0.0;}

               if(MathFloor(dJMA_f78[nJMA_n])>=1) dJMA_v2[nJMA_n]=MathFloor(dJMA_f78[nJMA_n]); else dJMA_v2[nJMA_n]=1.0;

               if(dJMA_v2[nJMA_n]>0)nJMA_fE0=MathFloor(dJMA_v2[nJMA_n]);else{if(dJMA_v2[nJMA_n]<0)nJMA_fE0=MathCeil(dJMA_v2[nJMA_n]);else nJMA_fE0=0.0;}

               if(nJMA_fE8==nJMA_fE0) dJMA_f68=1.0; else {dJMA_v4=nJMA_fE8-nJMA_fE0; dJMA_f68=(dJMA_f78[nJMA_n]-nJMA_fE0)/dJMA_v4;}
               if(nJMA_fE0 <= 29) nJMA_v5 = nJMA_fE0; else nJMA_v5 = 29;
               if(nJMA_fE8 <= 29) nJMA_v6 = nJMA_fE8; else nJMA_v6 = 29;
               dJMA_fA8[nJMA_n]=(dJMA_series-dJMA_buffer[nJMA_n][nJMA_LP1[nJMA_n]-nJMA_v5]) *(1.0-dJMA_f68)/nJMA_fE0+(dJMA_series
                                 -dJMA_buffer[nJMA_n][nJMA_LP1[nJMA_n]-nJMA_v6])*dJMA_f68/nJMA_fE8;
              }
           }
         else
           {
            if(dJMA_f98[nJMA_n] >= MathPow(dJMA_fA0/dJMA_f60, dJMA_f88[nJMA_n])) dJMA_v1[nJMA_n] = MathPow(dJMA_fA0/dJMA_f60, dJMA_f88[nJMA_n]);
            else dJMA_v1[nJMA_n] = dJMA_f98[nJMA_n];
            if(dJMA_v1[nJMA_n]<1.0) dJMA_v2[nJMA_n]=1.0;
            else
              {
               if(dJMA_f98[nJMA_n]>=MathPow(dJMA_fA0/dJMA_f60,dJMA_f88[nJMA_n])) dJMA_v3[nJMA_n]=MathPow(dJMA_fA0/dJMA_f60,dJMA_f88[nJMA_n]);
               else dJMA_v3[nJMA_n]=dJMA_f98[nJMA_n]; dJMA_v2[nJMA_n]=dJMA_v3[nJMA_n];
              }
            dJMA_f58=dJMA_v2[nJMA_n]; dJMA_f70=MathPow(dJMA_f90[nJMA_n],MathSqrt(dJMA_f58));
            if(dJMA_f28 > 0.0) dJMA_f18[nJMA_n] = dJMA_f8; else dJMA_f18[nJMA_n] = dJMA_f8 - dJMA_f28 * dJMA_f70;
            if(dJMA_f48 < 0.0) dJMA_f38[nJMA_n] = dJMA_f8; else dJMA_f38[nJMA_n] = dJMA_f8 - dJMA_f48 * dJMA_f70;
           }
        }
      if(nJMA_LP2[nJMA_n]>30)
        {
         dJMA_f30=MathPow(dJMA_Kg[nJMA_n],dJMA_f58);
         dJMA_fC0[nJMA_n] =(1.0 - dJMA_f30) * dJMA_series + dJMA_f30 * dJMA_fC0[nJMA_n];
         dJMA_fC8[nJMA_n] =(dJMA_series - dJMA_fC0[nJMA_n]) * (1.0 - dJMA_Kg[nJMA_n]) + dJMA_Kg[nJMA_n] * dJMA_fC8[nJMA_n];
         dJMA_fD0 = dJMA_Pf[nJMA_n] * dJMA_fC8[nJMA_n] + dJMA_fC0[nJMA_n];
         dJMA_f20 = dJMA_f30 *(-2.0);
         dJMA_f40 = dJMA_f30 * dJMA_f30;
         dJMA_fB0 = dJMA_f20 + dJMA_f40 + 1.0;
         dJMA_fA8[nJMA_n] =(dJMA_fD0 - dJMA_JMA[nJMA_n]) * dJMA_fB0 + dJMA_f40 * dJMA_fA8[nJMA_n];
         dJMA_JMA[nJMA_n] = dJMA_JMA[nJMA_n] + dJMA_fA8[nJMA_n];
        }
     }
//++++++++++++++++++
   if(nJMA_LP1[nJMA_n]<=30)dJMA_JMA[nJMA_n]=0.0;
//----+ 

//----++ checking for error in the execution of the JJMASeries() function code
   nJMA_Error=GetLastError();
   if(nJMA_Error>4000)
     {
      Print(StringConcatenate("JJMASeries number =",nJMA_n,
            ". Error when executing the JJMASeries() function!!!"));

      Print(StringConcatenate("JJMASeries number =",
            nJMA_n,". ",JMA_ErrDescr(nJMA_Error)));
      return(0.0);
     }

   nJMA_reset=0;
   return(dJMA_JMA[nJMA_n]);
//----+  End of JJMASeries() function calculations
  }
//+X================================================================X+
//| JJMASeriesResize() function                                      |
//+X================================================================X+
// JJMASeriesResize is an additional function for resizing       |
// and initialization of buffer variables of the JJMASeries function.   |
// Call example: JJMASeriesResize(5); where 5 is the number     |
// of calls of JJMASeries() in the text of the indicator. This call     |
// of the JJMASeriesResize function should be added                       |
// to the initialization block of a custom indicator or EA    |                         
//+X================================================================X+
int JJMASeriesResize(int nJJMAResize_Size)
  {
//----+
   if(nJJMAResize_Size<1)
     {
      Print("JJMASeriesResize: Error!!! The nJJMAResize_Size parameter cannot be less than 1!!!");
      nJMA_Resize=-1;
      return(0);
     }
   int nJJMAResize_reset,nJJMAResize_cycle;
//--+
   while(nJJMAResize_cycle==0)
     {
      //----++ <<< resizing buffer variables >>> +------------------------+
      if(ArrayResize(dJMA_list,  nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA_ring1, nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA_ring2, nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA_buffer,nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA_mem1,  nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(nJMA_mem2,  nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(nJMA_mem7,  nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA_mem3,  nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA_LIST,  nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA_RING1, nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA_RING2, nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA_Kg,    nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA_Pf,    nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA_f18,   nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA_f38,   nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA_fA8,   nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA_fC0,   nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA_fC8,   nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA_s8,    nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA_s18,   nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA_JMA,   nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(nJMA_s50,   nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(nJMA_s70,   nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(nJMA_LP2,   nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(nJMA_LP1,   nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(nJMA_s38,   nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(nJMA_s40,   nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(nJMA_s48,   nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA_v1,    nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA_v2,    nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA_v3,    nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA_f90,   nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA_f78,   nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA_f88,   nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(dJMA_f98,   nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(nJMA_s28,   nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(nJMA_s30,   nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(nJMA_f0,    nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      if(ArrayResize(nJMA_TIME,  nJJMAResize_Size) == 0){nJJMAResize_reset = -1; break;}
      //+------------------------------------------------------------------------------+
      nJJMAResize_cycle=1;
     }
//--+
   if(nJJMAResize_reset==-1)
     {
      Print(StringConcatenate("JJMASeriesResize: Error!!! Failed ",
            "to resize buffer variables of the JJMASeries() function."));

      int nJJMAResize_Error=GetLastError();
      if(nJJMAResize_Error>4000)
         Print(StringConcatenate("JJMASeriesResize(): ",
               JMA_ErrDescr(nJJMAResize_Error)));
      nJMA_Resize=-2;
      return(0);
     }
   else
     {
      Print(StringConcatenate
            ("JJMASeriesResize: JJMASeries()size = ",
            nJJMAResize_Size,""));

      //----+-----------------------------------------------------+
      ArrayInitialize(nJMA_f0,1);
      ArrayInitialize(nJMA_s28,63);
      ArrayInitialize(nJMA_s30,64);
      for(int rrr=0; rrr<nJJMAResize_Size; rrr++)
        {
         for(int kkk=0; kkk<=nJMA_s28[rrr]; kkk++)
            dJMA_list[rrr][kkk]=-1000000.0;

         for(kkk=nJMA_s30[rrr]; kkk<=127; kkk++)
            dJMA_list[rrr][kkk]=+1000000.0;
        }
      //----+-----------------------------------------------------+
      nJMA_Resize=nJJMAResize_Size;
      return(nJJMAResize_Size);
     }
//----+
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
/*
//+X================================================================X+
//| JJMASeries1Alert() function                                      |
//+X================================================================X+
/*                                                                   |
 JJMASeriesAlert is an additional function for indication   |
 of error when setting nJMA external variables. Length and nJMA_Phase     |
 of the JJMASeries() function.                                               |
  ----------------------- input parameters  ------------------------| 
 Number                                                              |
 ExternVar - value of the external variable for the nJMA_Length parameter  | 
 name - name of the external variable for the nJMA_Phase parameter if        |
 Number = 0 or nJMA_Phase if Number = 1.                         |
  -------------------------- Application example  ------------------|
  int init()                                                         |
  //----                                                             |
  Some initialization of variables and buffers can be here                  |
                                                                     |                                                                                               
  //---- setting alerts for                                        |
                //invalid values of external variables           |
  JJMASeriesAlert(0, "Length1", Length1);                            |
  JJMASeriesAlert(0, "Length2", Length2);                            |
  JJMASeriesAlert(1, "Phase1", Phase1);                              |                                                            
  JJMASeriesAlert(1, "Phase2", Phase2);                              |                                                          
  //---- initialization complete                                    |
  return(0);                                                         |
 }                                                                   |
//+X================================================================X+
*/
void JJMASeriesAlert(int Number,string name,int ExternVar)
  {
//----+
//---- setting alerts for invalid values of input parameters 
   switch(Number)
     {
      case 0:
         if(ExternVar<1)
         Print(StringConcatenate
               ("The ",name," parameter must not be less than 1",
               " You have entered invalid ",ExternVar,
               " the value of 1 will be used"));
         break;
         //----
      case 1:
         if(ExternVar<-100 || ExternVar>100)
         Print(StringConcatenate
               ("The ",name," parameter must be from -100 to +100",
               " You have entered invalid ",ExternVar,
               " the value of -100 will be used"));
         break;
         //----  
      default:
         Print(StringConcatenate
               ("The Number parameter can only be equal to 0 and 1",
               " You have entered invalid ",Number,"!!!"));
     }
//----+
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
/*
Russian translation provided by Nikolay Kositsin, 01.12.2006  
//+X================================================================X+
                                          JMA_ErrDescr(MQL4_RUS).mqh |
                         Copyright  2004, MetaQuotes Software Corp. |
                                          http://www.metaquotes.net/ |
//+X================================================================X+
 by the MQL4 error code the JMA_ErrDescr() function returns the string    |
 containing the error code and description.                                |
                                                                     |
  -------------------- Application example  ----------------------- | 
 int Error = GetLastError();                                         |
 if (Error > 4000) Print(JMA_ErrDescr(Error));                       |
//+X----------------------------------------------------------------X+
*/
string JMA_ErrDescr(int error_code)
  {
   string error_string;
//----
   switch(error_code)
     {
      //---- MQL4 errors 
      case 4000: error_string = StringConcatenate("Error code = ",error_code,". no errors");                                              break;
      case 4001: error_string = StringConcatenate("Error code = ",error_code,". Wrong function pointer");                          break;
      case 4002: error_string = StringConcatenate("Error code = ",error_code,". Array index is out of range");             break;
      case 4003: error_string = StringConcatenate("Error code = ",error_code,". No memory for function call stack");                            break;
      case 4004: error_string = StringConcatenate("Error code = ",error_code,". Recursive stack overflow");            break;
      case 4005: error_string = StringConcatenate("Error code = ",error_code,". Not enough stack for parameter");             break;
      case 4006: error_string = StringConcatenate("Error code = ",error_code,". No memory for string parameter");                     break;
      case 4007: error_string = StringConcatenate("Error code = ",error_code,". No memory for temp string");                         break;
      case 4008: error_string = StringConcatenate("Error code = ",error_code,". Uninitialized string");                             break;
      case 4009: error_string = StringConcatenate("Error code = ",error_code,". Uninitialized string in array");                   break;
      case 4010: error_string = StringConcatenate("Error code = ",error_code,". No memory for string array");                       break;
      case 4011: error_string = StringConcatenate("Error code = ",error_code,". String too long");                                  break;
      case 4012: error_string = StringConcatenate("Error code = ",error_code,". Remainder from zero divide");                              break;
      case 4013: error_string = StringConcatenate("Error code = ",error_code,". Zero divide");                                         break;
      case 4014: error_string = StringConcatenate("Error code = ",error_code,". Unknown command");                                     break;
      case 4015: error_string = StringConcatenate("Error code = ",error_code,". Wrong jump (never generated error)");            break;
      case 4016: error_string = StringConcatenate("Error code = ",error_code,". Uninitialized array");                             break;
      case 4017: error_string = StringConcatenate("Error code = ",error_code,". DLL calls are not allowed");                                 break;
      case 4018: error_string = StringConcatenate("Error code = ",error_code,". Cannot load the library");                         break;
      case 4019: error_string = StringConcatenate("Error code = ",error_code,". Cannot call the function");                              break;
      case 4020: error_string = StringConcatenate("Error code = ",error_code,". Calls of external library functions are not allowed");        break;
      case 4021: error_string = StringConcatenate("Error code = ",error_code,". Not enough memory for returned string"); break;
      case 4022: error_string = StringConcatenate("Error code = ",error_code,". System is busy (never generated error)");                  break;
      case 4050: error_string = StringConcatenate("Error code = ",error_code,". Invalid number of function parameters");              break;
      case 4051: error_string = StringConcatenate("Error code = ",error_code,". Invalid function parameter value");                 break;
      case 4052: error_string = StringConcatenate("Error code = ",error_code,". String function internal error");                     break;
      case 4053: error_string = StringConcatenate("Error code = ",error_code,". Array error");                                          break;
      case 4054: error_string = StringConcatenate("Error code = ",error_code,". Incorrect use of time series array");            break;
      case 4055: error_string = StringConcatenate("Error code = ",error_code,". Custom indicator error");                     break;
      case 4056: error_string = StringConcatenate("Error code = ",error_code,". Incompatible arrays");                                    break;
      case 4057: error_string = StringConcatenate("Error code = ",error_code,". Global variable processing error");                 break;
      case 4058: error_string = StringConcatenate("Error code = ",error_code,". Global variable not found");                     break;
      case 4059: error_string = StringConcatenate("Error code = ",error_code,". Function is not allowed in testing mode");                  break;
      case 4060: error_string = StringConcatenate("Error code = ",error_code,". Function is not confirmed");                                 break;
      case 4061: error_string = StringConcatenate("Error code = ",error_code,".\ Mail sending error");                                   break;
      case 4062: error_string = StringConcatenate("Error code = ",error_code,". String parameter expected");                          break;
      case 4063: error_string = StringConcatenate("Error code = ",error_code,". Integer parameter expected");                         break;
      case 4064: error_string = StringConcatenate("Error code = ",error_code,". Double parameter expected");                          break;
      case 4065: error_string = StringConcatenate("Error code = ",error_code,". Array expected as parameter");                   break;
      case 4066: error_string = StringConcatenate("Error code = ",error_code,". Requested history data are being updated");  break;
      case 4067: error_string = StringConcatenate("Error code = ",error_code,". Error when executing trading operation");                 break;
      case 4099: error_string = StringConcatenate("Error code = ",error_code,". End of file");                                             break;
      case 4100: error_string = StringConcatenate("Error code = ",error_code,". Error when working with file");                              break;
      case 4101: error_string = StringConcatenate("Error code = ",error_code,". Wrong file name");                                  break;
      case 4102: error_string = StringConcatenate("Error code = ",error_code,". Too many open files");                           break;
      case 4103: error_string = StringConcatenate("Error code = ",error_code,". Cannot open the file");                                 break;
      case 4104: error_string = StringConcatenate("Error code = ",error_code,". Incompatible file access mode");                     break;
      case 4105: error_string = StringConcatenate("Error code = ",error_code,". No order selected");                                 break;
      case 4106: error_string = StringConcatenate("Error code = ",error_code,". Unknown symbol");                                      break;
      case 4107: error_string = StringConcatenate("Error code = ",error_code,". Invalid price parameter for trading function");         break;
      case 4108: error_string = StringConcatenate("Error code = ",error_code,". Invalid ticket number");                                   break;
      case 4109: error_string = StringConcatenate("Error code = ",error_code,". Trade is not allowed");                                   break;
      case 4110: error_string = StringConcatenate("Error code = ",error_code,". Long positions are not allowed");                            break;
      case 4111: error_string = StringConcatenate("Error code = ",error_code,". Short positions are not allowed");                           break;
      case 4200: error_string = StringConcatenate("Error code = ",error_code,". Object already exists");                                   break;
      case 4201: error_string = StringConcatenate("Error code = ",error_code,". Unknown object property requested");                  break;
      case 4202: error_string = StringConcatenate("Error code = ",error_code,". Object does not exist");                                    break;
      case 4203: error_string = StringConcatenate("Error code = ",error_code,". Unknown object type");                                 break;
      case 4204: error_string = StringConcatenate("Error code = ",error_code,". No object name");                                       break;
      case 4205: error_string = StringConcatenate("Error code = ",error_code,". Object coordinates error");                                break;
      case 4206: error_string = StringConcatenate("Error code = ",error_code,". The specified subwindow cannot be found");                            break;
      case 4207: error_string = StringConcatenate("Error code = ",error_code,". Error when working with the object");                            break;
      default:   error_string = StringConcatenate("Error code = ",error_code,". unknown error");
     }
//----
   return(error_string);
  }
//+------------------------------------------------------------------+
