package Calendar;
/* INSTRUCTION: This is a command line application. So please execute this template with the following arguments:

		arg[0] = username
		arg[1] = password
*/
import com.google.gdata.client.GoogleService;
import com.google.gdata.client.Query;
import com.google.gdata.client.calendar.CalendarService;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.PlainTextConstruct;
import com.google.gdata.data.calendar.CalendarEntry;
import com.google.gdata.data.calendar.CalendarEventEntry;
import com.google.gdata.data.calendar.CalendarEventFeed;
import com.google.gdata.data.calendar.CalendarFeed;
import com.google.gdata.data.extensions.Reminder;
import com.google.gdata.data.extensions.When;
import com.google.gdata.data.extensions.Reminder.Method;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ServiceException;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

  public class Calendar {
    
	public static void main(String[] args) {
    	
    	try {
	    	//--- EXTERNAL VARIABLES ----------------------------
		  	String alertTxt       	= args[2];
		  	String reanimationTxt 	= args[3];
		  	String stopSMS			= args[4];
		  	int timePeriod 			= Integer.parseInt(args[5]);	// interval in minutes at which the terminal will get connected
		  	int mode                = Integer.parseInt(args[6]);
		  	int startHour 			= Integer.parseInt(args[7]);
		  	int startMin 			= Integer.parseInt(args[8]);
			//---------------------------------------------------
			//--- INTERNAL VARIABLES --------------------------
		  	URL feedUrl 			= new URL("http://www.google.com/calendar/feeds/default/private/full");
		  	                               	//link for working with events
		  	URL calendarUrl 		= new URL("http://www.google.com/calendar/feeds/default/allcalendars/full");
		  									//link for working with calendars  	
			//---------------------------------------------------
		  	System.out.println(">>----------  Start   ----------<<");
		  	
	    	// Create a new Calendar service, connect to Google
	        CalendarService myService = new CalendarService("My Application");
	        myService.setUserCredentials(args[0],args[1]); 			// LOGIN AND PASSWORD AS ARGUMENTS
	        
	        // DECLARE VARIABLES FOR EVENT SEARCH
	        Query 				myQuery 		= new Query(feedUrl);
	        CalendarEventFeed 	myResultsFeed;
	        CalendarEventEntry 	firstMatchEntry = null;
	        String 				myEntryTitle;
	        URL 				deleteUrl;
	        When 				timeVar;
	        SimpleDateFormat 	formater 		= new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
	        Date 				newDate 		= new Date();
	        CalendarEventEntry 	myEntry;
	        When 				eventTimes 		= new When();
	        DateTime 			startTime		= null;
	        DateTime 			endTime			= null;
	        int					reminderMinutes;
	        Method 				methodType 		= Method.SMS;
	        Reminder 			reminder 		= new Reminder();
	        CalendarEventEntry 	insertedEntry;
	        
	        // PREPARE SEARCH QUERY
	        myQuery.setFullTextQuery(stopSMS);			// stopSMS TEXT EVENT
	    	myResultsFeed = myService.query(myQuery, CalendarEventFeed.class);
	        if (myResultsFeed.getEntries().size() > 0)
	    	{	
	    		System.out.println(">> STOP event found. \n>> Finish");
	    		return;
	    	}
	        
	        // PREPARE SEARCH QUERY
	        myQuery.setFullTextQuery(reanimationTxt);	// reanimationTxt TEXT EVENT
	    	myResultsFeed = myService.query(myQuery, CalendarEventFeed.class);
	        if (myResultsFeed.getEntries().size() > 0)
	    	{	// IF FOUND
	    		System.out.println(">> REANIMATION event found");
	    		// GET TITLE OF THE FIRST MATCH ENTRY
	    		firstMatchEntry = (CalendarEventEntry) myResultsFeed.getEntries().get(0); 
	    		myEntryTitle 	= firstMatchEntry.getTitle().getPlainText();
	    		 
	    		// IF THE reanimationTxt EVENT FOUND, DELETE IT
	    		deleteUrl = new URL(firstMatchEntry.getEditLink().getHref());
			    myService.getRequestFactory().setHeader("If-Match", "*");
	    		myService.delete(deleteUrl);
	    		System.out.println(">> ...deleting REANIMATION event");
	    	}
	    	
	        // PREPARE SEARCH QUERY
	    	myQuery.setFullTextQuery(alertTxt);			// alertTxt TEXT EVENT
	    	myResultsFeed = myService.query(myQuery, CalendarEventFeed.class);
	        if (myResultsFeed.getEntries().size() > 0)
	    	{	// IF FOUND
	    		System.out.println(">>	>> ALERT event found");
	    		// GET TITLE OF THE FIRST MATCH ENTRY
	    		firstMatchEntry = (CalendarEventEntry) myResultsFeed.getEntries().get(0); 
	    		myEntryTitle 	= firstMatchEntry.getTitle().getPlainText();
	    		
	    		timeVar 		= firstMatchEntry.getTimes().get(0);
			  	System.out.println(">>	>> event start&stop time         : " + timeVar.getStartTime() + "\n>>	>>                               : "+ timeVar.getEndTime());
			  	System.out.println(">>	>> event start     (milliseconds): " + timeVar.getStartTime().getValue());
				System.out.println(">>	>> new event start (milliseconds): " + (newDate.getTime() - (1000*60*timePeriod)));
				
			  	if(timeVar.getStartTime().getValue() > newDate.getTime() - (1000*60*0))
				{	// IF THE START TIME OF THE OLD EVENT IS LESS THAN timePeriod MINUTES AGO
					// DELETE IT
		    		deleteUrl = new URL(firstMatchEntry.getEditLink().getHref());
				    myService.getRequestFactory().setHeader("If-Match", "*");
		    		myService.delete(deleteUrl);
		    		System.out.println(">>		>> event start > new event start");
		    		System.out.println(">>		>> ...deleting event");
		    		System.out.println(">>		>>    #M###      ##M    #M#  ");
		    		System.out.println(">>		>>   ########    ###   ###   ");
		    		System.out.println(">>		>>   ###  ###    ###  ###    ");
		    		System.out.println(">>		>>  ###    ###   ### ###     ");
		    		System.out.println(">>		>>  M##    ###   ######M     ");
		    		System.out.println(">>		>>  ###    ###   #### ###    ");
		    		System.out.println(">>		>>  ###    ###   ###  ###    ");
		    		System.out.println(">>		>>  ###    ###   #M#   ###   ");
		    		System.out.println(">>		>>   ###  ###    ###   ###   ");
		    		System.out.println(">>		>>   ########    ###    ###  ");
		    		System.out.println(">>		>>     ####      ###     ### ");
				}
				else
				{	// THE TIME IS MORE THAN timePeriod MINUTES AGO, WHICH MEANS THAT THE sms HAS ALREADY BEEN SENT
					// DELETE IT
		    		deleteUrl = new URL(firstMatchEntry.getEditLink().getHref());
				    myService.getRequestFactory().setHeader("If-Match", "*");
		    		myService.delete(deleteUrl);
		    		System.out.println(">>		>> SMS has gone already");
		    		System.out.println(">>		>> event start < new event start");
		    		System.out.println(">>		>> ...deleting event");
		    		System.out.println(">>		>>   .M####   M##M   ###M   .#####   ");
		    		System.out.println(">>		>>  ########  ####   ####  ########  ");
		    		System.out.println(">>		>>  ###  ###  ####   ####  #M#  ###  ");
		    		System.out.println(">>		>>  ###       ###M# #####  ###       ");
		    		System.out.println(">>		>>  #M####    ##### #####  ######    ");
		    		System.out.println(">>		>>   ######   ### # # @##   #M####   ");
		    		System.out.println(">>		>>     #####  ### # # ###     #####  ");
		    		System.out.println(">>		>>  #M#  ###  ### # # ###  M##  ###  ");
		    		System.out.println(">>		>>  ###  ###  ### ### ###  ###  ###  ");
		    		System.out.println(">>		>>   ######   ### ### ###   ######   ");
		    		System.out.println(">>		>>    ####    ###  #  ###    ####    ");
		    		// CREATE NEW EVENT
		    		myEntry 	   = new CalendarEventEntry();
			        myEntry.setTitle(new PlainTextConstruct(reanimationTxt));		// SET ITS TITLE
			        
			        newDate.setTime(newDate.getTime() + 1000*60*1); // CURRENT TIME + 1 MINUTE
			  	  	startTime 	= DateTime.parseDateTime(formater.format(newDate));		// INSERTS THE LINE USING THE PATTERN "2009-06-30T20:55:00"
			  	  	
			  	  	System.out.println(">>		>> creating REANIMATION event");
			  	  	System.out.println(">>		>> event starttime: " + formater.format(newDate));
			  	  	
			  	  	newDate.setTime(newDate.getTime() + 1000*60*0); // AGAIN ADD THE CURRENT TIME + 1 MINUTE
			  	  	endTime   	= DateTime.parseDateTime(formater.format(newDate));
			  	  	
			  	    System.out.println(">>		>> event stoptime : " + formater.format(newDate));
			  	  	
		        	eventTimes.setStartTime(startTime);
		        	eventTimes.setEndTime(endTime);
		        	myEntry.addTime(eventTimes);
		
		        	reminderMinutes = 0;  // REMIND 1 MINUTE BEFORE
		        	
		        	reminder.setMinutes(reminderMinutes);
		        	reminder.setMethod(methodType);
		        	myEntry.getReminder().add(reminder);
		
		        	// CREATE A NEW Calendar service, CONNECT TO Google
			        CalendarService tempService = new CalendarService("My Application");
			        tempService.setUserCredentials(args[0],args[1]); 			// LOGIN AND PASSWORDS AS ARGUMENTS
		        	// PUT EVENT IN QUEUE
		        	tempService.insert(feedUrl, myEntry);
				}
			}
	    	
	        // CREATE A NEW Calendar service, CONNECT TO Google
	        CalendarService basicService = new CalendarService("basic Application");
	        basicService.setUserCredentials(args[0],args[1]); 			// LOGIN AND PASSWORDS AS ARGUMENTS
	    	
	    	// CREATE NEW EVENT
	    	CalendarEventEntry basicEntry 	   = new CalendarEventEntry();
	        basicEntry.setTitle(new PlainTextConstruct(alertTxt));		// SET ITS TITLE
	        
	        if (mode == 0)
	        {	// STANDARD DAILY SITUATION
	        	newDate.setTime(newDate.getTime() + 1000*60*timePeriod); 		// CURRENT TIME + timePeriod MINUTES
		  	  	startTime 	= DateTime.parseDateTime(formater.format(newDate));	// INSERTS THE LINE USING THE PATTERN "2009-06-30T20:55:00"
		  	  	
		  	  	newDate.setTime(newDate.getTime() + 1000*60*0); 		// AGAIN ADD THE CURRENT TIME + timePeriod MINUTES
		  	  	endTime   	= DateTime.parseDateTime(formater.format(newDate));
	        }
	        if (mode == 1)
	        {	// SCHEDULE EVENT FOR THE NEXT MORNING OR MONDAY MORNING
	        	Date 				curDate	= new Date();
	    		GregorianCalendar 	gDate 	= new GregorianCalendar();
	    		gDate.setTime(curDate);
	    		// SET THE REQUIRED HOUR AND MINUTE
	    		gDate.set(GregorianCalendar.HOUR_OF_DAY, startHour);
	    		gDate.set(GregorianCalendar.MINUTE     , startMin);
	    		gDate.set(GregorianCalendar.SECOND     , 0);
	    		
	    		if (gDate.get(GregorianCalendar.DAY_OF_WEEK) < 6)
	    		{	// MO - THU
	    			gDate.set(GregorianCalendar.DAY_OF_MONTH, gDate.get(GregorianCalendar.DAY_OF_MONTH) + 1);
	    		}
	    		else
	    		{	// FRI
	    			gDate.set(GregorianCalendar.DAY_OF_MONTH, gDate.get(GregorianCalendar.DAY_OF_MONTH) + 3);
	    		}
	    		// System.out.println("gDate "+ gDate.getTime());
	    		startTime 	= DateTime.parseDateTime(formater.format(gDate.getTime()));
	    		gDate.set(GregorianCalendar.MINUTE, gDate.get(GregorianCalendar.MINUTE) + timePeriod);
	    		endTime   	= DateTime.parseDateTime(formater.format(gDate.getTime()));
	    		System.out.println(">> nextday event should be created");
	        }
	        //System.out.println("creating ALERT event!");
	        System.out.println(">> creating ALERT event");
	  	  	System.out.println(">> event starttime: " + startTime.toString());
	  	    System.out.println(">> event stoptime : " + endTime.toString());
	  	  	
        	eventTimes.setStartTime(startTime);
        	eventTimes.setEndTime(endTime);
        	basicEntry.addTime(eventTimes);

        	reminderMinutes = 0;  // REMIND 1 MINUTE BEFORE
        	
        	reminder.setMinutes(reminderMinutes);
        	reminder.setMethod(methodType);
        	basicEntry.getReminder().add(reminder);

        	// PUT EVENT IN QUEUE
        	basicService.insert(feedUrl, basicEntry);
        	
        	System.out.println(">>----------  Finish  ----------<<");
    	}
    	catch(AuthenticationException e) {
            e.printStackTrace();
          }
          catch(MalformedURLException e) {
            e.printStackTrace();
          }
          catch(ServiceException e) {
            e.printStackTrace();
          }
          catch(IOException e) {
            e.printStackTrace();
          }
    }
}