//+---------------------------------------------------------------------------+
//|                                            cNetEventsProcDLL.cpp          |
//|                      Copyright  2012, http://www.mql4.com/ru/users/more  |
//|                                       tradertobe@gmail.com                |
//+---------------------------------------------------------------------------+

// cNetEventsProcDLL.cpp

#include <winsock2.h>
#include "cNetEventsProcDLL.h"
#include "GlobalVar.h"
BOOL WINAPI DllMain(HINSTANCE hinstDLL,  // DLL module handle
					DWORD fdwReason,     // reason called 
					LPVOID lpvReserved)  // reserved 
{ 
    switch (fdwReason) 
    {	 
        // DLL load due to process initialization or LoadLibrary: 
		// 1. Create/Open named file-mapping object
		// 2.Create/Open three named event object with auto-reset and initial blocked, and 1 mutex object
        case DLL_PROCESS_ATTACH: 
			 return cNetEventsProcDLL::MessageDLL_PROCESS_ATTACH();

		// The attached process creates a new thread
        case DLL_THREAD_ATTACH:
            break; 
 
        // The thread of the attached process Exits
        case DLL_THREAD_DETACH: 
            break; 
 
        // DLL unload due to process termination or FreeLibrary
        case DLL_PROCESS_DETACH: 
			return cNetEventsProcDLL::MessageDLL_PROCESS_DETACH();
      
	}
    return TRUE; 
    UNREFERENCED_PARAMETER(hinstDLL); 
    UNREFERENCED_PARAMETER(lpvReserved); 
} 
//*******************************************************************************************************************

// DLL load due to process initialization or LoadLibrary: 
// 1. Create/Open named file-mapping object
// 2.Create/Open three named event object with auto-reset and initial blocked, and 1 mutex object
BOOL cNetEventsProcDLL::MessageDLL_PROCESS_ATTACH(void)
{
	// Create/Open a named file mapping object
	gh_MapObject = CreateFileMapping( 
						INVALID_HANDLE_VALUE,   // use paging file
						NULL,                   // default security attributes
						PAGE_READWRITE,         // read/write access
						0,                      // size: high 32-bits
						sizeof(kSharedMem),  // size: low 32-bits
						gt_MemName);			// name of map object

	DWORD	u32_Error;
	u32_Error = GetLastError();

	if (gh_MapObject == NULL)
		return FALSE;

	BOOL	b_FirstInit;
	// The first process initializes memory
	b_FirstInit = (u32_Error != ERROR_ALREADY_EXISTS); 

	// Get a pointer to the file-mapped shared memory
	gpk_SharedMem =	(kSharedMem*)MapViewOfFile( 
											gh_MapObject,		// object to map view of
											FILE_MAP_WRITE,		// read/write access
											0,					// high offset:  map from
											0,					// low offset:   beginning
											0);					// default: map entire file

	if (gpk_SharedMem == NULL) 
		return FALSE; 
    
	// Initialize memory if this is the first process 
	if (b_FirstInit)
		memset(gpk_SharedMem, '\0', sizeof(kSharedMem)); 
			
	// Create/Open named event object with auto-reset and initially blocked to wake up NetEventsProc process
	// NetEventsProc process is waiting for this event to be signaled to start request processing
	gh_ReqEvent = CreateEvent(0, FALSE, FALSE, gt_ReqEventName); // auto-reset, initially = blocked, named

	if (!gh_ReqEvent)
		return FALSE;
	// Create/Open named event object with auto-reset and initial blocked to Exit NetEventsProc process
	// NetEventsProc process is waiting for this event to be signaled to Exit
	gh_ExitEvent = CreateEvent(0, FALSE, FALSE, gt_ExitEventName); // auto-reset, initially = blocked, named

	if (!gh_ExitEvent)
		return FALSE;
	// Create/Open named event object with auto-reset and initially blocked to synchronize NetEventsProc process with NetEventsProcDLL
	// NetEventsProcDLL wait for this event to set signaled by NetEventsProc process when NetEventsProc process completes request processing 
	gh_SyncEvent = CreateEvent(0, FALSE, FALSE, gt_SyncEventName); // auto-reset, initially = blocked, named

	if (!gh_SyncEvent)
		return FALSE;
	// Create/Open named mutex object initially not owned to synchronize user applications calls to NetEventsProcDLL functions.
	// One and only user application thread at a time can deal with any of NetEventsProcDLL function,
	// others will wait for this mutex object to be released.
	gh_Mutex = CreateMutex(NULL, FALSE, gt_MutexObjectName); // default security attributes, initially not owned, named

	if (!gh_Mutex)
		return FALSE;

	if (gpk_SharedMem->u32_AttachCount++)
	{
		return TRUE;  // NetEventsProc process already created and run !
	}

	ZeroMemory( &gk_Si, sizeof(gk_Si));
	gk_Si.cb = sizeof(gk_Si);
	ZeroMemory( &gk_Pi, sizeof(gk_Pi));

	// Start the child process that will Server/Clients 
	if( !CreateProcess( gt_ModuleName, // Module name 
						NULL,              // Command line
						NULL,              // Process handle not inheritable
						NULL,              // Thread handle not inheritable
						FALSE,             // Set handle inheritance to FALSE
						#if _DEBUG
						0,				   // No any flags
						#else
						DETACHED_PROCESS,  // No console
						#endif
						NULL,              // Use parent's environment block
						NULL,              // Use parent's starting directory 
						&gk_Si,            // Pointer to STARTUPINFO structure
						&gk_Pi             // Pointer to PROCESS_INFORMATION structure
					  )
	        )
	{
		return FALSE;
	}
	else
	{
		// Save in SharedMem NetEventsProc child process handle
		gpk_SharedMem->h_NetEventsProcProcess = gk_Pi.hProcess;
		// Save in SharedMem NetEventsProc child process thread  handle
		gpk_SharedMem->h_NetEventsProcThread  = gk_Pi.hThread;
		return TRUE;
	}
}
//****************************************************************************************************************************

// DLL unload due to process termination or FreeLibrary
BOOL cNetEventsProcDLL::MessageDLL_PROCESS_DETACH(void)
{
	gpk_SharedMem->u32_AttachCount--;
			
	if (gpk_SharedMem->u32_AttachCount == 0) // "0" - means: no any process requires the services of needNetEventsProc process,
	{                                        //       so, Exit this process !
		// NetEventsProc process should Exit upon set this event to signaled
		SetEvent(gh_ExitEvent);
		// Close child process and child thread handles. 
		CloseHandle(gpk_SharedMem->h_NetEventsProcProcess );
		CloseHandle(gpk_SharedMem->h_NetEventsProcThread);
	}
			
    // Unmap shared memory from the process's address space, close the process's handle to the file-mapping object
	UnmapViewOfFile(gpk_SharedMem); 
	// Close the process's handle to the file-mapping object
	CloseHandle(gh_MapObject); 
	// Close process handles for three named event object and mutex object
	CloseHandle(gh_ReqEvent);
	CloseHandle(gh_ExitEvent);
	CloseHandle(gh_SyncEvent);
	CloseHandle(gh_Mutex);

	return TRUE;
}
//*******************************************************************************************************************
int __stdcall cNetEventsProcDLL::ConnectTo(char* ps8_ServerIP, //in - ps8_ServerIP = "0123456789123456"
										   int   s32_Port,     //in 
										   int*  ph_Client)   //out - int ph_Client[1]
{
	WaitForSingleObject(gh_Mutex,INFINITE);

	if (!ps8_ServerIP || !s32_Port || !ph_Client || strcpy_s(gpk_SharedMem->s8_ServerIP, 17, ps8_ServerIP))
	{
		ReleaseMutex(gh_Mutex);

		return ERROR_INVALID_PARAMETER;
	}

	gpk_SharedMem->u32_Port = s32_Port;
	gpk_SharedMem->e_Req = E_ConnectTo;

	SetEvent(gh_ReqEvent);

	DWORD u32_Index  =  WaitForSingleObject(gh_SyncEvent, WAIT_FOR_EVENT_TIMEOUT);

	if (u32_Index == WAIT_TIMEOUT)
	{
		ReleaseMutex(gh_Mutex);
		return ERROR_TIMEOUT;
	}

	ph_Client[0] = gpk_SharedMem->h_Client;

	DWORD u32_Return = gpk_SharedMem->u32_ReqRes;

	ReleaseMutex(gh_Mutex);

	return u32_Return;
}
//*******************************************************************************************************************

int __stdcall cNetEventsProcDLL::ConnectClose(int h_Client) //in 
{
	WaitForSingleObject(gh_Mutex,INFINITE);

	if (!h_Client)
	{
		ReleaseMutex(gh_Mutex);

		return ERROR_INVALID_PARAMETER;
	}

	gpk_SharedMem->h_Client = h_Client;
	gpk_SharedMem->e_Req = E_ConnectClose;

	SetEvent(gh_ReqEvent);

	DWORD u32_Index  =  WaitForSingleObject(gh_SyncEvent, WAIT_FOR_EVENT_TIMEOUT);
	
	if (u32_Index == WAIT_TIMEOUT)
	{
		ReleaseMutex(gh_Mutex);
		return ERROR_TIMEOUT;
	}
	
	DWORD u32_Return = gpk_SharedMem->u32_ReqRes;

	ReleaseMutex(gh_Mutex);

	return u32_Return;
}
//*******************************************************************************************************************

int __stdcall cNetEventsProcDLL::ServerOpen(int s32_Port) //in 
{
	WaitForSingleObject(gh_Mutex,INFINITE);

	if (!s32_Port)
	{
		ReleaseMutex(gh_Mutex);

		return ERROR_INVALID_PARAMETER;
	}

	gpk_SharedMem->u32_Port = s32_Port;
	gpk_SharedMem->e_Req = E_ServerOpen;

	SetEvent(gh_ReqEvent);

	DWORD u32_Index  =  WaitForSingleObject(gh_SyncEvent, WAIT_FOR_EVENT_TIMEOUT);
	
	if (u32_Index == WAIT_TIMEOUT)
	{
		ReleaseMutex(gh_Mutex);
		return ERROR_TIMEOUT;
	}
	
	DWORD u32_Return = gpk_SharedMem->u32_ReqRes;

	ReleaseMutex(gh_Mutex);

	return u32_Return;
}
//*******************************************************************************************************************

int __stdcall cNetEventsProcDLL::GetAllConnections(int* ph_Client,           // out - int ph_Client[62]
												   int* ps32_ClientIP,       // out - int ps32_ClientIP[62]
												   int* ps32_ClientCount)    // out - int ps32_ClientCount[1]
{
	WaitForSingleObject(gh_Mutex,INFINITE);

	if (!ph_Client || !ps32_ClientIP || !ps32_ClientCount)
	{
		ReleaseMutex(gh_Mutex);

		return ERROR_INVALID_PARAMETER;
	}

	gpk_SharedMem->e_Req = E_GetAllConnections;

	SetEvent(gh_ReqEvent);

	DWORD u32_Index  =  WaitForSingleObject(gh_SyncEvent, WAIT_FOR_EVENT_TIMEOUT);
	
	if (u32_Index == WAIT_TIMEOUT)
	{
		ReleaseMutex(gh_Mutex);
		return ERROR_TIMEOUT;
	}
	
	for (int i = 0; i <62; i++)
	{
		ph_Client[i]     = gpk_SharedMem->ph_Client[i];
		ps32_ClientIP[i] = gpk_SharedMem->pu32_ClientIP[i];
	}

	ps32_ClientCount[0] = gpk_SharedMem->u32_ClientCount;

	DWORD u32_Return = gpk_SharedMem->u32_ReqRes;

	ReleaseMutex(gh_Mutex);

	return u32_Return;
}
//*******************************************************************************************************************

int __stdcall cNetEventsProcDLL::DisconnectClient(SOCKET h_Client) // in 
{
	WaitForSingleObject(gh_Mutex,INFINITE);

	if (!h_Client)
	{
		ReleaseMutex(gh_Mutex);

		return ERROR_INVALID_PARAMETER;
	}

	gpk_SharedMem->h_Client = h_Client;
	gpk_SharedMem->e_Req = E_DisconnectClient;

	SetEvent(gh_ReqEvent);

	DWORD u32_Index  =  WaitForSingleObject(gh_SyncEvent, WAIT_FOR_EVENT_TIMEOUT);
	
	if (u32_Index == WAIT_TIMEOUT)
	{
		ReleaseMutex(gh_Mutex);
		return ERROR_TIMEOUT;
	}
	
	DWORD u32_Return = gpk_SharedMem->u32_ReqRes;

	ReleaseMutex(gh_Mutex);

	return u32_Return;
}
//*******************************************************************************************************************

int __stdcall cNetEventsProcDLL::ServerClose()
{
	WaitForSingleObject(gh_Mutex,INFINITE);

	gpk_SharedMem->e_Req = E_ServerClose;

	SetEvent(gh_ReqEvent);

	DWORD u32_Index  =  WaitForSingleObject(gh_SyncEvent, WAIT_FOR_EVENT_TIMEOUT);
	
	if (u32_Index == WAIT_TIMEOUT)
	{
		ReleaseMutex(gh_Mutex);
		return ERROR_TIMEOUT;
	}
	
	DWORD u32_Return = gpk_SharedMem->u32_ReqRes;

	ReleaseMutex(gh_Mutex);

	return u32_Return;
}
//*******************************************************************************************************************

int __stdcall cNetEventsProcDLL::SendToInt(SOCKET h_Client,		   // in
										   int*   ps32_SendBuf,	   // in
										   int    s32_SendBufLen)  // in -  SendBuf[] array size in int element
{
	WaitForSingleObject(gh_Mutex,INFINITE);

	DWORD u32_Return = SendTo(h_Client, (char*)ps32_SendBuf, s32_SendBufLen*sizeof(int));

	ReleaseMutex(gh_Mutex);

	return u32_Return;
}
//*******************************************************************************************************************

int __stdcall cNetEventsProcDLL::SendToDouble(SOCKET  h_Client,		   // in
											  double* pd_SendBuf,	   // in
											  int     s32_SendBufLen)  // in -  SendBuf[] array size in double element
{
	WaitForSingleObject(gh_Mutex,INFINITE);

	DWORD u32_Return = SendTo(h_Client, (char*)pd_SendBuf, s32_SendBufLen*sizeof(double));

	ReleaseMutex(gh_Mutex);

	return u32_Return;
}
//*******************************************************************************************************************

int __stdcall cNetEventsProcDLL::SendToString(SOCKET h_Client, // in
	                               char*  ps8_SendBuf,		   // in
								   INT   s32_SendBufLen)	   // SendBuf string size in char element
{
	WaitForSingleObject(gh_Mutex,INFINITE);

	DWORD u32_Return = SendTo(h_Client, ps8_SendBuf, s32_SendBufLen);

	ReleaseMutex(gh_Mutex);

	return u32_Return;
}
//*******************************************************************************************************************

int __stdcall cNetEventsProcDLL::ReadFromInt(SOCKET h_Client,		// in
											 int*   ps32_ReadBuf,	// in
											 int    s32_ReadBufLen,	// ReadBuf[] array size in int element
											 int*   ps32_ReadLen)	// out  - int ps32_ReadLen[1] - actual count of read data in int element
{
	WaitForSingleObject(gh_Mutex,INFINITE);

	INT s32_ReadLen;

	DWORD u32_Return = ReadFrom(h_Client, (char*)ps32_ReadBuf, s32_ReadBufLen*sizeof(int),s32_ReadLen);

	ps32_ReadLen[0] = s32_ReadLen/sizeof(int);

	ReleaseMutex(gh_Mutex);

	return u32_Return;
}

int __stdcall cNetEventsProcDLL::ReadFromDouble(SOCKET  h_Client,		// in
												double* pd_ReadBuf,		// in
												int     s32_ReadBufLen,	// ReadBuf[] array size in double element
												int*    ps32_ReadLen)	// out - int ps32_ReadLen[1] - actual count of read data in double element
{
	WaitForSingleObject(gh_Mutex,INFINITE);

	INT s32_ReadLen;

	DWORD u32_Return = ReadFrom(h_Client, (char*)pd_ReadBuf, s32_ReadBufLen*sizeof(double),s32_ReadLen);

	ps32_ReadLen[0] = s32_ReadLen/sizeof(double);

	ReleaseMutex(gh_Mutex);

	return u32_Return;
}
//*******************************************************************************************************************

int __stdcall cNetEventsProcDLL::ReadFromString(SOCKET h_Client,		// in
												char*  ps8_ReadBuf,		// in
												int    s32_ReadBufLen,	// ReadBuf[] array size in char element
												int*   ps32_ReadLen)	// out - int ps32_ReadLen[1] - actual count of read data in char element
{
	WaitForSingleObject(gh_Mutex,INFINITE);

	INT s32_ReadLen;

	DWORD u32_Return = ReadFrom(h_Client, ps8_ReadBuf, s32_ReadBufLen,s32_ReadLen);

	ps32_ReadLen[0] = s32_ReadLen;

	ReleaseMutex(gh_Mutex);

	return u32_Return;
}
//*******************************************************************************************************************

DWORD cNetEventsProcDLL::SendTo(SOCKET h_Client, char* ps8_SendBuf, INT s32_SendBufLen)
{
	if (!h_Client || !ps8_SendBuf || !s32_SendBufLen )
		return ERROR_INVALID_PARAMETER;

	gpk_SharedMem->h_Client = h_Client;

	memcpy(gpk_SharedMem->s8_Data, ps8_SendBuf, s32_SendBufLen);

	gpk_SharedMem->u32_DataLen = s32_SendBufLen;

	gpk_SharedMem->e_Req = E_SendTo;

	SetEvent(gh_ReqEvent);

	DWORD u32_Index  =  WaitForSingleObject(gh_SyncEvent, WAIT_FOR_EVENT_TIMEOUT);
	
	if (u32_Index == WAIT_TIMEOUT)
		return ERROR_TIMEOUT;
	
	DWORD u32_Return = gpk_SharedMem->u32_ReqRes;

	return u32_Return;
}
//*******************************************************************************************************************

DWORD cNetEventsProcDLL::ReadFrom(SOCKET h_Client, char* ps8_ReadBuf, INT s32_ReadBufLen, INT& s32_ReadLen)
{
	if (!h_Client || !ps8_ReadBuf || !s32_ReadBufLen)
		return ERROR_INVALID_PARAMETER;

	gpk_SharedMem->h_Client    = h_Client;
	gpk_SharedMem->u32_DataLen = s32_ReadBufLen;
	gpk_SharedMem->e_Req       = E_ReadFrom;

	SetEvent(gh_ReqEvent);

	DWORD u32_Index  =  WaitForSingleObject(gh_SyncEvent, WAIT_FOR_EVENT_TIMEOUT);
	
	if (u32_Index == WAIT_TIMEOUT)
		return ERROR_TIMEOUT;
	
	s32_ReadLen = gpk_SharedMem->s32_ReadDataLen;

	if (s32_ReadLen > 0)
		memcpy(ps8_ReadBuf, gpk_SharedMem->s8_Data, s32_ReadLen);

	DWORD u32_Return = gpk_SharedMem->u32_ReqRes;

	return u32_Return;
}
//*******************************************************************************************************************
