//+---------------------------------------------------------------------------+
//|                                            GlobalVar.h                    |
//|                      Copyright  2012, http://www.mql4.com/ru/users/more  |
//|                                       tradertobe@gmail.com                |
//+---------------------------------------------------------------------------+

// GlobalVar.h

#pragma once

#ifndef Dll_Global_var_h
#define Dll_Global_var_h

#define WAIT_FOR_EVENT_TIMEOUT  10000 // 10 sec. after this interval WaitFoSingleEvent(...) escape with ERROR_TIMEOUT
// Temporary storage size for some Send/Read operations
#define DATA_BUFFER_SIZE   64*1024

// This enum  defines all possible requests for NetEventsProc process to execute.
enum eRequest
{
	E_ConnectTo         = 1,
	E_ConnectClose      = 2,	
	//
	E_ServerOpen        = 4,
	E_GetAllConnections = 8,
	E_DisconnectClient  = 16,
	E_ServerClose       = 32,
	//
	E_SendTo            = 64,
	E_ReadFrom          = 128,
};

struct kSharedMem
{
	HANDLE h_NetEventsProcProcess;  // NetEventsProc process handle
	HANDLE h_NetEventsProcThread;   // NetEventsProc process thread handle

	DWORD    u32_AttachCount;

	DWORD    u32_ReqRes;        // NetEventsProc processes our request and returns OK or error code
	eRequest e_Req;				// what NetEventsProc process must do for caller

	DWORD    u32_Port;
	char     s8_ServerIP [17];     

	SOCKET   h_Client; // in/out
	char     s8_Data [DATA_BUFFER_SIZE];
	DWORD    u32_DataLen;
	INT      s32_ReadDataLen;
	// for GetAllConnections(...):
	SOCKET     ph_Client[62];     // out - int ph_Client[62]
	DWORD      pu32_ClientIP[62]; // out - int pu32_ClientIP[62]
	DWORD      u32_ClientCount;   // out  
};

								  #if _DEBUG
static const  TCHAR*              gt_ModuleName    = TEXT("D:\\MT4\\experts\\libraries\\NetEventsProc.exe");
								  #else
static const  TCHAR*              gt_ModuleName    = TEXT("C:\\NetEventsProc\\NetEventsProc.exe");
								  #endif

static        STARTUPINFO         gk_Si;
static        PROCESS_INFORMATION gk_Pi;	

static TCHAR*         gt_MemName    = TEXT("SharedMemfilemapName");
static HANDLE         gh_MapObject  = NULL;
static kSharedMem*    gpk_SharedMem = NULL;  

// Named event object with auto-reset and initially blocked to wake up NetEventsProc process
// NetEventsProc process is waiting for this event to be signaled to start request processing
static TCHAR*         gt_ReqEventName = TEXT("ReqEventName");
static HANDLE         gh_ReqEvent     = NULL; 

// Named event object with auto-reset and initially blocked to Exit NetEventsProc process
// NetEventsProc process is waiting for this event to be signaled to Exit to Windows i.e. to terminate Windows process
static TCHAR*         gt_ExitEventName = TEXT("ExitEventName");
static HANDLE         gh_ExitEvent     = NULL; 

// Named event object with auto-reset and initially blocked to to synchronize NetEventsProc process with NetEventsProcDLL
// NetEventsProcDLL wait for this event to set signaled by NetEventsProc process when NetEventsProc process completes request processing 
static TCHAR*         gt_SyncEventName = TEXT("SyncEventName");
static HANDLE         gh_SyncEvent     = NULL; 

// Named mutex object initially not owned to synchronize user applications calls to NetEventsProcDLL functions
// One and only user application thread at a time can deal with any of NetEventsProcDLL function,
// others will wait for this mutex object to be released.
static TCHAR*         gt_MutexObjectName = TEXT("MutexObjectName");
static HANDLE         gh_Mutex           = NULL; 
#endif