
// cSocketApp.h

#pragma once

// Listen and Connect Port
#define PORT	2000

// The time in seconds after which a server disconnects his idle clients
// Set 0 to disable the timeout
#define MAX_SERVER_IDLE_TIME  0 //5*60  5 minutes

// The time in seconds after which a client disconnects from his idle server
// Set 0 to disable the timeout
#define MAX_CLIENT_IDLE_TIME  0 // off

#define DATA_MODE  E_NORMAL // E_NORMAL set in cSocketApp class constructor by parameter

// Temporary storage size for some Send/Read operations
#define TEMP_BUFFER_SIZE   64*1024

#include "stdio.h"
#include "cSocket.h"
// Data Send/Recieve modes define how to work with pi_RecvMem!
// In case pay attention, server and clients must use the same Data Mode !
enum eDataMode
{
	// Receive data is retrieved immediately exactly as it comes from Winsock
	E_NORMAL = 0,
		
	// Sends all data prefixed with a DWORD which contains the length of the entire datablock.
	// Even if the data arrives in multiple parts the receiver knows in advance 
	// how many data he has to read into pi_RecvMem
	E_PREFIXED = 1,
		
	// Accumulate characters sent from a Telnet client (Port 23)
	// untill '\n' and save them as entire lines rather than single characters in i_SocketList recieved buffer.
	E_TELNET = 2
};

// Variable of this structure type should be used by application to get result from 
// kCon GetAllConnections() method of this class
struct kCon
{
	struct kClient
	{
       SOCKET			h_Client;
	   DWORD			u32_ClientIP;
	};
	kClient k_Client[62];
	DWORD    u32_ClientCount;
};

class cSocketApp
{
protected:
	class cSocketList
	{
	
	public:
		cSocketList(void);
		~cSocketList(void);
		struct kSocket
		{
			SOCKET			h_Socket;
			DWORD			u32_IP;
			TCP::cSocket::cMemory* pi_RecvMem;
		};
		kSocket* FindSocket(SOCKET h_Socket);
		kSocket* Add(SOCKET h_Socket, DWORD u32_IP);
		DWORD    UpdateSocketList(TCP::cSocket* pi_Socket);
		SOCKET   GetSocketByIndex(DWORD u32_Index);
		DWORD    GetIpByIndex(DWORD u32_Index);
		BOOL     Remove(DWORD u32_Index);
		void     RemoveAll();
		DWORD    GetSocketCount();
	protected:
		kSocket mk_Socket[WSA_MAXIMUM_WAIT_EVENTS-2];   // maximum 62 for Server sockets or 1 for Client socket
		DWORD	mu32_Count;
		TCP::cSocket::cHash<SOCKET,DWORD> mi_cHashSocketList;
	};

public:
	 cSocketApp();
	 cSocketApp(DWORD u32_Port, eDataMode DataMode = DATA_MODE);
	~cSocketApp();
	//**************************************************************************************
	// Methods to be used by users of this class:
	//
	// Create server:
	DWORD        Listen(); 
	// Create client
	DWORD	     ConnectTo(DWORD u32_ServerIP, SOCKET &h_Socket); 
	// Get all client's connections, for both server and client users. 
	kCon         GetAllConnections();	
	// This function is for use on a server only
	// It can be called to force a disconnect of a specific client from the server
	DWORD		 DisconnectClient(SOCKET h_Socket);
	// Send data to peer, for both server and client users
	DWORD        SendTo  (SOCKET h_Socket, char* s8_SendBuf, DWORD u32_SendBufLen);
	// Read data recieved from peer, for both server and client users
	DWORD        ReadFrom(SOCKET h_Socket, char* s8_ReadBuf, INT u32_ReadBufLen, INT &u32_Count);   
	// This function is for use for both server and client users, remove all sockets, aka, delete Client or Server
	void         CloseSockets();
	// This function is for use for both server and client users,
	// returns total socket count including Listen(...) socket himself and, of course, ConnectTo(...) socket
	DWORD    GetSocketCount(); 
	//***************************************************************************************
protected:
	
	static ULONG WINAPI ProcessEventThread(void* p_Param);
	void    ProcessEvents();
	void    ProcessReceivedDataNormal(cSocketList::kSocket* pk_Socket, TCP::cSocket::cMemory* pi_RecvMem);
	void    ProcessReceivedDataPrefix(cSocketList::kSocket* pk_Socket, TCP::cSocket::cMemory* pi_RecvMem);
	void    ProcessReceivedDataTelnet(cSocketList::kSocket* pk_Socket, TCP::cSocket::cMemory* pi_RecvMem);
	
	TCP::cSocket      mi_Socket;
	USHORT            mu16_Port;
	cSocketList       mi_SocketList;
	char*             ms8_TempBuffer;          // Temporary storage for some Send/Read operations
	HANDLE            mh_Thread;               // handle for separate Thread in which ProcessEvents() runs it's endlees loop
	BOOL              mb_ParentThreadClosed;
	DWORD             mu32_ProcessEventsError; // set TRUE in CloseSockets() and signal for network event handler thread to terminate !
	eDataMode         me_DataMode;
	CRITICAL_SECTION  mk_Critical;
};

