
// cInterface.h

#pragma once

#include "cSocketApp.h"
#include "GlobalVar.h"

#define MAX_CLIENTS  (WSA_MAXIMUM_WAIT_EVENTS-2)

enum eEvent
	{
		E_RequestEvent = 1,
		E_ExitEvent    = 2,	
	};

class cInterface
{
public:
	enum eType
	{
		E_Client        = 2,  // ConnectTo's Client socket
		E_Server        = 4,  // Server Listen socket
	};
protected:
	struct kData
	{
		SOCKET h_Socket;    // for Server socket: h_Socket = 0 
		DWORD  u32_IP;      // for Server socket: u32_IP   = 0
		eType       e_Type; // E_Client: ConnectTo's Client socket, E_Server: Server Listen socket
		cSocketApp* pi_SocketApp;  
	};
	class cList
		{
		public:
			 cList();
			~cList();
			
			kData*   Add(SOCKET h_Socket, DWORD u32_IP, eType e_Type, cSocketApp* pi_SocketApp);
			BOOL     Remove(DWORD u32_Index);
			void     RemoveAll();
			int      FindSocket(SOCKET h_Socket);

			DWORD    mu32_CountTotal;
			DWORD    mu32_CountClient;
			kData    mk_Data [MAX_CLIENTS + 1];//+1: for Server Listen socket : h_Socket = 0, u32_IP = 0, e_Type = E_Server
		};

public:
	cInterface(void);
   ~cInterface(void);
    DWORD   Initialize();
	DWORD  ProcessEvents(eEvent* pe_Events, eRequest* pe_Request, SOCKET* ph_Socket, DWORD* pu32_Read, DWORD* pu32_Sent);
	void   TerminateNetEventsProc();
	HANDLE mgh_SyncEvent;
protected:
	DWORD ConnectTo(char* ps8_ServerIP, DWORD s32_Port, SOCKET& h_Client);
	DWORD ConnectClose(SOCKET h_Client);

	DWORD ServerOpen(DWORD s32_Port);
	DWORD GetAllConnections(SOCKET* ph_Client, DWORD* pu32_ClientIP, DWORD& u32_ClientCount);  
	DWORD DisconnectClient(SOCKET ph_Client); 
	DWORD ServerClose();
	
	DWORD SendTo(SOCKET ph_Client, char* ps8_SendBuf, DWORD u32_SendBufLen);

	DWORD ReadFrom(SOCKET ph_Client, char*   ps8_ReadBuf, DWORD s32_ReadBufLen, INT& s32_ReadLen);

	cList  mi_List;
	
	HANDLE mh_Events[2];
	BOOL   mb_Initialized;
};

