
// cInterface.cpp

#include "cInterface.h"

cInterface::cInterface()
{
	mb_Initialized    = FALSE;
}

cInterface::~cInterface()
{
	if (mb_Initialized) 
	{
		// Unmap shared memory from the process's address space, close the process's handle to the file-mapping object
		UnmapViewOfFile(gpk_SharedMem); 
		// Close the process's handle to the file-mapping object
		CloseHandle(gh_MapObject); 
		// Close process handles for  three named event object
		CloseHandle(gh_ReqEvent);
		CloseHandle(gh_ExitEvent);
		CloseHandle(gh_SyncEvent);
	}
}
// static
DWORD cInterface::Initialize()
{
	if (mb_Initialized)
		return 0;

	// Create/Open a named file mapping object
	gh_MapObject = CreateFileMapping( 
						INVALID_HANDLE_VALUE,   // use paging file
						NULL,                   // default security attributes
						PAGE_READWRITE,         // read/write access
						0,                      // size: high 32-bits
						sizeof(kSharedMem),  // size: low 32-bits
						gt_MemName);			// name of map object

	DWORD	u32_Error;
	u32_Error = GetLastError();

	if (gh_MapObject == NULL)
		return u32_Error;

	// The first process initializes memory
	BOOL b_FirstInit = (u32_Error != ERROR_ALREADY_EXISTS); 

	// Get a pointer to the file-mapped shared memory
	gpk_SharedMem =	(kSharedMem*)MapViewOfFile( 
											gh_MapObject,		// object to map view of
											FILE_MAP_WRITE,		// read/write access
											0,					// high offset:  map from
											0,					// low offset:   beginning
											0);					// default: map entire file

	if (gpk_SharedMem == NULL) 
		return GetLastError(); 
    
	// Initialize memory if this is the first process 
	if (b_FirstInit)
		memset(gpk_SharedMem, '\0', sizeof(kSharedMem)); 
			
	//****************************************************************************************************************************
	// Create/Open named event object with auto-reset and initially blocked to wake up NetEventsProc process
	// NetEventsProc process is waiting for this event to be signaled to start request processing
	gh_ReqEvent = CreateEvent(0, FALSE, FALSE, gt_ReqEventName); // auto-reset, initially = blocked, named

	if (!gh_ReqEvent)
		return GetLastError();
	// Create/Open named event object with auto-reset and initial blocked to Exit NetEventsProc process
	// NetEventsProc process is waiting for this event to be signaled to Exit
	gh_ExitEvent = CreateEvent(0, FALSE, FALSE, gt_ExitEventName); // auto-reset, initially = blocked, named

	if (!gh_ExitEvent)
		return GetLastError();
	// Create/Open named event object with auto-reset and initially blocked to synchronize NetEventsProc process with NetEventsProcDLL
	// NetEventsProcDLL wait for this event to set signaled by NetEventsProc process when NetEventsProc process completes request processing 
	gh_SyncEvent = CreateEvent(0, FALSE, FALSE, gt_SyncEventName); // auto-reset, initially = blocked, named
	
	if (!gh_SyncEvent)
		return GetLastError();
	//****************************************************************************************************************************
	mgh_SyncEvent  = gh_SyncEvent; /* NetEventsProcDLL wait for this event to set signaled by NetEventsProc process when 
	                                  NetEventsProc process completes request processing */
	mh_Events[0]   = gh_ReqEvent;  // NetEventsProc process is waiting for this event to be signaled to start request processing
	mh_Events[1]   = gh_ExitEvent;  // NetEventsProc process is waiting for this event to be signaled to Exit
	mb_Initialized = TRUE;
	return 0;
}

// Waits for incoming events(gh_ReqEvent or gh_ExitEvent) from NetEventsProcDLL faunction  and processes them (used on Server + Client)
// returns the event(s) that occurred, NetEventsProcDLL faunction Request, and h_socket which has caused the event.
// If the event is gh_ReqEvent and  eRequest = E_SendTo/E_ReadFrom returns byte's count for E_SendTo/E_ReadFrom operations.

// If the incoming event is gh_ExitEvent or some error occurred NetEventsProc executes TerminateNetEventsProc() and terminate
// itself, i.e. exit to Windows.

// You may observe over in _DEBUG mode.

DWORD cInterface::ProcessEvents(eEvent*   pe_ParmEvent,   // OUT
								eRequest* pe_ParmRequest, // OUT
								SOCKET*   ph_ParmSocket,  // OUT
								DWORD*    pu32_ParmRead,  // OUT
								DWORD*    pu32_ParmSent)  // OUT
{
	// -------------------------------------------
	
	*pe_ParmEvent   = (eEvent)0;
	*pe_ParmRequest = (eRequest)0;
	*ph_ParmSocket  = 0;
	*pu32_ParmRead  = 0;
	*pu32_ParmSent  = 0;

	// -------------------------------------------

	// Wait until an event occurred or the timeout has elapsed
	// u32_Index is the index in the eventlist mh_Events of the event that has occurred
	DWORD u32_Index = WaitForMultipleObjects(2,          // number of objects in array
											 mh_Events,  // array of objects
											 FALSE,      // wait for any object
											 INFINITE);  // no time-out interval, no  any WAIT_TIMEOUT for u32_Index
	if (u32_Index == WAIT_FAILED)
		return WSAGetLastError();

	if (u32_Index == WAIT_TIMEOUT)
		return ERROR_TIMEOUT;

	// -------------------------------------------

	u32_Index -= WAIT_OBJECT_0;

	// -------------------------------------------
	// mh_Events[0] is used for the Request.
	if (u32_Index == 0)
	{
		*pe_ParmEvent = E_RequestEvent;
		// Process the Request that came
		if (gpk_SharedMem->e_Req == E_ConnectTo)
		{
			*pe_ParmRequest = E_ConnectTo;
			/*EXPFUNC int __stdcall  ConnectTo(char* ps8_ServerIP, //in - ps8_ServerIP = "0123456789123456"
												int   s32_Port,     //in 
												int*  ph_Client)    //out - int ph_Client[1]*/
			DWORD u32_Error = ConnectTo( gpk_SharedMem->s8_ServerIP,
				                         gpk_SharedMem->u32_Port,
										 gpk_SharedMem->h_Client);

			gpk_SharedMem->u32_ReqRes = u32_Error;

			*ph_ParmSocket = gpk_SharedMem->h_Client;

			return u32_Error;
		}
		// -------------------------------------------

		// Process the Request that came
		if (gpk_SharedMem->e_Req == E_ConnectClose)
		{
			*pe_ParmRequest = E_ConnectClose;
			//EXPFUNC int __stdcall  ConnectClose(int h_Client/*in*/)
			DWORD u32_Error = ConnectClose(gpk_SharedMem->h_Client);

			gpk_SharedMem->u32_ReqRes = u32_Error;

			*ph_ParmSocket = gpk_SharedMem->h_Client;

			return u32_Error;
		}
		// -------------------------------------------

		// Process the Request that came
		if (gpk_SharedMem->e_Req == E_ServerOpen)
		{
			*pe_ParmRequest = E_ServerOpen;
			//EXPFUNC int __stdcall  ServerOpen(int s32_Port/*in*/)
			DWORD u32_Error = ServerOpen(gpk_SharedMem->u32_Port);

			gpk_SharedMem->u32_ReqRes = u32_Error;

			return u32_Error;
			
		}
		// -------------------------------------------

		// Process the Request that came
		if (gpk_SharedMem->e_Req == E_GetAllConnections)
		{
			*pe_ParmRequest = E_GetAllConnections;
			/*EXPFUNC int __stdcall GetAllConnections(int* ph_Client,           // out - int ph_Client[62]
													  int* ps32_ClientIP,       // out - int ps32_ClientIP[62]
													  int* ps32_ClientCount)    // out  - ps32_ClientCount[1]*/
			DWORD u32_Error = GetAllConnections(gpk_SharedMem->ph_Client,
												gpk_SharedMem->pu32_ClientIP,
												gpk_SharedMem->u32_ClientCount);

			gpk_SharedMem->u32_ReqRes = u32_Error;

			return u32_Error;
			
		}
		// -------------------------------------------

		// Process the Request that came
		if (gpk_SharedMem->e_Req == E_DisconnectClient)
		{
			*pe_ParmRequest = E_DisconnectClient;
			// EXPFUNC int __stdcall DisconnectClient(SOCKET h_Client) // in
			DWORD u32_Error = DisconnectClient(gpk_SharedMem->h_Client);
			
			gpk_SharedMem->u32_ReqRes = u32_Error;
			*ph_ParmSocket = gpk_SharedMem->h_Client;
			return u32_Error;
			
		}
		// -------------------------------------------

		// Process the Request that came
		if (gpk_SharedMem->e_Req== E_ServerClose)
		{
			*pe_ParmRequest = E_ServerClose;
			// EXPFUNC int __stdcall ServerClose()
			DWORD u32_Error = ServerClose();
			
			gpk_SharedMem->u32_ReqRes = u32_Error;

			return u32_Error;
			
		}
		// -------------------------------------------

		// Process the Request that came
		if (gpk_SharedMem->e_Req== E_SendTo)
		{
			*pe_ParmRequest = E_SendTo;
			// DWORD SendTo(SOCKET h_Client, char* ps8_SendBuf, DWORD u32_SendBufLen))
			DWORD u32_Error = SendTo(gpk_SharedMem->h_Client,
									 gpk_SharedMem->s8_Data,
									 gpk_SharedMem->u32_DataLen);
			
			gpk_SharedMem->u32_ReqRes = u32_Error;
			*ph_ParmSocket = gpk_SharedMem->h_Client;
			*pu32_ParmSent = gpk_SharedMem->u32_DataLen;

			return u32_Error;
		}
		// -------------------------------------------

		// Process the Request that came
		if (gpk_SharedMem->e_Req== E_ReadFrom)
		{
			*pe_ParmRequest = E_ReadFrom;
			// DWORD ReadFrom(SOCKET h_Client, char* ps8_ReadBuf, DWORD u32_ReadBufLen, INT& s32_ReadLen)
			DWORD u32_Error = ReadFrom(gpk_SharedMem->h_Client,
									   gpk_SharedMem ->s8_Data,
									   gpk_SharedMem ->u32_DataLen,
									   gpk_SharedMem ->s32_ReadDataLen
									 );
			
			gpk_SharedMem->u32_ReqRes = u32_Error;
			*ph_ParmSocket = gpk_SharedMem->h_Client;
			*pu32_ParmRead = gpk_SharedMem->s32_ReadDataLen;

			return u32_Error;
		}
		// -------------------------------------------
	}

	// -------------------------------------------
	// mh_Events[1] is used for the Exit NetEventsProc (terminate !).
	if (u32_Index == 1)
	{
		*pe_ParmEvent = E_ExitEvent;
		return 0;
	}
}

DWORD cInterface::ConnectTo(char* ps8_ServerIP, DWORD s32_Port, SOCKET& h_Client)
{
	DWORD u32_ServerIP = inet_addr(ps8_ServerIP);
	
	if (u32_ServerIP == INADDR_NONE || u32_ServerIP == INADDR_ANY) // inet_addr failed and returned INADDR_NONE or INADDR_ANY
		return INADDR_NONE;

	cSocketApp* pi_SocketApp = new cSocketApp(s32_Port, E_PREFIXED);

	DWORD u32_Error = pi_SocketApp->ConnectTo(u32_ServerIP, h_Client);

	if (u32_Error)
	{
		delete pi_SocketApp;
		return u32_Error;
	}

	kData* pk_Data = mi_List.Add(h_Client, u32_ServerIP, E_Client, pi_SocketApp);

	if (!pk_Data)
	{
		delete pi_SocketApp;
		return WSAECONNREFUSED;
	}
		
	return 0;
}

DWORD cInterface::ConnectClose(SOCKET h_Client)
{
	int s32_Index = mi_List.FindSocket(h_Client);

	if (s32_Index < 0) 
		return  ERROR_INVALID_PARAMETER;

	mi_List.mk_Data[s32_Index].pi_SocketApp->CloseSockets();

	mi_List.Remove(s32_Index);

	return 0;
}

DWORD cInterface::ServerOpen(DWORD s32_Port)
{
	// Server socket may be already open...
	int s32_Index = mi_List.FindSocket(0);

	if (s32_Index >= 0) 
		return WSAEADDRINUSE; // Server already open, only single server is permitted

	cSocketApp* pi_SocketApp = new cSocketApp(s32_Port, E_PREFIXED);
	DWORD u32_Error = pi_SocketApp->Listen();

	if (u32_Error)
	{
		delete pi_SocketApp;
		return u32_Error;
	}
			
	kData* pk_Data = mi_List.Add(0, 0, E_Server, pi_SocketApp);

	return 0;
}

DWORD cInterface::GetAllConnections(SOCKET* ph_Client, DWORD* pu32_ClientIP, DWORD& u32_ClientCount)
{
	// get Server socket element, this element has mi_List.mk_Data[i].h_Socket = 0
	int s32_Index = mi_List.FindSocket(0);

	if (s32_Index < 0) 
		return  WSAENOTCONN; // Server is not open

	cSocketApp* pi_SocketApp = mi_List.mk_Data[s32_Index].pi_SocketApp;

	kCon k_Con;
	k_Con = pi_SocketApp->GetAllConnections();

	u32_ClientCount = k_Con.u32_ClientCount;

	for (DWORD i = 0; i<u32_ClientCount; i++)
	{
		ph_Client[i]     = k_Con.k_Client[i].h_Client;
		pu32_ClientIP[i] = k_Con.k_Client[i].u32_ClientIP;
	}
	
	return 0;
}

DWORD cInterface::DisconnectClient(SOCKET ph_Client)
{
	// get Server socket element, this element has mi_List.mk_Data[i].h_Socket = 0
	int s32_Index = mi_List.FindSocket(0);

	if (s32_Index < 0) 
		return WSAENOTCONN; // Server is not open

	// get pointer to Listen socket
	cSocketApp* pi_SocketApp = mi_List.mk_Data[s32_Index].pi_SocketApp;	

	kCon k_Con;
	k_Con = pi_SocketApp->GetAllConnections();

	DWORD u32_Count = k_Con.u32_ClientCount;

	if (!u32_Count)
		return ERROR_INVALID_PARAMETER;   // Listen socket exists, but have no any peer Clients 

	for (DWORD i = 0; i<u32_Count; i++)
	{
		if (k_Con.k_Client[i].h_Client == ph_Client)
		{
			DWORD u32_Error = pi_SocketApp->DisconnectClient(ph_Client);
			return u32_Error;
		}
	}

	return ERROR_INVALID_PARAMETER; // no such socket(h_Socket) in Listen's connected client list
}

DWORD cInterface::ServerClose()
{
	// get Server socket element, this element has mi_List.mk_Data[i].h_Socket = 0
	int s32_Index = mi_List.FindSocket(0);

	if (s32_Index < 0) 
		return WSAENOTCONN; // Server is not open

	// get pointer to Listen socket
	cSocketApp* pi_SocketApp = mi_List.mk_Data[s32_Index].pi_SocketApp;	

	pi_SocketApp->CloseSockets();

	mi_List.Remove(s32_Index); 

	return 0;  
}

DWORD cInterface::SendTo(SOCKET h_Client, char* ps8_SendBuf, DWORD u32_SendBufLen)
{
	cSocketApp* pi_SocketApp;

	int s32_IndexClient = mi_List.FindSocket(h_Client);

	if (s32_IndexClient >=0)
		pi_SocketApp = mi_List.mk_Data[s32_IndexClient].pi_SocketApp;

	if (s32_IndexClient < 0)  // no Client with this socket
	{
		int s32_IndexServer = mi_List.FindSocket(0);

		if (s32_IndexServer < 0) 
			return ERROR_INVALID_PARAMETER; // no Client with this socket, Server at all is not opened
		
		// get pointer to Listen socket
		pi_SocketApp = mi_List.mk_Data[s32_IndexServer].pi_SocketApp;	
				
		kCon k_Con;
		k_Con = pi_SocketApp->GetAllConnections();

		DWORD u32_Count = k_Con.u32_ClientCount;

		if (!u32_Count)
			return ERROR_INVALID_PARAMETER;   // no Client with such socket, Listen socket exists, but have no any peer Clients 

		for (DWORD i = 0; i<u32_Count; i++)
		{
			if (k_Con.k_Client[i].h_Client == h_Client)
				break;
			else
				continue;
			return ERROR_INVALID_PARAMETER; //no Client with such socket, Listen socket exists, but have no peer Clients with such socket
		}
	}
	
	DWORD u32_Error = pi_SocketApp->SendTo(h_Client, ps8_SendBuf, u32_SendBufLen);
	return u32_Error;
}

DWORD cInterface::ReadFrom(SOCKET h_Client, char* ps8_ReadBuf, DWORD s32_ReadBufLen, INT& s32_ReadLen)
{
	cSocketApp* pi_SocketApp;

	int s32_IndexClient = mi_List.FindSocket(h_Client);

	if (s32_IndexClient >=0)
		pi_SocketApp = mi_List.mk_Data[s32_IndexClient].pi_SocketApp;

	if (s32_IndexClient < 0)  // no Client with this socket
	{
		int s32_IndexServer = mi_List.FindSocket(0);

		if (s32_IndexServer < 0) 
			return ERROR_INVALID_PARAMETER; // no Client with this socket, Server at all is not opened
		
		// get pointer to Listen socket
		pi_SocketApp = mi_List.mk_Data[s32_IndexServer].pi_SocketApp;	
				
		kCon k_Con;
		k_Con = pi_SocketApp->GetAllConnections();

		DWORD u32_Count = k_Con.u32_ClientCount;

		if (!u32_Count)
			return ERROR_INVALID_PARAMETER;   // no Client with such socket, Listen socket exists, but have no any peer Clients 

		for (DWORD i = 0; i<u32_Count; i++)
		{
			if (k_Con.k_Client[i].h_Client == h_Client)
				break;
			else
				continue;
			return ERROR_INVALID_PARAMETER; //no Client with such socket, Listen socket exists, but have no peer Clients with such socket
		}
	}
	
	DWORD u32_Error = pi_SocketApp->ReadFrom(h_Client, ps8_ReadBuf, s32_ReadBufLen, s32_ReadLen);

	return u32_Error;
}

void cInterface::TerminateNetEventsProc()
{
	for (DWORD i = 0; i<mi_List.mu32_CountTotal; i++)
		mi_List.mk_Data[i].pi_SocketApp->CloseSockets(); 

	mi_List.RemoveAll();
}
/***************************************************************************************
****************************************************************************************

	embedded class cList

	Description:
	Stores all ConnectTo's Client sockets and one single Listen's socket
	CLIENTS:
	Stores for all ConnectTo's Client sockets: 
	  - SOCKET h_Socket,          their Handle,
	  - DWORD  u32_IP,            their peer's IP address, 
	  - cSocketApp* pi_SocketApp  their pointer to cSocketApp instance

	SERVER:
    Stores for Listen's single socket:
	  - SOCKET h_Socket = 0
	  - DWORD  u32_IP   = 0
	  - cSocketApp* pi_SocketApp  pointer to cSocketApp instance for Listen socket 
		
****************************************************************************************
****************************************************************************************/

cInterface::cList::cList()
{
	mu32_CountTotal  = 0;
	mu32_CountClient = 0;
}

cInterface::cList::~cList()
{
	RemoveAll();
}

cInterface::kData* cInterface::cList::Add(SOCKET h_Socket, DWORD u32_IP, eType e_Type, cSocketApp* pi_SocketApp)
{
	// Store max 63 sockets: 62 - for ConnectTo's Clients sockets and +1 for Server Listen socket
	if (mu32_CountTotal >= MAX_CLIENTS + 1)
		return 0;

	if (e_Type == E_Client && mu32_CountClient >= MAX_CLIENTS)
		return 0;

	if (e_Type == E_Client)
		mu32_CountClient++;

	memset(&mk_Data[mu32_CountTotal], 0, sizeof(kData));

	mk_Data  [mu32_CountTotal].h_Socket      = h_Socket;
	mk_Data  [mu32_CountTotal].u32_IP        = u32_IP;
	mk_Data  [mu32_CountTotal].e_Type        = e_Type;
	mk_Data  [mu32_CountTotal].pi_SocketApp  = pi_SocketApp;

	return &mk_Data[mu32_CountTotal++];
}

// returns the index of the given socket in the socket list
// returns -1 if not found
int cInterface::cList::FindSocket(SOCKET h_Socket)
{
	for (DWORD i=0; i<mu32_CountTotal; i++)
	{
		if (!mk_Data[i].pi_SocketApp->GetSocketCount())
		{
			Remove(i); // dummy socket
			continue;
		}
	}

	for (DWORD i=0; i<mu32_CountTotal; i++)
	{
		if (mk_Data[i].h_Socket == h_Socket)
		{
			return i;
		}
	}
	return -1;
}

BOOL cInterface::cList::Remove(DWORD u32_Index)
{
	if (u32_Index >= mu32_CountTotal)
		return FALSE;

	if (mk_Data[u32_Index].pi_SocketApp) delete mk_Data[u32_Index].pi_SocketApp;

	if (mk_Data[u32_Index].e_Type == E_Client)
		mu32_CountClient--;

	// Close the gap by copying the last socket to the deleted location
	mu32_CountTotal--;
	mk_Data  [u32_Index] = mk_Data [mu32_CountTotal];

	return TRUE;
}

void cInterface::cList::RemoveAll()
{
	while (mu32_CountTotal)
	{
		Remove(mu32_CountTotal-1);
	}
}