//+---------------------------------------------------------------------------+
//|                                            NetEventsProc.cpp              |
//|                      Copyright  2012, http://www.mql4.com/ru/users/more  |
//|                                       tradertobe@gmail.com                |
//+---------------------------------------------------------------------------+

// NetEventsProc.cpp

#include "cInterface.h"
#include <iostream>

int main()
{
	cInterface i_Interface;
	DWORD u32_Error = i_Interface.Initialize();

	gh_SyncEvent = i_Interface.mgh_SyncEvent;

	TCHAR t_Message[300];

	if (u32_Error)
	{
		#if !_DEBUG
		AllocConsole();
		freopen( "CONOUT$", "wb", stdout);
		#endif

		sprintf(t_Message, "\nNetEventsProc initialization error: %d. NetEventsProc is not running !\n", u32_Error);
		printf(t_Message);

		Sleep(5000); // 5 sec. to allow for user to read message

		// Close child process and child thread handles. 
		CloseHandle(gpk_SharedMem->h_NetEventsProcProcess );
		CloseHandle(gpk_SharedMem->h_NetEventsProcThread);
		return 1;
	}
	else
		#if _DEBUG
		printf("\nNetEventsProc is running !\n");
		#endif


	while(TRUE)
	{
		eEvent   e_Event;   
		eRequest e_Request;  
		SOCKET   h_Socket;   
		DWORD    u32_Read;   
		DWORD    u32_Sent; 

		u32_Error = i_Interface.ProcessEvents(&e_Event, &e_Request, &h_Socket,  &u32_Read, &u32_Sent);

		if (!e_Event)
		{
			#if !_DEBUG
			AllocConsole();
			freopen( "CONOUT$", "wb", stdout);
			#endif
			sprintf(t_Message, "\nNetEventsProc WaitForMultipleObjects(...) error: %d. NetEventsProc is terminating !\n", u32_Error);
			printf(t_Message);

			Sleep(5000); // 5 sec. to allow for user to read message

			i_Interface.TerminateNetEventsProc();
			return 2;
		}

		if (e_Event == E_ExitEvent)
		{
			#if _DEBUG
			sprintf(t_Message, "\nNetEventsProc recieved Terminate command. NetEventsProc is now normally terminating !\n");
			printf(t_Message);

			Sleep(5000); // 5 sec. to allow for user to read message

			#endif

			i_Interface.TerminateNetEventsProc();
			return 0;
		}

		if (e_Event == E_RequestEvent)
		{
			//report NetEventsProcDLL function - request done !
			if (!SetEvent(i_Interface.mgh_SyncEvent))
			{
				#if !_DEBUG
				AllocConsole();
				freopen( "CONOUT$", "wb", stdout);
				#endif
				sprintf(t_Message, "\nSetEvent(gh_SyncEvent) error: %d. NetEventsProc is terminating !\n", GetLastError());
				printf(t_Message);

				Sleep(9000); // 5 sec. to allow for user to read message

				i_Interface.TerminateNetEventsProc();
				return 3;
			}
			#if _DEBUG
			switch(e_Request)
			{
			case E_ConnectTo:		  sprintf(t_Message, "\nE_ConnectTo Request, ProcessEvents Return: %d\n", u32_Error);
									  printf(t_Message); break;	
			case E_ConnectClose:	  sprintf(t_Message, "\nE_ConnectClose Request, ProcessEvents Return: %d\n", u32_Error);
									  printf(t_Message); break;	

			case E_ServerOpen:		  sprintf(t_Message, "\nE_ServerOpen Request, ProcessEvents Return: %d\n", u32_Error);
									  printf(t_Message); break;	
			case E_GetAllConnections: sprintf(t_Message, "\nE_GetAllConnections Request, ProcessEvents Return: %d\n", u32_Error);
									  printf(t_Message); break;	
			case E_DisconnectClient:  sprintf(t_Message, "\nE_DisconnectClient Request, ProcessEvents Return: %d\n", u32_Error);
									  printf(t_Message); break;	
			case E_ServerClose:		  sprintf(t_Message, "\nE_ServerClose Request, ProcessEvents Return: %d\n", u32_Error);
									  printf(t_Message); break;	

			case E_SendTo:   sprintf(t_Message, "\nE_SendTo Request, h_Socket = %d  Sent = %d bytes, ProcessEvents Return: %d\n",h_Socket, u32_Sent , u32_Error);
						     printf(t_Message); break;
			case E_ReadFrom: sprintf(t_Message, "\nE_ReadFrom Request, h_Socket = %d Read = %d bytes, ProcessEvents Return: %d\n",h_Socket, u32_Read , u32_Error);
						     printf(t_Message); break;

			default: break;
			}
			#endif
		}
	}
	return 0;
}
