//+------------------------------------------------------------------+
//|                                                UniformRandom.mqh |
//|                        Copyright 2023, MetaQuotes Software Corp. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2023, MetaQuotes Software Corp."
#property link      "https://www.mql5.com"
//+----------------------------------------------------------------------+
//|  CUniFrand class: Uniformly distributed random 0 - 1 number generator|
//+----------------------------------------------------------------------+

class CUniFrand
{
 private :
   uint m_m[256];
   int m_mwc_initialized;
   int m_mwc_seed;
   uint m_carry;
   
   uint random  (void);
   
 public :
    //constructor
    CUniFrand (void);
    //desctructor
    ~CUniFrand (void);
    //optionally set a seed for number generator
    void   SetSeed ( const int iseed);
    //get random number between 0 and 1
    double RandomDouble(void);
};
//+------------------------------------------------------------------+
//|  Default constructor                                             |
//+------------------------------------------------------------------+
CUniFrand::CUniFrand(void)
{
  m_mwc_initialized=0;
  m_mwc_seed=123456789;
  m_carry=362436;
}
//+------------------------------------------------------------------+
//|   Destructor                                                     |
//+------------------------------------------------------------------+
 CUniFrand::~CUniFrand(void)
{
}
//+------------------------------------------------------------------+
//| creates and returns random integer number                        |
//+------------------------------------------------------------------+
uint CUniFrand::random(void)
{
  uint t,a=809430660;
  static uchar i;
  if(!m_mwc_initialized)
    {
     uint k,j=m_mwc_seed;
     m_mwc_initialized=1;
     for(k=0;k<256;k++)
       {
        j = 69069 * j + 12345;
        m_m[k]=j;
       }
    }
  
  t=a*m_m[++i] + m_carry;
  m_carry = (uint)(t>>32);
  m_m[i]  = (uint)(t&UINT_MAX);
  
 
     
  return m_m[i];
}
//+------------------------------------------------------------------+
//| Optionally set the seed for random number generator              |
//+------------------------------------------------------------------+
void CUniFrand::SetSeed(const int iseed)
{
 m_mwc_seed=iseed;
 m_mwc_initialized=0;
}
//+------------------------------------------------------------------+
//| returns a random number between 0 and 1                          |
//+------------------------------------------------------------------+
double CUniFrand::RandomDouble(void)
{
 double mult =1.0/UINT_MAX;
 return mult * random();
}