//+------------------------------------------------------------------+
//|                                                       SynBar.mq4 |
//|                                    Copyright 2011, Rustem Bigeev |
//|                                                    rbigeev@bk.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2011, Rustem Bigeev"
#property link      "rbigeev@bk.ru"
#property indicator_chart_window
#include <WinUser32.mqh>
//--- input parameters
extern int       ExtBarHeight=100;
extern bool      SplitOnline=true;

double   d_open   = 0;
double   d_high   = 0;
double   d_low    = 0;
double   d_close  = 0;
int      d_volume = 0;
int      i_time   = 0;
double   barsize  = 0;
int      ExtHandle;
int      hwnd=0;
int      i_period=9;//Period()*ExtPeriodMultiplier;
int      last_fpos;
int      cur_time;
int      last_time;
int      whereami;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   ObjectDelete("EBH1"); 
   ObjectDelete("EBH2");
   ObjectCreate("EBH1",OBJ_LABEL,0,0,0);
   ObjectSet("EBH1",OBJPROP_XDISTANCE,10);
   ObjectSet("EBH1",OBJPROP_YDISTANCE,50);
   ObjectSetText("EBH1","0"+ExtBarHeight);
   int    version=400;
   string c_copyright;
   string c_symbol=Symbol();
   int    i_digits=Digits;
   int    i_unused[13];
//----  
   ExtHandle=FileOpenHistory(c_symbol+i_period+".hst",FILE_BIN|FILE_WRITE);
   if(ExtHandle<0) return(-1);
//---- write history file header
   c_copyright="(C)opyright 2003, MetaQuotes Software Corp.";
   FileWriteInteger(ExtHandle,version,LONG_VALUE);
   FileWriteString(ExtHandle,c_copyright,64);
   FileWriteString(ExtHandle,c_symbol,12);
   FileWriteInteger(ExtHandle,i_period,LONG_VALUE);
   FileWriteInteger(ExtHandle,i_digits,LONG_VALUE);
   FileWriteInteger(ExtHandle, 0, LONG_VALUE);       //timesign
   FileWriteInteger(ExtHandle, 0, LONG_VALUE);       //last_sync
   FileWriteArray(ExtHandle,i_unused,0,13);
   FileFlush(ExtHandle);
   last_fpos=FileTell(ExtHandle);

   barsize=ExtBarHeight*Point;
   for(int i=Bars-1; i>0; i--) processbar(i);
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
///////////////////////////////////////////////////////////////////////
   if(hwnd==0)
     {
      hwnd=WindowHandle(Symbol(),i_period);
      if(hwnd!=0) Print("Chart window detected");
     }
///////////////////////////////////////////////////////////////////////
   if(Volume[0]==1) 
     {
      processbar(1);
      if(hwnd!=0) PostMessageA(hwnd,WM_COMMAND,33324,0);
      return(0);
     }
///////////////////////////////////////////////////////////////////////
   cur_time=LocalTime();
   if(cur_time-last_time>=2) 
     {
      whereami=0;
      d_volume++;
      if(SplitOnline) movetopoint(Close[0]);
      savebar(d_open,MathMax(d_high,Close[0]),MathMin(d_low,Close[0]),Close[0]);

      FileFlush(ExtHandle);
      if(hwnd!=0) PostMessageA(hwnd,WM_COMMAND,33324,0);
      last_time=cur_time;
     }
  }
//+------------------------------------------------------------------+
//| Processing of bars                                               |
//+------------------------------------------------------------------+
int processbar(int n)
  {
   whereami = n;
   d_volume = 1;
   i_time=Time[n];
   movetopoint(Open[n]);
   if(Open[n]>Close[n]) 
   {
     movetopoint(High[n]);
     movetopoint(Low[n]);
   }
   else 
   {
    movetopoint(Low[n]);
    movetopoint(High[n]);
   }
   movetopoint(Close[n]);
  }
//+------------------------------------------------------------------+
//| Plotting a bar                                                   |
//+------------------------------------------------------------------+
int movetopoint(double price)
  {
   if(d_open<Point)  // if at the start of operation
   {
     d_open=price; 
     d_high=price; 
     d_low=price; 
   } 
   d_close=price;
   if(d_close > d_high) d_high = d_close;
   if(d_close < d_low ) d_low  = d_close;
   if(d_high-d_low>barsize) checkbarsize(); // should a piece of the bar perhaps be 'cut off'?
  }
//+------------------------------------------------------------------+
//| Checking the bar size                                            |
//+------------------------------------------------------------------+
int checkbarsize()
  {
   while(d_close-d_low>barsize)
     {// up
      savebar(d_open,d_low+barsize,d_low,d_low+barsize);
      d_low=d_low+barsize;
      d_open=d_low;
      last_fpos=FileTell(ExtHandle);
     }
   while(d_high-d_close>barsize)
     {// down
      savebar(d_open,d_high,d_high-barsize,d_high-barsize);
      d_high = d_high - barsize;
      d_open = d_high;
      last_fpos=FileTell(ExtHandle);
     }
  }
//+------------------------------------------------------------------+
//| Saving the bar to the file                                       |
//+------------------------------------------------------------------+
int savebar(double o,double h,double l,double c)
  {
   FileSeek(ExtHandle,last_fpos,SEEK_SET);
   FileWriteInteger(ExtHandle,i_time,LONG_VALUE);
   FileWriteDouble(ExtHandle,o,DOUBLE_VALUE);
   FileWriteDouble(ExtHandle,l,DOUBLE_VALUE);
   FileWriteDouble(ExtHandle,h,DOUBLE_VALUE);
   FileWriteDouble(ExtHandle,c,DOUBLE_VALUE);
   FileWriteDouble(ExtHandle,d_volume,DOUBLE_VALUE);
   FileFlush(ExtHandle);
   i_time+=1;
  }
//+------------------------------------------------------------------+

