//+------------------------------------------------------------------+
//|                                OffensiveDefensiveScatterPlot.mq5 |
//|                        Copyright 2023, MetaQuotes Software Corp. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2023, MetaQuotes Software Corp."
#property link      "https://www.mql5.com"
#property version   "1.00"
#property script_show_inputs
#include <Graphics\Graphic.mqh>
#include<Janus.mqh>

input ENUM_PRICE AppliedPrice=CLOSE;
input ENUM_DIFF_TYPE AppliedDiffType=DIFF_LOG;
input ENUM_INDEX_TYPE SelectIndexType=INDEX_FOREX_MAJORS;
input uint AppliedPeriod = 25;
input string BenchMarkSymbols="";
input int MaxBars = 50;

CJanus *janus;
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//---   
   janus=new CJanus();   
//--- 
   if(!janus.Initialize(AppliedPrice,AppliedDiffType,SelectIndexType,PERIOD_CURRENT,MaxBars,BenchMarkSymbols))
     {
      if(CheckPointer(janus)==POINTER_DYNAMIC)
        delete janus;
     }
//--- 
   janus.Update();
//---
   double y[];
   double x[];
   
   int size=janus.GetSymbolsTotal();
   
   ArrayResize(x,size);
   ArrayResize(y,size);
   
   long chart=0;
   string name="OffenseDefense";
   
  for(int k=MaxBars-1;k>=0;k--) 
   {
    for(int i=0;i<size;i++)
    {
     string ssy=janus.GetSymbolAt(i);
     janus.CalculateSymbolOffenseDefense(k,ssy,AppliedPeriod,y[i],x[i]);
    }
    
    CGraphic graphic;
   if(ObjectFind(chart,name)<0)
      graphic.Create(chart,name,0,0,0,780,380);
   else
      graphic.Attach(chart,name);
//---
   graphic.CurveAdd(x,y,ColorToARGB(clrBlue),CURVE_POINTS,"DefensiveOffensive ");
//---
   graphic.CurvePlotAll();
//---
   graphic.Update();
   Sleep(5*1000);
   graphic.Destroy();
   ChartRedraw();
  }  
  
  if(CheckPointer(janus)==POINTER_DYNAMIC)
        delete janus;
        
  ChartSetInteger(0,CHART_SHOW,true);      
              
 }
