//+------------------------------------------------------------------+
//|                                             RelativeStrength.mq5 |
//|                        Copyright 2023, MetaQuotes Software Corp. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2023, MetaQuotes Software Corp."
#property link      "https://www.mql5.com"
#property version   "1.00"
#property indicator_separate_window
#property indicator_buffers 1
#property indicator_plots   1
//--- plot RelativeStrength
#property indicator_label1  "RelativeStrength"
#property indicator_type1   DRAW_LINE
#property indicator_color1  clrRed
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
#include<Janus.mqh>
//inputs
input ENUM_PRICE AppliedPrice=CLOSE;
input ENUM_DIFF_TYPE AppliedDiffType=DIFF_LOG;
input ENUM_INDEX_TYPE SelectIndexType=INDEX_FOREX_MAJORS;
input uint AppliedPeriod = 25;
input string BenchMarkSymbols="";
input int MaxBars = 300;
//--- indicator buffers
double         RelativeStrengthBuffer[];
//---
CJanus *janus;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,RelativeStrengthBuffer,INDICATOR_DATA);
//---    
   ArraySetAsSeries(RelativeStrengthBuffer,true);
//---   
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
   IndicatorSetString(INDICATOR_SHORTNAME,"RS("+_Symbol+")("+string(AppliedPeriod)+")");
//---
   janus=new CJanus();   
//--- 
   if(!janus.Initialize(AppliedPrice,AppliedDiffType,SelectIndexType,PERIOD_CURRENT,MaxBars,BenchMarkSymbols))
     return(INIT_FAILED);     
//---
   
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//|Custom indicator deinitialization function                        |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
 {
//--- 
  switch(reason)
   {
    case REASON_INITFAILED:
      ChartIndicatorDelete(ChartID(),ChartWindowFind(),"RS("+_Symbol+")("+string(AppliedPeriod)+")");
       break;
    default:
       break;
   } 
//---
   if(CheckPointer(janus)==POINTER_DYNAMIC)
      delete janus;       
 }     
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---
   int limit;
   if(prev_calculated<=0)
     {
      limit=janus.HistorySize()-int(AppliedPeriod+2);
      PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,rates_total-limit+1);
     } 
   else 
     limit=rates_total-prev_calculated;
   //---  
   if(!janus.Update())
     return(prev_calculated); 
     
   for(int i=limit;i>=1;i--)
    {
     RelativeStrengthBuffer[i]=janus.CalculateRelativeStrength(i,_Symbol,AppliedPeriod);
    } 
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
