#include "example.h"
#include <iostream>
#include <cassert>
#include <vector>
#include <memory>

int main() {
	int res = 0;

	std::cout << "--- misc ---\n";
	res = add(1,2);
	std::cout << "add(1,2): " << res << std::endl;
	assert(res == 3);

	res = 0;

	res = sub(2,1);
	std::cout << "sub(2,1): " << res << std::endl;
	assert(res == 1);

	res = 0;

	std::cout << "hardware concurrency: " << num_hardware_concurrency() << std::endl;
	std::cout << "--- end ---\n" << std::endl;

	std::vector<int> arr(1000000000, 1);

	std::cout << "--- single-threaded sum(1000M) ---\n";
	res = single_threaded_sum(arr.data(), arr.size());
	std::cout << "sum: " << res << std::endl;
	assert(res == 1000000000);
	std::cout << "--- end ---\n" << std::endl;
	
	res = 0;

	// this would needs around ~4 GB of memory provided that sizeof(int) is 4 bytes
	//std::cout << "--- multi-threaded sum_v1(1000M) ---\n";
	//sum = multi_threaded_sum_v1(arr.data(), arr.size());
	//std::cout << "sum: " << sum << std::endl;
	//assert(sum == 1000000000);
	//std::cout << "--- end ---\n" << std::endl;

	//sum = 0;

	std::cout << "--- multi-threaded sum_v2(1000M) ---\n";
	res = multi_threaded_sum_v2(arr.data(), arr.size());
	std::cout << "sum: " << res << std::endl;
	assert(res == 1000000000);
	std::cout << "--- end ---" << std::endl;

	return 0;
}
