//+------------------------------------------------------------------+
#property service
#property copyright "Daniel Jose"
#property description "Quote sharing service between"
#property description "MetaTrader 5 and Excel"
#property version   "1.00"
//+------------------------------------------------------------------+
input string user01 = "Quote.csv"; //FileName
//+------------------------------------------------------------------+
class C_ShareAtExcel
{
    private :
            string  szSymbol[],
                    szFileName;
            int     maxBuff;
            bool    bError;
//+------------------------------------------------------------------+
inline void Message(const string szMsg)
                    {
                            PrintFormat("Sharing service with Excel: [%s].", szMsg);
                    }
//+------------------------------------------------------------------+
    public  :
//+------------------------------------------------------------------+
            C_ShareAtExcel(string szArg)
                    :bError(true),
                     maxBuff(0),
                     szFileName(szArg)
                    {
                            int     file;
                            string  sz0, szRet[];
    
                            if ((file = FileOpen(szFileName, FILE_CSV | FILE_READ | FILE_ANSI)) == INVALID_HANDLE)
                            {
                                    Message("Failed");
                                    return;
                            }
                            while (!FileIsEnding(file))
                            {
                                    sz0 = FileReadString(file);
                                    if (StringSplit(sz0, ';', szRet) > 1)
                                    {
                                            ArrayResize(szSymbol, maxBuff + 1);
                                            szSymbol[maxBuff] = szRet[0];
                                            StringToUpper(szSymbol[maxBuff]);
                                            maxBuff++;
                                    }
                            }
                            FileClose(file);
                            bError = false;
                            Message("Started");
                    }
//+------------------------------------------------------------------+
            ~C_ShareAtExcel()
                    {
                            ArrayResize(szSymbol, 0);
                            Message("Finished");
                    }
//+------------------------------------------------------------------+
            void Looping(int seconds)
                    {
                            string  szInfo;
                            int     file;
                            
                            while ((!_StopFlag) && (!bError))
                            {
                                    szInfo = "";
                                    for (int c0 = 0; c0 < maxBuff; c0++)
                                            szInfo += StringFormat("%s;%0.2f\r\n", szSymbol[c0], iClose(szSymbol[c0], PERIOD_D1, 0));
                                    if ((file = FileOpen(szFileName, FILE_TXT | FILE_WRITE | FILE_ANSI | FILE_SHARE_WRITE)) != INVALID_HANDLE)
                                    {
                                            FileWriteString(file, szInfo);
                                            FileClose(file);
                                    };
                                    Sleep(seconds * 1000);
                            }
                    }
//+------------------------------------------------------------------+
};
//+------------------------------------------------------------------+
C_ShareAtExcel *share;
//+------------------------------------------------------------------+
void OnStart()
{
    share = new C_ShareAtExcel(user01);
    
    share.Looping(2);
    
    delete share;
}
//+------------------------------------------------------------------+