//---------------------------------------------------------------------------

#include <vcl.h>
#include <windows.h>
#include <Graphics.hpp>
#include <gdiplus.h>
#include <stdio.h>
#pragma comment(lib, "gdiplus.lib")

#pragma hdrstop
//---------------------------------------------------------------------------

#pragma argsused
int WINAPI DllEntryPoint(HINSTANCE hinst, unsigned long reason, void* lpReserved)
{
	return 1;
}
//---------------------------------------------------------------------------


using namespace Gdiplus;

int GetEncoderClsid(const WCHAR* format, CLSID* pClsid)
{
   UINT  num = 0;          // number of image encoders
   UINT  size = 0;         // size of the image encoder array in bytes

   ImageCodecInfo* pImageCodecInfo = NULL;

   GetImageEncodersSize(&num, &size);
   if(size == 0)
      return -1;  // Failure

   pImageCodecInfo = (ImageCodecInfo*)(malloc(size));
   if(pImageCodecInfo == NULL)
      return -1;  // Failure

   GetImageEncoders(num, size, pImageCodecInfo);

   for(UINT j = 0; j < num; ++j)
   {
      if( wcscmp(pImageCodecInfo[j].MimeType, format) == 0 )
      {
         *pClsid = pImageCodecInfo[j].Clsid;
		 free(pImageCodecInfo);
         return j;  // Success
      }    
   }

   free(pImageCodecInfo);
   return -1;  // Failure
}
//---------------------------------------------------------------------------
extern "C" __declspec(dllexport) bool __stdcall  Convert_PNG(char *src, char *dst, int X_Size, int Y_Size)
{
   GdiplusStartupInput gdiplusStartupInput;
   ULONG_PTR gdiplusToken;
   GdiplusStartup(&gdiplusToken, &gdiplusStartupInput, NULL);

   CLSID   encoderClsid;
   Status  stat;
   Image*   image = new Image((WCHAR *)src);
   Bitmap* bmp = new Bitmap(X_Size, Y_Size, image);
   // Get the CLSID of the PNG encoder.
   GetEncoderClsid(L"image/bmp", &encoderClsid);

   stat = image->Save((WCHAR *)dst, &encoderClsid, NULL);

   if(stat != Ok) return false;

   delete image;
   GdiplusShutdown(gdiplusToken);
   return true;
}
