//+------------------------------------------------------------------+
//|                                           Google_Charts_test.mq5 |
//|                        Copyright 2010, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#include <Google_Charts.mqh>

#property copyright "Copyright 2010, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"
#property script_show_inputs

//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
input DIAGRAM_TYPE diagram_type=1;// diagram type
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void OnStart()
  {
//---
   ObjectDelete(0,"test diagram");
   if(!ObjectCreate(0,"test diagram",OBJ_BITMAP_LABEL,0,0,0))
     {Alert("Graphical object is not created"); return;}
   ObjectSetInteger(0,"test diagram",OBJPROP_XDISTANCE,0);
   ObjectSetInteger(0,"test diagram",OBJPROP_YDISTANCE,0);
   switch(diagram_type)
     {
      case 0: {Alert("Basic class doesn't draw diagrams, choose another one"); return;}
      case 1: {CLineXYChart_Example(); return;}
      case 2: {CFormulaChart_Example(); return;}
      case 3: {CBarChart_Example(); return;}
      case 4: {CPieChart_Example(); return;}
      case 5: {CGraphChart_Example(); return;}
      case 6: {CRadarChart_Example(); return;}
      case 7: {CQRCode_Example(); return;}
      case 8: {CVennChart_Example(); return;}
      case 9: {CCandleChart_Example(); return;}
      case 10: {CScatterChart_Example(); return;}
      case 11: {CMapChart_Example(); return;}
     }
  }
//+------------------------------------------------------------------+
void CLineXYChart_Example()
  {
//create an instance of class
   CLineXYChart chart;
//bind it to a previously created object
   chart.Attach(0,"test diagram");
//set size
   chart.SetSize(700,400);
//prepare data
   double Y3[10]={1000, 1200, 1800, 1700, 1300, 900, 700, 750, 800, 600};
   double X3[10]={2, 4, 5, 6, 10, 15, 17, 20, 21, 23};
   double Y2[10]={-70, -5, 6, 8, 10, 20, 100, 130, 90, 60};
   double Y[10]={-50,-40,-25,-35,10,50,70,40,15,80};
//add lines
   int first_line=chart.AddLine(Y,Red,0,"Test line");
   int second_line=chart.AddLine(Y2,Blue,0,"Test line 2");
   int third_line=chart.AddLine(Y3,X3,Green,0,"Test line 3");
//main axes
   chart.SetAxis(DIAGRAM_AXIS_BOTTOM|DIAGRAM_AXIS_LEFT,-1,0,0,10,0);
//secondary axes 
   chart.SetAxis(DIAGRAM_AXIS_RIGHT|DIAGRAM_AXIS_TOP,third_line,0,Red,15,2);
//grid
   chart.SetGrid();
//legend
   chart.ShowLegend(DIAGRAM_LEGEND_POSITION_BOTTOM_HORIZONTAL);
//heading
   chart.SetTitle("My Chart",Green,15);
//filling of chart
   chart.SetFill(Linen,Silver);
//markers
   chart.SetLineMarker(first_line, DIAGRAM_LINE_MARKERS_DIAMOND, BlueViolet, 10);
   chart.SetLineMarker(second_line, DIAGRAM_LINE_MARKERS_CROSS, YellowGreen, 15);
//set filling between two lines
   chart.SetLineFilling(first_line,Lime,second_line);
//add labels
   chart.AddLabel(first_line, DIAGRAM_LABEL_TYPE_FLAG, 5, "Flag", Red, 15);
   chart.AddLabel(second_line, DIAGRAM_LABELS_TYPE_ANNOTATION, 3, "annotation", Blue, 25);
//slightly compress lines (by 20%)
   chart.SetLineScaling(second_line,false,20);
//bind third line to the secondary axes
   chart.SetLineScaling(third_line,true,20);
//get chart
   chart.GetChart();
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CBarChart_Example()
  {
   CBarChart chart;
   chart.Attach(0,"test diagram");
//set size
   chart.SetSize(700,400);
//prepare data
   double Y3[10]={100, 120, 18, 17, 13, 9, 70, 75, 80, 60};
   double Y2[10]={70, 5, 6, 8, 10, 20, 100, 130, 90, 60};
   double Y[10]={50,40,25,35,10,50,70,40,15,80};
//add lines
   int first_line=chart.AddLine(Y,Red,0,"Test bar 1");
   int second_line=chart.AddLine(Y2,Blue,0,"Test bar 2");
   int third_line=chart.AddLine(Y3,Green,0,"Test bar 3");
//main axes
   chart.SetAxis(DIAGRAM_AXIS_BOTTOM|DIAGRAM_AXIS_LEFT,-1,0,0,10,0);
//grid
   chart.SetGrid();
//legend
   chart.ShowLegend();
//heading
   chart.SetTitle("My Chart",Green,15);
//filling of chart
   chart.SetFill(Linen,Silver);
//set grouping
   chart.SetGrouped(true);
//get chart
   chart.GetChart();
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CPieChart_Example()
  {
   CPieChart chart;
   chart.Attach(0,"test diagram");
//set size
   chart.SetSize(350,200);
//add sectors
   chart.AddPieSlice(10, 0, Red, 0, "Test slice 1");
   chart.AddPieSlice(20, 0, Green, 0, "Test slice 2");
   chart.AddPieSlice(30, 0, Blue, 0, "Test slice 3");
//add second ring
   chart.AddPieSlice(50, 1, YellowGreen, 0, "Test ring 1");
   chart.AddPieSlice(20, 1, Magenta, 0, "Test ring 2");
   chart.AddPieSlice(70, 1, Maroon, 0, "Test ring 3");
//and labels
   chart.SetPieLabels(true);
//heading
   chart.SetTitle("My Chart",Green,15);
//displaying mode is 2D
   chart.SetPieType(true);
//get chart
   chart.GetChart();
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CRadarChart_Example()
  {
   CRadarChart chart;
   chart.Attach(0,"test diagram");
//set size
   chart.SetSize(300,300);
//add lines
   double Y3[10]={100, 120, 18, 17, 13, 9, 70, 75, 80, 60};
   double Y2[10]={70, 5, 6, 8, 10, 20, 100, 130, 90, 60};
   double Y[10]={50,40,25,35,10,50,70,40,15,80};
   int first_line=chart.AddLine(Y,Red,0,"Test line");
   int second_line=chart.AddLine(Y2,Blue,0,"Test line 2");
   int third_line=chart.AddLine(Y3,Green,0,"Test line 3");
//set filling between two lines
   chart.SetLineFilling(first_line,Lime,second_line);
//markers
   chart.SetLineMarker(first_line, DIAGRAM_LINE_MARKERS_CIRCLE, BlueViolet, 10);
   chart.SetLineMarker(second_line, DIAGRAM_LINE_MARKERS_DIAMOND, YellowGreen, 15);
//heading
   chart.SetTitle("My Chart",Green,15);
//grid
   chart.SetGrid();
//legend
   chart.ShowLegend(DIAGRAM_LEGEND_POSITION_BOTTOM_HORIZONTAL);
//get chart
   chart.GetChart();
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CCandleChart_Example()
  {
   CCandleChart chart;
   chart.Attach(0,"test diagram");
//set size
   chart.SetSize(300,300);
//add 10 candlesticks from the current chart
   double Open[10],Close[10],High[10],Low[10];
   CopyOpen(Symbol(),PERIOD_CURRENT,0,10,Open);
   CopyClose(Symbol(),PERIOD_CURRENT,0,10,Close);
   CopyHigh(Symbol(),PERIOD_CURRENT,0,10,High);
   CopyLow(Symbol(),PERIOD_CURRENT,0,10,Low);
   chart.AddCandles(Open,Close,High,Low);
//heading
   chart.SetTitle(Symbol(),Green,15);
//grid
   chart.SetGrid();
//main axes
   chart.SetAxis(DIAGRAM_AXIS_LEFT,-1,0,0,10,4);
//get chart
   chart.GetChart();
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CFormulaChart_Example()
  {
   CFormulaChart chart;
   chart.Attach(0,"test diagram");
//set size
   chart.SetSize(300,75);
//add formula
   chart.SetFormulaString("x=-b\pm\sqrt{b^2-4ac}\over(2a)");
//its color
   chart.SetFormulaColor(Blue);
//heading
   chart.GetChart();
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CGraphChart_Example()
  {
   CGraphChart chart;
   chart.Attach(0,"test diagram");
//set size
   chart.SetSize(300,220);
//add edges and nodes
   int A=chart.AddNode("A");
   int B=chart.AddNode("B");
   int C=chart.AddNode("C");
   int D=chart.AddNode("D");
   chart.AddEdge(A,B);
   chart.AddEdge(B,C);
   chart.AddEdge(C,D);
   chart.AddEdge(A,C);
//set engine
   chart.SetEngine(DIAGRAM_GRAPH_ENGINE_NEATO);
//and arrows
   chart.SetGraphType(false);
//heading
   chart.GetChart();
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CVennChart_Example()
  {
   CVennChart chart;
   chart.Attach(0,"test diagram");
//set size
   chart.SetSize(300,220);
//add sets (and set their sizes)
   chart.SetCircleSizes(100,90,80);
//colors
   chart.SetCircleColors(Yellow,Lime,Maroon);
//legend
   chart.SetVennLegend("EURUSD","USDJPY","EURJPY");
//sizes of intersections
   chart.SetIntersections(30,30,30,10);
//legend
   chart.ShowLegend();
//heading
   chart.SetTitle("Venn",Green,15);
//heading
   chart.GetChart();
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CQRCode_Example()
  {
   CQRCode chart;
   chart.Attach(0,"test diagram");
//set size
   chart.SetSize(200,200);
//add data
   chart.SetData("test data");
//set a correction level error while coding
   chart.SetErrCorrection(DIAGRAM_QRCODE_ERROR_CORRECTION_LOW);
//and encoding
   chart.SetEncoding(DIAGRAM_QRCODE_ENCODING_UTF_8);
//heading
   chart.GetChart();
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CMapChart_Example()
  {
   CMapChart chart;
   chart.Attach(0,"test diagram");
//set size
   chart.SetSize(440,220);
//set region
   chart.SetZoomArea(DIAGRAM_MAP_AREA_AFRICA);
//and countries
   chart.SetCountries("DZEGMGAOBWNGCFKECGCVSNDJTZGHMZZM");
//colors
   chart.SetColors(White,Red,Blue);
//color of an ocean - blue(2-nd parameter)
   chart.SetFill(Gray,Blue);
//heading
   chart.GetChart();
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CScatterChart_Example()
  {
//create an instance of class
   CScatterChart chart;
//bind it to a previously created object
   chart.Attach(0,"test diagram");
//set size
   chart.SetSize(300,300);
//prepare data
   double Y2[10]={70, 5, 6, 8, 10, 20, 100, 130, 90, 60};
   double X2[10]={1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
   double Z2[10]={90, 80, 75, 90, 10, 700, 80, 90, 90, 88};
   double Y[10]={50, 40, 25, 35, 10, 50, 70, 40, 105, 80};
   double X[10]={1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
   double Z[10]={60, 90, 90, 80, 70, 90, 73, 80, 77, 100};
//add scatters
   int first_line=chart.AddLineScatter(Y,X,Z,Red,0,"scatters 1");
   int second_line=chart.AddLineScatter(Y2,X2,Z2,Blue,0,"scatters 2");
//main axes
   chart.SetAxis(DIAGRAM_AXIS_BOTTOM|DIAGRAM_AXIS_LEFT,-1,0,0,10,0);
//grid
   chart.SetGrid();
//legend
   chart.ShowLegend(DIAGRAM_LEGEND_POSITION_BOTTOM_HORIZONTAL);
//heading
   chart.SetTitle("My Chart",Green,15);
//filling of chart
   chart.SetFill(Linen,Silver);
//get chart
   chart.GetChart();
  }
//+------------------------------------------------------------------+
