//+------------------------------------------------------------------+
//|                                                         dAMA.mq5 |
//|                        Copyright 2009, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "2009, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"
//---- drawing the indicator in a separate window
#property indicator_separate_window
#property indicator_buffers 2
#property indicator_plots   1
//---- plot MA
#property indicator_label1  "dAMA"
#property indicator_type1   DRAW_LINE
#property indicator_color1  Red
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//--- input parameters
input int ama_period = 9; // period of AMA
input int fast_ma_period = 2; // period of fast MA
input int slow_ma_period = 30; // period of slow MA
input int  ama_shift = 0; // horizontal shift of the indicator
input ENUM_APPLIED_PRICE  applied_price = PRICE_CLOSE; // type of price or handle
//--- indicator buffers
double AMA_Buffer[], dAMA_Buffer[];
int AMA_Handle;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0, dAMA_Buffer, INDICATOR_DATA);
   SetIndexBuffer(1, AMA_Buffer, INDICATOR_CALCULATIONS);
//---- performing shift of the beginning of counting of drawing the indicators
   PlotIndexSetInteger(0, PLOT_DRAW_BEGIN, ama_period + 2);
   PlotIndexSetInteger(1, PLOT_DRAW_BEGIN, ama_period + 1);
//--- set short indicator name
   IndicatorSetString(INDICATOR_SHORTNAME, "AMA(" + ama_period + ")");
//--- determination of accuracy of displaying of the indicator values
   IndicatorSetInteger(INDICATOR_DIGITS, _Digits);
   
//---- indexation of elements in buffers as in timeseries
   ArraySetAsSeries(AMA_Buffer, true);
   ArraySetAsSeries(dAMA_Buffer, true);
//---
   AMA_Handle = iAMA(NULL, 0, 
       ama_period, fast_ma_period, slow_ma_period, ama_shift, applied_price);
//---      
   if (AMA_Handle == INVALID_HANDLE)Print(" Failed to get handle of the AMA indicator");
//---   
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//----+
    //--- Release handle of the indicator
    IndicatorRelease(AMA_Handle);
//----+   
  }
//+-
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate
              (
               const int rates_total,
               const int prev_calculated,
               const int begin,
               const double &price[]
              )
  {
//--- check if all data calculated
   if(BarsCalculated(AMA_Handle) < rates_total || rates_total < ama_period - 2 + begin)
    return(0);
   
//--- calculation of the necessary amount of data to be copied
   int to_copy;
   if(prev_calculated > rates_total || prev_calculated <= 0)// checking for the first start of calculation of an indicator
        to_copy = rates_total - begin; // calculated number of all bars
   else to_copy = rates_total - prev_calculated + 1; // calculated number of new bars only

//--- copy the newly appeared data into the indicator buffer AMA_Buffer[]
   if (CopyBuffer(AMA_Handle, 0, 0, to_copy, AMA_Buffer) <= 0)
    return(0);  

   int limit;
   if(prev_calculated > rates_total || prev_calculated <= 0)
        limit = rates_total - ama_period + begin - 4;
   else limit = rates_total - prev_calculated; 
  
   for(int bar = limit; bar >= 0; bar--)
    dAMA_Buffer[bar] = AMA_Buffer[bar] - AMA_Buffer[bar + 1]; 
    
   
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
