//+------------------------------------------------------------------+
//|                                            IsNewBar_AMA_Test.mq5 |
//|                        Copyright 2010, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2010, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"
int Handle;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//---
   //----+ Get handle of the indicator
   Handle = iCustom(NULL, 0, "AMA");
   if (Handle == INVALID_HANDLE)
     Print(" Failed to get handle of the AMA indicator");
//---
   return(0);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//----+
    //--- Release handle of the indicator
    IndicatorRelease(Handle);
//----+   
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//----+
   //---- declaration of a static variable - an array for storing values of the AMA indicator
   static double Array[3];
    
   //---- declaration of a static variable for storing results of copying data from the AMA indicator
   static bool Recount;

   //----+ Using handle of the indicator, copy values of the indicator buffer 
                   // to a static array especially prepared for it
   if (IsNewBar(0, NULL, 0) || Recount)
    {
     if (CopyBuffer(Handle, 1, 1, 3, Array) < 0)
      {
       Recount = true; // the attempt of copying of data failed
       return; // exit from the function OnTick()
      }
     
     //---- All operations of copying from the buffers of indicators are successfully finished
          // we may leave this block unvisited till the next change of bar
     Recount = false;
    }
 //----+
  }
//+------------------------------------------------------------------+
//| IsNewBar() function                                              |
//+------------------------------------------------------------------+
bool IsNewBar
            (
             int Number, // Number of a call in the IsNewBar function in the program code of the Expert Advisor
             string symbol, // Symbol of a chart calculation of data is performed at
             ENUM_TIMEFRAMES timeframe // Timeframe of a chart calculation of data is performed at
            )
  {
//----+
   static datetime Told[];
   datetime Tnew;
   
   //----+ Declaration of a variable for storing sizes of arrays of variables
   static int Size_ = 0;
   
   //----+ Changing size of arrays of variables
   if (Number + 1 > Size_)
    {
     uint size = Number + 1;
     //----
     if (ArrayResize(Told, size) == -1)
      {
       string word = "";
       StringConcatenate(word, "IsNewBar( ", Number,
                    " ): Error!!! Failed to change sizes of arrays of variables!!!"); 
       Print(word); 
       //----          
       int error = GetLastError();
       ResetLastError();
       if (error > 4000)
        {
         StringConcatenate(word, "IsNewBar( ", Number, " ): Error code ", error);
         Print(word); 
        }  
       //----                                                                                                                                                                    
       Size_ = -2;
       return(false);
      }
    }
    
   Tnew = SeriesInfoInteger(symbol, timeframe, SERIES_LASTBAR_DATE);
   if (Tnew != Told[Number])
    {
     Told[Number] = Tnew;
     return(true);
    }
//----+
   return(false);
  }
//+X----------------------+ <<< The End >>> +-----------------------X+
