//+------------------------------------------------------------------+
//|                                                         AMkA.mq5 |
//|              MQL4 Code:  Copyright  2004, GOODMAN & Mstera  AF |
//|              MQL5 Code:     Copyright  2010,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
//---  
#property copyright "Copyright  2004, by GOODMAN & Mstera  AF"
//---    
#property link      "http://forum.viac.ru/viewforum.php?f=7"
//---   
#property version   "1.00"
//---     
#property indicator_chart_window 
//---        
#property indicator_buffers 3
//---    
#property indicator_plots   3
//+----------------------------------------------+
//|    AMA                |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_LINE
//---        - 
#property indicator_color1  clrBlueViolet
//---   1 -  
#property indicator_style1  STYLE_SOLID
//---    1  3
#property indicator_width1  3
//---    
#property indicator_label1  "AMA"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---        
#property indicator_color2  clrRed
//---    2  2
#property indicator_width2  2
//---    
#property indicator_label2  "Dn_Signal"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//---   3   
#property indicator_type3   DRAW_ARROW
//---        
#property indicator_color3  clrLime
//---    3  2
#property indicator_width3  2
//---    
#property indicator_label3  "Up_Signal"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int ama_period=9;      //  AMA
input int fast_ma_period=2;  //   
input int slow_ma_period=30; //   
input double G=2.0;          // ,     
input int AMAShift = 0;      //       
input double dK = 1.0;       //   
//+----------------------------------------------+
//---   ,   
//---      
double AMABuffer[];
double BearsBuffer[];
double BullsBuffer[];
//---       
double dSC,slowSC,fastSC; int AMA_Handle,dAMA_Handle;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+ 
void OnInit()
  {
//---    AMABuffer   
   SetIndexBuffer(0,AMABuffer,INDICATOR_DATA);
//---    1    ama_shift
   PlotIndexSetInteger(0,PLOT_SHIFT,AMAShift);
//---       1  1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,ama_period+1);
//---      DataWindow
   PlotIndexSetString(0,PLOT_LABEL,"AMA");
//---      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//---    BearsBuffer   
   SetIndexBuffer(1,BearsBuffer,INDICATOR_DATA);
//---    2    ama_shift
   PlotIndexSetInteger(1,PLOT_SHIFT,AMAShift);
//---       2  ama_period + 2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,ama_period+2);
//---      DataWindow
   PlotIndexSetString(1,PLOT_LABEL,"DnSignal");
//---    
   PlotIndexSetInteger(1,PLOT_ARROW,159);
//---      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
//---    BullsBuffer   
   SetIndexBuffer(2,BullsBuffer,INDICATOR_DATA);
//---    3    ama_shift
   PlotIndexSetInteger(2,PLOT_SHIFT,AMAShift);
//---       3  ama_period + 2
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,ama_period+2);
//---      DataWindow
   PlotIndexSetString(2,PLOT_LABEL,"UpSignal");
//---    
   PlotIndexSetInteger(2,PLOT_ARROW,159);
//---      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0.0);
//---      
   string shortname;
   StringConcatenate(shortname,"AMkA( ",ama_period,", ",fast_ma_period,", ",slow_ma_period," )");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//---   
   slowSC = (2.0 / (slow_ma_period + 1));
   fastSC = (2.0 / (fast_ma_period + 1));
   dSC=fastSC-slowSC;
//---
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const int begin,          //     
                const double &price[])    //     
  {
//---       
   if(rates_total<2*ama_period+2+begin) return(0);
//---    
   int first,bar,iii;
   double noise,AMA,signal,ER,ERSC,SSC,price0,price1;
   double Sum,SMAdif,StDev,BULLS,BEARS,Filter;
   static double dAMA[],dama;
//---    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=ama_period+2+begin; //      
      AMA=price[first-1];
      if(ArrayResize(dAMA,ama_period)!=ama_period) return(0);

      //---      begin ,      
      if(begin>0)
        {
         PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,ama_period+begin);
         PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,2*ama_period+begin+2);
         PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,2*ama_period+begin+2);
        }
     }
   else
     {
      first=prev_calculated-1; //      
      AMA=AMABuffer[first-1];
     }
//---     AMA
   for(bar=first; bar<rates_total; bar++)
     {
      //--- 
      noise=Point()/10000;
      for(iii=0; iii<ama_period; iii++)
        {
         price0 = price[bar - iii - 0];
         price1 = price[bar - iii - 1];
         noise += MathAbs(price0 - price1);
        }
      price0 = price[bar];
      price1 = price[bar - ama_period];
      signal = MathAbs(price0 - price1);
      ER=signal/noise;
      ERSC= ER * dSC;
      SSC = ERSC + slowSC;
      AMA = AMA + (MathPow(SSC, G) * (price0 - AMA));
      //AMA = NormalizeDouble(AMA, _Digits);
      //---       AMA
      AMABuffer[bar]=AMA;
     }

   if(prev_calculated==0)
      first=2*ama_period+6+begin;
//---     AMkA
   for(bar=first; bar<rates_total; bar++)
     {
      //---    AMA     
      for(iii=0; iii<ama_period; iii++)
         dAMA[iii]=AMABuffer[bar-iii-0]-AMABuffer[bar-iii-1];
      //---     AMA
      Sum=0.0;
      for(iii=0; iii<ama_period; iii++)
         Sum+=dAMA[iii];
      SMAdif=Sum/ama_period;
      //---       
      Sum=0.0;
      for(iii=0; iii<ama_period; iii++)
         Sum+=MathPow(dAMA[iii]-SMAdif,2);
      //---      StDev   AMA
      StDev=MathSqrt(Sum/ama_period);
      //---  
      dama=NormalizeDouble(dAMA[0],_Digits+2);
      Filter= NormalizeDouble(dK * StDev,_Digits+2);
      BEARS = 0;
      BULLS = 0;
      //---   
      if(dama < -Filter) BEARS = AMABuffer[bar]; //  
      if(dama > +Filter) BULLS = AMABuffer[bar]; //  
      //---       
      BullsBuffer[bar] = BULLS;
      BearsBuffer[bar] = BEARS;
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
