//+------------------------------------------------------------------+
//|                                                          ASI.mq5 |
//|                      Copyright  2007, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net/"
//---   
#property version   "1.00"
//---     
#property indicator_separate_window 
//---    1
#property indicator_buffers 1 
//---    
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//---     
#property indicator_type1   DRAW_LINE
//---       Coral 
#property indicator_color1 clrCoral
//---   -  
#property indicator_style1  STYLE_SOLID
//---     1
#property indicator_width1  1
//---   
#property indicator_label1  "ASI"
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET 0 //        
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint T = 300;        //  
input uint ATRPeriod=1;    // ATR 
//+-----------------------------------+
//---   ,   
//---      
double ExtBuffer[];
//---       
int Ind_Handle;
//---
double dT;
//---      
int  min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//---     
   min_rates_total=int(ATRPeriod+1);
//---    iATR
   Ind_Handle=iATR(Symbol(),PERIOD_CURRENT,ATRPeriod);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      iATR");
      return(INIT_FAILED);
     }
//---  
   dT=_Point*T;
//---      
   SetIndexBuffer(0,ExtBuffer,INDICATOR_DATA);
//---       
   ArraySetAsSeries(ExtBuffer,true);
//---      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"ASI");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total || BarsCalculated(Ind_Handle)<rates_total) return(RESET);
//---    
   int to_copy,limit,bar,bar1;
//---       
   double ATR[],TR,ER,K,SH,R,res;
//---         
   ArraySetAsSeries(ATR,true);
   ArraySetAsSeries(open,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(close,true);
//---      
//---   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      bar1=limit+1;
      ExtBuffer[bar1]=high[bar1]-low[bar1];
     }
   else limit=rates_total-prev_calculated; //      
//---   
   to_copy=limit+1;
//---      
   if(CopyBuffer(Ind_Handle,0,0,to_copy,ATR)<=0) return(RESET);
//---    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      bar1=bar+1;
      TR=ATR[bar];
      if(close[bar+1]>=low[bar] && close[bar+1]<=high[bar]) ER=0.0;
      else
        {
         if(close[bar1]> high[bar]) ER=MathAbs(high[bar]-close[bar1]);
         if(close[bar1] < low[bar]) ER=MathAbs(low[bar]-close[bar1]);
        }
      K=MathMax(MathAbs(high[bar]-close[bar1]),MathAbs(low[bar]-close[bar1]));
      SH= MathAbs(close[bar1]-open[bar1]);
      R = TR-0.5*ER+0.25*SH;
      if(R) res=50*(close[bar]-close[bar+1]+0.5*(close[bar]-open[bar])+0.25*(close[bar+1]-open[bar+1]))*(K/dT)/R;
      else res=0.0;
      ExtBuffer[bar]=ExtBuffer[bar+1]+res;
     }
//---    
   return(rates_total);
  }
//+------------------------------------------------------------------+