//|                                                          Integer |
//|                          https://login.mql5.com/ru/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/ru/users/Integer"
#property version   "1.00"
/*
   External parameters:
   input int            CHVPeriod   =  10;
   input int            CHVSmPeriod =  10;
   input ENUM_MA_METHOD CHVSmMehod  =  MODE_EMA;
   
   Declaration:
   #include <IncOnArray/IncCHVOnArray.mqh>
   CCHVOnArray chv;

   In OnInit:
   chv.Init(CHVPeriod,CHVSmPeriod,CHVSmMehod);

   In OnCalculate:
   chv.Solve(rates_total,prev_calculated,DataHigh,DataLow,R,RS,CHVBuffer);
*/

#include <IncOnArray/IncMAOnArray.mqh>
//+------------------------------------------------------------------+
//| CCHVOnArray                                                      |
//+------------------------------------------------------------------+
class CCHVOnArray
  {
protected:
   int               m_VPeriod;
   int               m_SmPeriod;
   ENUM_MA_METHOD    m_SmMethod;
   int               m_br;
   string            m_Name;
   CMAOnArray        m_ma;
public:
   void Init(int aVPeriod,int aSmPeriod,ENUM_MA_METHOD aMethod)
     {
      m_VPeriod=aVPeriod;
      m_SmPeriod=aSmPeriod;
      m_SmMethod=aMethod;
      m_ma.Init(m_SmPeriod,m_SmMethod);
      m_Name="CHV("+IntegerToString(m_VPeriod)+","+IntegerToString(m_SmPeriod)+","+m_ma.NameMethod()+")";
      m_br=m_ma.BarsRequired()+m_VPeriod-1;
     }
   void Solve(const int aRatesTotal,
              const int aPrevCalc,
              double  &aDataHigh[],
              double  &aDataLow[],
              double  &aR[],
              double  &aRS[],
              double  &aCHV[]
              )
     {
      int Start=0;
      int Start2=0;
      if(aPrevCalc==0)
        {
         for(int i=0;i<aRatesTotal;i++)
           {
            if(aDataHigh[i]!=0 && aDataHigh[i]!=EMPTY_VALUE)
              {
               if(aDataLow[i]!=0 && aDataLow[i]!=EMPTY_VALUE)
                 {
                  Start=i;
                  break;
                 }
              }
           }
         Start2=Start+m_ma.BarsRequired()+m_VPeriod-1;
        }
      else
        {
         Start=aPrevCalc-1;
         Start2=Start;
        }
      for(int i=Start;i<aRatesTotal;i++)
        {
         aR[i]=aDataHigh[i]-aDataLow[i];
        }
      m_ma.Solve(aRatesTotal,aPrevCalc,aR,aRS);
      for(int i=Start2;i<aRatesTotal;i++)
        {
         if(aRS[i-m_VPeriod]!=0)
           {
            aCHV[i]=100.0*(aRS[i]-aRS[i-m_VPeriod])/aRS[i-m_VPeriod];
           }
         else
           {
            aCHV[i]=0;
           }
        }
     }
   int BarsRequired()
     {
      return(m_br);
     }
   string Name()
     {
      return(m_Name);
     }
   string About()
     {
      return("Integer's CHVOnArray class. https://login.mql5.com/ru/users/Integer");
     }

  };
//+------------------------------------------------------------------+
