//+------------------------------------------------------------------+
//|                                                IncCCIOnArray.mqh |
//|                                                          Integer |
//|                          https://login.mql5.com/en/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/en/users/Integer"
#property version   "1.00"
/*
   External parameters:
   input int            CCIPeriod  =  14;
   input ENUM_MA_METHOD CCIMethod  =  MODE_SMA;   

   Declaration:
   #include <IncOnArray/IncCCIOnArray.mqh>
   CCCIOnArray cci;

   In OnInit:
   cci.Init(CCIPeriod,CCIMethod);

   In OnCalculate:
   cci.Solve(rates_total,prev_calculated,data,MABuffer,CCIBuffer); 
*/

#include <IncOnArray/IncMAOnArray.mqh>
//+------------------------------------------------------------------+
//| CCCIOnArray                                                      |
//+------------------------------------------------------------------+
class CCCIOnArray
  {
private:
   int               m_Period;
   string            m_Name;
   double            m_Mul;
   double            m_sum;
   double            m_s;
   double            m_d;
   CMAOnArray        m_ma;
   int               m_br;
public:
   void Init(int aPeriod=14,ENUM_MA_METHOD aMethod=MODE_SMA)
     {
      m_Period=aPeriod;
      m_Mul=0.015/m_Period;
      m_ma.Init(m_Period,aMethod);
      m_Name="CCI("+IntegerToString(m_Period)+","+m_ma.NameMethod()+")";
      m_br=m_ma.BarsRequired();
     }
   void Solve(const int aRatesTotal,
              const int aPrevCalc,
              double  &aData[],
              double  &aMA[],
              double  &aCCI[])
     {
      m_ma.Solve(aRatesTotal,aPrevCalc,aData,aMA);
      int Start=0;
      if(aPrevCalc==0)
        {
         for(int i=0;i<aRatesTotal;i++)
           {
            if(aMA[i]!=0 && aMA[i]!=EMPTY_VALUE)
              {
               Start=i;
               Start=MathMax(Start,m_Period);
               break;
              }
           }
        }
      else
        {
         Start=aPrevCalc-1;
        }
      for(int i=Start;i<aRatesTotal;i++)
        {
         m_sum=0.0;
         for(int j=0;j<m_Period;j++)
           {
            m_sum+=MathAbs(aData[i-j]-aMA[i]);
           }
         m_d=m_sum*m_Mul;
         m_s=aData[i]-aMA[i];
         if(m_d!=0)
           {
            aCCI[i]=m_s/m_d;
           }
         else
           {
            aCCI[i]=0;
           }
        }
     }
   int BarsRequired()
     {
      return(m_br);
     }
   string Name()
     {
      return(m_Name);
     }
   string About()
     {
      return("Integer's CCIOnArray class. https://login.mql5.com/en/users/Integer");
     }
  };
//+------------------------------------------------------------------+
