//+------------------------------------------------------------------+
//|                                              Test_AMAOnArray.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"
#property indicator_chart_window
#property indicator_buffers 2
#property indicator_plots   1
//--- plot Label1
#property indicator_label1  "Label1"
#property indicator_type1   DRAW_LINE
#property indicator_color1  clrRed
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//--- input parameters
input int   AMAPeriod      =  9;
input int   AMAFastPeriod  =  2;
input int   AMASlowPeriod  =  30;
//--- indicator buffers
double         AMABuffer[];
double         data[];
//---
#include <IncOnArray/IncAMAOnArray.mqh>
CAMAOnArray ama;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
   ama.Init(AMAPeriod,AMAFastPeriod,AMASlowPeriod);

//--- indicator buffers mapping
   SetIndexBuffer(0,AMABuffer,INDICATOR_DATA);
   SetIndexBuffer(1,data,INDICATOR_CALCULATIONS);

   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,ama.BarsRequired());
   PlotIndexSetString(0,PLOT_LABEL,ama.Name());
//---
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const int begin,
                const double &price[])
  {
   int start;
   if(prev_calculated>0)
     {
      start=prev_calculated-1;
     }
   else
     {
      start=0;
     }
   for(int i=start;i<rates_total;i++)
     {
      data[i]=price[i];
     }

   ama.Solve(rates_total,prev_calculated,data,AMABuffer);

   return(rates_total);
  }
//+------------------------------------------------------------------+
